/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicButtonListener;
import com.sun.java.swing.plaf.basic.BasicButtonUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.metal.MetalButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class MetalButtonUI
extends BasicButtonUI {
    private static final MetalButtonUI metalButtonUI = new MetalButtonUI();

    protected Color getSelectColor() {
        return UIManager.getColor("Button.pressed");
    }

    protected Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledText");
    }

    protected Color getFocusColor() {
        return UIManager.getColor("Button.focus");
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return metalButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(true);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isOpaque()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl = abstractButton.getIcon() != null;
        if (string != null & !string.equals("")) {
            if (!bl) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl) {
            rectangle4.setBounds(rectangle3);
        }
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
            return;
        }
        graphics.setColor(UIManager.getColor("Button.disabledText"));
        BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected BasicButtonListener createListener(JComponent jComponent) {
        return new MetalButtonListener((AbstractButton)jComponent);
    }
}

