
/*
 * Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: scalar.h,v 1.6 1999/10/29 18:33:16 stes Exp $
 */

@interface Scalar : Variable
{
   union {
     id u_id;
     int u_int;
     long u_long;
     char u_char;
     float u_float;
     double u_double;
     char *u_charstar;
     void *u_voidstar;
   } u;
}

- u_id:x;
- u_int:(int)x;
- u_long:(long)x;
- u_char:(char)x;
- u_float:(float)x;
- u_double:(double)x;
- u_charstar:(char*)x;
- u_voidstar:(void*)x;

- (int)u_int;
- (long)u_long;
- (char)u_char;
- (float)u_float;
- (double)u_double;
- (char*)u_charstar;
- (void*)u_voidstar;

- (BOOL)isZero;

- decrement;
- increment;

@end
 
