
/*
 * Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: scalar.m,v 1.5 1999/10/29 18:33:16 stes Exp $
 */

#include "config.h"
#include <stdlib.h>
#include <assert.h>
#ifndef __OBJECT_INCLUDED__
#define __OBJECT_INCLUDED__
#include <stdio.h> /* FILE */
#include "Object.h" /* Stepstone Object.h assumes #import */
#endif
#include <ocstring.h>
#include "node.h"
#include "var.h"
#include "scalar.h"

@implementation Scalar

- u_id
{
  return u.u_id;
}

- u_id:x
{
  u.u_id = x;return self;
}

- (int)u_int
{
  return u.u_int;
}

- u_int:(int)x
{
  u.u_int = x;return self;
}

- u_long:(long)x
{
  u.u_long = x;return self;
}

- (long)u_long
{
  return u.u_long;
}

- u_char:(char)x
{
  u.u_char = x;return self;
}

- (char)u_char
{
  return u.u_char;
}

- u_float:(float)x
{
  u.u_float = x;return self;
}

- (float)u_float
{
  return u.u_float;
}

- u_double:(double)x
{
  u.u_double = x;return self;
}

- (double)u_double
{
  return u.u_double;
}

- u_charstar:(char*)x
{
  u.u_charstar = x;return self;
}

- (char*)u_charstar
{
  return u.u_charstar;
}

- u_voidstar:(void*)x
{
  u.u_voidstar = x;return self;
}

- (void*)u_voidstar
{
  return u.u_voidstar;
}

- (BOOL)isZero
{
  return u.u_int == 0;
}

- increment
{
  u.u_int++;
  return self;
}

- decrement
{
  u.u_int--;
  return self;
}

@end
 
