/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include "context.h"


int root_context_cpy(ss_root_context_t *dst, 
		     ss_root_context_t *src)
{ 
    (dst)->user = (src)->user;
    (dst)->role = (src)->role;
    (dst)->type = (src)->type; 
    (dst)->range.low.sens = (src)->range.low.sens; 
    if (!ebitmap_cpy(&(dst)->range.low.cat,&(src)->range.low.cat))
	    return FALSE;
    (dst)->range.high.sens = (src)->range.high.sens; 
    if (!ebitmap_cpy(&(dst)->range.high.cat,&(src)->range.high.cat))
    {
	ebitmap_destroy(&(dst)->range.low.cat);
	return FALSE;
    }
    return TRUE;
}


void 
context_init(ss_context_t * c, int isroot)
{
	c->isroot = isroot;
	if (c->isroot) {
		root_context_init(&RCONTEXT(c));
	} else {
		child_context_init(&CCONTEXT(c));
	}
}


int 
context_cmp(ss_context_t * c1, ss_context_t * c2)
{
	if (c1->isroot != c2->isroot)
		return FALSE;

	if (c1->isroot)
		return root_context_cmp(&RCONTEXT(c1), &RCONTEXT(c2));

	return child_context_cmp(&CCONTEXT(c1), &CCONTEXT(c2));
}


int 
context_cpy(ss_context_t * dst, ss_context_t * src)
{
	dst->isroot = src->isroot;

	if (dst->isroot)
		return root_context_cpy(&RCONTEXT(dst), &RCONTEXT(src));

	child_context_cpy(&CCONTEXT(dst), &CCONTEXT(src));
	return TRUE;
}


void 
context_destroy(ss_context_t * c)
{
	if ((c)->isroot) {
		root_context_destroy(&RCONTEXT(c));
	} else {
		child_context_destroy(&CCONTEXT(c));
	}
}
