/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

/*
  ebitmap.h

  Definition of an extensible sparse bitmap type.
*/

#ifndef _EBITMAP_H_
#define _EBITMAP_H_

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#define MAPTYPE unsigned long long
#define MAPSIZE (sizeof(MAPTYPE) * 8)
#define MAPBIT  1ULL

typedef struct ebitmap_node
{
    unsigned long startbit;
    MAPTYPE map;
    struct ebitmap_node *next;
} ebitmap_node_t;

typedef struct ebitmap
{
    ebitmap_node_t *node;
    unsigned long highbit;
} ebitmap_t;


#define ebitmap_length(e) ((e)->highbit)

#define ebitmap_init(e) \
{ \
    (e)->highbit = 0; \
    (e)->node = 0; \
}

int ebitmap_cmp(ebitmap_t *e1, ebitmap_t *e2);
int ebitmap_or(ebitmap_t *dst, ebitmap_t *e1, ebitmap_t *e2);
int ebitmap_cpy(ebitmap_t *dst, ebitmap_t *src);
int ebitmap_contains(ebitmap_t *e1, ebitmap_t *e2);
int ebitmap_get_bit(ebitmap_t *e, unsigned long bit);
int ebitmap_set_bit(ebitmap_t *e, unsigned long bit, int value);
void ebitmap_destroy(ebitmap_t *e);

#endif _EBITMAP_H_

/* FLASK */
