/*
 * PASHAS.C - more routines that are shared between PANACEA and its pre and
 *          - post processors
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "panace.h"

static byte
 SC_DECLARE(*_PA_realloc, 
            (PA_variable *pp, dimdes *olddm, int flag));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_CHANGE_DIM - store a new value in the given variable and reallocate
 *               - every variable in PA_variable_tab which uses the
 *               - given variable address to find dimension values
 */

void PA_change_dim(pdm, val)
   int *pdm, val;
   {int i, sz, oval;
    int *dmn, *dmx;
    hashel *np, **tb;
    dimdes *olddm;
    PA_variable *pp;
    PA_dimens *pvd;

    oval = *pdm;
    *pdm = val;

/* check every variable's dimension list for a match to this address */
    sz = PA_variable_tab->size;
    tb = PA_variable_tab->table;
    for (i = 0; i < sz; i++)
        for (np = tb[i]; np != NULL; np = np->next)
            {if (np->type[3] == 'p')                   /* skip the packages */
                continue;
             pp = (PA_variable *) np->def;

/* check the dimension list for this variable and reallocate it if it
 * changed (only one dimension need change so break after only one)
 */
             for (pvd = PA_VARIABLE_DIMS(pp); pvd != NULL; pvd = pvd->next)
                 {dmn = pvd->index_min;
                  dmx = pvd->index_max;
                  if ((dmn == pdm) || (dmx == pdm))

/* change it back long enough to make a list of the original dimensions */
                     {*pdm  = oval;
                      olddm = _PA_mk_sym_dims(PA_VARIABLE_DIMS(pp));
                      *pdm  = val;

		      _PA_realloc(pp, olddm, PA_DATABASE);

		      _PD_rl_dimensions(olddm);

                      break;};};};

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_CHANGE_SIZE - reallocate the variable to the current size specified
 *                - by the dimensions specified (PA_FILE or PA_DATABASE)
 */

void PA_change_size(name, flag)
   char *name;
   int flag;
   {PA_variable *pp;

    pp = PA_inquire_variable(name);
    PA_ERR((pp == NULL),
           "VARIABLE %s IS NOT IN THE DATA BASE - PA_CHANGE_SIZE", name);

    _PA_realloc(pp, NULL, flag);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_ADJUST_REFS - update the pointer list of the specified variable PP
 *                 - with the new data pointer PDATA and size PSZ
 */

static void _PA_adjust_refs(pp, pdata, psz)
   PA_variable *pp;
   byte *pdata;
   long psz;
   {pcons *lst;

/* now update the pointer list */
    lst = PA_VARIABLE_ACCESS_LIST(pp);
    for (; lst != NULL; lst = (pcons *) lst->cdr)
        *(char **) lst->car = (char *) pdata;

    PA_VARIABLE_DATA(pp)         = pdata;
    PA_VARIABLE_SIZE(pp)         = psz;
    PA_VARIABLE_DESC(pp)->number = psz;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_REALLOC - reallocate (change the length) the named variable
 *             - to the given new size and
 *             - return a pointer to it
 */

static byte *_PA_realloc(pp, olddm, flag)
   PA_variable *pp;
   dimdes *olddm;
   int flag;
   {char *ptype, *pname;
    int pclass, n_ref;
    long psz;
    pcons *lst;
    byte *pdata;
    defstr *pd;

    pname  = PA_VARIABLE_NAME(pp);
    ptype  = PA_VARIABLE_TYPE_S(pp);
    pclass = PA_VARIABLE_CLASS(pp);
    pdata  = PA_VARIABLE_DATA(pp);
    pd     = PA_VARIABLE_TYPE(pp);

/* count the references */
    n_ref = 0;
    lst   = PA_VARIABLE_ACCESS_LIST(pp);
    for (; lst != NULL; lst = (pcons *) lst->cdr, n_ref++);

/* force consistency in variable size and shape */
    psz = _PA_consistent_size(pp, flag);

    PA_ERR((pclass == PSEUDO),
           "CANNOT REALLOCATE PSEUDO VARIABLE %s - _PA_REALLOC", pname);

/* handle case when there is no data hence reallocation is inappropriate */
    if (pdata == NULL)
       {if ((n_ref == 0) || (psz <= 0L))
           return(NULL);

        else
           {pdata = _PA_init_space(pp, psz);
            PA_ERR((pdata == NULL),
                   "ALLOCATION FAILED - _PA_REALLOC");};}
    else
       {byte *oldsp, *newsp;
        PFInt proc;
        long nbn, nbo;

/* get the byte size of the spaces
 * NOTE: 1000 times NO to fiddling with statically allocated arrays
 * even to shrink them!
 */
        nbn = psz*(pd->size);
        nbo = SC_arrlen(pdata);

        newsp = SC_alloc_na(nbn, 1, NULL, FALSE);
        oldsp = pdata;

/* see whether there is a routine to map the old space into the new one */
        proc = PA_GET_VAR_FUNCTION(pp, PFInt, "change_dim");
        if (proc != NULL)
           {long i, nd, *ndm, *odm;
	    dimdes *newdm, *pnd, *pod;

/* safe to use _PA_mk_sym_dims because _PA_consistent_size has
 * already been done
 */
	    newdm = _PA_mk_sym_dims(PA_VARIABLE_DIMS(pp));

/* count the dimensions */
            for (nd = 0, pod = olddm; pod != NULL; nd++, pod = pod->next);

            ndm = FMAKE_N(long, nd, "_PA_REALLOC:ndm");
            odm = FMAKE_N(long, nd, "_PA_REALLOC:odm");

/* make arrays of values */
            for (i = 0, pnd = newdm, pod = olddm;
		 i < nd;
		 i++, pnd = pnd->next, pod = pod->next)
                {ndm[i] = pnd->number;
                 odm[i] = pod->number;};

            (*proc)(pname, newsp, oldsp, &nd, ndm, odm);

	    _PD_rl_dimensions(newdm);

            SFREE(ndm);
            SFREE(odm);}

/* copy the smaller number of bytes
 * oldsp+nbn may be out of bounds and a coredump will ensue
 * the remaining new bytes would be zero anyway!
 */
        else
	   memcpy(newsp, oldsp, min(nbo, nbn));

        pdata = newsp;

        SFREE(oldsp);};

    _PA_adjust_refs(pp, pdata, psz);

    return(pdata);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_INTERN - intern a variable pointed to by the first arg in the
 *            - variable table under the name given by the second arg
 *            - if vr is NULL and is an array allocate the space
 *            - return a pointer to the data
 */

byte *_PA_intern(vr, name)
   byte *vr;
   char *name;
   {PA_variable *pp;
    char *ptype;
    long psz;
    byte *pdata;

    pp = PA_inquire_variable(name);
    PA_ERR((pp == NULL),
           "VARIABLE %s IS NOT IN THE DATA BASE - _PA_INTERN", name);

/* force consistency in variable size and shape */
    psz = _PA_consistent_size(pp, PA_DATABASE);

/* decide what to do based on the size and whether
 * or not the pointer vr is NULL
 */
    if ((psz < 1L) || (vr != NULL))
       pdata  = vr;
    else
       {ptype = PA_VARIABLE_TYPE_S(pp);
        pdata = _PA_alloc(PA_VARIABLE_TYPE(pp),
                          ptype, psz,
                          PA_VARIABLE_INIT_VAL(pp));};

    _PA_adjust_refs(pp, pdata, psz);

    return(pdata);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_SIZEOF - sizeof operator for PANACEA */

int _PA_sizeof(s)
   char *s;
   {

    if (PA_vif != NULL)
       return(_PD_lookup_size(s, PA_vif->chart));

    else
       return(SC_sizeof(s));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INIT_THREADS - execute the given function FNC on NT threads
 *                 - serial execution follows from NT equal to 1
 */

void PA_init_threads(nt, tid)
   int nt;
   PFVoid tid;
   {

    SC_init_tpool(nt, tid);

    PA_set_n_threads(nt);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DO_THREADS - execute the given function FNC on NT threads
 *               - serial execution follows from NT equal to 1
 */

void PA_do_threads(fnc, ret)
   void *(*fnc)();
   void **ret;
   {int nt;
    PFPVoid lfnc;

    lfnc = fnc;

    PA_get_n_threads(nt);

    SC_do_threads(1, &nt, &lfnc, NULL, ret);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
