/*
 * PDSZOF.C - byte size routines for PDB
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

#define DONE         1
#define LEAF         2
#define LEAF_ITEM    3
#define LEAF_RET     4
#define LEAF_INDIR   5
#define INDIRECT     6
#define INDIR_ITEM   7
#define INDIR_RET    8
#define BLOCK        9
#define BLOCK_ITEM  10
#define BLOCK_RET   11
#define SKIP_TO     12
#define SKIP_RET    13


#define SAVE_S(s, t)                                                         \
    {SZ_STR_STACK(_t_index)[SZ_STR_PTR(_t_index)++] = s;                                         \
     s = SC_strsavef(t, "char*:SAVE_S:t");}

#define RESTORE_S(s)                                                         \
    {SFREE(s);                                                               \
     s = SZ_STR_STACK(_t_index)[--SZ_STR_PTR(_t_index)];}

#define SAVE_I(val)                                                          \
    (SZ_LVAL_STACK(_t_index)[SZ_LVAL_PTR(_t_index)++].diskaddr = (long) val)

#define RESTORE_I(val)                                                       \
    (val = SZ_LVAL_STACK(_t_index)[--SZ_LVAL_PTR(_t_index)].diskaddr)

#define SAVE_P(val)                                                          \
    (SZ_LVAL_STACK(_t_index)[SZ_LVAL_PTR(_t_index)++].memaddr = (char *) val)

#define RESTORE_P(type, val)                                                 \
    (val = (type *) SZ_LVAL_STACK(_t_index)[--SZ_LVAL_PTR(_t_index)].memaddr)

#define SET_CONT(ret)                                                        \
   {SZ_CALL_STACK(_t_index)[SZ_CALL_PTR(_t_index)++] = ret;                                      \
    dst = _PD_indirection(ltype) ? INDIRECT : LEAF;                          \
    continue;}

#define SET_CONT_RD(ret, branch)                                             \
   {SZ_CALL_STACK(_t_index)[SZ_CALL_PTR(_t_index)++] = ret;                                      \
    dst = branch;                                                            \
    continue;}

#define GO_CONT                                                              \
   {dst = SZ_CALL_STACK(_t_index)[--SZ_CALL_PTR(_t_index)];                                      \
    continue;}

#define GO(lbl)                                                              \
    {dst = lbl;                                                              \
     continue;}

#define INIT_STACKS(_t, _d)                                                  \
    {long _a, _f;                                                            \
     if (SZ_LIST_T(_t_index) == 0)                                                     \
        {SZ_LIST_T(_t_index) = _t;                                                     \
	 SZ_LIST_D(_t_index) = _d;                                                     \
         SC_mem_stats(&_a, &_f, NULL, NULL);                                 \
	 DYN_STK(long, SZ_CALL_STACK(_t_index), SZ_CALL_PTR(_t_index), SZ_CALL_PTR_X(_t_index));           \
	 DYN_STK(char *, SZ_STR_STACK(_t_index), SZ_STR_PTR(_t_index), SZ_STR_PTR_X(_t_index));            \
	 DYN_STK(SC_address, SZ_LVAL_STACK(_t_index), SZ_LVAL_PTR(_t_index), SZ_LVAL_PTR_X(_t_index));     \
         SC_mem_stats_set(_a, _f);};                                         \
     SZ_CALL_PTR(_t_index) = 0L;                                                       \
     SZ_LVAL_PTR(_t_index) = 0L;                                                       \
     SZ_STR_PTR(_t_index)  = 0L;                                                       \
     ltype    = NULL;                                                        \
     SZ_CALL_STACK(_t_index)[SZ_CALL_PTR(_t_index)++] = DONE;}

#define DYN_STK(_t, _s, _p, _px)                                             \
    {if (_p > _px - SZ_LIST_T(_t_index))                                               \
        {_px += SZ_LIST_D(_t_index);                                                   \
	 if (_s == NULL)                                                     \
	    {_s = FMAKE_N(_t, _px, "_PD_DYN_STK:s");}                        \
	 else                                                                \
	    REMAKE_N(_s, _t, _px);};}

#define START                                                                \
    while (TRUE)                                                             \
       {DYN_STK(long, SZ_CALL_STACK(_t_index), SZ_CALL_PTR(_t_index), SZ_CALL_PTR_X(_t_index));            \
	DYN_STK(char *, SZ_STR_STACK(_t_index), SZ_STR_PTR(_t_index), SZ_STR_PTR_X(_t_index));             \
        DYN_STK(SC_address, SZ_LVAL_STACK(_t_index), SZ_LVAL_PTR(_t_index), SZ_LVAL_PTR_X(_t_index));      \
	switch (dst) {

#define FINISH(f, tag)                                                       \
    default  :                                                               \
         sprintf(bf, "UNDECIDABLE CASE - %s", f);                            \
         PD_error(bf, tag);};}

struct s_file_static
   {long *sz_call_stack;
    long  sz_call_ptr;
    long  sz_call_ptr_x;
    long  sz_lval_ptr;
    long  sz_lval_ptr_x;
    long  sz_str_ptr;
    long  sz_str_ptr_x;
    long  sz_list_t;
    long  sz_list_d;
    SC_address *sz_lval_stack;
    char **sz_str_stack;};

typedef struct s_file_static FILE_STATIC;

#ifdef HAVE_THREADS

#define SZ_CALL_STACK(x) _PD_szof_static[x].sz_call_stack
#define SZ_CALL_PTR(x)   _PD_szof_static[x].sz_call_ptr
#define SZ_CALL_PTR_X(x) _PD_szof_static[x].sz_call_ptr_x
#define SZ_LVAL_PTR(x)   _PD_szof_static[x].sz_lval_ptr
#define SZ_LVAL_PTR_X(x) _PD_szof_static[x].sz_lval_ptr_x
#define SZ_STR_PTR(x)    _PD_szof_static[x].sz_str_ptr
#define SZ_STR_PTR_X(x)  _PD_szof_static[x].sz_str_ptr_x
#define SZ_LIST_T(x)     _PD_szof_static[x].sz_list_t
#define SZ_LIST_D(x)     _PD_szof_static[x].sz_list_d
#define SZ_LVAL_STACK(x) _PD_szof_static[x].sz_lval_stack
#define SZ_STR_STACK(x)  _PD_szof_static[x].sz_str_stack

static FILE_STATIC
 *_PD_szof_static = NULL;

#else

#define SZ_CALL_STACK(x) sz_call_stack
#define SZ_CALL_PTR(x)   sz_call_ptr
#define SZ_CALL_PTR_X(x) sz_call_ptr_x
#define SZ_LVAL_PTR(x)   sz_lval_ptr
#define SZ_LVAL_PTR_X(x) sz_lval_ptr_x
#define SZ_STR_PTR(x)    sz_str_ptr
#define SZ_STR_PTR_X(x)  sz_str_ptr_x
#define SZ_LIST_T(x)     sz_list_t
#define SZ_LIST_D(x)     sz_list_d
#define SZ_LVAL_STACK(x) sz_lval_stack
#define SZ_STR_STACK(x)  sz_str_stack

static long
 *sz_call_stack = NULL,
 sz_call_ptr = 0L,
 sz_call_ptr_x = 0L,
 sz_lval_ptr = 0L,
 sz_lval_ptr_x = 0L,
 sz_str_ptr = 0L,
 sz_str_ptr_x = 0L,
 sz_list_t = 0L,
 sz_list_d = 0L;

static SC_address
 *sz_lval_stack = NULL;

static char
 **sz_str_stack = NULL;

#endif

SC_THREAD_LOCK(PD_szof_lock);

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_SZ_ITAG - compute the byte size that the ITAG would incur */

static long _PD_sz_itag(type)
   char *type;
   {long nb;
    static long szl = 0L;

    if (szl == 0L)
       {SC_LOCKON(PD_szof_lock);
        if (szl == 0L)
           szl = (long) ceil(log10(pow(256.0, ((double) sizeof(long)))));
        SC_LOCKOFF(PD_szof_lock);}

/* the itag format is "%ld\001%s\001%32ld\001%d\001\n"
 * allow for maximum space for 2 longs, a 32 digit address, and a string
 */

    nb = 2*szl + 32 + strlen(type) + 5;

    return(nb);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_SZ_LEAF_MEMBERS - write the direct leaf data */

static long _PD_sz_leaf_members(file, type, nitems, vr)
   PDBfile *file;
   char *type;
   long nitems;
   byte *vr;
   {long bytepitem, nb;
    defstr *dpf;

    dpf       = _PD_lookup_type(type, file->chart);
    bytepitem = dpf->size;
    if (bytepitem == -1)
       PD_error("CAN'T GET NUMBER OF BYTES - _PD_SZ_LEAF_MEMBERS", PD_TRACE);

    nb = nitems*bytepitem;

    return(nb);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_SZ_IND_ITAGS - handle the memory of pointers and write the itags
 *                  - correctly
 */

static int _PD_sz_ind_itags(pnb, file, vr, nitems, type)
   long *pnb;
   PDBfile *file;
   byte *vr;
   long nitems;
   char *type;
   {int ret;
    long i, n, nx;
    char **pl, **lst;

    *pnb += _PD_sz_itag(type);
    ret   = FALSE;
#ifdef HAVE_THREADS
    if (_PD_nthreads <= 1) {
#endif
    lst = file->ptr_wr_list;
    nx  = file->max_wr_indx;
    n   = file->wr_indx;

/* search the pointer list to see if this pointer
 * has been previously written
 */
    if (file->track_pointers)
       {pl = lst;
        for (i = 0L; (i < n) && (vr != *pl); i++, pl++);}
    else
       i = n;

/* if the loop did maxed out, this has not been seen before */
    if (i >= n)
       {SC_REMEMBER(char *, vr, lst, n, nx, 50L);
	ret = TRUE;};

    file->ptr_wr_list = lst;
    file->max_wr_indx = nx;
    file->wr_indx     = n;
#ifdef HAVE_THREADS
    }
    else
       ret = TRUE;
#endif
    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PD_SIZEOF - return the size in bytes of the space needed to contain
 *           - a PDB representation of the given object
 */

long PD_sizeof(file, type, nitems, vri)
   PDBfile *file;
   char *type;
   long nitems;
   byte *vri;
   {int dst, size, indir;
    long i, nb, n, nx;
    char bf[MAXLINE], *ltype, *vr, *svr, *ttype;
    char **alst;
    defstr *dp;
    memdes *desc, *mem_lst;
    SC_THREAD_ID(_t_index);

    if (vri == NULL)
       return(0L);

    switch (setjmp(_PD_TRACE_ERR(_t_index)))
       {case ABORT :
	     return(0L);
        case ERR_FREE :
	     return(nb);
        default :
	     memset(PD_ERR(_t_index), 0, MAXLINE);
	     break;};

#ifdef HAVE_THREADS
    if (_PD_nthreads <= 1) {
#endif
/* save the current ptr lists */
    alst = file->ptr_wr_list;
    nx   = file->max_wr_indx;
    n    = file->wr_indx;

    file->ptr_wr_list = NULL;
    file->max_wr_indx = 0L;
    file->wr_indx     = 0L;
#ifdef HAVE_THREADS
    };
#endif

    file->flushed = FALSE;

    INIT_STACKS(100L, 1000L);

    dst = _PD_indirection(type) ? INDIRECT : LEAF;

    if (dst == LEAF)
       {indir = FALSE;
	ltype = type;}
    else
       {indir = TRUE;
	SAVE_S(ltype, type);};

    nb = 0L;
    vr = (char *) vri;

/* some AIX compilers will erroneously take the default case if
 * this is terminated with a semicolon
 */
    START

    case LEAF :
         nb += _PD_sz_leaf_members(file, ltype, nitems, vr);

         dp = PD_inquire_host_type(file, ltype);
         if (dp == NULL)
            PD_error("BAD TYPE - PD_SIZEOF", PD_TRACE);

         mem_lst = dp->members;
         if (!dp->n_indirects || (mem_lst == NULL))
            GO_CONT;

/* if type is a struct with pointered members write them out now 
 * for an array of structs write the indirects for each array element
 */
         size = dp->size;
         svr  = vr;
         i    = 0L;

    case LEAF_ITEM :
         if (i >= nitems)
            GO_CONT;

         desc = mem_lst;

    case LEAF_INDIR :
         if (desc == NULL)
            {i++;
             svr += size;
             GO(LEAF_ITEM);};

         PD_CAST_TYPE(ttype, desc, svr+desc->member_offs, svr,
		      PD_error, "BAD CAST - PD_SIZEOF", PD_TRACE);

         SAVE_S(ltype, ttype);

         if (!_PD_indirection(ltype))
            {RESTORE_S(ltype);
             desc = desc->next;
             GO(LEAF_INDIR);};

         SAVE_I(nitems);
         nitems = desc->number;

         SAVE_I(i);
         SAVE_I(size);
         SAVE_P(mem_lst);
         SAVE_P(desc);
         SAVE_P(svr);
         SAVE_P(vr);
         vr = svr + desc->member_offs;
         SET_CONT(LEAF_RET);

    case LEAF_RET :
         RESTORE_P(char, vr);
         RESTORE_P(char, svr);
         RESTORE_P(memdes, desc);
         RESTORE_P(memdes, mem_lst);
         RESTORE_I(size);
         RESTORE_I(i);
         RESTORE_I(nitems);
         RESTORE_S(ltype);

         desc = desc->next;
         GO(LEAF_INDIR);

    case INDIRECT :
    
         if (vr == NULL)
            {nb += _PD_sz_itag(ltype);
             GO_CONT;};

/* dereference a local copy of the type */
         SAVE_S(ltype, ltype);
         PD_dereference(ltype);

/* write the data */
         i = 0L;

    case INDIR_ITEM :
         if (i >= nitems)
            {RESTORE_S(ltype);
             GO_CONT;};

         SAVE_P(vr);
         vr = DEREF(vr);
         if (vr == NULL)
            {nb += _PD_sz_itag(ltype);
             RESTORE_P(char, vr);
             i++;
             vr += sizeof(char *);
             GO(INDIR_ITEM);};

         SAVE_I(nitems);
         nitems = _PD_number_refd(vr, ltype, file->host_chart);
         if (nitems == -1L)
            {sprintf(bf,
                     "CAN'T GET POINTER LENGTH ON %s - PD_SIZEOF",
                     ltype);
             PD_error(bf, PD_TRACE);};

         if (nitems == -2L)
            {sprintf(bf,
                     "UNKNOWN TYPE %s - PD_SIZEOF",
                     ltype);
             PD_error(bf, PD_TRACE);};

         if (!_PD_sz_ind_itags(&nb, file, vr, nitems, ltype))
            {RESTORE_I(nitems);
             RESTORE_P(char, vr);
             i++;
             vr += sizeof(char *);
             GO(INDIR_ITEM);};

         SAVE_I(i);
         SAVE_S(ltype, ltype);
         SET_CONT(INDIR_RET);

    case INDIR_RET :
         RESTORE_S(ltype);
         RESTORE_I(i);
         RESTORE_I(nitems);
         RESTORE_P(char, vr);

         i++;
         vr += sizeof(char *);

         GO(INDIR_ITEM);

    case DONE :
         if (indir)
	    {RESTORE_S(ltype);};

#ifdef HAVE_THREADS
    if (_PD_nthreads <= 1) {
#endif
/* restore the initial ptr lists */
         SFREE(file->ptr_wr_list);

         file->ptr_wr_list = alst;
         file->max_wr_indx = nx;
         file->wr_indx     = n;
#ifdef HAVE_THREADS
    };
#endif
         return(nb);

    FINISH("PD_SIZEOF", PD_TRACE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PN_RELOCATE - change all the ITAGs to be relative to the current
 *             - buffer space
 *             - this is to cover the case of multiply referenced spaces
 *             - buffers which have been passed around
 */

int PN_relocate(file, type, n)
   PDBfile *file;
   char *type;
   long n;
   {int ret;

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PD_SZOF_PINIT - initialize the file static variables for
 *                  parallel execution.
 */

void _PD_szof_pinit()
  {

#ifdef HAVE_THREADS
    int i;

    if (_PD_szof_static == NULL)
       {_PD_szof_static = NMAKE_N(FILE_STATIC, _PD_nthreads,
				  "_PD_SZOF_PINIT:_PD_szof_static");

	for (i = 0; i < _PD_nthreads; i++)
	    {_PD_szof_static[i].sz_call_stack = NULL;
	     _PD_szof_static[i].sz_call_ptr   = 0L;
	     _PD_szof_static[i].sz_call_ptr_x = 0L;
	     _PD_szof_static[i].sz_lval_ptr   = 0L;
	     _PD_szof_static[i].sz_lval_ptr_x = 0L;
	     _PD_szof_static[i].sz_str_ptr    = 0L;
	     _PD_szof_static[i].sz_str_ptr_x  = 0L;
	     _PD_szof_static[i].sz_list_t     = 0L;
	     _PD_szof_static[i].sz_list_d     = 0L;
	     _PD_szof_static[i].sz_lval_stack = NULL;
	     _PD_szof_static[i].sz_str_stack  = NULL;};};
#endif

   return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

