
(define-class <image> (<object>)
  (image-width type: <fixnum>)
  (image-height type: <fixnum>))

(define-class <p5-image> (<image>)
  (filedes type: <fixnum>)
  (offset type: <fixnum>)
  (data type: <string>)
  (dirty? type: <boolean> init-value: #f))

(define-class <pgm-header-in-port> (<buffered-input-port>)
  (byte-offset init-value: 0)
  underlying-input-port)

(define (make-pgm-header-port fd)
  (make <pgm-header-in-port>
    underlying-input-port: (make <fd-input-port>
			     file-descriptor: fd)))

(define-method more-input-ready? ((self <pgm-header-in-port>))
  #t)

(define-method provide-more-input ((self <pgm-header-in-port>))
  (let ((l (read-line (underlying-input-port self))))
    (set-byte-offset! self (+ (byte-offset self) 1 (string-length l)))
    (if (and (> (string-length l) 0)
	     (char=? (string-ref l 0) #\#))
	(provide-more-input self)
	(string-append l "\n"))))

(define (read-pgm-header fd)
  (let ((i (make-pgm-header-port fd)))
    (assert (eq? (read i) 'P5))
    (let* ((w (read i))
	   (h (read i))
	   (max (read i)))
      (values w h max (byte-offset i)))))
    
(define (open-input-pgm-file (file <string>))
  (bind ((fd (fd-open file (make-fd-open-mode 'read) 0))
	 (w h maxv at (read-pgm-header fd))
	 (data (bvec-alloc <string> (+ 1 (* w h)))))
    (fd-lseek fd at 0)
    (let ((m (fd-read fd data 0 (* w h))))
      (format #t "~a: ~d x ~d ... ~s\n" file w h m))
    (make <p5-image>
      filedes: fd
      image-width: w
      image-height: h
      offset: at
      data: data)))

(define-method get-pixel ((self <p5-image>) y x)
  (bvec-ref (data self) (+ x (* y (image-width self)))))


;;;

(define (open-output-pgm-file (file <string>) #key 
			      width
			      height
			      (maxval default: 255))
  ;;
  (let ((h (format #f "P5\n~d ~d\n~d\n" width height maxval))
	(fd (fd-open file (make-fd-open-mode 'write 'create) #o666)))
    (fd-write fd h 0 (string-length h))
    (make <p5-image>
      filedes: fd
      image-width: width
      image-height: height
      offset: (string-length h)
      dirty?: #t
      data: (bvec-alloc <string> (+ 1 (* width height))))))

(define-method close-image ((self <p5-image>))
  (let ((fd (filedes self)))
    (if (dirty? self)
	(begin
	  (fd-lseek fd (offset self) 0)
	  (let ((n (fd-write fd (data self) 0 (string-length (data self)))))
	    (assert (eq? n (string-length (data self)))))))
    (set-filedes! self -1)
    (fd-close fd)
    (values)))

(define-method set-pixel! ((self <p5-image>) y x v)
  (bvec-set! (data self) (+ x (* y (image-width self))) v)
  (values))
