#include "rstoret.h"
#include "scan.h"


obj write_dirty_pages( struct RStore *store )
{
  struct VMPageRecord *page;
  
  while ((page = store->first_dirty))
    {
      obj unresolved = write_page( store, page );
      if (!EQ(unresolved,NIL_OBJ))
	{
	  /* note that if there was anything unresolved,
	     we do NOT mark this page as clean, because it
	     wasn't written
	     */
	  return unresolved;
	}
      page->ref.dirty = 0;
      store->num_dirty--;
      if (!(store->first_dirty = page->next_dirty))
	{
	  store->last_dirty = NULL;
	}
      page->next_dirty = NULL;
      mm_set_prot( page->mem_address, MM_PAGE_SIZE, MM_MODE_READ_ONLY );
    }
  return NIL_OBJ;
}
