/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A 1  T133  R CALL_PREFIX_NOT 133
D 2  T142  R ABSTRACT_RESULT 143,144
A 1  T144  R ORDINARY_RESULT 144
A 1  T167  R LOCAL_VAR_LIST 167
A 1  T192  E NATIVE_ARRAY[INTEGER_CONSTANT] 192
D 8  T203  R ROUTINE 293,292,290,289,278,277,274,272
A 1  T46   E NATIVE_ARRAY[FORMAL_GENERIC_ARG] 46
A*1  T248  R ARRAY[TYPE] 248
A*1  T60   R SMALL_EIFFEL 60
A*1  T360  R DICTIONARY[TYPE_REF_TO_EXP,STRING] 360
A*1  T343  R DICTIONARY[MANIFEST_STRING,STRING] 343
A*1  T45   R ARRAY[FORMAL_GENERIC_ARG] 45
A 1  T258  R TYPE_NONE 258
A 1  T207  R E_CHECK 207
A*1  T321  R ARRAY[RUN_FEATURE] 321
A*1  T304  R ARRAY[EXPORT_ITEM] 304
A*1  T295  R ARRAY[DECLARATION] 295
A 1  T174  R ARRAY[LOCAL_NAME1] 174
A*1  T84   R ARRAY[RENAME_PAIR] 84
A 1  T234  R LOOP_VARIANT_2 234
A*1  T97   R STRING_ALIASER 97
A 1  T130  R PREFIX_NAME 130
A 1  T262  R TYPE_CLASS 262
A 1  T118  R CALL_INFIX_EQ 118
A*1  T322  R DICTIONARY[RUN_CLASS,STRING] 322
A*1  T87   R DICTIONARY[E_FEATURE,STRING] 87
A 1  T314  E NATIVE_ARRAY[RUN_FEATURE] 314
A 1  T306  E NATIVE_ARRAY[EXPORT_ITEM] 306
A 1  T296  E NATIVE_ARRAY[DECLARATION] 296
A 1  T213  E NATIVE_ARRAY[INSTRUCTION] 213
A 1  T175  E NATIVE_ARRAY[LOCAL_NAME1] 175
A 1  T85   E NATIVE_ARRAY[RENAME_PAIR] 85
A 1  T110  R CALL_INFIX_AND 110
A*1  T39   R STD_OUTPUT 39
A*1  T333  R MEMO[E_OLD] 333
A 1  T251  E NATIVE_ARRAY[TYPE] 251
A 1  T6    E BOOLEAN 6
A 1  T361  R FIXED_ARRAY[TYPE_REF_TO_EXP] 361
A 1  T197  R FIXED_ARRAY[MANIFEST_STRING] 197
A*1  T18   R INTEGER_REF 18
A 1  T200  R CST_ATT_REAL 200
A*1  T91   R FEATURE_CLAUSE 91
A 1  T362  E NATIVE_ARRAY[TYPE_REF_TO_EXP] 362
A 1  T299  E NATIVE_ARRAY[LOCAL_ARGUMENT1] 299
A 1  T198  E NATIVE_ARRAY[MANIFEST_STRING] 198
A 1  T77   E NATIVE_ARRAY[CREATION_CLAUSE] 77
A 1  T108  R CALL_INFIX_OR 108
A*1  T72   R PARSER_BUFFER 72
A 1  T255  R TYPE_CHARACTER 255
A 1  T270  R REVERSE_ASSIGNMENT 270
A 1  T344  R PRECURSOR_NAME 344
A 1  T146  R WRITTEN_CURRENT 146
A 1  T300  R DECLARATION_1 300
A 1  T2    E INTEGER 2
A 1  T292  R ONCE_PROCEDURE 292
A*1  T187  R TMP_FEATURE 187
A*1  T50   R ASSERTION 50
A*1  T334  R MANIFEST_ARRAY_POOL 334
A*1  T90   R FEATURE_CLAUSE_LIST 90
A*1  T43   R FORMAL_GENERIC_LIST 43
A*1  T68   R ERROR_HANDLER 68
A*1  T53   R COMMENT 53
D 3  T150  R PROC_CALL 153,152,151
D 11 T313  R RUN_FEATURE 363,337,338,353,352,325,327,349,348,328,345
A 1  T3    E CHARACTER 3
A 1  T201  R CST_ATT_DOUBLE 201
A 1  T188  R CST_ATT_UNIQUE 188
A*1  T193  R COUNTER 193
A*1  T319  R FIXED_ARRAY[PARENT] 319
A*1  T26   R FIXED_ARRAY[STRING] 26
D 2  T226  R WHEN_ITEM 230,229
A 1  T8    E POINTER 8
A 1  T246  R TYPE_LIKE_CURRENT 246
A 1  T256  R TYPE_DOUBLE 256
A 1  T121  R CALL_INFIX_DIV 121
A 1  T135  R E_STRIP 135
A*1  T232  R LOOP_INVARIANT 232
A 1  T347  R IMPLICIT_CAST 347
A 1  T114  R CALL_INFIX_LT 114
A 1  T112  R CALL_INFIX_GT 112
A 1  T260  R TYPE_REAL 260
A*1  T315  R RUN_REQUIRE 315
A 1  T172  R LOCAL_NAME1 172
D 8  T189  R CST_ATT 202,195,199,194,196,188,201,200
A 1  T181  E NATIVE_ARRAY[ARGUMENT_NAME1] 181
A 1  T93   E NATIVE_ARRAY[FEATURE_CLAUSE] 93
A 1  T250  R TYPE_ARRAY 250
A 1  T280  R NATIVE_WITH_CURRENT 280
A 1  T162  R REAL_CONSTANT 162
A*1  T342  R MANIFEST_STRING_POOL 342
A 1  T287  R NATIVE_JVM_INVOKEVIRTUAL 287
A 1  T169  R LOCAL_NAME2 169
A*1  T339  R ADDRESS_OF_POOL 339
A 1  T253  R TYPE_BOOLEAN 253
A*1  T323  R FIXED_ARRAY[RUN_CLASS] 323
A*1  T88   R FIXED_ARRAY[E_FEATURE] 88
A*1  T335  R DICTIONARY[TYPE,INTEGER] 335
A 1  T261  R TYPE_STRING 261
A 1  T123  R CALL_INFIX_INT_DIV 123
A*1  T354  R ONCE_ROUTINE_POOL 354
A*1  T309  R ARRAY[INDEX_CLAUSE] 309
A 1  T247  R TYPE_LIKE_ARGUMENT 247
D 2  T294  R DECLARATION 300,297
A 3  T312  R FIXED_ARRAY[RUN_FEATURE] 357,355,312
A*1  T206  R FIXED_ARRAY[INSTRUCTION] 206
A 1  T279  R NATIVE_SMALL_EIFFEL 279
A 1  T274  R DEFERRED_FUNCTION 274
A 1  T196  R CST_ATT_STRING 196
A*1  T17   R CREATION_CLAUSE_LIST 17
A 1  T220  R E_RETRY 220
A*1  T37   R STD_ERROR 37
A 1  T99   R MANIFEST_ARRAY 99
A 1  T151  R PROC_CALL_0 151
A 1  T122  R CALL_INFIX_INT_REM 122
D 2  T173  R LOCAL_ARGUMENT1 179,172
A 1  T229  R WHEN_ITEM_1 229
A 1  T219  R EXPRESSION_WITH_COMMENT 219
A 1  T152  R PROC_CALL_1 152
A*1  T36   R ECHO 36
A 1  T272  R DEFERRED_PROCEDURE 272
A*1  T311  R RUN_CLASS 311
A 1  T236  R CREATION_CALL_1 236
A 1  T221  R E_INSPECT 221
A 1  T140  R CALL_1_C 140
A 1  T138  R CALL_0_C 138
A*1  T223  R WHEN_LIST 223
D 2  T298  R ARRAY[LOCAL_ARGUMENT1] 180,174
A 1  T210  R ARRAY[MANIFEST_STRING] 210
A*1  T76   R ARRAY[CREATION_CLAUSE] 76
A 1  T115  R CALL_INFIX_LE 115
A 1  T113  R CALL_INFIX_GE 113
D 4  T288  R EFFECTIVE_ROUTINE 293,289,290,292
A 1  T230  R WHEN_ITEM_2 230
A*1  T205  R COMPOUND 205
A 1  T71   E NATIVE_ARRAY[POSITION] 71
D 22 T47   R TYPE 359,329,268,267,265,264,263,262,261,260,259,258,257,256,255,253,252,250,249,247,246,244
A 1  T148  R ADDRESS_OF 148
A 1  T285  R NATIVE_JVM_INVOKESTATIC 285
A 1  T328  R RUN_FEATURE_1 328
A*1  T32   R STD_FILE_READ 32
A 1  T297  R DECLARATION_GROUP 297
A 1  T161  R BIT_CONSTANT 161
A 1  T211  R IFTHENELSE 211
A*1  T74   R RUN_CONTROL 74
A 1  T268  R TYPE_FORMAL_GENERIC 268
A 1  T341  E NATIVE_ARRAY[ADDRESS_OF] 341
A 1  T186  E NATIVE_ARRAY[CLASS_NAME] 186
A 1  T100  E NATIVE_ARRAY[EXPRESSION] 100
A 1  T66   E NATIVE_ARRAY[BASE_CLASS] 66
A 1  T239  R CREATION_CALL_2 239
A*1  T303  R EXPORT_ITEM 303
A*1  T55   R TAG_NAME 55
A 1  T358  E NATIVE_ARRAY[RUN_FEATURE_6] 358
A 1  T356  E NATIVE_ARRAY[RUN_FEATURE_5] 356
A*1  T204  R E_ENSURE 204
A*1  T48   R CLASS_NAME 48
A 1  T259  R TYPE_POINTER 259
A 1  T257  R TYPE_INTEGER 257
A*1  T31   R SYSTEM_TOOLS 31
A 1  T337  R RUN_FEATURE_2 337
A 1  T126  R INFIX_NAME 126
D 6  T254  R TYPE_BASIC_EIFFEL_EXPANDED 257,259,253,260,256,255
A 1  T109  R CALL_INFIX_OR_ELSE 109
D 17 T149  R INSTRUCTION 270,269,243,241,239,236,233,221,220,211,214,209,207,166,153,152,151
A*1  T63   R FIXED_ARRAY[INTEGER] 63
A 1  T264  R TYPE_EXPANDED 264
A 1  T278  R EXTERNAL_FUNCTION 278
A 1  T111  R CALL_INFIX_AND_THEN 111
A 1  T136  R SIMPLE_FEATURE_NAME 136
A 1  T153  R PROC_CALL_N 153
A*1  T96   R TMP_NAME 96
A 1  T302  R FROZEN_FEATURE_NAME 302
A 1  T241  R CREATION_CALL_3 241
D 2  T231  R LOOP_VARIANT 235,234
A 1  T325  R RUN_FEATURE_3 325
A*1  T83   R RENAME_PAIR 83
D 7  T275  R NATIVE 287,285,284,283,282,280,279
A 1  T301  R WRITABLE_ATTRIBUTE 301
A 1  T277  R EXTERNAL_PROCEDURE 277
A 1  T357  R FIXED_ARRAY[RUN_FEATURE_6] 357
A 1  T355  R FIXED_ARRAY[RUN_FEATURE_5] 355
A 1  T145  R E_VOID 145
A 1  T352  R RUN_FEATURE_4 352
A 1  T243  R CREATION_CALL_4 243
A 1  T166  R E_PRECURSOR_PROCEDURE 166
A*1  T94   R CLIENT_LIST 94
A*1  T7    R STRING 7
D 2  T271  R DEFERRED_ROUTINE 272,274
A 1  T156  R E_TRUE 156
A 1  T225  E NATIVE_ARRAY[E_WHEN] 225
A 1  T218  E NATIVE_ARRAY[IFTHEN] 218
A 1  T59   E NATIVE_ARRAY[PARENT] 59
A 1  T27   E NATIVE_ARRAY[STRING] 27
A 1  T125  R CALL_INFIX_FREEOP 125
A 1  T290  R FUNCTION 290
A 1  T134  R E_OLD 134
A*1  T215  R IFTHEN 215
A 1  T194  R CST_ATT_BOOLEAN 194
A*1  T81   R RENAME_LIST 81
A 1  T284  R NATIVE_INLINE_WITHOUT_CURRENT 284
D 2  T165  R E_PRECURSOR 164,166
A*1  T56   R PARENT_LIST 56
A 1  T353  R RUN_FEATURE_5 353
A*1  T10   R SHORT 10
A 1  T141  R CALL_N 141
A*1  T95   R ID_PROVIDER 95
A 1  T127  R CALL_PREFIX_FREEOP 127
A*1  T70   R POSITION 70
A*1  T44   R FORMAL_GENERIC_ARG 44
A*1  T364  R ARRAY[BOOLEAN] 364
A*1  T160  R ARRAY[INTEGER] 160
A*1  T222  R E_WHEN 222
A 1  T252  R TYPE_NATIVE_ARRAY 252
D 5  T78   R FEATURE_NAME 344,302,136,126,130
A 1  T143  R ONCE_RESULT 143
A*1  T307  R INDEX_CLAUSE 307
A 1  T338  R RUN_FEATURE_6 338
A 1  T233  R E_LOOP 233
A*1  T57   R PARENT 57
A 1  T199  R CST_ATT_BIT 199
A 1  T164  R E_PRECURSOR_FUNCTION 164
A 1  T331  E NATIVE_ARRAY[TYPE_BIT_REF] 331
A 1  T310  E NATIVE_ARRAY[INDEX_CLAUSE] 310
A 1  T82   E NATIVE_ARRAY[FEATURE_NAME] 82
A*1  T305  R EXPORT_LIST 305
A*1  T224  R ARRAY[E_WHEN] 224
A*1  T217  R ARRAY[IFTHEN] 217
A*1  T58   R ARRAY[PARENT] 58
A*1  T35   R ARRAY[STRING] 35
A*1  T40   R SHORT_PRINT 40
A*1  T326  R ARRAY[RUN_CLASS] 326
A*1  T316  R ARRAY[E_REQUIRE] 316
A*1  T227  R ARRAY[WHEN_ITEM] 227
A*1  T51   R ARRAY[ASSERTION] 51
D 2  T291  R ONCE_ROUTINE 293,292
A 1  T282  R NATIVE_INLINE_WITH_CURRENT 282
A 1  T349  R RUN_FEATURE_7 349
A 1  T263  R TYPE_GENERIC 263
A 1  T340  R FIXED_ARRAY[ADDRESS_OF] 340
A*1  T185  R FIXED_ARRAY[CLASS_NAME] 185
A 4  T139  R FIXED_ARRAY[EXPRESSION] 340,197,191,139
A*1  T65   R FIXED_ARRAY[BASE_CLASS] 65
A 3  T336  R FIXED_ARRAY[TYPE] 361,336,330
D 2  T276  R EXTERNAL_ROUTINE 277,278
D 2  T168  R DECLARATION_LIST 176,167
A 1  T244  R TYPE_LIKE_FEATURE 244
D 51 T54   R EXPRESSION 347,179,172,219,101,107,108,109,110,111,112,114,113,115,116,118,119,120,121,122,123,124,183,125,134,182,177,169,164,163,162,161,159,158,157,156,148,146,145,144,143,141,140,138,136,135,127,131,132,133,99
A 1  T183  R CALL_INFIX_POWER 183
A*1  T318  R DICTIONARY[RUN_FEATURE,STRING] 318
A 1  T327  R RUN_FEATURE_8 327
A*1  T346  R EXCEPTIONS_HANDLER 346
D 2  T266  R TYPE_BIT 267,265
A*1  T75   R CREATION_CLAUSE 75
A 1  T179  R ARGUMENT_NAME1 179
A*1  T208  R CHECK_INVARIANT 208
A*1  T69   R FIXED_ARRAY[POSITION] 69
A 4  T98   R ARRAY[EXPRESSION] 180,174,210,98
A 1  T348  R RUN_FEATURE_9 348
A 1  T214  R INSTRUCTION_WITH_COMMENT 214
A*1  T350  R C_PRETTY_PRINTER 350
A*1  T137  R EFFECTIVE_ARG_LIST 137
A 1  T132  R CALL_PREFIX_PLUS 132
A 1  T124  R CALL_INFIX_TIMES 124
A 1  T119  R CALL_INFIX_MINUS 119
A*1  T73   R DICTIONARY[STRING,STRING] 73
A 1  T195  R CST_ATT_CHARACTER 195
A 1  T116  R CALL_INFIX_NEQ 116
A 1  T359  R TYPE_REF_TO_EXP 359
D 17 T86   R E_FEATURE 301,293,292,290,289,278,277,274,272,202,201,200,199,196,195,194,188
A 1  T324  E NATIVE_ARRAY[RUN_CLASS] 324
A 1  T317  E NATIVE_ARRAY[E_REQUIRE] 317
A 1  T228  E NATIVE_ARRAY[WHEN_ITEM] 228
A 1  T89   E NATIVE_ARRAY[E_FEATURE] 89
A 1  T52   E NATIVE_ARRAY[ASSERTION] 52
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T131  R CALL_PREFIX_MINUS 131
A*1  T62   R DICTIONARY[BASE_CLASS,STRING] 62
A 1  T329  R TYPE_BIT_REF 329
A 1  T330  R FIXED_ARRAY[TYPE_BIT_REF] 330
A*1  T80   R FIXED_ARRAY[FEATURE_NAME] 80
A 1  T158  R CHARACTER_CONSTANT 158
D 2  T154  R BOOLEAN_CONSTANT 157,156
A 1  T177  R ARGUMENT_NAME2 177
A 1  T289  R PROCEDURE 289
A 1  T202  R CST_ATT_INTEGER 202
A 1  T120  R CALL_INFIX_PLUS 120
A 1  T363  R RUN_FEATURE_10 363
A*1  T216  R IFTHENLIST 216
A*1  T22   R BASE_CLASS 22
A 1  T293  R ONCE_FUNCTION 293
A 1  T191  R FIXED_ARRAY[INTEGER_CONSTANT] 191
A 1  T249  R TYPE_ANY 249
A 1  T265  R TYPE_BIT_1 265
A 1  T163  R INTEGER_CONSTANT 163
A 1  T269  R ASSIGNMENT 269
A 1  T157  R E_FALSE 157
A*1  T308  R INDEX_LIST 308
A 1  T107  R CALL_INFIX_XOR 107
A*1  T79   R FEATURE_NAME_LIST 79
A 1  T209  R E_DEBUG 209
A 1  T180  R ARRAY[ARGUMENT_NAME1] 180
A*1  T92   R ARRAY[FEATURE_CLAUSE] 92
A 1  T159  R MANIFEST_STRING 159
A 1  T176  R FORMAL_ARG_LIST 176
A 1  T182  R IMPLICIT_CURRENT 182
A 1  T101  R CALL_INFIX_IMPLIES 101
A*1  T184  R CLASS_NAME_LIST 184
A*1  T41   R CLASS_INVARIANT 41
A*1  T273  R E_REQUIRE 273
A 1  T267  R TYPE_BIT_2 267
A 1  T365  E NATIVE_ARRAY[BOOLEAN] 365
A 1  T64   E NATIVE_ARRAY[INTEGER] 64
A 1  T235  R LOOP_VARIANT_1 235
A 1  T345  R RUN_FEATURE_11 345
A*1  T67   R EIFFEL_PARSER 67
A*1  T320  R ASSERTION_COLLECTOR 320
A 1  T283  R NATIVE_WITHOUT_CURRENT 283
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S133 T133;
typedef struct S144 T144;
typedef struct S167 T167;
typedef struct S163 T163;
typedef struct S44 T44;
typedef struct S248 T248;
typedef struct S60 T60;
typedef struct S360 T360;
typedef struct S343 T343;
typedef struct S45 T45;
typedef struct S258 T258;
typedef struct S207 T207;
typedef struct S321 T321;
typedef struct S304 T304;
typedef struct S295 T295;
typedef struct S174 T174;
typedef struct S84 T84;
typedef struct S234 T234;
typedef void*T97;
typedef struct S130 T130;
typedef struct S262 T262;
typedef struct S118 T118;
typedef struct S322 T322;
typedef struct S87 T87;
typedef struct S303 T303;
typedef struct S172 T172;
typedef struct S83 T83;
typedef struct S110 T110;
typedef void*T39;
typedef struct S333 T333;
typedef struct S361 T361;
typedef struct S197 T197;
typedef struct S18 T18;
typedef struct S200 T200;
typedef struct S91 T91;
typedef struct S359 T359;
typedef struct S159 T159;
typedef struct S75 T75;
typedef struct S108 T108;
typedef struct S72 T72;
typedef struct S255 T255;
typedef struct S270 T270;
typedef struct S344 T344;
typedef struct S146 T146;
typedef struct S300 T300;
typedef struct S292 T292;
typedef struct S187 T187;
typedef struct S50 T50;
typedef void*T334;
typedef struct S90 T90;
typedef struct S43 T43;
typedef struct S68 T68;
typedef struct S53 T53;
typedef struct S201 T201;
typedef struct S188 T188;
typedef struct S193 T193;
typedef struct S319 T319;
typedef struct S26 T26;
typedef struct S246 T246;
typedef struct S256 T256;
typedef struct S121 T121;
typedef struct S135 T135;
typedef struct S232 T232;
typedef struct S347 T347;
typedef struct S114 T114;
typedef struct S112 T112;
typedef struct S260 T260;
typedef struct S315 T315;
typedef struct S179 T179;
typedef struct S250 T250;
typedef struct S280 T280;
typedef struct S162 T162;
typedef void*T342;
typedef struct S287 T287;
typedef struct S169 T169;
typedef void*T339;
typedef struct S253 T253;
typedef struct S323 T323;
typedef struct S88 T88;
typedef struct S335 T335;
typedef struct S261 T261;
typedef struct S123 T123;
typedef void*T354;
typedef struct S309 T309;
typedef struct S247 T247;
typedef struct S312 T312;
typedef struct S206 T206;
typedef struct S279 T279;
typedef struct S274 T274;
typedef struct S196 T196;
typedef struct S17 T17;
typedef struct S220 T220;
typedef void*T37;
typedef struct S99 T99;
typedef struct S151 T151;
typedef struct S122 T122;
typedef struct S229 T229;
typedef struct S219 T219;
typedef struct S152 T152;
typedef struct S36 T36;
typedef struct S272 T272;
typedef struct S311 T311;
typedef struct S236 T236;
typedef struct S221 T221;
typedef struct S140 T140;
typedef struct S138 T138;
typedef struct S223 T223;
typedef struct S210 T210;
typedef struct S76 T76;
typedef struct S115 T115;
typedef struct S113 T113;
typedef struct S230 T230;
typedef struct S205 T205;
typedef struct S70 T70;
typedef struct S148 T148;
typedef struct S285 T285;
typedef struct S328 T328;
typedef struct S32 T32;
typedef struct S297 T297;
typedef struct S161 T161;
typedef struct S211 T211;
typedef struct S74 T74;
typedef struct S268 T268;
typedef struct S48 T48;
typedef struct S22 T22;
typedef struct S239 T239;
typedef struct S55 T55;
typedef struct S338 T338;
typedef struct S353 T353;
typedef struct S204 T204;
typedef struct S259 T259;
typedef struct S257 T257;
typedef struct S31 T31;
typedef struct S337 T337;
typedef struct S126 T126;
typedef struct S109 T109;
typedef struct S63 T63;
typedef struct S264 T264;
typedef struct S278 T278;
typedef struct S111 T111;
typedef struct S136 T136;
typedef struct S153 T153;
typedef struct S96 T96;
typedef struct S302 T302;
typedef struct S241 T241;
typedef struct S325 T325;
typedef struct S301 T301;
typedef struct S277 T277;
typedef struct S357 T357;
typedef struct S355 T355;
typedef struct S145 T145;
typedef struct S352 T352;
typedef struct S243 T243;
typedef struct S166 T166;
typedef struct S94 T94;
typedef struct S7 T7;
typedef struct S156 T156;
typedef struct S222 T222;
typedef struct S215 T215;
typedef struct S57 T57;
typedef struct S125 T125;
typedef struct S290 T290;
typedef struct S134 T134;
typedef struct S194 T194;
typedef struct S81 T81;
typedef struct S284 T284;
typedef struct S56 T56;
typedef struct S10 T10;
typedef struct S141 T141;
typedef struct S95 T95;
typedef struct S127 T127;
typedef struct S364 T364;
typedef struct S160 T160;
typedef struct S252 T252;
typedef struct S143 T143;
typedef struct S307 T307;
typedef struct S233 T233;
typedef struct S199 T199;
typedef struct S164 T164;
typedef struct S329 T329;
typedef struct S305 T305;
typedef struct S224 T224;
typedef struct S217 T217;
typedef struct S58 T58;
typedef struct S35 T35;
typedef struct S40 T40;
typedef struct S326 T326;
typedef struct S316 T316;
typedef struct S227 T227;
typedef struct S51 T51;
typedef struct S282 T282;
typedef struct S349 T349;
typedef struct S263 T263;
typedef struct S340 T340;
typedef struct S185 T185;
typedef struct S139 T139;
typedef struct S65 T65;
typedef struct S336 T336;
typedef struct S244 T244;
typedef struct S183 T183;
typedef struct S318 T318;
typedef struct S327 T327;
typedef struct S346 T346;
typedef struct S208 T208;
typedef struct S69 T69;
typedef struct S98 T98;
typedef struct S348 T348;
typedef struct S214 T214;
typedef struct S350 T350;
typedef struct S137 T137;
typedef struct S132 T132;
typedef struct S124 T124;
typedef struct S119 T119;
typedef struct S73 T73;
typedef struct S195 T195;
typedef struct S116 T116;
typedef struct S273 T273;
typedef struct S131 T131;
typedef struct S62 T62;
typedef struct S330 T330;
typedef struct S80 T80;
typedef struct S158 T158;
typedef struct S177 T177;
typedef struct S289 T289;
typedef struct S202 T202;
typedef struct S120 T120;
typedef struct S363 T363;
typedef struct S216 T216;
typedef struct S293 T293;
typedef struct S191 T191;
typedef struct S249 T249;
typedef struct S265 T265;
typedef struct S269 T269;
typedef struct S157 T157;
typedef struct S308 T308;
typedef struct S107 T107;
typedef struct S79 T79;
typedef struct S209 T209;
typedef struct S180 T180;
typedef struct S92 T92;
typedef struct S176 T176;
typedef struct S182 T182;
typedef struct S101 T101;
typedef struct S184 T184;
typedef struct S41 T41;
typedef struct S267 T267;
typedef struct S235 T235;
typedef struct S345 T345;
typedef struct S67 T67;
typedef struct S320 T320;
typedef struct S283 T283;

/*C Header Pass 2 :*/
typedef T0**T192;
typedef T0**T46;
typedef T0**T314;
typedef T0**T306;
typedef T0**T296;
typedef T0**T213;
typedef T0**T175;
typedef T0**T85;
typedef T0**T251;
typedef T0**T362;
typedef T0**T299;
typedef T0**T198;
typedef T0**T77;
typedef T0**T181;
typedef T0**T93;
typedef T0**T71;
typedef T0**T341;
typedef T0**T186;
typedef T0**T100;
typedef T0**T66;
typedef T0**T358;
typedef T0**T356;
typedef T0**T225;
typedef T0**T218;
typedef T0**T59;
typedef T0**T27;
typedef T0**T331;
typedef T0**T310;
typedef T0**T82;
typedef T0**T324;
typedef T0**T317;
typedef T0**T228;
typedef T0**T89;
typedef T0**T52;
typedef T3*T9;
typedef T6*T365;
typedef T2*T64;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S133{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T133 M133;
struct S144{int id;T0* _start_position;T0* _run_feature;};
extern T144 M144;
struct S167{int id;T0* _list;T0* _flat_list;};
extern T167 M167;
struct S248{T251 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T248 M248;
struct S60{T6 _short_flag;T6 _pretty_flag;T2 _magic_count;T2 _top;};
extern T60 M60;
struct S360{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T360 M360;
struct S343{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T343 M343;
struct S45{T46 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T45 M45;
struct S258{int id;T0* _base_class_name;};
extern T258 M258;
struct S207{int id;T0* _check_invariant;T0* _current_type;};
extern T207 M207;
struct S321{T314 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T321 M321;
struct S304{T306 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T304 M304;
struct S295{T296 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T295 M295;
struct S174{int id;T175 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T174 M174;
struct S84{T85 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T84 M84;
struct S234{int id;T0* _comment;T0* _expression;T0* _current_type;T0* _tag;};
extern T234 M234;
extern T97 M97;
struct S130{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T130 M130;
struct S262{int id;T0* _base_class_name;};
extern T262 M262;
struct S118{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T118 M118;
struct S322{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T322 M322;
struct S87{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T87 M87;
struct S110{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T110 M110;
extern T39 M39;
struct S333{T0* _item;};
extern T333 M333;
struct S361{int id;T362 _storage;T2 _capacity;T2 _upper;};
extern T361 M361;
struct S197{int id;T198 _storage;T2 _capacity;T2 _upper;};
extern T197 M197;
struct S18{T2 _item;};
extern T18 M18;
struct S200{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T200 M200;
struct S91{T0* _clients;T0* _comment;T0* _list;};
extern T91 M91;
struct S108{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T108 M108;
struct S72{T0* _path;T2 _count;};
extern T72 M72;
struct S255{int id;T0* _base_class_name;};
extern T255 M255;
struct S270{int id;T0* _left_side;T0* _right_side;T0* _current_type;};
extern T270 M270;
struct S344{int id;T0* _enclosing;T0* _to_key;};
extern T344 M344;
struct S146{int id;T0* _start_position;T0* _result_type;};
extern T146 M146;
struct S300{int id;T0* _name;};
extern T300 M300;
struct S292{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T292 M292;
struct S187{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
extern T187 M187;
struct S50{T0* _tag;T0* _expression;T0* _comment;T0* _current_type;};
extern T50 M50;
extern T334 M334;
struct S90{T0* _list;};
extern T90 M90;
struct S43{T0* _start_position;T0* _list;};
extern T43 M43;
struct S68{T2 _error_counter;T2 _warning_counter;T6 _no_warning;};
extern T68 M68;
struct S53{T0* _start_position;T0* _list;};
extern T53 M53;
struct S201{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T201 M201;
struct S188{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _values;};
extern T188 M188;
struct S193{T2 _value;};
extern T193 M193;
struct S319{T59 _storage;T2 _capacity;T2 _upper;};
extern T319 M319;
struct S26{T27 _storage;T2 _capacity;T2 _upper;};
extern T26 M26;
struct S246{int id;T0* _start_position;T0* _run_type;};
extern T246 M246;
struct S256{int id;T0* _base_class_name;};
extern T256 M256;
struct S121{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T121 M121;
struct S135{int id;T0* _start_position;T0* _current_type;T0* _list;T0* _result_type_memory;};
extern T135 M135;
struct S232{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T232 M232;
struct S347{int id;T0* _expression;T0* _result_type;};
extern T347 M347;
struct S114{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T114 M114;
struct S112{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T112 M112;
struct S260{int id;T0* _base_class_name;};
extern T260 M260;
struct S315{T0* _list;};
extern T315 M315;
struct S172{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;T6 _is_used;};
extern T172 M172;
struct S250{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T250 M250;
struct S280{int id;};
extern T280 M280;
struct S162{int id;T0* _start_position;T0* _to_string;};
extern T162 M162;
extern T342 M342;
struct S287{int id;};
extern T287 M287;
struct S169{int id;T0* _start_position;T2 _rank;T0* _local_var_list;};
extern T169 M169;
extern T339 M339;
struct S253{int id;T0* _base_class_name;};
extern T253 M253;
struct S323{T324 _storage;T2 _capacity;T2 _upper;};
extern T323 M323;
struct S88{T89 _storage;T2 _capacity;T2 _upper;};
extern T88 M88;
struct S335{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T335 M335;
struct S261{int id;T0* _base_class_name;};
extern T261 M261;
struct S123{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T123 M123;
extern T354 M354;
struct S309{T310 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T309 M309;
struct S247{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_feature;};
extern T247 M247;
struct S312{int id;T314 _storage;T2 _capacity;T2 _upper;};
extern T312 M312;
struct S206{T213 _storage;T2 _capacity;T2 _upper;};
extern T206 M206;
struct S279{int id;};
extern T279 M279;
struct S274{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _result_type;};
extern T274 M274;
struct S196{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _first_value;T0* _remainder;};
extern T196 M196;
struct S17{T0* _list;};
extern T17 M17;
struct S220{int id;T0* _start_position;T0* _run_feature;};
extern T220 M220;
extern T37 M37;
struct S99{int id;T0* _start_position;T0* _list;T0* _result_type;T0* _current_type;};
extern T99 M99;
struct S151{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T151 M151;
struct S122{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T122 M122;
struct S229{int id;T0* _e_when;T0* _expression;T2 _expression_value;};
extern T229 M229;
struct S219{int id;T0* _expression;T0* _comment;};
extern T219 M219;
struct S152{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T152 M152;
struct S36{T6 _verbose;};
extern T36 M36;
struct S272{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T272 M272;
struct S311{T0* _current_type;T2 _id;T6 _at_run_time;T0* _running;T0* _class_invariant;T6 _compile_to_c_done;T0* _feature_dictionary;T0* _actuals_clients;T6 _strip_used;T6 _runnable_class_invariant_done;};
extern T311 M311;
struct S236{int id;T0* _start_position;T0* _writable;T0* _current_type;};
extern T236 M236;
struct S221{int id;T0* _start_position;T0* _expression;T0* _when_list;T0* _else_position;T0* _else_compound;T0* _current_type;};
extern T221 M221;
struct S140{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T140 M140;
struct S138{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T138 M138;
struct S223{T0* _e_inspect;T0* _list;};
extern T223 M223;
struct S210{int id;T198 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T210 M210;
struct S76{T77 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T76 M76;
struct S115{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T115 M115;
struct S113{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T113 M113;
struct S230{int id;T0* _e_when;T0* _upper;T0* _lower;T2 _lower_value;T2 _upper_value;};
extern T230 M230;
struct S205{T0* _header_comment;T0* _current_type;T0* _first_one;T0* _remainder;};
extern T205 M205;
struct S148{int id;T0* _feature_name;T0* _current_type;T0* _run_feature;};
extern T148 M148;
struct S285{int id;};
extern T285 M285;
struct S328{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _value;T0* _result_type;};
extern T328 M328;
struct S32{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T32 M32;
struct S297{int id;T0* _name_list;};
extern T297 M297;
struct S161{int id;T0* _start_position;T0* _value;T0* _result_type;T0* _hexa;};
extern T161 M161;
struct S211{int id;T0* _start_position;T0* _ifthenlist;T0* _else_compound;T0* _current_type;};
extern T211 M211;
struct S74{T2 _level;T6 _generating_type_used;T6 _generator_used;};
extern T74 M74;
struct S268{int id;T0* _formal_name;T2 _rank;T0* _run_type;};
extern T268 M268;
struct S239{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _type;};
extern T239 M239;
struct S303{T0* _clients;T0* _list;};
extern T303 M303;
struct S55{T0* _to_string;T0* _start_position;};
extern T55 M55;
struct S204{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_ensure_then;};
extern T204 M204;
struct S48{T0* _to_string;T0* _start_position;};
extern T48 M48;
struct S259{int id;T0* _base_class_name;};
extern T259 M259;
struct S257{int id;T0* _base_class_name;};
extern T257 M257;
struct S31{T0* _system_name;T0* _sys_directory;T0* _bin_directory;};
extern T31 M31;
struct S337{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _result_type;};
extern T337 M337;
struct S126{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T126 M126;
struct S109{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T109 M109;
struct S63{T64 _storage;T2 _capacity;T2 _upper;};
extern T63 M63;
struct S264{int id;T0* _start_position;T0* _written_mark;T0* _mapped;T0* _run_time_mark;T0* _run_type;};
extern T264 M264;
struct S278{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;T0* _result_type;};
extern T278 M278;
struct S111{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T111 M111;
struct S136{int id;T0* _to_string;T0* _start_position;T0* _run_feature_2;};
extern T136 M136;
struct S153{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T153 M153;
struct S96{T2 _column;T2 _line;T0* _aliased_string_memory;};
extern T96 M96;
struct S302{int id;T0* _feature_name;};
extern T302 M302;
struct S241{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _call;};
extern T241 M241;
struct S325{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T325 M325;
struct S83{T0* _new_name;T0* _old_name;};
extern T83 M83;
struct S301{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;};
extern T301 M301;
struct S277{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T277 M277;
struct S357{int id;T358 _storage;T2 _capacity;T2 _upper;};
extern T357 M357;
struct S355{int id;T356 _storage;T2 _capacity;T2 _upper;};
extern T355 M355;
struct S145{int id;T0* _start_position;};
extern T145 M145;
struct S352{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T352 M352;
struct S243{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _type;T0* _call;};
extern T243 M243;
struct S166{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T166 M166;
struct S94{T0* _start_position;T0* _list;};
extern T94 M94;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S156{int id;T0* _start_position;};
extern T156 M156;
struct S125{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T125 M125;
struct S290{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T290 M290;
struct S134{int id;T0* _expression;T0* _current_type;};
extern T134 M134;
struct S215{T0* _expression;T0* _then_compound;T0* _current_type;};
extern T215 M215;
struct S194{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T194 M194;
struct S81{T0* _list;};
extern T81 M81;
struct S284{int id;};
extern T284 M284;
struct S56{T0* _base_class;T0* _start_position;T0* _heading_comment;T0* _list;};
extern T56 M56;
struct S353{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T353 M353;
struct S10{T0* _root_class;T0* _format;T0* _run_class;T6 _sort;T6 _short;};
extern T10 M10;
struct S141{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T141 M141;
struct S95{T0* _mem_id;T0* _mem_str;};
extern T95 M95;
struct S127{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T127 M127;
struct S70{T0* _base_class_name;T2 _mem_line_column;};
extern T70 M70;
struct S44{T0* _name;T0* _constraint;};
extern T44 M44;
struct S364{T365 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T364 M364;
struct S160{T64 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T160 M160;
struct S222{T0* _start_position;T0* _list;T0* _header_comment;T0* _compound;T0* _when_list;T0* _values;};
extern T222 M222;
struct S252{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T252 M252;
struct S143{int id;T0* _start_position;T0* _run_feature_6;};
extern T143 M143;
struct S307{T0* _tag;T0* _list;};
extern T307 M307;
struct S338{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T338 M338;
struct S233{int id;T0* _start_position;T0* _initialize;T0* _invariant_clause;T0* _variant_clause;T0* _until_expression;T0* _loop_body;T0* _current_type;};
extern T233 M233;
struct S57{T0* _parent_list;T0* _type;T0* _comment;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _select_list;T0* _undefine_memory1;T0* _undefine_memory2;};
extern T57 M57;
struct S199{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T199 M199;
struct S164{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T164 M164;
struct S305{T0* _start_position;T0* _items;};
extern T305 M305;
struct S224{T225 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T224 M224;
struct S217{T218 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T217 M217;
struct S58{T59 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T58 M58;
struct S35{T27 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T35 M35;
struct S40{T0* _format_directory;T0* _base_class;T0* _run_class;};
extern T40 M40;
struct S326{T324 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T326 M326;
struct S316{T317 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T316 M316;
struct S227{T228 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T227 M227;
struct S51{T52 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T51 M51;
struct S282{int id;};
extern T282 M282;
struct S349{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _ensure_assertion;};
extern T349 M349;
struct S263{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T263 M263;
struct S340{int id;T341 _storage;T2 _capacity;T2 _upper;};
extern T340 M340;
struct S185{T186 _storage;T2 _capacity;T2 _upper;};
extern T185 M185;
struct S139{int id;T100 _storage;T2 _capacity;T2 _upper;};
extern T139 M139;
struct S65{T66 _storage;T2 _capacity;T2 _upper;};
extern T65 M65;
struct S336{int id;T251 _storage;T2 _capacity;T2 _upper;};
extern T336 M336;
struct S244{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_type;};
extern T244 M244;
struct S183{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T183 M183;
struct S318{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T318 M318;
struct S327{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T327 M327;
struct S346{T6 _used;};
extern T346 M346;
struct S75{T0* _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T75 M75;
struct S179{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;};
extern T179 M179;
struct S208{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T208 M208;
struct S69{T71 _storage;T2 _capacity;T2 _upper;};
extern T69 M69;
struct S98{int id;T100 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T98 M98;
struct S348{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T348 M348;
struct S214{int id;T0* _instruction;T0* _comment;};
extern T214 M214;
struct S350{T6 _basic_directory_used;};
extern T350 M350;
struct S137{T0* _first_one;T0* _remainder;T0* _current_type;};
extern T137 M137;
struct S132{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T132 M132;
struct S124{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T124 M124;
struct S119{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T119 M119;
struct S73{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T73 M73;
struct S195{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T195 M195;
struct S116{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T116 M116;
struct S359{int id;T0* _run_class;T0* _written_mark;T0* _expanded_type;};
extern T359 M359;
struct S131{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T131 M131;
struct S62{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T62 M62;
struct S329{int id;T0* _type_bit;T0* _written_mark;T0* _run_time_mark;};
extern T329 M329;
struct S330{int id;T331 _storage;T2 _capacity;T2 _upper;};
extern T330 M330;
struct S80{T82 _storage;T2 _capacity;T2 _upper;};
extern T80 M80;
struct S158{int id;T0* _start_position;T3 _value;T2 _pretty_print_mode;};
extern T158 M158;
struct S177{int id;T0* _start_position;T2 _rank;T0* _formal_arg_list;};
extern T177 M177;
struct S289{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T289 M289;
struct S202{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T202 M202;
struct S120{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T120 M120;
struct S363{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T363 M363;
struct S216{T0* _list;T0* _current_type;};
extern T216 M216;
struct S22{T2 _id;T0* _path;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_type_string;T0* _parent_list;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T0* _feature_dictionary;T0* _isom;};
extern T22 M22;
struct S293{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T293 M293;
struct S191{int id;T192 _storage;T2 _capacity;T2 _upper;};
extern T191 M191;
struct S249{int id;T0* _base_class_name;};
extern T249 M249;
struct S265{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;};
extern T265 M265;
struct S163{int id;T0* _start_position;T2 _value;};
extern T163 M163;
struct S269{int id;T0* _left_side;T0* _right_side;};
extern T269 M269;
struct S157{int id;T0* _start_position;};
extern T157 M157;
struct S308{T0* _list;};
extern T308 M308;
struct S107{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T107 M107;
struct S79{T0* _first;T0* _remainder;};
extern T79 M79;
struct S209{int id;T0* _start_position;T0* _list;T0* _compound;T0* _current_type;};
extern T209 M209;
struct S180{int id;T181 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T180 M180;
struct S92{T93 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T92 M92;
struct S159{int id;T0* _start_position;T0* _to_string;T0* _break;T0* _ascii;T0* _percent;T0* _mangling;};
extern T159 M159;
struct S176{int id;T0* _list;T0* _flat_list;};
extern T176 M176;
struct S182{int id;T0* _start_position;T0* _result_type;};
extern T182 M182;
struct S101{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T101 M101;
struct S184{T0* _first;T0* _remainder;};
extern T184 M184;
struct S41{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T41 M41;
struct S273{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_require_else;};
extern T273 M273;
struct S267{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;T2 _nb;};
extern T267 M267;
struct S235{int id;T0* _comment;T0* _expression;T0* _current_type;};
extern T235 M235;
struct S345{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T345 M345;
struct S67{T6 _case_insensitive;T6 _no_style_warning;T6 _drop_comments;T6 _is_running;T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_comments;T6 _inside_function;T6 _inside_once_function;T0* _formal_generic_list;T6 _in_ensure;T6 _in_rescue;T0* _arguments;T0* _local_vars;T6 _ok;T2 _last_ascii_code;T0* _last_base_class;T0* _last_base_type;T0* _last_binary;T0* _last_bit_constant;T0* _last_boolean_constant;T0* _last_character_constant;T0* _last_class_name;T0* _last_class_type;T0* _last_expression;T0* _last_feature_declaration;T0* _last_feature_name;T0* _last_feature_name_list;T0* _last_keyword;T0* _last_type_formal_generic;T0* _last_infix;T0* _last_prefix;T0* _last_integer_constant;T0* _last_instruction;T0* _last_index_value;T0* _last_manifest_constant;T0* _last_manifest_string;T0* _last_parent;T0* _last_real_constant;T0* _last_type;T0* _last_tag_mark;T2 _start_column;T2 _start_line;};
extern T67 M67;
struct S320{T6 _processing_require;T0* _header_comment;};
extern T320 M320;
struct S283{int id;};
extern T283 M283;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T2 r2min(T2 C,T2 a1);
T2 r2max(T2 C,T2 a1);
T2 r2hash_code(T2 C);
T3 r2digit(T2 C);
T3 r2hexadecimal_digit(T2 C);
void r2append_in(T2 C,T0* a1);
T0* r2to_string(T2 C);
T3 r3to_lower(T3 C);
T2 r3value(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3is_separator(T3 C);
T6 r3same_as(T3 C,T3 a1);
T6 r3is_digit(T3 C);
T6 r3_px_60(T3 C,T3 a1);
T3 r3to_upper(T3 C);
T192 r192realloc(T192 C,T2 a1,T2 a2);
void r192copy_from(T192 C,T192 a1,T2 a2);
void r192set_all_with(T192 C,T0* a1,T2 a2);
void r192clear_all(T192 C,T2 a1);
T46 r46realloc(T46 C,T2 a1,T2 a2);
void r46copy_from(T46 C,T46 a1,T2 a2);
void r314clear(T314 C,T2 a1,T2 a2);
T314 r314realloc(T314 C,T2 a1,T2 a2);
void r314move(T314 C,T2 a1,T2 a2,T2 a3);
void r314copy_from(T314 C,T314 a1,T2 a2);
void r314set_all_with(T314 C,T0* a1,T2 a2);
T2 r314fast_index_of(T314 C,T0* a1,T2 a2);
T306 r306realloc(T306 C,T2 a1,T2 a2);
void r306copy_from(T306 C,T306 a1,T2 a2);
T296 r296realloc(T296 C,T2 a1,T2 a2);
void r296copy_from(T296 C,T296 a1,T2 a2);
T213 r213realloc(T213 C,T2 a1,T2 a2);
void r213copy_from(T213 C,T213 a1,T2 a2);
void r213clear_all(T213 C,T2 a1);
T175 r175realloc(T175 C,T2 a1,T2 a2);
void r175copy_from(T175 C,T175 a1,T2 a2);
void r175set_all_with(T175 C,T0* a1,T2 a2);
T85 r85realloc(T85 C,T2 a1,T2 a2);
void r85copy_from(T85 C,T85 a1,T2 a2);
T251 r251realloc(T251 C,T2 a1,T2 a2);
void r251copy_from(T251 C,T251 a1,T2 a2);
void r251set_all_with(T251 C,T0* a1,T2 a2);
T362 r362realloc(T362 C,T2 a1,T2 a2);
void r362copy_from(T362 C,T362 a1,T2 a2);
void r362set_all_with(T362 C,T0* a1,T2 a2);
T198 r198realloc(T198 C,T2 a1,T2 a2);
void r198copy_from(T198 C,T198 a1,T2 a2);
void r198set_all_with(T198 C,T0* a1,T2 a2);
void r198clear_all(T198 C,T2 a1);
T77 r77realloc(T77 C,T2 a1,T2 a2);
void r77copy_from(T77 C,T77 a1,T2 a2);
T181 r181realloc(T181 C,T2 a1,T2 a2);
void r181copy_from(T181 C,T181 a1,T2 a2);
void r181set_all_with(T181 C,T0* a1,T2 a2);
T93 r93realloc(T93 C,T2 a1,T2 a2);
void r93copy_from(T93 C,T93 a1,T2 a2);
T71 r71realloc(T71 C,T2 a1,T2 a2);
T6 r71equal_like(T0* a1,T0* a2);
void r71copy_from(T71 C,T71 a1,T2 a2);
T2 r71fast_index_of(T71 C,T0* a1,T2 a2);
T2 r71index_of(T71 C,T0* a1,T2 a2);
T341 r341realloc(T341 C,T2 a1,T2 a2);
void r341copy_from(T341 C,T341 a1,T2 a2);
void r341clear_all(T341 C,T2 a1);
T186 r186realloc(T186 C,T2 a1,T2 a2);
void r186copy_from(T186 C,T186 a1,T2 a2);
T100 r100realloc(T100 C,T2 a1,T2 a2);
void r100copy_from(T100 C,T100 a1,T2 a2);
void r100clear_all(T100 C,T2 a1);
T66 r66realloc(T66 C,T2 a1,T2 a2);
void r66copy_from(T66 C,T66 a1,T2 a2);
void r66set_all_with(T66 C,T0* a1,T2 a2);
T2 r66fast_index_of(T66 C,T0* a1,T2 a2);
T358 r358realloc(T358 C,T2 a1,T2 a2);
void r358copy_from(T358 C,T358 a1,T2 a2);
void r358set_all_with(T358 C,T0* a1,T2 a2);
T2 r358fast_index_of(T358 C,T0* a1,T2 a2);
T356 r356realloc(T356 C,T2 a1,T2 a2);
void r356copy_from(T356 C,T356 a1,T2 a2);
void r356set_all_with(T356 C,T0* a1,T2 a2);
T2 r356fast_index_of(T356 C,T0* a1,T2 a2);
T225 r225realloc(T225 C,T2 a1,T2 a2);
void r225copy_from(T225 C,T225 a1,T2 a2);
T218 r218realloc(T218 C,T2 a1,T2 a2);
void r218copy_from(T218 C,T218 a1,T2 a2);
T59 r59realloc(T59 C,T2 a1,T2 a2);
void r59copy_from(T59 C,T59 a1,T2 a2);
T27 r27realloc(T27 C,T2 a1,T2 a2);
T6 r27equal_like(T0* a1,T0* a2);
void r27copy_from(T27 C,T27 a1,T2 a2);
void r27set_all_with(T27 C,T0* a1,T2 a2);
T2 r27fast_index_of(T27 C,T0* a1,T2 a2);
T2 r27index_of(T27 C,T0* a1,T2 a2);
T331 r331realloc(T331 C,T2 a1,T2 a2);
void r331copy_from(T331 C,T331 a1,T2 a2);
void r331set_all_with(T331 C,T0* a1,T2 a2);
T310 r310realloc(T310 C,T2 a1,T2 a2);
void r310copy_from(T310 C,T310 a1,T2 a2);
T82 r82realloc(T82 C,T2 a1,T2 a2);
void r82copy_from(T82 C,T82 a1,T2 a2);
void r82set_all_with(T82 C,T0* a1,T2 a2);
T324 r324realloc(T324 C,T2 a1,T2 a2);
void r324copy_from(T324 C,T324 a1,T2 a2);
void r324set_all_with(T324 C,T0* a1,T2 a2);
T2 r324fast_index_of(T324 C,T0* a1,T2 a2);
T317 r317realloc(T317 C,T2 a1,T2 a2);
void r317copy_from(T317 C,T317 a1,T2 a2);
T228 r228realloc(T228 C,T2 a1,T2 a2);
void r228copy_from(T228 C,T228 a1,T2 a2);
T89 r89realloc(T89 C,T2 a1,T2 a2);
void r89copy_from(T89 C,T89 a1,T2 a2);
void r89set_all_with(T89 C,T0* a1,T2 a2);
void r89clear_all(T89 C,T2 a1);
T52 r52realloc(T52 C,T2 a1,T2 a2);
void r52copy_from(T52 C,T52 a1,T2 a2);
void r52set_all_with(T52 C,T0* a1,T2 a2);
T2 r52fast_index_of(T52 C,T0* a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
T365 r365realloc(T365 C,T2 a1,T2 a2);
void r365clear(T365 C,T2 a1,T2 a2);
void r365move(T365 C,T2 a1,T2 a2,T2 a3);
void r365copy_from(T365 C,T365 a1,T2 a2);
void r365set_all_with(T365 C,T6 a1,T2 a2);
T64 r64realloc(T64 C,T2 a1,T2 a2);
void r64copy_from(T64 C,T64 a1,T2 a2);
void r64set_all_with(T64 C,T2 a1,T2 a2);
T2 r64fast_index_of(T64 C,T2 a1,T2 a2);
T6 r7has_string(T7* C,T0* a1);
T6 r7is_equal(T7* C,T0* a1);
T3 r7last(T7* C);
void r7add_first(T7* C,T3 a1);
T8 r7to_external(T7* C);
T6 r7same_as(T7* C,T0* a1);
void r7prepend(T7* C,T0* a1);
void r7swap(T7* C,T2 a1,T2 a2);
void r7copy(T7* C,T0* a1);
T6 r7_px_62(T7* C,T0* a1);
void r7head(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7to_lower(T7* C);
void r7remove_first(T7* C,T2 a1);
T2 r7index_of_string(T7* C,T0* a1);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
void r7to_hexadecimal(T7* C);
T6 r7has_prefix(T7* C,T0* a1);
T2 r7hash_code(T7* C);
void r7remove_last(T7* C,T2 a1);
T6 r7_px_60(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r248with_capacity(T248* C,T2 a1,T2 a2);
void r248add_last(T248* C,T0* a1);
void r248copy(T248* C,T0* a1);
T0* r248twin(T248* C);
T2 r248count(T248* C);
T0* r248item(T248* C,T2 a1);
void r45add_last(T45* C,T0* a1);
T2 r45count(T45* C);
T0* r45item(T45* C,T2 a1);
void r321make(T321* C,T2 a1,T2 a2);
void r321force(T321* C,T0* a1,T2 a2);
void r321resize(T321* C,T2 a1,T2 a2);
T0* r321item(T321* C,T2 a1);
void r304add_last(T304* C,T0* a1);
T2 r304count(T304* C);
T0* r304item(T304* C,T2 a1);
void r295add_last(T295* C,T0* a1);
T2 r295count(T295* C);
T0* r295item(T295* C,T2 a1);
void r174add_last(T174* C,T0* a1);
void r174make(T174* C,T2 a1,T2 a2);
void r174copy(T174* C,T0* a1);
T0* r174twin(T174* C);
T2 r174count(T174* C);
T0* r174item(T174* C,T2 a1);
void r84add_last(T84* C,T0* a1);
T2 r84count(T84* C);
T0* r84item(T84* C,T2 a1);
void r361make(T361* C,T2 a1);
void r361resize(T361* C,T2 a1);
void r197add_last(T197* C,T0* a1);
void r197with_capacity(T197* C,T2 a1);
void r197make(T197* C,T2 a1);
void r197copy(T197* C,T0* a1);
void r197resize(T197* C,T2 a1);
T0* r197twin(T197* C);
void r319add_last(T319* C,T0* a1);
void r319with_capacity(T319* C,T2 a1);
T6 r319empty(T319* C);
T0* r319last(T319* C);
void r319remove_last(T319* C);
void r26add_last(T26* C,T0* a1);
void r26with_capacity(T26* C,T2 a1);
void r26make(T26* C,T2 a1);
T2 r26fast_index_of(T26* C,T0* a1);
void r26resize(T26* C,T2 a1);
void r323add_last(T323* C,T0* a1);
void r323with_capacity(T323* C,T2 a1);
void r323make(T323* C,T2 a1);
T2 r323fast_index_of(T323* C,T0* a1);
void r323resize(T323* C,T2 a1);
void r88add_last(T88* C,T0* a1);
void r88with_capacity(T88* C,T2 a1);
T6 r88empty(T88* C);
void r88make(T88* C,T2 a1);
void r88copy(T88* C,T0* a1);
void r88resize(T88* C,T2 a1);
T0* r88twin(T88* C);
void r309add_last(T309* C,T0* a1);
T2 r309count(T309* C);
void r312add_last(T312* C,T0* a1);
void r312with_capacity(T312* C,T2 a1);
void r312make(T312* C,T2 a1);
T6 r312fast_has(T312* C,T0* a1);
void r312swap(T312* C,T2 a1,T2 a2);
T2 r312fast_index_of(T312* C,T0* a1);
void r312resize(T312* C,T2 a1);
T6 r312valid_index(T312* C,T2 a1);
void r312clear_all(T312* C);
T2 r312count(T312* C);
T0* r312item(T312* C,T2 a1);
void r206with_capacity(T206* C,T2 a1);
void r206add_last(T206* C,T0* a1);
void r206copy(T206* C,T0* a1);
T0* r206twin(T206* C);
void r210add_last(T210* C,T0* a1);
void r210copy(T210* C,T0* a1);
T0* r210twin(T210* C);
T2 r210count(T210* C);
T0* r210item(T210* C,T2 a1);
void r76add_last(T76* C,T0* a1);
T2 r76count(T76* C);
T0* r76item(T76* C,T2 a1);
void r63with_capacity(T63* C,T2 a1);
void r63add_last(T63* C,T2 a1);
void r63make(T63* C,T2 a1);
T6 r63fast_has(T63* C,T2 a1);
T2 r63fast_index_of(T63* C,T2 a1);
void r63resize(T63* C,T2 a1);
T6 r63valid_index(T63* C,T2 a1);
void r357add_last(T357* C,T0* a1);
void r357with_capacity(T357* C,T2 a1);
void r357make(T357* C,T2 a1);
T6 r357fast_has(T357* C,T0* a1);
void r357swap(T357* C,T2 a1,T2 a2);
T2 r357fast_index_of(T357* C,T0* a1);
void r357resize(T357* C,T2 a1);
T6 r357valid_index(T357* C,T2 a1);
void r355add_last(T355* C,T0* a1);
void r355with_capacity(T355* C,T2 a1);
void r355make(T355* C,T2 a1);
T6 r355fast_has(T355* C,T0* a1);
void r355swap(T355* C,T2 a1,T2 a2);
T2 r355fast_index_of(T355* C,T0* a1);
void r355resize(T355* C,T2 a1);
T6 r355valid_index(T355* C,T2 a1);
void r364make(T364* C,T2 a1,T2 a2);
void r364set_slice_with(T364* C,T6 a1,T2 a2,T2 a3);
void r364force(T364* C,T6 a1,T2 a2);
void r364resize(T364* C,T2 a1,T2 a2);
T6 r364valid_index(T364* C,T2 a1);
T6 r364item(T364* C,T2 a1);
void r160add_last(T160* C,T2 a1);
T6 r160fast_has(T160* C,T2 a1);
T2 r160fast_index_of(T160* C,T2 a1);
T6 r160valid_index(T160* C,T2 a1);
T2 r160count(T160* C);
void r224add_last(T224* C,T0* a1);
void r224copy(T224* C,T0* a1);
T0* r224twin(T224* C);
T2 r224count(T224* C);
T0* r224item(T224* C,T2 a1);
void r217add_last(T217* C,T0* a1);
void r217copy(T217* C,T0* a1);
T0* r217twin(T217* C);
T2 r217count(T217* C);
T0* r217item(T217* C,T2 a1);
void r58add_last(T58* C,T0* a1);
T2 r58count(T58* C);
T0* r58item(T58* C,T2 a1);
void r35with_capacity(T35* C,T2 a1,T2 a2);
void r35add_last(T35* C,T0* a1);
T6 r35fast_has(T35* C,T0* a1);
T2 r35fast_index_of(T35* C,T0* a1);
T2 r35index_of(T35* C,T0* a1);
T6 r35valid_index(T35* C,T2 a1);
T2 r35count(T35* C);
T0* r35item(T35* C,T2 a1);
void r326add_last(T326* C,T0* a1);
T6 r326fast_has(T326* C,T0* a1);
T2 r326fast_index_of(T326* C,T0* a1);
T6 r326valid_index(T326* C,T2 a1);
T2 r326count(T326* C);
void r316with_capacity(T316* C,T2 a1,T2 a2);
void r316add_last(T316* C,T0* a1);
void r316swap(T316* C,T2 a1,T2 a2);
T2 r316count(T316* C);
T0* r316item(T316* C,T2 a1);
void r227add_last(T227* C,T0* a1);
void r227copy(T227* C,T0* a1);
T0* r227twin(T227* C);
T2 r227count(T227* C);
T0* r227item(T227* C,T2 a1);
void r51with_capacity(T51* C,T2 a1,T2 a2);
void r51add_last(T51* C,T0* a1);
void r51clear(T51* C);
T6 r51empty(T51* C);
void r51make(T51* C,T2 a1,T2 a2);
T6 r51fast_has(T51* C,T0* a1);
void r51copy(T51* C,T0* a1);
T2 r51fast_index_of(T51* C,T0* a1);
T6 r51valid_index(T51* C,T2 a1);
T0* r51twin(T51* C);
T2 r51count(T51* C);
T0* r51item(T51* C,T2 a1);
void r340add_last(T340* C,T0* a1);
void r340with_capacity(T340* C,T2 a1);
void r340copy(T340* C,T0* a1);
T0* r340twin(T340* C);
void r185with_capacity(T185* C,T2 a1);
void r185add_last(T185* C,T0* a1);
void r139with_capacity(T139* C,T2 a1);
void r139add_last(T139* C,T0* a1);
void r139copy(T139* C,T0* a1);
T0* r139twin(T139* C);
T0* r139item(T139* C,T2 a1);
void r65add_last(T65* C,T0* a1);
void r65with_capacity(T65* C,T2 a1);
void r65make(T65* C,T2 a1);
T6 r65fast_has(T65* C,T0* a1);
T2 r65fast_index_of(T65* C,T0* a1);
void r65resize(T65* C,T2 a1);
T6 r65valid_index(T65* C,T2 a1);
void r336make(T336* C,T2 a1);
void r336resize(T336* C,T2 a1);
void r336clear_all(T336* C);
T2 r336count(T336* C);
void r69add_last(T69* C,T0* a1);
void r69with_capacity(T69* C,T2 a1);
T6 r69fast_has(T69* C,T0* a1);
T2 r69fast_index_of(T69* C,T0* a1);
T2 r69index_of(T69* C,T0* a1);
T6 r69valid_index(T69* C,T2 a1);
T6 r69has(T69* C,T0* a1);
void r98add_last(T98* C,T0* a1);
void r98copy(T98* C,T0* a1);
T0* r98twin(T98* C);
T2 r98count(T98* C);
T0* r98item(T98* C,T2 a1);
void r330add_last(T330* C,T0* a1);
void r330with_capacity(T330* C,T2 a1);
void r330make(T330* C,T2 a1);
void r330resize(T330* C,T2 a1);
void r80with_capacity(T80* C,T2 a1);
void r80add_last(T80* C,T0* a1);
void r80make(T80* C,T2 a1);
void r191add_last(T191* C,T0* a1);
void r191with_capacity(T191* C,T2 a1);
void r191make(T191* C,T2 a1);
void r191copy(T191* C,T0* a1);
T0* r191twin(T191* C);
void r180add_last(T180* C,T0* a1);
void r180make(T180* C,T2 a1,T2 a2);
void r180copy(T180* C,T0* a1);
T0* r180twin(T180* C);
T2 r180count(T180* C);
T0* r180item(T180* C,T2 a1);
void r92add_last(T92* C,T0* a1);
T2 r92count(T92* C);
T0* r92item(T92* C,T2 a1);
void r360with_capacity(T360* C,T2 a1);
void r360resize_buckets(T360* C,T2 a1);
void r360expand(T360* C);
void r360put(T360* C,T0* a1,T0* a2);
T6 r360has(T360* C,T0* a1);
void r343with_capacity(T343* C,T2 a1);
void r343resize_buckets(T343* C,T2 a1);
void r343expand(T343* C);
void r343put(T343* C,T0* a1,T0* a2);
T6 r343has(T343* C,T0* a1);
void r322with_capacity(T322* C,T2 a1);
void r322resize_buckets(T322* C,T2 a1);
void r322expand(T322* C);
T0* r322at(T322* C,T0* a1);
void r322set_cache_user_idx(T322* C,T2 a1);
void r322put(T322* C,T0* a1,T0* a2);
T6 r322has(T322* C,T0* a1);
T0* r322item(T322* C,T2 a1);
void r87with_capacity(T87* C,T2 a1);
void r87resize_buckets(T87* C,T2 a1);
void r87expand(T87* C);
T0* r87at(T87* C,T0* a1);
void r87put(T87* C,T0* a1,T0* a2);
T6 r87has(T87* C,T0* a1);
void r335with_capacity(T335* C,T2 a1);
void r335resize_buckets(T335* C,T2 a1);
void r335expand(T335* C);
void r335put(T335* C,T0* a1,T2 a2);
T6 r335has(T335* C,T2 a1);
void r318with_capacity(T318* C,T2 a1);
void r318resize_buckets(T318* C,T2 a1);
void r318expand(T318* C);
T0* r318at(T318* C,T0* a1);
void r318put(T318* C,T0* a1,T0* a2);
T6 r318has(T318* C,T0* a1);
void r73with_capacity(T73* C,T2 a1);
void r73resize_buckets(T73* C,T2 a1);
void r73expand(T73* C);
T0* r73at(T73* C,T0* a1);
void r73put(T73* C,T0* a1,T0* a2);
T6 r73has(T73* C,T0* a1);
void r62with_capacity(T62* C,T2 a1);
void r62resize_buckets(T62* C,T2 a1);
void r62expand(T62* C);
T0* r62at(T62* C,T0* a1);
void r62put(T62* C,T0* a1,T0* a2);
T6 r62has(T62* C,T0* a1);
void r133short_target(T133* C);
T0* r133runnable_expression(T0* a1,T0* a2);
void r133run_feature_has_result(T133* C);
void r133short(T133* C);
T0* r133static_result_base_class(T133* C);
T0* r133run_feature_for(T133* C,T0* a1,T0* a2);
void r133make(T133* C,T0* a1,T0* a2);
extern T0*oBC12eh;
void r133fatal_error(T0* a1);
void r133bracketed_short(T133* C);
void r133run_feature_match(T133* C);
extern T0*oBC12short_print;
T0* r133add_comment(T133* C,T0* a1);
void r133assertion_check(T133* C,T3 a1);
void r133with(T133* C,T0* a1,T0* a2,T0* a3);
T0* r133operator(void);
T0* r133to_runnable(T133* C,T0* a1);
T2 r133to_integer(T133* C);
void r133error(T0* a1,T0* a2);
T0* r133result_type(T133* C);
extern T0*oBC12small_eiffel;
T0* r144static_result_base_class(void);
T0* r144add_comment(T144* C,T0* a1);
T0* r144to_runnable(T144* C,T0* a1);
T2 r144to_integer(T144* C);
void r144error(T0* a1,T0* a2);
T0* r144result_type(T144* C);
void r167add_last(T167* C,T0* a1);
T2 r167rank_of(T167* C,T0* a1);
void r167fatal_error(T0* a1);
void r167check_name_clash(T167* C,T0* a1);
void r167declaration_list_make(T167* C,T0* a1);
T0* r167to_runnable(T167* C,T0* a1);
T0* r167twin(T167* C);
T0* r167type(T167* C,T2 a1);
void r167dynamic_runnable(T167* C,T0* a1);
void r167error(T0* a1,T0* a2);
T6 r167is_runnable(T167* C,T0* a1);
extern T0*oBC60parser_buffer_path;
extern int fBC60rename_dictionary;
extern T0*oBC60rename_dictionary;
T0* r60rename_dictionary(T60* C);
extern T0*oBC12tmp_file_read;
void r60pop(T60* C);
T0* r60top_rf(T60* C);
extern T0*oBC60stack_rf;
void r60incr_magic_count(T60* C);
T0* r60base_class(T60* C,T0* a1);
extern T0*oBC60base_class_dictionary;
T6 r60parser_buffer_for(T60* C,T0* a1);
void r60push(T60* C,T0* a1);
T6 r60is_used(T0* a1);
T0* r60load_class(T60* C,T0* a1);
void r60add_class(T60* C,T0* a1);
extern int fBC60loading_path;
extern T0*oBC60loading_path;
T0* r60loading_path(void);
T0* r60run_class(T0* a1);
T0* r60get_class(T0* a1);
void r60fatal_error(T0* a1);
extern T0*oBC12echo;
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r60system_tools(void);
extern T0*oBC60run_class_dictionary;
extern int fBC60tmp_class_name;
extern T0*oBC60tmp_class_name;
T0* r60tmp_class_name(void);
extern T0*oBC60tmp_tail;
extern T0*oBC12parser_buffer;
extern T0*oBC12eiffel_parser;
void r258fatal_error_generic_list(T258* C);
T0* r258generic_list(T258* C);
T0* r258smallest_ancestor(T0* a1);
T0* r258base_class(T258* C);
T0* r258look_up_for(T258* C,T0* a1,T0* a2);
T6 r258has_creation(T258* C,T0* a1);
void r258error(T0* a1,T0* a2);
T0* r258run_time_mark(void);
T6 r258is_a_in(T258* C,T0* a1,T0* a2);
void r258short(T258* C);
void r258make(T258* C,T0* a1);
T0* r258written_mark(void);
void r207make(T207* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC12run_control;
T0* r207add_comment(T207* C,T0* a1);
T0* r207to_runnable(T207* C,T0* a1);
T0* r207start_position(T207* C);
void r234make(T234* C,T0* a1,T0* a2,T0* a3);
T0* r234to_runnable(T234* C,T0* a1);
T0* r234twin(T234* C);
void r234error(T0* a1,T0* a2);
T0* r234start_position(T234* C);
void r126declaration_in(T126* C,T0* a1);
void r126make(T126* C,T0* a1,T0* a2);
void r126undefine_in(T126* C,T0* a1);
extern int fBC12string_aliaser;
extern T0*oBC12string_aliaser;
T0* r126string_aliaser(void);
T0* r126origin_base_class(T126* C);
void r126error(T0* a1,T0* a2);
void r130short(T130* C);
void r130declaration_in(T130* C,T0* a1);
void r130make(T130* C,T0* a1,T0* a2);
void r130undefine_in(T130* C,T0* a1);
T0* r130string_aliaser(void);
T0* r130origin_base_class(T130* C);
void r130error(T0* a1,T0* a2);
void r262fatal_error_generic_list(T262* C);
T0* r262generic_list(T262* C);
T2 r262id(T262* C);
T0* r262smallest_ancestor(T262* C,T0* a1);
T0* r262base_class(T262* C);
T0* r262look_up_for(T262* C,T0* a1,T0* a2);
T0* r262to_runnable(T262* C,T0* a1);
T6 r262has_creation(T262* C,T0* a1);
T6 r262is_a_in(T262* C,T0* a1,T0* a2);
void r262short(T262* C);
T6 r262is_a(T262* C,T0* a1);
T0* r262run_class(T262* C);
extern T0*oBC262check_memory;
T6 r262is_expanded(T262* C);
T0* r262expanded_initializer(T262* C);
void r262used_as_reference(T262* C);
T6 r262is_reference(T262* C);
void r118short_target(T118* C);
T0* r118runnable_expression(T0* a1,T0* a2);
void r118check_comparison(T118* C,T0* a1);
void r118bracketed_short(T118* C);
T0* r118add_comment(T118* C,T0* a1);
void r118with(T118* C,T0* a1,T0* a2,T0* a3);
T0* r118operator(void);
T0* r118runnable_args(T0* a1,T0* a2);
T0* r118to_runnable(T118* C,T0* a1);
T2 r118to_integer(T118* C);
void r118bit_limitation(T118* C,T0* a1,T0* a2);
void r118error(T0* a1,T0* a2);
extern int fBC12type_boolean;
extern T0*oBC12type_boolean;
T0* r118type_boolean(void);
void r118short(T118* C);
T0* r118static_result_base_class(void);
void r118make(T118* C,T0* a1,T0* a2,T0* a3);
void r118fatal_error(T0* a1);
void r118assertion_check(T118* C,T3 a1);
void r118error_comparison(T118* C,T0* a1,T0* a2);
void r110short_target(T110* C);
T0* r110runnable_expression(T0* a1,T0* a2);
void r110run_feature_has_result(T110* C);
void r110bracketed_short(T110* C);
void r110run_feature_match(T110* C,T0* a1);
T0* r110add_comment(T110* C,T0* a1);
void r110with(T110* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r110operator(void);
T0* r110runnable_args(T0* a1,T0* a2);
T0* r110to_runnable(T110* C,T0* a1);
T2 r110to_integer(T110* C);
void r110error(T0* a1,T0* a2);
T0* r110result_type(T110* C);
void r110short(T110* C);
T0* r110static_result_base_class(T110* C);
T0* r110run_feature_for(T110* C,T0* a1,T0* a2);
void r110make(T110* C,T0* a1,T0* a2,T0* a3);
void r110fatal_error(T0* a1);
void r110assertion_check(T110* C,T3 a1);
extern T0*oBC40tmp_hook;
void r40hook(T40* C,T0* a1);
void r40start(T40* C,T0* a1,T0* a2,T0* a3);
void r40a_prefix_name(T40* C,T0* a1);
void r40a_infix_name(T40* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r40a_integer(T2 a1);
extern T0*oBC40tmp_string;
void r40a_feature(T40* C,T0* a1);
T6 r40hook_exists(T40* C,T0* a1);
T0* r40system_tools(void);
void r40a_class_name(T40* C,T0* a1);
void r40finish(T40* C);
void r40hook_and(T40* C,T0* a1,T0* a2);
extern T0*oBC40tmp_hook_path;
void r40hook_or(T40* C,T0* a1,T0* a2);
void r40hook_and_lower(T40* C,T0* a1,T0* a2);
extern T0*oBC1std_output;
void r40a_base_type_constant(T40* C,T0* a1);
void r40a_run_feature(T40* C,T0* a1);
T6 r200is_merge_with(T200* C,T0* a1,T0* a2);
T6 r200is_merge_with2aux(T200* C,T0* a1,T0* a2);
T0* r200try_to_undefine_aux(T200* C,T0* a1,T0* a2);
T0* r200try_to_undefine(T200* C,T0* a1,T0* a2);
void r200check_obsolete(T200* C,T0* a1);
T6 r200is_merge_with1(T200* C,T0* a1);
T6 r200is_merge_with2(T200* C,T0* a1,T0* a2);
T0* r200to_run_feature(T200* C,T0* a1,T0* a2);
void r200error(T0* a1,T0* a2);
void r200make(T200* C,T0* a1,T0* a2,T0* a3);
void r200add_into(T200* C,T0* a1);
T6 r200can_hide(T200* C,T0* a1,T0* a2);
void r200merge_header_comments(T200* C,T0* a1);
T0* r200start_position(T200* C);
void r91for_short(T91* C,T0* a1,T6 a2,T0* a3,T0* a4);
void r91make(T91* C,T0* a1,T0* a2,T0* a3);
void r91add_into(T91* C,T0* a1);
void r91do_heading_for_short(T91* C,T0* a1);
void r108short_target(T108* C);
T0* r108runnable_expression(T0* a1,T0* a2);
void r108run_feature_has_result(T108* C);
void r108bracketed_short(T108* C);
void r108run_feature_match(T108* C,T0* a1);
T0* r108add_comment(T108* C,T0* a1);
void r108with(T108* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r108operator(void);
T0* r108runnable_args(T0* a1,T0* a2);
T0* r108to_runnable(T108* C,T0* a1);
T2 r108to_integer(T108* C);
void r108error(T0* a1,T0* a2);
T0* r108result_type(T108* C);
void r108short(T108* C);
T0* r108static_result_base_class(T108* C);
T0* r108run_feature_for(T108* C,T0* a1,T0* a2);
void r108make(T108* C,T0* a1,T0* a2,T0* a3);
void r108fatal_error(T0* a1);
void r108assertion_check(T108* C,T3 a1);
T0* r97key_for_prefix_infix(T0* a1,T0* a2);
T0* r97item(T0* a1);
T0* r97for_prefix(T0* a1);
void r97add2(T0* a1);
T0* r97for_infix(T0* a1);
extern T0*oBC97memory;
void r255fatal_error_generic_list(T255* C);
T0* r255generic_list(T255* C);
T0* r255smallest_ancestor(T255* C,T0* a1);
extern int fBC255check_type;
void r255check_type(T255* C);
extern int fBC12type_character_ref;
extern T0*oBC12type_character_ref;
T0* r255type_character_ref(void);
T0* r255base_class(T255* C);
void r255load_ref(T0* a1);
T0* r255look_up_for(T255* C,T0* a1,T0* a2);
T0* r255to_runnable(T255* C,T0* a1);
T6 r255has_creation(T255* C,T0* a1);
void r255error(T0* a1,T0* a2);
T0* r255run_time_mark(void);
T6 r255is_a_in(T255* C,T0* a1,T0* a2);
void r255short(T255* C);
T6 r255is_a(T255* C,T0* a1);
T0* r255run_class(T255* C);
void r255make(T255* C,T0* a1);
extern int fBC255used_as_reference;
void r255used_as_reference(void);
T0* r255written_mark(void);
T0* r270left_type(T270* C);
void r270make(T270* C,T0* a1,T0* a2);
void r270warning(T0* a1,T0* a2);
T0* r270add_comment(T270* C,T0* a1);
T0* r270right_type(T270* C);
T0* r270to_runnable(T270* C,T0* a1);
void r270error(T0* a1,T0* a2);
T0* r270start_position(T270* C);
void r344refer_to(T344* C,T2 a1,T0* a2);
void r344undefine_in(T344* C,T0* a1);
T0* r344string_aliaser(void);
T0* r344origin_base_class(T344* C);
T6 r344is_frozen(T344* C);
T0* r344to_string(T344* C);
void r344error(T0* a1,T0* a2);
T0* r344start_position(T344* C);
T0* r146add_comment(T146* C,T0* a1);
T0* r146to_runnable(T146* C,T0* a1);
T2 r146to_integer(T146* C);
void r146error(T0* a1,T0* a2);
void r300short(T300* C);
void r300make(T300* C,T0* a1,T0* a2);
void r300append_in(T300* C,T0* a1);
T6 r292is_merge_with(T292* C,T0* a1,T0* a2);
T6 r292is_merge_with2aux(T292* C,T0* a1,T0* a2);
T0* r292try_to_undefine_aux(T292* C,T0* a1,T0* a2);
T0* r292try_to_undefine(T292* C,T0* a1,T0* a2);
void r292check_obsolete(T292* C,T0* a1);
T6 r292is_merge_with1(T292* C,T0* a1);
T6 r292is_merge_with2(T292* C,T0* a1,T0* a2);
T0* r292to_run_feature(T292* C,T0* a1,T0* a2);
void r292error(T0* a1,T0* a2);
void r292set_header_comment(T292* C,T0* a1);
void r292make_routine(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r292make(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r292add_into(T292* C,T0* a1);
T6 r292can_hide(T292* C,T0* a1,T0* a2);
void r292merge_header_comments(T292* C,T0* a1);
T0* r292start_position(T292* C);
void r50short(T50* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8,T0* a9,T0* a10,T0* a11,T0* a12,T0* a13,T0* a14,T0* a15,T0* a16,T0* a17,T0* a18,T0* a19,T0* a20,T0* a21,T0* a22,T0* a23,T0* a24,T0* a25,T0* a26);
void r50make(T50* C,T0* a1,T0* a2,T0* a3);
T0* r50to_runnable(T50* C,T0* a1,T3 a2);
void r50error(T0* a1,T0* a2);
T0* r50start_position(T50* C);
void r90for_short(T90* C,T0* a1,T6 a2,T0* a3,T0* a4);
void r90get_started(T90* C,T0* a1);
void r43short(T43* C);
void r43make(T43* C,T0* a1,T0* a2);
void r43fatal_error(T0* a1);
T2 r43index_of(T43* C,T0* a1);
void r68add_position(T0* a1);
void r68print_as_fatal_error(T68* C);
extern T0*oBC68explanation;
void r68feature_not_found(T0* a1);
extern T0*oBC68positions;
void r68print_as_warning(T68* C);
void r68add_feature_name(T0* a1);
void r68add_type(T0* a1,T0* a2);
void r68do_print(T0* a1);
void r68print_as_error(T68* C);
void r53good_end(T53* C,T0* a1);
void r53short(T53* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r53make(T53* C,T0* a1,T0* a2);
void r53warning(T0* a1,T0* a2);
void r53append(T53* C,T0* a1);
T6 r201is_merge_with(T201* C,T0* a1,T0* a2);
T6 r201is_merge_with2aux(T201* C,T0* a1,T0* a2);
T0* r201try_to_undefine_aux(T201* C,T0* a1,T0* a2);
T0* r201try_to_undefine(T201* C,T0* a1,T0* a2);
void r201check_obsolete(T201* C,T0* a1);
T6 r201is_merge_with1(T201* C,T0* a1);
T6 r201is_merge_with2(T201* C,T0* a1,T0* a2);
T0* r201to_run_feature(T201* C,T0* a1,T0* a2);
void r201error(T0* a1,T0* a2);
void r201make(T201* C,T0* a1,T0* a2,T0* a3);
void r201add_into(T201* C,T0* a1);
T6 r201can_hide(T201* C,T0* a1,T0* a2);
void r201merge_header_comments(T201* C,T0* a1);
T0* r201start_position(T201* C);
T6 r188is_merge_with(T188* C,T0* a1,T0* a2);
T6 r188is_merge_with2aux(T188* C,T0* a1,T0* a2);
T0* r188try_to_undefine_aux(T188* C,T0* a1,T0* a2);
extern T0*oBC188counter;
T0* r188try_to_undefine(T188* C,T0* a1,T0* a2);
void r188check_obsolete(T188* C,T0* a1);
T6 r188is_merge_with1(T188* C,T0* a1);
T6 r188is_merge_with2(T188* C,T0* a1,T0* a2);
T0* r188to_run_feature(T188* C,T0* a1,T0* a2);
void r188error(T0* a1,T0* a2);
void r188make(T188* C,T0* a1,T0* a2);
void r188add_into(T188* C,T0* a1);
T6 r188can_hide(T188* C,T0* a1,T0* a2);
void r188merge_header_comments(T188* C,T0* a1);
T0* r188start_position(T188* C);
T6 r246is_any(T246* C);
void r246fatal_error_generic_list(T246* C);
T6 r246is_string(T246* C);
T0* r246generic_list(T246* C);
T2 r246id(T246* C);
T0* r246smallest_ancestor(T246* C,T0* a1);
T0* r246base_class(T246* C);
T6 r246is_array(T246* C);
void r246with(T246* C,T0* a1,T0* a2);
T6 r246is_double(T246* C);
T6 r246is_none(T246* C);
T0* r246look_up_for(T246* C,T0* a1,T0* a2);
T0* r246to_runnable(T246* C,T0* a1);
T6 r246has_creation(T246* C,T0* a1);
T6 r246is_pointer(T246* C);
T0* r246run_time_mark(T246* C);
T6 r246is_a_in(T246* C,T0* a1,T0* a2);
T6 r246is_boolean(T246* C);
T6 r246is_a(T246* C,T0* a1);
T0* r246run_class(T246* C);
T6 r246is_generic(T246* C);
T6 r246is_expanded(T246* C);
T6 r246is_basic_eiffel_expanded(T246* C);
T0* r246expanded_initializer(T246* C);
void r246used_as_reference(T246* C);
T6 r246is_character(T246* C);
T6 r246is_reference(T246* C);
T0* r246written_mark(void);
T6 r246is_real(T246* C);
T0* r246base_class_name(T246* C);
T6 r246is_bit(T246* C);
T6 r246is_integer(T246* C);
void r256fatal_error_generic_list(T256* C);
T0* r256generic_list(T256* C);
extern int fBC12type_double_ref;
extern T0*oBC12type_double_ref;
T0* r256type_double_ref(void);
T0* r256smallest_ancestor(T256* C,T0* a1);
extern int fBC256check_type;
void r256check_type(T256* C);
T0* r256base_class(T256* C);
void r256load_ref(T0* a1);
T0* r256look_up_for(T256* C,T0* a1,T0* a2);
T0* r256to_runnable(T256* C,T0* a1);
T6 r256has_creation(T256* C,T0* a1);
void r256error(T0* a1,T0* a2);
T0* r256run_time_mark(void);
T6 r256is_a_in(T256* C,T0* a1,T0* a2);
void r256short(T256* C);
T6 r256is_a(T256* C,T0* a1);
T0* r256run_class(T256* C);
void r256make(T256* C,T0* a1);
extern int fBC256used_as_reference;
void r256used_as_reference(void);
T0* r256written_mark(void);
void r121short_target(T121* C);
T0* r121runnable_expression(T0* a1,T0* a2);
void r121run_feature_has_result(T121* C);
void r121bracketed_short(T121* C);
void r121run_feature_match(T121* C,T0* a1);
T0* r121add_comment(T121* C,T0* a1);
void r121with(T121* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r121operator(void);
T0* r121runnable_args(T0* a1,T0* a2);
T0* r121to_runnable(T121* C,T0* a1);
T2 r121to_integer(T121* C);
void r121error(T0* a1,T0* a2);
T0* r121result_type(T121* C);
void r121short(T121* C);
T0* r121static_result_base_class(T121* C);
T0* r121run_feature_for(T121* C,T0* a1,T0* a2);
void r121make(T121* C,T0* a1,T0* a2,T0* a3);
void r121fatal_error(T0* a1);
void r121assertion_check(T121* C,T3 a1);
void r135short_target(T135* C);
extern int fBC12type_any;
extern T0*oBC12type_any;
T0* r135type_any(void);
void r135short(T135* C);
T0* r135static_result_base_class(void);
void r135make(T135* C,T0* a1,T0* a2);
void r135bracketed_short(T135* C);
T0* r135add_comment(T135* C,T0* a1);
extern T0*oBC12manifest_array_pool;
T0* r135to_runnable(T135* C,T0* a1);
T2 r135to_integer(T135* C);
void r135error(T0* a1,T0* a2);
T0* r135result_type(T135* C);
void r232make(T232* C,T0* a1,T0* a2,T0* a3);
T0* r232to_runnable(T232* C,T0* a1);
T0* r232twin(T232* C);
extern T0*oBC12assertion_collector;
void r347short_target(T347* C);
T2 r347precedence(T347* C);
T6 r347is_current(T347* C);
void r347short(T347* C);
T0* r347static_result_base_class(T347* C);
void r347make(T347* C,T0* a1,T0* a2);
void r347bracketed_short(T347* C);
void r347assertion_check(T347* C,T3 a1);
T0* r347add_comment(T347* C,T0* a1);
T0* r347to_runnable(T347* C,T0* a1);
T2 r347to_integer(T347* C);
void r347error(T0* a1,T0* a2);
T0* r347start_position(T347* C);
void r114short_target(T114* C);
T0* r114runnable_expression(T0* a1,T0* a2);
void r114run_feature_has_result(T114* C);
void r114bracketed_short(T114* C);
void r114run_feature_match(T114* C,T0* a1);
T0* r114add_comment(T114* C,T0* a1);
void r114with(T114* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r114operator(void);
T0* r114runnable_args(T0* a1,T0* a2);
T0* r114to_runnable(T114* C,T0* a1);
T2 r114to_integer(T114* C);
void r114error(T0* a1,T0* a2);
T0* r114result_type(T114* C);
void r114short(T114* C);
T0* r114static_result_base_class(T114* C);
T0* r114run_feature_for(T114* C,T0* a1,T0* a2);
void r114make(T114* C,T0* a1,T0* a2,T0* a3);
void r114fatal_error(T0* a1);
void r114assertion_check(T114* C,T3 a1);
void r112short_target(T112* C);
T0* r112runnable_expression(T0* a1,T0* a2);
void r112run_feature_has_result(T112* C);
void r112bracketed_short(T112* C);
void r112run_feature_match(T112* C,T0* a1);
T0* r112add_comment(T112* C,T0* a1);
void r112with(T112* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r112operator(void);
T0* r112runnable_args(T0* a1,T0* a2);
T0* r112to_runnable(T112* C,T0* a1);
T2 r112to_integer(T112* C);
void r112error(T0* a1,T0* a2);
T0* r112result_type(T112* C);
void r112short(T112* C);
T0* r112static_result_base_class(T112* C);
T0* r112run_feature_for(T112* C,T0* a1,T0* a2);
void r112make(T112* C,T0* a1,T0* a2,T0* a3);
void r112fatal_error(T0* a1);
void r112assertion_check(T112* C,T3 a1);
void r260fatal_error_generic_list(T260* C);
T0* r260generic_list(T260* C);
T0* r260smallest_ancestor(T260* C,T0* a1);
extern int fBC260check_type;
void r260check_type(T260* C);
T0* r260base_class(T260* C);
void r260load_ref(T0* a1);
T0* r260look_up_for(T260* C,T0* a1,T0* a2);
T0* r260to_runnable(T260* C,T0* a1);
T6 r260has_creation(T260* C,T0* a1);
void r260error(T0* a1,T0* a2);
T0* r260run_time_mark(void);
T6 r260is_a_in(T260* C,T0* a1,T0* a2);
void r260short(T260* C);
T6 r260is_a(T260* C,T0* a1);
T0* r260run_class(T260* C);
void r260make(T260* C,T0* a1);
extern int fBC12type_real_ref;
extern T0*oBC12type_real_ref;
T0* r260type_real_ref(void);
extern int fBC260used_as_reference;
void r260used_as_reference(void);
extern int fBC12type_double;
extern T0*oBC12type_double;
T0* r260type_double(void);
T0* r260written_mark(void);
void r315short(T315* C);
void r315make(T315* C,T0* a1);
void r315add(T315* C,T0* a1);
void r172short_target(T172* C);
T0* r172base_class_written(T172* C);
void r172short(T172* C);
T0* r172static_result_base_class(T172* C);
void r172make(T172* C,T0* a1,T0* a2);
void r172bracketed_short(T172* C);
void r172name_clash_for(T172* C,T0* a1,T0* a2);
T0* r172add_comment(T172* C,T0* a1);
T0* r172to_runnable(T172* C,T0* a1);
T2 r172to_integer(T172* C);
T0* r172twin(T172* C);
void r172error(T0* a1,T0* a2);
T0* r172written_in(T172* C);
T2 r250id(T250* C);
T0* r250smallest_ancestor(T250* C,T0* a1);
T0* r250string_aliaser(void);
T0* r250base_class(T250* C);
void r250with(T250* C,T0* a1,T0* a2,T0* a3);
T0* r250look_up_for(T250* C,T0* a1,T0* a2);
T0* r250to_runnable(T250* C,T0* a1);
T6 r250has_creation(T250* C,T0* a1);
T0* r250run_time_mark(T250* C);
T6 r250is_a_in(T250* C,T0* a1,T0* a2);
void r250short(T250* C);
T6 r250is_a(T250* C,T0* a1);
extern T0*oBC250tmp_written_mark;
T0* r250run_class(T250* C);
void r250final(T250* C,T0* a1,T0* a2);
void r250make(T250* C,T0* a1,T0* a2);
void r250fatal_error(T0* a1);
T0* r250run_type(T250* C);
void r250load_basic_features(T250* C);
void r250short_hook(T250* C);
T6 r250is_run_type(T250* C);
void r163short_target(T163* C);
void r163unary_minus(T163* C);
T0* r163static_result_base_class(void);
void r163make(T163* C,T2 a1,T0* a2);
void r163bracketed_short(T163* C);
T0* r163add_comment(T163* C,T0* a1);
T0* r163to_real_constant(T163* C);
void r163error(T0* a1,T0* a2);
extern int fBC163result_type;
extern T0*oBC163result_type;
T0* r163result_type(void);
void r169short_target(T169* C);
void r169short(T169* C);
T0* r169static_result_base_class(T169* C);
void r169fatal_error(T0* a1);
void r169refer_to(T169* C,T0* a1,T0* a2,T2 a3);
void r169bracketed_short(T169* C);
T0* r169add_comment(T169* C,T0* a1);
void r169assertion_check(T169* C,T3 a1);
T0* r169to_runnable(T169* C,T0* a1);
T2 r169to_integer(T169* C);
T0* r169to_string(T169* C);
void r169error(T0* a1,T0* a2);
T0* r169result_type(T169* C);
void r253fatal_error_generic_list(T253* C);
T0* r253generic_list(T253* C);
T0* r253smallest_ancestor(T253* C,T0* a1);
extern int fBC253check_type;
void r253check_type(T253* C);
T0* r253base_class(T253* C);
void r253load_ref(T0* a1);
T0* r253look_up_for(T253* C,T0* a1,T0* a2);
T0* r253to_runnable(T253* C,T0* a1);
T6 r253has_creation(T253* C,T0* a1);
extern int fBC12type_boolean_ref;
extern T0*oBC12type_boolean_ref;
T0* r253type_boolean_ref(void);
void r253error(T0* a1,T0* a2);
T0* r253run_time_mark(void);
T6 r253is_a_in(T253* C,T0* a1,T0* a2);
void r253short(T253* C);
T6 r253is_a(T253* C,T0* a1);
T0* r253run_class(T253* C);
void r253make(T253* C,T0* a1);
extern int fBC253used_as_reference;
void r253used_as_reference(void);
T0* r253written_mark(void);
void r261fatal_error_generic_list(T261* C);
T0* r261generic_list(T261* C);
extern int fBC12type_string;
extern T0*oBC12type_string;
T0* r261type_string(void);
T0* r261smallest_ancestor(T261* C,T0* a1);
T0* r261base_class(T261* C);
extern int fBC261set_at_run_time;
void r261set_at_run_time(void);
T0* r261look_up_for(T261* C,T0* a1,T0* a2);
T6 r261has_creation(T261* C,T0* a1);
T0* r261run_time_mark(void);
T6 r261is_a_in(T261* C,T0* a1,T0* a2);
void r261short(T261* C);
T6 r261is_a(T261* C,T0* a1);
T0* r261run_class(T261* C);
void r261make(T261* C,T0* a1);
T0* r261written_mark(void);
void r123short_target(T123* C);
T0* r123runnable_expression(T0* a1,T0* a2);
void r123run_feature_has_result(T123* C);
void r123bracketed_short(T123* C);
void r123run_feature_match(T123* C,T0* a1);
T0* r123add_comment(T123* C,T0* a1);
void r123with(T123* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r123operator(void);
T0* r123runnable_args(T0* a1,T0* a2);
T0* r123to_runnable(T123* C,T0* a1);
T2 r123to_integer(T123* C);
void r123error(T0* a1,T0* a2);
T0* r123result_type(T123* C);
void r123short(T123* C);
T0* r123static_result_base_class(T123* C);
T0* r123run_feature_for(T123* C,T0* a1,T0* a2);
void r123make(T123* C,T0* a1,T0* a2,T0* a3);
void r123fatal_error(T0* a1);
void r123assertion_check(T123* C,T3 a1);
void r176add_last(T176* C,T0* a1);
T6 r176is_a_in(T176* C,T0* a1,T0* a2);
void r176short(T176* C);
T2 r176rank_of(T176* C,T0* a1);
void r176make(T176* C,T0* a1);
void r176fatal_error(T0* a1);
void r176check_name_clash(T176* C,T0* a1);
void r176declaration_list_make(T176* C,T0* a1);
void r176with(T176* C,T0* a1,T0* a2);
T0* r176type(T176* C,T2 a1);
void r176dynamic_runnable(T176* C,T0* a1);
void r176error(T0* a1,T0* a2);
T6 r176is_runnable(T176* C,T0* a1);
T0* r176start_position(T176* C);
T6 r274is_merge_with(T274* C,T0* a1,T0* a2);
T6 r274is_merge_with2aux(T274* C,T0* a1,T0* a2);
T0* r274try_to_undefine(T274* C,T0* a1,T0* a2);
void r274check_obsolete(T274* C,T0* a1);
T6 r274is_merge_with1(T274* C,T0* a1);
T6 r274is_merge_with2(T274* C,T0* a1,T0* a2);
T0* r274to_run_feature(T274* C,T0* a1,T0* a2);
void r274error(T0* a1,T0* a2);
void r274set_header_comment(T274* C,T0* a1);
void r274set_rescue_compound(T274* C,T0* a1);
void r274make_routine(T274* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r274make(T274* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r274add_into(T274* C,T0* a1);
T6 r274can_hide(T274* C,T0* a1,T0* a2);
void r274from_effective(T274* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r274merge_header_comments(T274* C,T0* a1);
T0* r274start_position(T274* C);
T0* r196value(T196* C,T2 a1);
T6 r196is_merge_with(T196* C,T0* a1,T0* a2);
T6 r196is_merge_with2aux(T196* C,T0* a1,T0* a2);
T0* r196try_to_undefine_aux(T196* C,T0* a1,T0* a2);
T0* r196try_to_undefine(T196* C,T0* a1,T0* a2);
void r196check_obsolete(T196* C,T0* a1);
T6 r196is_merge_with1(T196* C,T0* a1);
T6 r196is_merge_with2(T196* C,T0* a1,T0* a2);
T0* r196to_run_feature(T196* C,T0* a1,T0* a2);
void r196error(T0* a1,T0* a2);
void r196make(T196* C,T0* a1,T0* a2,T0* a3);
void r196add_into(T196* C,T0* a1);
T6 r196can_hide(T196* C,T0* a1,T0* a2);
void r196merge_header_comments(T196* C,T0* a1);
T0* r196start_position(T196* C);
void r17check_expanded_with(T17* C,T0* a1);
T6 r17short(T17* C);
void r17fatal_error(T0* a1);
T0* r17expanded_initializer(T17* C,T0* a1);
T0* r17get_clause(T17* C,T0* a1);
T0* r17start_position(T17* C);
T0* r220add_comment(T220* C,T0* a1);
T0* r220to_runnable(T220* C,T0* a1);
void r37put_string(T37* C,T0* a1);
void r37put_integer(T37* C,T2 a1);
extern T0*oBC38tmp_string;
void r99short_target(T99* C);
T0* r99type_any(void);
void r99short(T99* C);
T0* r99static_result_base_class(void);
void r99make(T99* C,T0* a1,T0* a2);
void r99bracketed_short(T99* C);
T0* r99add_comment(T99* C,T0* a1);
void r99assertion_check(T99* C,T3 a1);
T0* r99to_runnable(T99* C,T0* a1);
T2 r99to_integer(T99* C);
void r99error(T0* a1,T0* a2);
T0* r151runnable_expression(T0* a1,T0* a2);
T0* r151run_feature_for(T151* C,T0* a1,T0* a2);
void r151make(T151* C,T0* a1,T0* a2);
void r151fatal_error(T0* a1);
void r151run_feature_has_no_result(T151* C);
void r151run_feature_match(T151* C);
T0* r151add_comment(T151* C,T0* a1);
T0* r151to_runnable(T151* C,T0* a1);
T0* r151make_runnable(T151* C,T0* a1,T0* a2,T0* a3);
T0* r151start_position(T151* C);
void r122short_target(T122* C);
T0* r122runnable_expression(T0* a1,T0* a2);
void r122run_feature_has_result(T122* C);
void r122bracketed_short(T122* C);
void r122run_feature_match(T122* C,T0* a1);
T0* r122add_comment(T122* C,T0* a1);
void r122with(T122* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r122operator(void);
T0* r122runnable_args(T0* a1,T0* a2);
T0* r122to_runnable(T122* C,T0* a1);
T2 r122to_integer(T122* C);
void r122error(T0* a1,T0* a2);
T0* r122result_type(T122* C);
void r122short(T122* C);
T0* r122static_result_base_class(T122* C);
T0* r122run_feature_for(T122* C,T0* a1,T0* a2);
void r122make(T122* C,T0* a1,T0* a2,T0* a3);
void r122fatal_error(T0* a1);
void r122assertion_check(T122* C,T3 a1);
T0* r229to_runnable_integer(T229* C,T0* a1);
T0* r229to_runnable_character(T229* C,T0* a1);
T0* r229twin(T229* C);
void r229error(T0* a1,T0* a2);
T0* r229start_position(T229* C);
void r219short_target(T219* C);
T2 r219precedence(T219* C);
T6 r219is_current(T219* C);
void r219short(T219* C);
T0* r219static_result_base_class(T219* C);
void r219make(T219* C,T0* a1,T0* a2);
void r219bracketed_short(T219* C);
T0* r219add_comment(T219* C,T0* a1);
void r219assertion_check(T219* C,T3 a1);
T0* r219to_runnable(T219* C,T0* a1);
T2 r219to_integer(T219* C);
T6 r219is_void(T219* C);
void r219error(T0* a1,T0* a2);
T0* r219result_type(T219* C);
T0* r219start_position(T219* C);
T0* r152runnable_expression(T0* a1,T0* a2);
T0* r152run_feature_for(T152* C,T0* a1,T0* a2);
void r152make(T152* C,T0* a1,T0* a2,T0* a3);
void r152fatal_error(T0* a1);
void r152run_feature_has_no_result(T152* C);
void r152run_feature_match(T152* C,T0* a1);
T0* r152add_comment(T152* C,T0* a1);
void r152with(T152* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r152runnable_args(T0* a1,T0* a2);
T0* r152to_runnable(T152* C,T0* a1);
T0* r152make_runnable(T152* C,T0* a1,T0* a2,T0* a3);
T0* r152start_position(T152* C);
void r36put_string(T36* C,T0* a1);
void r36put_integer(T36* C,T2 a1);
void r36sfr_connect(T36* C,T0* a1,T0* a2);
void r36w_put_string(T0* a1);
void r36w_put_integer(T2 a1);
void r36w_put_character(T3 a1);
extern T0*oBC1std_error;
void r36put_character(T36* C,T3 a1);
T6 r272is_merge_with(T272* C,T0* a1,T0* a2);
T6 r272is_merge_with2aux(T272* C,T0* a1,T0* a2);
T0* r272try_to_undefine(T272* C,T0* a1,T0* a2);
void r272check_obsolete(T272* C,T0* a1);
T6 r272is_merge_with1(T272* C,T0* a1);
T6 r272is_merge_with2(T272* C,T0* a1,T0* a2);
T0* r272to_run_feature(T272* C,T0* a1,T0* a2);
void r272error(T0* a1,T0* a2);
void r272set_header_comment(T272* C,T0* a1);
void r272set_rescue_compound(T272* C,T0* a1);
void r272make_routine(T272* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r272add_into(T272* C,T0* a1);
T6 r272can_hide(T272* C,T0* a1,T0* a2);
void r272from_effective(T272* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r272merge_header_comments(T272* C,T0* a1);
T0* r272start_position(T272* C);
extern int fBC12class_general;
extern T0*oBC12class_general;
T0* r311class_general(void);
T0* r311at(T311* C,T0* a1);
T0* r311base_class(T311* C);
T0* r311get_feature(T311* C,T0* a1);
void r311set_at_run_time(T311* C);
void r311error(T0* a1,T0* a2);
void r311runnable_class_invariant(T311* C);
void r311store_feature(T311* C,T0* a1);
void r311make(T311* C,T0* a1);
void r311fatal_error(T0* a1);
extern T0*oBC311to_reference_memory;
void r311efnf(T311* C,T0* a1,T0* a2);
T0* r311get_result_type(T311* C,T0* a1);
T0* r311get_or_fatal_error(T311* C,T0* a1);
T0* r311get_copy(T311* C);
T0* r311get_feature_with(T311* C,T0* a1);
T6 r311is_running_of(T311* C,T0* a1);
void r311used_as_reference(T311* C);
T0* r311get_rf_with(T311* C,T0* a1);
void r311add_running(T311* C,T0* a1);
void r311add_rf(T311* C,T0* a1,T0* a2);
T0* r311class_with(T0* a1);
extern int fBC12id_provider;
extern T0*oBC12id_provider;
T0* r311id_provider(void);
void r311add_client(T311* C,T0* a1);
void r236make(T236* C,T0* a1,T0* a2);
void r236fatal_error(T0* a1);
void r236warning(T0* a1,T0* a2);
T0* r236add_comment(T236* C,T0* a1);
void r236check_created_type(T236* C,T0* a1);
void r236check_creation_clause(T236* C,T0* a1);
void r236check_writable(T236* C,T0* a1);
T0* r236to_runnable(T236* C,T0* a1);
void r236error(T0* a1,T0* a2);
void r221make(T221* C,T0* a1,T0* a2);
T0* r221add_comment(T221* C,T0* a1);
void r221set_else_compound(T221* C,T0* a1,T0* a2);
T0* r221to_runnable(T221* C,T0* a1);
T0* r221twin(T221* C);
void r221error(T0* a1,T0* a2);
void r221add_when(T221* C,T0* a1);
void r140short_target(T140* C);
T0* r140runnable_expression(T0* a1,T0* a2);
void r140run_feature_has_result(T140* C);
void r140short(T140* C);
T0* r140static_result_base_class(T140* C);
T0* r140run_feature_for(T140* C,T0* a1,T0* a2);
void r140make(T140* C,T0* a1,T0* a2,T0* a3);
void r140fatal_error(T0* a1);
void r140bracketed_short(T140* C);
void r140run_feature_match(T140* C,T0* a1);
T0* r140add_comment(T140* C,T0* a1);
void r140assertion_check(T140* C,T3 a1);
void r140with(T140* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r140runnable_args(T0* a1,T0* a2);
T0* r140to_runnable(T140* C,T0* a1);
T2 r140to_integer(T140* C);
void r140error(T0* a1,T0* a2);
T0* r140result_type(T140* C);
T0* r140start_position(T140* C);
void r138short_target(T138* C);
T0* r138runnable_expression(T0* a1,T0* a2);
void r138run_feature_has_result(T138* C);
void r138short(T138* C);
T0* r138static_result_base_class(T138* C);
T0* r138run_feature_for(T138* C,T0* a1,T0* a2);
void r138make(T138* C,T0* a1,T0* a2);
void r138fatal_error(T0* a1);
void r138bracketed_short(T138* C);
void r138run_feature_match(T138* C);
T0* r138add_comment(T138* C,T0* a1);
void r138assertion_check(T138* C,T3 a1);
void r138with(T138* C,T0* a1,T0* a2,T0* a3);
T0* r138to_runnable(T138* C,T0* a1);
T2 r138to_integer(T138* C);
void r138error(T0* a1,T0* a2);
T0* r138result_type(T138* C);
T0* r138start_position(T138* C);
T0* r223to_runnable_integer(T223* C,T0* a1);
void r223from_when_list(T223* C,T0* a1);
T0* r223to_runnable_character(T223* C,T0* a1);
T6 r223includes_integer(T223* C,T2 a1);
void r223error(T0* a1,T0* a2);
T0* r223start_position(T223* C);
void r115short_target(T115* C);
T0* r115runnable_expression(T0* a1,T0* a2);
void r115run_feature_has_result(T115* C);
void r115bracketed_short(T115* C);
void r115run_feature_match(T115* C,T0* a1);
T0* r115add_comment(T115* C,T0* a1);
void r115with(T115* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r115operator(void);
T0* r115runnable_args(T0* a1,T0* a2);
T0* r115to_runnable(T115* C,T0* a1);
T2 r115to_integer(T115* C);
void r115error(T0* a1,T0* a2);
T0* r115result_type(T115* C);
void r115short(T115* C);
T0* r115static_result_base_class(T115* C);
T0* r115run_feature_for(T115* C,T0* a1,T0* a2);
void r115make(T115* C,T0* a1,T0* a2,T0* a3);
void r115fatal_error(T0* a1);
void r115assertion_check(T115* C,T3 a1);
void r113short_target(T113* C);
T0* r113runnable_expression(T0* a1,T0* a2);
void r113run_feature_has_result(T113* C);
void r113bracketed_short(T113* C);
void r113run_feature_match(T113* C,T0* a1);
T0* r113add_comment(T113* C,T0* a1);
void r113with(T113* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r113operator(void);
T0* r113runnable_args(T0* a1,T0* a2);
T0* r113to_runnable(T113* C,T0* a1);
T2 r113to_integer(T113* C);
void r113error(T0* a1,T0* a2);
T0* r113result_type(T113* C);
void r113short(T113* C);
T0* r113static_result_base_class(T113* C);
T0* r113run_feature_for(T113* C,T0* a1,T0* a2);
void r113make(T113* C,T0* a1,T0* a2,T0* a3);
void r113fatal_error(T0* a1);
void r113assertion_check(T113* C,T3 a1);
T0* r230to_runnable_integer(T230* C,T0* a1);
void r230make(T230* C,T0* a1,T0* a2);
T0* r230to_runnable_character(T230* C,T0* a1);
T0* r230twin(T230* C);
void r230error(T0* a1,T0* a2);
T0* r230start_position(T230* C);
void r205make(T205* C,T0* a1,T0* a2,T0* a3);
void r205fatal_error(T0* a1);
T0* r205to_runnable(T205* C,T0* a1);
void r205put(T205* C,T0* a1,T2 a2);
T2 r205count(T205* C);
void r205from_compound(T205* C,T0* a1);
T0* r205item(T205* C,T2 a1);
T0* r205start_position(T205* C);
void r148short_target(T148* C);
extern int fBC12type_pointer;
extern T0*oBC12type_pointer;
T0* r148type_pointer(void);
extern T0*oBC12address_of_pool;
void r148short(T148* C);
T0* r148static_result_base_class(void);
void r148bracketed_short(T148* C);
T0* r148add_comment(T148* C,T0* a1);
T0* r148to_runnable(T148* C,T0* a1);
T2 r148to_integer(T148* C);
void r148error(T0* a1,T0* a2);
T0* r148start_position(T148* C);
T0* r328run_class(T328* C);
void r328make(T328* C,T0* a1,T0* a2,T0* a3);
void r328initialize(T328* C);
T6 r328is_exported_in(T328* C,T0* a1);
T0* r328clients(T328* C);
T0* r328start_position(T328* C);
void r32disconnect(T32* C);
void r32read_line_in(T32* C,T0* a1);
T6 r32end_of_input(T32* C);
extern T0*oBC33last_string;
void r32read_character(T32* C);
void r32read_line(T32* C);
void r32read_word(T32* C);
void r32connect_to(T32* C,T0* a1);
void r32skip_separators(T32* C);
void r297short(T297* C);
void r297make(T297* C,T0* a1,T0* a2);
void r297append_in(T297* C,T0* a1);
T2 r297count(T297* C);
void r161short_target(T161* C);
void r161short(T161* C);
T0* r161static_result_base_class(void);
void r161make(T161* C,T0* a1,T0* a2);
void r161bracketed_short(T161* C);
T0* r161add_comment(T161* C,T0* a1);
T0* r161to_runnable(T161* C,T0* a1);
T2 r161to_integer(T161* C);
void r161error(T0* a1,T0* a2);
T0* r211add_comment(T211* C,T0* a1);
void r211add_if_then(T211* C,T0* a1,T0* a2);
T0* r211to_runnable(T211* C,T0* a1);
T0* r211twin(T211* C);
T6 r74ensure_check(T74* C);
T6 r74debug_check(T74* C);
T6 r74loop_check(T74* C);
T6 r74boost(T74* C);
T6 r74invariant_check(T74* C);
T6 r74all_check(T74* C);
T6 r74require_check(T74* C);
T6 r268is_any(T268* C);
void r268fatal_error_generic_list(T268* C);
T6 r268is_string(T268* C);
T0* r268generic_list(T268* C);
T0* r268constraint(T268* C);
T2 r268id(T268* C);
T0* r268smallest_ancestor(T268* C,T0* a1);
void r268warning(T0* a1,T0* a2);
T0* r268base_class(T268* C);
T6 r268is_array(T268* C);
T6 r268is_double(T268* C);
T6 r268is_none(T268* C);
T0* r268look_up_for(T268* C,T0* a1,T0* a2);
T0* r268to_runnable(T268* C,T0* a1);
T0* r268make_runnable(T268* C,T0* a1);
T6 r268has_creation(T268* C,T0* a1);
T0* r268twin(T268* C);
T6 r268is_pointer(T268* C);
T0* r268formal_arg(T268* C);
void r268error(T0* a1,T0* a2);
T0* r268static_base_class_name(T268* C);
T0* r268run_time_mark(T268* C);
T6 r268is_a_in(T268* C,T0* a1,T0* a2);
void r268short(T268* C);
T6 r268is_boolean(T268* C);
T6 r268is_a(T268* C,T0* a1);
T0* r268run_class(T268* C);
T6 r268is_generic(T268* C);
void r268make(T268* C,T0* a1,T2 a2);
void r268fatal_error(T0* a1);
T6 r268is_expanded(T268* C);
T6 r268is_basic_eiffel_expanded(T268* C);
T0* r268expanded_initializer(T268* C);
void r268used_as_reference(T268* C);
T0* r268formal_generic_list(T268* C);
T6 r268is_character(T268* C);
T6 r268is_reference(T268* C);
T6 r268is_real(T268* C);
T0* r268base_class_name(T268* C);
T6 r268is_bit(T268* C);
T6 r268is_integer(T268* C);
void r239make(T239* C,T0* a1,T0* a2,T0* a3);
void r239fatal_error(T0* a1);
void r239warning(T0* a1,T0* a2);
T0* r239add_comment(T239* C,T0* a1);
void r239check_created_type(T239* C,T0* a1);
void r239check_creation_clause(T239* C,T0* a1);
void r239check_writable(T239* C,T0* a1);
T0* r239to_runnable(T239* C,T0* a1);
void r239check_explicit_type(T239* C);
void r239error(T0* a1,T0* a2);
void r303make(T303* C,T0* a1,T0* a2);
void r303make_all(T303* C,T0* a1);
T6 r303affect(T303* C,T0* a1);
void r55short(T55* C);
void r55make(T55* C,T0* a1,T0* a2);
T0* r320runnable(T0* a1,T0* a2,T0* a3,T3 a4);
T0* r320require_end(T320* C,T0* a1,T0* a2);
void r320assertion_add_last(T320* C,T0* a1);
T0* r320ensure_end(T320* C,T0* a1,T0* a2);
void r320invariant_add_last(T320* C,T0* a1);
extern T0*oBC320collector;
void r320ensure_start(T320* C);
void r320require_start(T320* C);
T0* r320invariant_end(T320* C,T0* a1);
void r320error(T0* a1,T0* a2);
void r320invariant_start(T320* C);
T6 r48is_subclass_of(T48* C,T0* a1);
void r48make(T48* C,T0* a1,T0* a2);
T0* r48base_class(T48* C);
void r48make_unknown(T48* C);
void r259fatal_error_generic_list(T259* C);
T0* r259generic_list(T259* C);
T0* r259smallest_ancestor(T259* C,T0* a1);
extern int fBC259check_type;
void r259check_type(T259* C);
T0* r259base_class(T259* C);
void r259load_ref(T0* a1);
T0* r259look_up_for(T259* C,T0* a1,T0* a2);
T0* r259to_runnable(T259* C,T0* a1);
T6 r259has_creation(T259* C,T0* a1);
extern int fBC12type_pointer_ref;
extern T0*oBC12type_pointer_ref;
T0* r259type_pointer_ref(void);
void r259error(T0* a1,T0* a2);
T0* r259run_time_mark(void);
T6 r259is_a_in(T259* C,T0* a1,T0* a2);
void r259short(T259* C);
T6 r259is_a(T259* C,T0* a1);
T0* r259run_class(T259* C);
void r259make(T259* C,T0* a1);
extern int fBC259used_as_reference;
void r259used_as_reference(void);
T0* r259written_mark(void);
void r257fatal_error_generic_list(T257* C);
T0* r257generic_list(T257* C);
T0* r257smallest_ancestor(T257* C,T0* a1);
extern int fBC257check_type;
void r257check_type(T257* C);
T0* r257base_class(T257* C);
void r257load_ref(T0* a1);
T0* r257look_up_for(T257* C,T0* a1,T0* a2);
T0* r257to_runnable(T257* C,T0* a1);
T6 r257has_creation(T257* C,T0* a1);
extern int fBC12type_integer_ref;
extern T0*oBC12type_integer_ref;
T0* r257type_integer_ref(void);
void r257error(T0* a1,T0* a2);
T0* r257run_time_mark(void);
T6 r257is_a_in(T257* C,T0* a1,T0* a2);
void r257short(T257* C);
T6 r257is_a(T257* C,T0* a1);
T0* r257run_class(T257* C);
void r257make(T257* C,T0* a1);
extern int fBC257used_as_reference;
void r257used_as_reference(void);
T0* r257written_mark(void);
void r31environment_variable_substitution(T31* C,T0* a1,T0* a2);
T6 r31backslash_separator(T31* C);
T0* r31get_environment_variable(T31* C,T0* a1);
void r31make(T31* C);
extern T0*oBC31system_list;
void r31bad_use_exit(T31* C,T0* a1);
T6 r31slash_separator(T31* C);
T0* r31format_directory(T31* C,T0* a1);
void r31append_lp_in(T31* C,T0* a1,T0* a2);
void r31loading_path_add(T31* C,T0* a1,T0* a2,T2 a3);
void r31add_directory(T31* C,T0* a1,T0* a2);
void r31parent_directory(T31* C,T0* a1);
void r31read_loading_path_in(T31* C,T0* a1);
T0* r337run_class(T337* C);
void r337make(T337* C,T0* a1,T0* a2,T0* a3);
void r337initialize(T337* C);
T6 r337is_exported_in(T337* C,T0* a1);
T0* r337clients(T337* C);
void r109short_target(T109* C);
T0* r109runnable_expression(T0* a1,T0* a2);
void r109run_feature_has_result(T109* C);
void r109bracketed_short(T109* C);
void r109run_feature_match(T109* C,T0* a1);
T0* r109add_comment(T109* C,T0* a1);
void r109with(T109* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r109operator(void);
T0* r109runnable_args(T0* a1,T0* a2);
T0* r109to_runnable(T109* C,T0* a1);
T2 r109to_integer(T109* C);
void r109error(T0* a1,T0* a2);
T0* r109result_type(T109* C);
void r109short(T109* C);
T0* r109static_result_base_class(T109* C);
T0* r109run_feature_for(T109* C,T0* a1,T0* a2);
void r109make(T109* C,T0* a1,T0* a2,T0* a3);
void r109fatal_error(T0* a1);
void r109assertion_check(T109* C,T3 a1);
void r264from_other(T264* C,T0* a1,T0* a2);
T0* r264generic_list(T264* C);
T2 r264id(T264* C);
T0* r264smallest_ancestor(T264* C,T0* a1);
T0* r264string_aliaser(void);
T0* r264base_class(T264* C);
T6 r264is_double(T264* C);
T0* r264look_up_for(T264* C,T0* a1,T0* a2);
T0* r264to_runnable(T264* C,T0* a1);
T6 r264has_creation(T264* C,T0* a1);
T6 r264is_pointer(T264* C);
T0* r264compute_mark(T0* a1);
T6 r264is_a_in(T264* C,T0* a1,T0* a2);
void r264short(T264* C);
T6 r264is_boolean(T264* C);
T6 r264is_a(T264* C,T0* a1);
extern T0*oBC264tmp_written_mark;
T6 r264is_generic(T264* C);
T0* r264run_class(T264* C);
void r264make(T264* C,T0* a1,T0* a2);
void r264fatal_error(T0* a1);
T6 r264is_basic_eiffel_expanded(T264* C);
T0* r264expanded_initializer(T264* C);
void r264used_as_reference(T264* C);
T6 r264is_character(T264* C);
T6 r264is_real(T264* C);
T0* r264base_class_name(T264* C);
void r264short_hook(T264* C);
T6 r264is_bit(T264* C);
T6 r264is_integer(T264* C);
T6 r278is_merge_with(T278* C,T0* a1,T0* a2);
T6 r278is_merge_with2aux(T278* C,T0* a1,T0* a2);
T0* r278try_to_undefine_aux(T278* C,T0* a1,T0* a2);
T0* r278try_to_undefine(T278* C,T0* a1,T0* a2);
void r278check_obsolete(T278* C,T0* a1);
T6 r278is_merge_with1(T278* C,T0* a1);
T6 r278is_merge_with2(T278* C,T0* a1,T0* a2);
T0* r278to_run_feature(T278* C,T0* a1,T0* a2);
void r278error(T0* a1,T0* a2);
void r278set_header_comment(T278* C,T0* a1);
void r278set_rescue_compound(T278* C,T0* a1);
void r278make_routine(T278* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r278make(T278* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r278make_external_routine(T278* C,T0* a1,T0* a2);
void r278add_into(T278* C,T0* a1);
T6 r278can_hide(T278* C,T0* a1,T0* a2);
void r278merge_header_comments(T278* C,T0* a1);
T0* r278start_position(T278* C);
void r111short_target(T111* C);
T0* r111runnable_expression(T0* a1,T0* a2);
void r111run_feature_has_result(T111* C);
void r111bracketed_short(T111* C);
void r111run_feature_match(T111* C,T0* a1);
T0* r111add_comment(T111* C,T0* a1);
void r111with(T111* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r111operator(void);
T0* r111runnable_args(T0* a1,T0* a2);
T0* r111to_runnable(T111* C,T0* a1);
T2 r111to_integer(T111* C);
void r111error(T0* a1,T0* a2);
T0* r111result_type(T111* C);
void r111short(T111* C);
T0* r111static_result_base_class(T111* C);
T0* r111run_feature_for(T111* C,T0* a1,T0* a2);
void r111make(T111* C,T0* a1,T0* a2,T0* a3);
void r111fatal_error(T0* a1);
void r111assertion_check(T111* C,T3 a1);
void r136short_target(T136* C);
void r136short(T136* C);
T0* r136static_result_base_class(T136* C);
void r136make(T136* C,T0* a1,T0* a2);
void r136fatal_error(T0* a1);
void r136bracketed_short(T136* C);
void r136undefine_in(T136* C,T0* a1);
T0* r136origin_base_class(T136* C);
T0* r136add_comment(T136* C,T0* a1);
void r136with(T136* C,T0* a1,T0* a2);
T0* r136to_runnable(T136* C,T0* a1);
T2 r136to_integer(T136* C);
void r136error(T0* a1,T0* a2);
T0* r136run_feature(T136* C,T0* a1);
T0* r153runnable_expression(T0* a1,T0* a2);
T0* r153run_feature_for(T153* C,T0* a1,T0* a2);
void r153make(T153* C,T0* a1,T0* a2,T0* a3);
void r153fatal_error(T0* a1);
void r153run_feature_has_no_result(T153* C);
void r153run_feature_match(T153* C,T0* a1);
T0* r153add_comment(T153* C,T0* a1);
void r153with(T153* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r153runnable_args(T0* a1,T0* a2);
T0* r153to_runnable(T153* C,T0* a1);
T0* r153make_runnable(T153* C,T0* a1,T0* a2,T0* a3);
T0* r153start_position(T153* C);
void r302short(T302* C);
void r302declaration_in(T302* C,T0* a1);
void r302undefine_in(T302* C,T0* a1);
T0* r302origin_base_class(T302* C);
T0* r302to_key(T302* C);
T0* r302to_string(T302* C);
void r302error(T0* a1,T0* a2);
T0* r302start_position(T302* C);
void r241make(T241* C,T0* a1,T0* a2,T0* a3);
void r241fatal_error(T0* a1);
void r241warning(T0* a1,T0* a2);
T0* r241add_comment(T241* C,T0* a1);
void r241check_created_type(T241* C,T0* a1);
T2 r241arg_count(T241* C);
void r241check_creation_clause(T241* C,T0* a1);
void r241check_writable(T241* C,T0* a1);
T0* r241to_runnable(T241* C,T0* a1);
void r241error(T0* a1,T0* a2);
void r241cp_not_found(T241* C,T0* a1);
T0* r325run_ensure(T325* C);
T0* r325run_class(T325* C);
void r325make(T325* C,T0* a1,T0* a2,T0* a3);
T0* r325run_require(T325* C);
void r325initialize(T325* C);
extern T0*oBC12exceptions_handler;
T6 r325is_exported_in(T325* C,T0* a1);
T0* r325clients(T325* C);
void r83make(T83* C,T0* a1,T0* a2);
void r83fatal_error(T0* a1);
T6 r301is_merge_with(T301* C,T0* a1,T0* a2);
T6 r301is_merge_with2aux(T301* C,T0* a1,T0* a2);
T0* r301try_to_undefine_aux(T301* C,T0* a1,T0* a2);
T0* r301try_to_undefine(T301* C,T0* a1,T0* a2);
void r301check_obsolete(T301* C,T0* a1);
T6 r301is_merge_with1(T301* C,T0* a1);
T6 r301is_merge_with2(T301* C,T0* a1,T0* a2);
T0* r301to_run_feature(T301* C,T0* a1,T0* a2);
void r301error(T0* a1,T0* a2);
void r301make(T301* C,T0* a1,T0* a2);
void r301add_into(T301* C,T0* a1);
T6 r301can_hide(T301* C,T0* a1,T0* a2);
void r301merge_header_comments(T301* C,T0* a1);
T0* r301start_position(T301* C);
T6 r277is_merge_with(T277* C,T0* a1,T0* a2);
T6 r277is_merge_with2aux(T277* C,T0* a1,T0* a2);
T0* r277try_to_undefine_aux(T277* C,T0* a1,T0* a2);
T0* r277try_to_undefine(T277* C,T0* a1,T0* a2);
void r277check_obsolete(T277* C,T0* a1);
T6 r277is_merge_with1(T277* C,T0* a1);
T6 r277is_merge_with2(T277* C,T0* a1,T0* a2);
T0* r277to_run_feature(T277* C,T0* a1,T0* a2);
void r277error(T0* a1,T0* a2);
void r277set_header_comment(T277* C,T0* a1);
void r277set_rescue_compound(T277* C,T0* a1);
void r277make_routine(T277* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r277make(T277* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r277make_external_routine(T277* C,T0* a1,T0* a2);
void r277add_into(T277* C,T0* a1);
T6 r277can_hide(T277* C,T0* a1,T0* a2);
void r277merge_header_comments(T277* C,T0* a1);
T0* r277start_position(T277* C);
T0* r145add_comment(T145* C,T0* a1);
T2 r145to_integer(T145* C);
void r145error(T0* a1,T0* a2);
extern int fBC145result_type;
extern T0*oBC145result_type;
T0* r145result_type(void);
T0* r352run_ensure(T352* C);
T0* r352run_class(T352* C);
void r352make(T352* C,T0* a1,T0* a2,T0* a3);
T0* r352run_require(T352* C);
void r352initialize(T352* C);
T6 r352is_exported_in(T352* C,T0* a1);
T0* r352clients(T352* C);
void r243make(T243* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r243fatal_error(T0* a1);
void r243warning(T0* a1,T0* a2);
T0* r243add_comment(T243* C,T0* a1);
void r243check_created_type(T243* C,T0* a1);
T2 r243arg_count(T243* C);
void r243check_creation_clause(T243* C,T0* a1);
void r243check_writable(T243* C,T0* a1);
T0* r243to_runnable(T243* C,T0* a1);
void r243check_explicit_type(T243* C);
void r243error(T0* a1,T0* a2);
void r243cp_not_found(T243* C,T0* a1);
void r166prepare_arguments(T166* C,T0* a1);
void r166make(T166* C,T0* a1,T0* a2,T0* a3);
void r166fatal_error(T0* a1);
T0* r166precursor_name(T0* a1,T0* a2);
T0* r166add_comment(T166* C,T0* a1);
T0* r166super_feature(T166* C,T0* a1);
T0* r166to_runnable(T166* C,T0* a1);
void r166error(T0* a1,T0* a2);
void r94make(T94* C,T0* a1,T0* a2);
T0* r94merge_with(T94* C,T0* a1);
void r94merge(T94* C,T0* a1,T0* a2,T0* a3);
T6 r94gives_permission_to_any(T94* C);
T6 r94gives_permission_to(T94* C,T0* a1);
T0* r94append(T94* C,T0* a1);
void r94vape_check(T94* C,T0* a1,T0* a2);
void r94gives_permission_error(T94* C,T6 a1,T0* a2);
T0* r156type_boolean(void);
T0* r156static_result_base_class(void);
T0* r156add_comment(T156* C,T0* a1);
T0* r156to_string(void);
void r156error(T0* a1,T0* a2);
void r125short_target(T125* C);
T0* r125runnable_expression(T0* a1,T0* a2);
void r125run_feature_has_result(T125* C);
void r125bracketed_short(T125* C);
void r125run_feature_match(T125* C,T0* a1);
T0* r125add_comment(T125* C,T0* a1);
void r125with(T125* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r125runnable_args(T0* a1,T0* a2);
T0* r125to_runnable(T125* C,T0* a1);
T2 r125to_integer(T125* C);
void r125error(T0* a1,T0* a2);
T0* r125result_type(T125* C);
void r125short(T125* C);
T0* r125static_result_base_class(T125* C);
T0* r125run_feature_for(T125* C,T0* a1,T0* a2);
void r125make(T125* C,T0* a1,T0* a2,T0* a3);
void r125fatal_error(T0* a1);
void r125assertion_check(T125* C,T3 a1);
T6 r290is_merge_with(T290* C,T0* a1,T0* a2);
T6 r290is_merge_with2aux(T290* C,T0* a1,T0* a2);
T0* r290try_to_undefine_aux(T290* C,T0* a1,T0* a2);
T0* r290try_to_undefine(T290* C,T0* a1,T0* a2);
void r290check_obsolete(T290* C,T0* a1);
T6 r290is_merge_with1(T290* C,T0* a1);
T6 r290is_merge_with2(T290* C,T0* a1,T0* a2);
T0* r290to_run_feature(T290* C,T0* a1,T0* a2);
void r290error(T0* a1,T0* a2);
void r290set_header_comment(T290* C,T0* a1);
void r290make_routine(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r290make(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r290add_into(T290* C,T0* a1);
T6 r290can_hide(T290* C,T0* a1,T0* a2);
void r290merge_header_comments(T290* C,T0* a1);
void r290make_effective_routine(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
T0* r290start_position(T290* C);
void r134short_target(T134* C);
void r134short(T134* C);
T0* r134static_result_base_class(T134* C);
void r134bracketed_short(T134* C);
T0* r134add_comment(T134* C,T0* a1);
void r134assertion_check(T134* C,T3 a1);
T0* r134to_runnable(T134* C,T0* a1);
T2 r134to_integer(T134* C);
void r134error(T0* a1,T0* a2);
T0* r134result_type(T134* C);
extern T0*oBC134vaol_check_memory;
T0* r134start_position(T134* C);
void r215make(T215* C,T0* a1,T0* a2);
T0* r215to_runnable(T215* C,T0* a1);
void r215error(T0* a1,T0* a2);
T6 r194is_merge_with(T194* C,T0* a1,T0* a2);
T6 r194is_merge_with2aux(T194* C,T0* a1,T0* a2);
T0* r194try_to_undefine_aux(T194* C,T0* a1,T0* a2);
T0* r194try_to_undefine(T194* C,T0* a1,T0* a2);
void r194check_obsolete(T194* C,T0* a1);
T6 r194is_merge_with1(T194* C,T0* a1);
T6 r194is_merge_with2(T194* C,T0* a1,T0* a2);
T0* r194to_run_feature(T194* C,T0* a1,T0* a2);
void r194error(T0* a1,T0* a2);
void r194make(T194* C,T0* a1,T0* a2,T0* a3);
void r194add_into(T194* C,T0* a1);
T6 r194can_hide(T194* C,T0* a1,T0* a2);
void r194merge_header_comments(T194* C,T0* a1);
T0* r194start_position(T194* C);
void r81fatal_error(T0* a1);
T0* r81name_in_child(T81* C,T0* a1);
T0* r81name_in_parent(T81* C,T0* a1);
void r81get_started(T81* C,T0* a1);
T0* r56first_parent_for(T56* C,T0* a1);
void r56inherit_cycle_check(T56* C);
extern int fBC12class_any;
extern T0*oBC12class_any;
T0* r56class_any(void);
T0* r56repeated_inheritance(T56* C,T0* a1,T0* a2,T0* a3);
T0* r56precursor_for(T56* C,T0* a1,T0* a2);
T0* r56smallest_ancestor(T56* C,T0* a1,T0* a2);
T6 r56is_a_vncg(T56* C,T0* a1,T0* a2);
void r56collect_assertion(T56* C,T0* a1);
void r56collect_invariant(T56* C,T0* a1);
T0* r56look_up_for(T56* C,T0* a1,T0* a2);
void r56get_started(T56* C);
T0* r56up_to_original(T56* C,T0* a1,T0* a2);
T0* r56going_up(T56* C,T0* a1,T0* a2,T0* a3);
void r56header_comment_for(T56* C,T0* a1);
T6 r56has_redefine(T56* C,T0* a1);
void r56make(T56* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r56fatal_error(T0* a1);
T6 r56has_parent(T56* C,T0* a1);
T0* r56clients_for(T56* C,T0* a1);
T0* r56e_feature(T56* C,T0* a1);
T0* r56next_parent_for(T56* C,T0* a1,T0* a2);
void r56up_to_any_in(T56* C,T0* a1);
T0* r56class_with(T0* a1);
T0* r353run_ensure(T353* C);
T0* r353run_class(T353* C);
void r353make(T353* C,T0* a1,T0* a2,T0* a3);
T0* r353run_require(T353* C);
extern T0*oBC12once_routine_pool;
void r353initialize(T353* C);
T6 r353is_exported_in(T353* C,T0* a1);
T0* r353clients(T353* C);
void r141short_target(T141* C);
T0* r141runnable_expression(T0* a1,T0* a2);
void r141run_feature_has_result(T141* C);
void r141short(T141* C);
T0* r141static_result_base_class(T141* C);
T0* r141run_feature_for(T141* C,T0* a1,T0* a2);
void r141make(T141* C,T0* a1,T0* a2,T0* a3);
void r141fatal_error(T0* a1);
void r141bracketed_short(T141* C);
void r141run_feature_match(T141* C,T0* a1);
T0* r141add_comment(T141* C,T0* a1);
void r141assertion_check(T141* C,T3 a1);
void r141with(T141* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r141runnable_args(T0* a1,T0* a2);
T0* r141to_runnable(T141* C,T0* a1);
T2 r141to_integer(T141* C);
void r141error(T0* a1,T0* a2);
T0* r141result_type(T141* C);
T0* r141start_position(T141* C);
void r95make(T95* C);
T2 r95max_id(T95* C);
void r95add2(T95* C,T0* a1,T2 a2);
T2 r95hash_code(T0* a1);
T2 r95item(T95* C,T0* a1);
void r127short_target(T127* C);
T0* r127runnable_expression(T0* a1,T0* a2);
void r127run_feature_has_result(T127* C);
void r127short(T127* C);
T0* r127static_result_base_class(T127* C);
T0* r127run_feature_for(T127* C,T0* a1,T0* a2);
void r127make(T127* C,T0* a1,T0* a2);
void r127fatal_error(T0* a1);
void r127bracketed_short(T127* C);
void r127run_feature_match(T127* C);
T0* r127add_comment(T127* C,T0* a1);
void r127assertion_check(T127* C,T3 a1);
void r127with(T127* C,T0* a1,T0* a2,T0* a3);
T0* r127to_runnable(T127* C,T0* a1);
T2 r127to_integer(T127* C);
void r127error(T0* a1,T0* a2);
T0* r127result_type(T127* C);
T6 r70is_equal(T70* C,T0* a1);
void r70make(T70* C,T2 a1,T2 a2);
void r70fatal_error(T0* a1);
void r70set_line_column(T70* C,T2 a1,T2 a2);
void r70with(T70* C,T2 a1,T2 a2,T0* a3);
T0* r70base_class(T70* C);
void r70show(T70* C);
T0* r70path(T70* C);
T0* r70get_line(T70* C);
void r44short(T44* C);
void r44make(T44* C,T0* a1,T0* a2);
void r222add_when_item_2(T222* C,T0* a1);
void r222add_value(T222* C,T0* a1);
T0* r222to_runnable_integer(T222* C,T0* a1);
void r222make(T222* C,T0* a1,T0* a2);
void r222from_e_when(T222* C,T0* a1);
void r222err_occ(T222* C,T2 a1,T0* a2);
T0* r222to_runnable_character(T222* C,T0* a1);
void r222add_when_item_1(T222* C,T0* a1);
void r222add_slice(T222* C,T0* a1,T0* a2);
T6 r222includes_integer(T222* C,T2 a1);
void r222error(T0* a1,T0* a2);
T0* r252type_any(void);
T2 r252id(T252* C);
T0* r252smallest_ancestor(T252* C,T0* a1);
T0* r252string_aliaser(void);
T0* r252base_class(T252* C);
T0* r252look_up_for(T252* C,T0* a1,T0* a2);
T0* r252to_runnable(T252* C,T0* a1);
void r252make_runnable(T252* C,T0* a1,T0* a2);
T0* r252twin(T252* C);
T0* r252run_time_mark(T252* C);
T6 r252is_a_in(T252* C,T0* a1,T0* a2);
void r252short(T252* C);
T6 r252is_a(T252* C,T0* a1);
T0* r252run_class(T252* C);
void r252make(T252* C,T0* a1,T0* a2);
void r252fatal_error(T0* a1);
void r252load_basic_features(T252* C);
void r252short_hook(T252* C);
T6 r252is_run_type(T252* C);
T0* r143static_result_base_class(void);
T0* r143add_comment(T143* C,T0* a1);
T0* r143to_runnable(T143* C,T0* a1);
T2 r143to_integer(T143* C);
void r143error(T0* a1,T0* a2);
void r307add_last(T307* C,T0* a1);
T0* r338run_ensure(T338* C);
T0* r338run_class(T338* C);
void r338make(T338* C,T0* a1,T0* a2,T0* a3);
void r338fatal_error(T0* a1);
T0* r338run_require(T338* C);
void r338initialize(T338* C);
T6 r338is_exported_in(T338* C,T0* a1);
T0* r338clients(T338* C);
void r338fe_vffd7(T338* C);
void r233make(T233* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T0* r233add_comment(T233* C,T0* a1);
T0* r233to_runnable(T233* C,T0* a1);
void r233error(T0* a1,T0* a2);
T0* r57going_down(T57* C,T0* a1,T0* a2);
T0* r57runnable_type(T57* C,T0* a1);
T0* r57do_rename(T57* C,T0* a1);
T0* r57precursor_for(T57* C,T0* a1,T0* a2);
T0* r57consider_export(T57* C,T0* a1);
T0* r57apply_undefine(T57* C,T0* a1,T0* a2);
T6 r57is_a_vncg(T57* C,T0* a1,T0* a2);
T0* r57base_class(T57* C);
T0* r57look_up_for(T57* C,T0* a1,T0* a2);
void r57get_started(T57* C,T0* a1);
extern T0*oBC57forbidden_parent_list;
T0* r57up_to_original(T57* C,T0* a1,T0* a2);
void r57missing_select(T0* a1,T0* a2);
T0* r57going_up(T57* C,T0* a1,T0* a2,T0* a3);
T6 r57has_redefine(T57* C,T0* a1);
T0* r57get_new_name(T57* C,T0* a1);
void r57make(T57* C,T0* a1);
T0* r57get_old_name(T57* C,T0* a1);
void r57fatal_error(T0* a1);
void r57multiple_check(T57* C,T0* a1);
T6 r57has_select_for(T57* C,T0* a1);
T0* r57name_in_parent(T57* C,T0* a1);
T0* r57has_undefine(T57* C,T0* a1);
T0* r57clients_for(T57* C,T0* a1);
T0* r57e_feature(T57* C,T0* a1);
void r57select_conflict(T0* a1,T0* a2);
void r57add_rename(T57* C,T0* a1);
T0* r57start_position(T57* C);
T6 r199is_merge_with(T199* C,T0* a1,T0* a2);
T6 r199is_merge_with2aux(T199* C,T0* a1,T0* a2);
T0* r199try_to_undefine_aux(T199* C,T0* a1,T0* a2);
T0* r199try_to_undefine(T199* C,T0* a1,T0* a2);
void r199check_obsolete(T199* C,T0* a1);
T6 r199is_merge_with1(T199* C,T0* a1);
T6 r199is_merge_with2(T199* C,T0* a1,T0* a2);
T0* r199to_run_feature(T199* C,T0* a1,T0* a2);
void r199error(T0* a1,T0* a2);
void r199make(T199* C,T0* a1,T0* a2,T0* a3);
void r199add_into(T199* C,T0* a1);
T6 r199can_hide(T199* C,T0* a1,T0* a2);
void r199merge_header_comments(T199* C,T0* a1);
T0* r199start_position(T199* C);
void r164prepare_arguments(T164* C,T0* a1);
T0* r164static_result_base_class(T164* C);
void r164make(T164* C,T0* a1,T0* a2,T0* a3);
void r164fatal_error(T0* a1);
T0* r164precursor_name(T0* a1,T0* a2);
T0* r164add_comment(T164* C,T0* a1);
T0* r164super_feature(T164* C,T0* a1);
T0* r164to_runnable(T164* C,T0* a1);
T2 r164to_integer(T164* C);
void r164error(T0* a1,T0* a2);
void r305make(T305* C,T0* a1,T0* a2);
T0* r305clients_for(T305* C,T0* a1);
T0* r349run_ensure(T349* C);
T0* r349run_class(T349* C);
void r349make(T349* C,T0* a1,T0* a2,T0* a3);
T0* r349run_require(T349* C);
void r349initialize(T349* C);
T6 r349is_exported_in(T349* C,T0* a1);
T0* r349clients(T349* C);
T0* r263type_any(void);
T6 r263is_written_runnable(T263* C);
T2 r263id(T263* C);
T0* r263smallest_ancestor(T263* C,T0* a1);
extern T0*oBC263tmp_mark;
T0* r263string_aliaser(void);
T0* r263base_class(T263* C);
T0* r263look_up_for(T263* C,T0* a1,T0* a2);
T0* r263to_runnable(T263* C,T0* a1);
void r263make_runnable(T263* C,T0* a1,T0* a2);
T6 r263has_creation(T263* C,T0* a1);
T0* r263twin(T263* C);
void r263basic_checks(T263* C);
T0* r263run_time_mark(T263* C);
T6 r263is_a_in(T263* C,T0* a1,T0* a2);
void r263short(T263* C);
T6 r263is_a(T263* C,T0* a1);
T0* r263run_class(T263* C);
void r263make(T263* C,T0* a1,T0* a2);
void r263fatal_error(T0* a1);
T0* r263run_type(T263* C);
T6 r263is_expanded(T263* C);
T0* r263expanded_initializer(T263* C);
void r263used_as_reference(T263* C);
T6 r263is_reference(T263* C);
void r263short_hook(T263* C);
T6 r263is_run_type(T263* C);
T6 r244is_any(T244* C);
void r244fatal_error_generic_list(T244* C);
T6 r244is_string(T244* C);
T0* r244generic_list(T244* C);
T2 r244id(T244* C);
T0* r244smallest_ancestor(T244* C,T0* a1);
T0* r244string_aliaser(void);
T0* r244base_class(T244* C);
T6 r244is_array(T244* C);
void r244with(T244* C,T0* a1,T0* a2);
T6 r244is_double(T244* C);
T6 r244is_none(T244* C);
T0* r244look_up_for(T244* C,T0* a1,T0* a2);
T0* r244to_runnable(T244* C,T0* a1);
T6 r244has_creation(T244* C,T0* a1);
T6 r244is_pointer(T244* C);
T0* r244static_base_class_name(T244* C);
T0* r244run_time_mark(T244* C);
T6 r244is_a_in(T244* C,T0* a1,T0* a2);
void r244short(T244* C);
T6 r244is_boolean(T244* C);
T6 r244is_a(T244* C,T0* a1);
T0* r244run_class(T244* C);
T6 r244is_generic(T244* C);
void r244anchor_cycle_start(T244* C);
void r244make(T244* C,T0* a1,T0* a2);
void r244fatal_error(T0* a1);
T6 r244is_expanded(T244* C);
T6 r244is_basic_eiffel_expanded(T244* C);
T0* r244expanded_initializer(T244* C);
void r244anchor_cycle_end(T244* C);
void r244used_as_reference(T244* C);
T6 r244is_character(T244* C);
T6 r244is_reference(T244* C);
T6 r244is_real(T244* C);
T0* r244base_class_name(T244* C);
void r244short_hook(T244* C);
extern T0*oBC245visited;
T6 r244is_bit(T244* C);
T6 r244is_integer(T244* C);
void r183short_target(T183* C);
T0* r183runnable_expression(T0* a1,T0* a2);
void r183run_feature_has_result(T183* C);
void r183bracketed_short(T183* C);
void r183run_feature_match(T183* C,T0* a1);
T0* r183add_comment(T183* C,T0* a1);
void r183with(T183* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r183operator(void);
T0* r183runnable_args(T0* a1,T0* a2);
T0* r183to_runnable(T183* C,T0* a1);
T2 r183to_integer(T183* C);
void r183error(T0* a1,T0* a2);
T0* r183result_type(T183* C);
void r183short(T183* C);
T0* r183static_result_base_class(T183* C);
T0* r183run_feature_for(T183* C,T0* a1,T0* a2);
void r183make(T183* C,T0* a1,T0* a2,T0* a3);
void r183fatal_error(T0* a1);
void r183assertion_check(T183* C,T3 a1);
extern T0*oBC12cpp;
T2 r327integer_value(T327* C,T0* a1);
T0* r327type_string(void);
T0* r327run_require(T327* C);
T6 r327is_exported_in(T327* C,T0* a1);
T0* r327clients(T327* C);
T0* r327run_ensure(T327* C);
T0* r327run_class(T327* C);
void r327make(T327* C,T0* a1,T0* a2,T0* a3);
void r327fatal_error(T0* a1);
void r327initialize(T327* C);
void r75check_expanded_with(T75* C,T0* a1);
T6 r75short(T75* C,T6 a1);
void r75make(T75* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r75fatal_error(T0* a1);
T0* r75expanded_initializer(T75* C,T0* a1);
T6 r75has(T75* C,T0* a1);
void r179short_target(T179* C);
T0* r179base_class_written(T179* C);
void r179short(T179* C);
T0* r179static_result_base_class(T179* C);
void r179make(T179* C,T0* a1,T0* a2);
void r179bracketed_short(T179* C);
void r179name_clash_for(T179* C,T0* a1,T0* a2);
T0* r179add_comment(T179* C,T0* a1);
T0* r179to_runnable(T179* C,T0* a1);
T2 r179to_integer(T179* C);
T0* r179twin(T179* C);
void r179error(T0* a1,T0* a2);
T0* r179written_in(T179* C);
void r208make(T208* C,T0* a1,T0* a2,T0* a3);
T0* r208to_runnable(T208* C,T0* a1);
T0* r208twin(T208* C);
T0* r348run_ensure(T348* C);
T0* r348run_class(T348* C);
void r348make(T348* C,T0* a1,T0* a2,T0* a3);
T0* r348run_require(T348* C);
void r348initialize(T348* C);
T6 r348is_exported_in(T348* C,T0* a1);
T0* r348clients(T348* C);
T0* r348start_position(T348* C);
void r214make(T214* C,T0* a1,T0* a2);
T0* r214add_comment(T214* C,T0* a1);
T0* r214to_runnable(T214* C,T0* a1);
void r214error(T0* a1,T0* a2);
T0* r214start_position(T214* C);
void r137match_with(T137* C,T0* a1,T0* a2);
void r137make_n(T137* C,T0* a1,T0* a2);
void r137short(T137* C);
T0* r137run_class(T137* C);
T6 r137is_like_argument(T137* C,T0* a1,T0* a2,T0* a3);
void r137assertion_check(T137* C,T3 a1);
T0* r137to_runnable(T137* C,T0* a1);
T0* r137expression(T137* C,T2 a1);
void r137put(T137* C,T0* a1,T2 a2);
T2 r137count(T137* C);
void r137from_model(T137* C,T0* a1);
void r137error(T0* a1,T0* a2);
T0* r137start_position(T137* C);
void r132short_target(T132* C);
T0* r132runnable_expression(T0* a1,T0* a2);
void r132run_feature_has_result(T132* C);
void r132short(T132* C);
T0* r132static_result_base_class(T132* C);
T0* r132run_feature_for(T132* C,T0* a1,T0* a2);
void r132make(T132* C,T0* a1,T0* a2);
void r132fatal_error(T0* a1);
void r132bracketed_short(T132* C);
void r132run_feature_match(T132* C);
T0* r132add_comment(T132* C,T0* a1);
void r132assertion_check(T132* C,T3 a1);
void r132with(T132* C,T0* a1,T0* a2,T0* a3);
T0* r132operator(void);
T0* r132to_runnable(T132* C,T0* a1);
T2 r132to_integer(T132* C);
void r132error(T0* a1,T0* a2);
T0* r132result_type(T132* C);
void r124short_target(T124* C);
T0* r124runnable_expression(T0* a1,T0* a2);
void r124run_feature_has_result(T124* C);
void r124bracketed_short(T124* C);
void r124run_feature_match(T124* C,T0* a1);
T0* r124add_comment(T124* C,T0* a1);
void r124with(T124* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r124operator(void);
T0* r124runnable_args(T0* a1,T0* a2);
T0* r124to_runnable(T124* C,T0* a1);
T2 r124to_integer(T124* C);
void r124error(T0* a1,T0* a2);
T0* r124result_type(T124* C);
void r124short(T124* C);
T0* r124static_result_base_class(T124* C);
T0* r124run_feature_for(T124* C,T0* a1,T0* a2);
void r124make(T124* C,T0* a1,T0* a2,T0* a3);
void r124fatal_error(T0* a1);
void r124assertion_check(T124* C,T3 a1);
void r119short_target(T119* C);
T0* r119runnable_expression(T0* a1,T0* a2);
void r119run_feature_has_result(T119* C);
void r119bracketed_short(T119* C);
void r119run_feature_match(T119* C,T0* a1);
T0* r119add_comment(T119* C,T0* a1);
void r119with(T119* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r119operator(void);
T0* r119runnable_args(T0* a1,T0* a2);
T0* r119to_runnable(T119* C,T0* a1);
T2 r119to_integer(T119* C);
void r119error(T0* a1,T0* a2);
T0* r119result_type(T119* C);
void r119short(T119* C);
T0* r119static_result_base_class(T119* C);
T0* r119run_feature_for(T119* C,T0* a1,T0* a2);
void r119make(T119* C,T0* a1,T0* a2,T0* a3);
void r119fatal_error(T0* a1);
void r119assertion_check(T119* C,T3 a1);
T6 r195is_merge_with(T195* C,T0* a1,T0* a2);
T6 r195is_merge_with2aux(T195* C,T0* a1,T0* a2);
T0* r195try_to_undefine_aux(T195* C,T0* a1,T0* a2);
T0* r195try_to_undefine(T195* C,T0* a1,T0* a2);
void r195check_obsolete(T195* C,T0* a1);
T6 r195is_merge_with1(T195* C,T0* a1);
T6 r195is_merge_with2(T195* C,T0* a1,T0* a2);
T0* r195to_run_feature(T195* C,T0* a1,T0* a2);
void r195error(T0* a1,T0* a2);
void r195make(T195* C,T0* a1,T0* a2,T0* a3);
void r195add_into(T195* C,T0* a1);
T6 r195can_hide(T195* C,T0* a1,T0* a2);
void r195merge_header_comments(T195* C,T0* a1);
T0* r195start_position(T195* C);
void r116short_target(T116* C);
T0* r116runnable_expression(T0* a1,T0* a2);
void r116check_comparison(T116* C,T0* a1);
void r116bracketed_short(T116* C);
T0* r116add_comment(T116* C,T0* a1);
void r116with(T116* C,T0* a1,T0* a2,T0* a3);
T0* r116operator(void);
T0* r116runnable_args(T0* a1,T0* a2);
T0* r116to_runnable(T116* C,T0* a1);
T2 r116to_integer(T116* C);
void r116bit_limitation(T116* C,T0* a1,T0* a2);
void r116error(T0* a1,T0* a2);
T0* r116type_boolean(void);
void r116short(T116* C);
T0* r116static_result_base_class(void);
void r116make(T116* C,T0* a1,T0* a2,T0* a3);
void r116fatal_error(T0* a1);
void r116assertion_check(T116* C,T3 a1);
void r116error_comparison(T116* C,T0* a1,T0* a2);
T0* r359generic_list(T359* C);
T0* r359smallest_ancestor(T0* a1);
T0* r359string_aliaser(void);
T0* r359base_class(T359* C);
T0* r359look_up_for(T359* C,T0* a1,T0* a2);
T0* r359static_base_class_name(T359* C);
T6 r359is_a_in(T359* C,T0* a1,T0* a2);
void r359short(T359* C);
T6 r359is_a(T359* C,T0* a1);
T6 r359is_generic(T359* C);
void r359make(T359* C,T0* a1);
void r359fatal_error(T0* a1);
T0* r359base_class_name(T359* C);
void r359short_hook(T359* C);
void r131short_target(T131* C);
T0* r131runnable_expression(T0* a1,T0* a2);
void r131run_feature_has_result(T131* C);
void r131short(T131* C);
T0* r131static_result_base_class(T131* C);
T0* r131run_feature_for(T131* C,T0* a1,T0* a2);
void r131make(T131* C,T0* a1,T0* a2);
void r131fatal_error(T0* a1);
void r131bracketed_short(T131* C);
void r131run_feature_match(T131* C);
T0* r131add_comment(T131* C,T0* a1);
void r131assertion_check(T131* C,T3 a1);
void r131with(T131* C,T0* a1,T0* a2,T0* a3);
T0* r131operator(void);
T0* r131to_runnable(T131* C,T0* a1);
T2 r131to_integer(T131* C);
void r131error(T0* a1,T0* a2);
T0* r131result_type(T131* C);
void r329fatal_error_generic_list(T329* C);
T0* r329type_any(void);
T0* r329generic_list(T329* C);
T2 r329id(T329* C);
T0* r329smallest_ancestor(T329* C,T0* a1);
T0* r329string_aliaser(void);
T0* r329base_class(T329* C);
T0* r329look_up_for(T329* C,T0* a1,T0* a2);
T6 r329is_a_in(T329* C,T0* a1,T0* a2);
T6 r329is_a(T329* C,T0* a1);
T0* r329run_class(T329* C);
void r329make(T329* C,T0* a1);
extern int fBC329base_class_name;
extern T0*oBC329base_class_name;
T0* r329base_class_name(void);
void r158short_target(T158* C);
T0* r158static_result_base_class(void);
void r158make(T158* C,T0* a1,T3 a2,T2 a3);
void r158bracketed_short(T158* C);
T0* r158add_comment(T158* C,T0* a1);
T0* r158to_string(T158* C);
void r158character_coding(T3 a1,T0* a2);
void r158error(T0* a1,T0* a2);
extern int fBC158result_type;
extern T0*oBC158result_type;
T0* r158result_type(void);
void r177short_target(T177* C);
void r177short(T177* C);
T0* r177static_result_base_class(T177* C);
void r177refer_to(T177* C,T0* a1,T0* a2,T2 a3);
void r177bracketed_short(T177* C);
T0* r177add_comment(T177* C,T0* a1);
void r177with(T177* C,T0* a1,T0* a2);
T0* r177to_runnable(T177* C,T0* a1);
T2 r177to_integer(T177* C);
T0* r177to_string(T177* C);
void r177error(T0* a1,T0* a2);
T0* r177result_type(T177* C);
T6 r289is_merge_with(T289* C,T0* a1,T0* a2);
T6 r289is_merge_with2aux(T289* C,T0* a1,T0* a2);
T0* r289try_to_undefine_aux(T289* C,T0* a1,T0* a2);
T0* r289try_to_undefine(T289* C,T0* a1,T0* a2);
void r289check_obsolete(T289* C,T0* a1);
T6 r289is_merge_with1(T289* C,T0* a1);
T6 r289is_merge_with2(T289* C,T0* a1,T0* a2);
T0* r289to_run_feature(T289* C,T0* a1,T0* a2);
void r289error(T0* a1,T0* a2);
void r289set_header_comment(T289* C,T0* a1);
void r289make_routine(T289* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r289make(T289* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r289add_into(T289* C,T0* a1);
T6 r289can_hide(T289* C,T0* a1,T0* a2);
void r289merge_header_comments(T289* C,T0* a1);
T0* r289start_position(T289* C);
T6 r202is_merge_with(T202* C,T0* a1,T0* a2);
T6 r202is_merge_with2aux(T202* C,T0* a1,T0* a2);
T0* r202try_to_undefine_aux(T202* C,T0* a1,T0* a2);
T0* r202try_to_undefine(T202* C,T0* a1,T0* a2);
void r202check_obsolete(T202* C,T0* a1);
T6 r202is_merge_with1(T202* C,T0* a1);
T6 r202is_merge_with2(T202* C,T0* a1,T0* a2);
T0* r202to_run_feature(T202* C,T0* a1,T0* a2);
void r202error(T0* a1,T0* a2);
void r202make(T202* C,T0* a1,T0* a2,T0* a3);
void r202add_into(T202* C,T0* a1);
T6 r202can_hide(T202* C,T0* a1,T0* a2);
void r202merge_header_comments(T202* C,T0* a1);
T0* r202start_position(T202* C);
void r120short_target(T120* C);
T0* r120runnable_expression(T0* a1,T0* a2);
void r120run_feature_has_result(T120* C);
void r120bracketed_short(T120* C);
void r120run_feature_match(T120* C,T0* a1);
T0* r120add_comment(T120* C,T0* a1);
void r120with(T120* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r120operator(void);
T0* r120runnable_args(T0* a1,T0* a2);
T0* r120to_runnable(T120* C,T0* a1);
T2 r120to_integer(T120* C);
void r120error(T0* a1,T0* a2);
T0* r120result_type(T120* C);
void r120short(T120* C);
T0* r120static_result_base_class(T120* C);
T0* r120run_feature_for(T120* C,T0* a1,T0* a2);
void r120make(T120* C,T0* a1,T0* a2,T0* a3);
void r120fatal_error(T0* a1);
void r120assertion_check(T120* C,T3 a1);
T0* r363run_ensure(T363* C);
T0* r363run_class(T363* C);
void r363make(T363* C,T0* a1,T0* a2,T0* a3);
T0* r363run_require(T363* C);
void r363initialize(T363* C);
T6 r363is_exported_in(T363* C,T0* a1);
T0* r363clients(T363* C);
T0* r363start_position(T363* C);
T0* r216to_runnable(T216* C,T0* a1);
void r22check_expanded_with(T22* C,T0* a1);
T6 r22is_subclass_of(T22* C,T0* a1);
void r22inherit_cycle_check(T22* C);
T0* r22super_e_feature(T22* C,T0* a1);
void r22set_parent_list(T22* C,T0* a1,T0* a2,T0* a3);
T0* r22class_any(void);
void r22add_index_clause(T22* C,T0* a1);
void r22set_invariant(T22* C,T0* a1,T0* a2,T0* a3);
void r22warning(T0* a1,T0* a2);
void r22collect_assertion(T22* C,T0* a1);
void r22set_obsolete_type_string(T22* C,T0* a1);
T0* r22look_up_for(T22* C,T0* a1,T0* a2);
T6 r22has_creation(T22* C,T0* a1);
T0* r22up_to_original(T22* C,T0* a1,T0* a2);
void r22error(T0* a1,T0* a2);
void r22add_creation_clause(T22* C,T0* a1);
T6 r22proper_has(T22* C,T0* a1);
T6 r22has_redefine(T22* C,T0* a1);
T0* r22run_ensure(T22* C,T0* a1);
void r22make(T22* C);
void r22vdrd6(T0* a1,T0* a2,T0* a3);
T0* r22new_name_of_original(T22* C,T0* a1,T0* a2);
extern int fBC22mem_fn;
extern T0*oBC22mem_fn;
T0* r22mem_fn(void);
void r22set_is_expanded(T22* C);
void r22set_is_deferred(T22* C);
void r22add_feature_clause(T22* C,T0* a1);
T0* r22new_name_of(T22* C,T0* a1,T0* a2);
void r22up_to_any_in(T22* C,T0* a1);
T6 r22has(T22* C,T0* a1);
T6 r22is_any(T22* C);
void r22fatal_undefine(T22* C,T0* a1);
T0* r22type_any(void);
T0* r22super_look_up_for(T22* C,T0* a1,T0* a2);
T0* r22smallest_ancestor(T22* C,T0* a1,T0* a2);
T0* r22run_require(T22* C,T0* a1);
T0* r22string_aliaser(void);
T6 r22is_a_vncg(T22* C,T0* a1,T0* a2);
void r22collect_invariant(T22* C,T0* a1);
T6 r22is_general(T22* C);
T6 r22has_simple_feature_name(T22* C,T0* a1);
void r22fatal_error_vdrd6(T0* a1,T0* a2,T0* a3);
void r22get_started(T22* C);
T0* r22going_up(T22* C,T0* a1,T0* a2,T0* a3);
void r22header_comment_for(T22* C,T0* a1);
T0* r22run_class(T22* C);
T0* r22run_feature_for(T22* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r22fatal_error(T0* a1);
T0* r22get_copy(T22* C);
T0* r22expanded_initializer(T22* C,T0* a1);
T6 r22is_subclass_of_aux(T22* C,T0* a1);
T0* r22clients_for(T22* C,T0* a1);
T0* r22e_feature(T22* C,T0* a1);
extern T0*oBC22going_up_trace;
extern T0*oBC22visited;
T0* r22class_with(T0* a1);
T0* r22id_provider(void);
T6 r293is_merge_with(T293* C,T0* a1,T0* a2);
T6 r293is_merge_with2aux(T293* C,T0* a1,T0* a2);
T0* r293try_to_undefine_aux(T293* C,T0* a1,T0* a2);
T0* r293try_to_undefine(T293* C,T0* a1,T0* a2);
void r293check_obsolete(T293* C,T0* a1);
T6 r293is_merge_with1(T293* C,T0* a1);
T6 r293is_merge_with2(T293* C,T0* a1,T0* a2);
T0* r293to_run_feature(T293* C,T0* a1,T0* a2);
void r293error(T0* a1,T0* a2);
void r293set_header_comment(T293* C,T0* a1);
void r293make_routine(T293* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r293make(T293* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r293add_into(T293* C,T0* a1);
T6 r293can_hide(T293* C,T0* a1,T0* a2);
void r293merge_header_comments(T293* C,T0* a1);
void r293make_effective_routine(T293* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
T0* r293start_position(T293* C);
void r249fatal_error_generic_list(T249* C);
T0* r249generic_list(T249* C);
T2 r249id(T249* C);
extern int fBC249check_type;
void r249check_type(T249* C);
T0* r249base_class(T249* C);
T0* r249look_up_for(T249* C,T0* a1,T0* a2);
T0* r249to_runnable(T249* C,T0* a1);
T6 r249has_creation(T249* C,T0* a1);
void r249error(T0* a1,T0* a2);
T0* r249run_time_mark(void);
T6 r249is_a_in(T249* C,T0* a1,T0* a2);
void r249short(T249* C);
T6 r249is_a(T249* C,T0* a1);
T0* r249run_class(T249* C);
void r249make(T249* C,T0* a1);
T0* r249written_mark(void);
void r265fatal_error_generic_list(T265* C);
T0* r265type_any(void);
T0* r265generic_list(T265* C);
T2 r265id(T265* C);
T0* r265smallest_ancestor(T265* C,T0* a1);
extern T0*oBC266mem_type_bit_ref;
T0* r265string_aliaser(void);
T0* r265base_class(T265* C);
T0* r265look_up_for(T265* C,T0* a1,T0* a2);
T0* r265to_runnable(T265* C,T0* a1);
extern T0*oBC266mem_ref_nb;
T6 r265is_a_in(T265* C,T0* a1,T0* a2);
void r265short(T265* C);
T6 r265is_a(T265* C,T0* a1);
T0* r265run_class(T265* C);
void r265make(T265* C,T0* a1,T0* a2);
void r265used_as_reference(T265* C);
void r265to_runnable_1_2(T265* C);
extern int fBC266base_class_name;
extern T0*oBC266base_class_name;
T0* r265base_class_name(void);
void r265short_hook(T265* C);
void r265set_run_time_mark(T265* C);
T0* r269left_type(T269* C);
void r269make(T269* C,T0* a1,T0* a2);
void r269fatal_error(T0* a1);
void r269warning(T0* a1,T0* a2);
void r269implicit_conversion(T269* C);
T0* r269add_comment(T269* C,T0* a1);
T0* r269right_type(T269* C);
T0* r269to_runnable(T269* C,T0* a1);
T0* r269start_position(T269* C);
T0* r157type_boolean(void);
T0* r157static_result_base_class(void);
T0* r157add_comment(T157* C,T0* a1);
T0* r157to_string(void);
void r157error(T0* a1,T0* a2);
void r107short_target(T107* C);
T0* r107runnable_expression(T0* a1,T0* a2);
void r107run_feature_has_result(T107* C);
void r107bracketed_short(T107* C);
void r107run_feature_match(T107* C,T0* a1);
T0* r107add_comment(T107* C,T0* a1);
void r107with(T107* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r107operator(void);
T0* r107runnable_args(T0* a1,T0* a2);
T0* r107to_runnable(T107* C,T0* a1);
T2 r107to_integer(T107* C);
void r107error(T0* a1,T0* a2);
T0* r107result_type(T107* C);
void r107short(T107* C);
T0* r107static_result_base_class(T107* C);
T0* r107run_feature_for(T107* C,T0* a1,T0* a2);
void r107make(T107* C,T0* a1,T0* a2,T0* a3);
void r107fatal_error(T0* a1);
void r107assertion_check(T107* C,T3 a1);
void r79add_last(T79* C,T0* a1);
void r79make_n(T79* C,T0* a1);
T0* r79feature_name(T79* C,T0* a1);
void r79short(T79* C);
T6 r79for_short(T79* C,T0* a1,T6 a2,T0* a3,T6 a4,T0* a5,T0* a6);
void r79short_for_creation(T79* C);
void r79fatal_error(T0* a1);
void r79fe_multiple(T0* a1,T0* a2);
T2 r79index_of(T79* C,T0* a1);
T2 r79count(T79* C);
T6 r79has(T79* C,T0* a1);
T0* r79item(T79* C,T2 a1);
void r209make(T209* C,T0* a1,T0* a2,T0* a3);
T0* r209add_comment(T209* C,T0* a1);
T0* r209to_runnable(T209* C,T0* a1);
void r159short_target(T159* C);
T0* r159type_string(void);
extern T0*oBC159tmp_string;
void r159bracketed_short(T159* C);
void r159add_ascii(T159* C,T3 a1);
T0* r159add_comment(T159* C,T0* a1);
T0* r159to_runnable(T159* C,T0* a1);
T2 r159to_integer(T159* C);
void r159short_character(T159* C,T2 a1);
T0* r159twin(T159* C);
void r159error(T0* a1,T0* a2);
extern T0*oBC12manifest_string_pool;
void r159break_line(T159* C);
void r159short(T159* C);
T0* r159static_result_base_class(void);
void r159make(T159* C,T0* a1);
void r159character_coding(T3 a1,T0* a2);
void r159add_percent(T159* C,T3 a1);
T0* r182add_comment(T182* C,T0* a1);
T0* r182to_runnable(T182* C,T0* a1);
T2 r182to_integer(T182* C);
void r182error(T0* a1,T0* a2);
void r101short_target(T101* C);
T0* r101runnable_expression(T0* a1,T0* a2);
void r101run_feature_has_result(T101* C);
void r101bracketed_short(T101* C);
void r101run_feature_match(T101* C,T0* a1);
T0* r101add_comment(T101* C,T0* a1);
void r101with(T101* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r101operator(void);
T0* r101runnable_args(T0* a1,T0* a2);
T0* r101to_runnable(T101* C,T0* a1);
T2 r101to_integer(T101* C);
void r101error(T0* a1,T0* a2);
T0* r101result_type(T101* C);
void r101short(T101* C);
T0* r101static_result_base_class(T101* C);
T0* r101run_feature_for(T101* C,T0* a1,T0* a2);
void r101make(T101* C,T0* a1,T0* a2,T0* a3);
void r101fatal_error(T0* a1);
void r101assertion_check(T101* C,T3 a1);
void r184add_last(T184* C,T0* a1);
void r184warning(T0* a1,T0* a2);
void r184merge(T184* C,T0* a1,T0* a2);
T6 r184gives_permission_to_any(T184* C);
T2 r184index_of(T184* C,T0* a1);
T6 r184gives_permission_to(T184* C,T0* a1);
T2 r184count(T184* C);
T0* r184item(T184* C,T2 a1);
void r41short(T41* C,T0* a1);
void r41make(T41* C,T0* a1,T0* a2,T0* a3);
void r41add_into(T41* C,T0* a1);
void r41make_runnable(T41* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r273short(T273* C,T0* a1,T0* a2);
void r273make(T273* C,T0* a1,T0* a2,T0* a3);
void r273add_into(T273* C,T0* a1);
void r273make_runnable(T273* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r267fatal_error_generic_list(T267* C);
T0* r267type_any(void);
T0* r267generic_list(T267* C);
T2 r267id(T267* C);
T0* r267smallest_ancestor(T267* C,T0* a1);
T0* r267string_aliaser(void);
T0* r267base_class(T267* C);
T0* r267look_up_for(T267* C,T0* a1,T0* a2);
T0* r267to_runnable(T267* C,T0* a1);
T6 r267is_a_in(T267* C,T0* a1,T0* a2);
void r267short(T267* C);
T6 r267is_a(T267* C,T0* a1);
T0* r267run_class(T267* C);
void r267make(T267* C,T0* a1,T0* a2);
void r267fatal_error(T0* a1);
void r267used_as_reference(T267* C);
void r267to_runnable_1_2(T267* C);
T0* r267base_class_name(void);
void r267short_hook(T267* C);
void r267set_run_time_mark(T267* C);
void r235make(T235* C,T0* a1,T0* a2);
T0* r235to_runnable(T235* C,T0* a1);
T0* r235twin(T235* C);
void r235error(T0* a1,T0* a2);
T0* r235start_position(T235* C);
T0* r345run_ensure(T345* C);
T0* r345run_class(T345* C);
void r345make(T345* C,T0* a1,T0* a2,T0* a3);
T0* r345run_require(T345* C);
void r345initialize(T345* C);
T6 r345is_exported_in(T345* C,T0* a1);
T0* r345clients(T345* C);
T0* r345start_position(T345* C);
T6 r67a_manifest_string(T67* C);
void r67a_indexing(T67* C);
T0* r67current_position(T67* C);
T0* r67a_actuals(T67* C);
T0* r67a_clients(T67* C);
T6 r67a_strip(T67* C);
extern T0*oBC67forbidden_class;
extern T0*oBC67tmp_name;
void r67a_after_a_dot(T67* C,T6 a1,T0* a2);
extern T0*oBC67faof;
T6 r67a_integer(T67* C);
void r67a_parent_list(T67* C,T0* a1,T0* a2);
T6 r67a_actual(T67* C);
void r67a_rename_list(T67* C);
T6 r67a_local_variable(T67* C);
T6 r67a_infix(T67* C);
T0* r67analyse_class(T67* C,T0* a1);
void r67skip_comments(T67* C);
T6 r67a_inspect(T67* C);
T6 r67a_current(T67* C);
void r67next_char(T67* C);
T6 r67a_unary(T67* C);
T6 r67a_conditional(T67* C);
void r67a_base_class_name1(T67* C);
T6 r67a_retry(T67* C);
extern T0*oBC67tmp_string;
T6 r67a_e10(T67* C);
T6 r67a_tag_mark(T67* C);
T0* r67a_routine_body(T67* C);
T6 r67a_feature_declaration(T67* C);
void r67a_r10(T67* C,T6 a1,T0* a2,T0* a3,T0* a4);
T6 r67a_keyword(T67* C,T0* a1);
T6 r67a_class_type(T67* C);
T6 r67a_feature_name_list(T67* C);
T6 r67a_feature_name(T67* C);
T0* r67a_assertion(T67* C);
void r67a_ascii_code(T67* C);
T6 r67a_void(T67* C);
void r67a_formal_generic_list(T67* C);
T6 r67a_index_value(T67* C);
void r67a_assignment_aux(T67* C,T6 a1);
T0* r67to_proc_call(T67* C,T0* a1,T0* a2,T0* a3);
T6 r67a_expression(T67* C);
T0* r67a_routine(T67* C);
T6 r67a_creation(T67* C);
T6 r67a_bit_constant(T67* C);
T6 r67a_boolean_constant(T67* C);
T0* r67a_external(T67* C);
T6 r67a_type(T67* C);
T6 r67skip1unless2(T67* C,T3 a1,T3 a2);
T6 r67a_real(T67* C);
T6 r67a_index_clause(T67* C);
void r67a_procedure_call(T67* C);
T6 r67a_parent(T67* C);
T0* r67a_compound1(T67* C);
T6 r67a_instruction(T67* C);
T6 r67a_debug(T67* C);
void r67to_frozen_feature_name(T67* C);
T6 r67a_manifest_constant(T67* C);
T6 r67a_base_type(T67* C);
T6 r67a_result(T67* C);
T6 r67a_base_class_name(T67* C);
void r67a_formal_arg_list(T67* C);
T6 r67a_identifier(T67* C);
void r67wcpefnc(T67* C,T0* a1,T0* a2);
T6 r67skip1(T67* C,T3 a1);
T6 r67skip2(T67* C,T3 a1,T3 a2);
T6 r67a_integer_constant(T67* C);
T0* r67a_compound2(T67* C,T0* a1,T0* a2);
void r67a_new_export_list(T67* C);
void r67a_creation_clause(T67* C,T0* a1);
void r67show_nb(T2 a1,T0* a2);
T6 r67a_identifier1(T67* C);
void r67fcp(T67* C,T0* a1);
T6 r67a_character_constant(T67* C);
extern T0*oBC67lcs;
void r67a_local_var_list(T67* C);
T0* r67pos(T2 a1,T2 a2);
T6 r67a_loop(T67* C);
T6 r67a_free_operator(T67* C);
T6 r67a_binary(T67* C,T0* a1);
T6 r67a_check(T67* C);
void r67a_then_part_list(T67* C,T0* a1);
T6 r67a_precursor(T67* C,T6 a1);
T6 r67a_prefix(T67* C);
void r67fatal_error(T0* a1);
T6 r67a_identifier2(T67* C);
void r67warning(T0* a1,T0* a2);
extern T0*oBC67tmp_feature;
T0* r67get_comments(T67* C);
void r67error(T0* a1,T0* a2);
T0* r67to_call(T0* a1,T0* a2,T0* a3);
T6 r67a_then_part(T67* C,T0* a1);
T6 r67a_type_formal_generic(T67* C);
void r67go_back_at(T67* C,T2 a1,T2 a2);
T6 r67a_when_part(T67* C,T0* a1);
T6 r67a_argument(T67* C);
T6 r67a_assignment_or_call(T67* C);
T6 r67a_constant(T67* C);
T6 r67a_e0(T67* C);
T6 r67a_e1(T67* C);
T6 r67a_e2(T67* C);
T6 r67a_e3(T67* C);
T6 r67a_e4(T67* C);
T6 r67a_e5(T67* C);
T6 r67a_e6(T67* C);
T6 r67a_e7(T67* C);
void r67a_function_call(T67* C);
T6 r67a_e8(T67* C);
T6 r67a_e9(T67* C);
T6 r67a_real_constant(T67* C);
T6 r67a_rename_pair(T67* C);
void r67a_r1(T67* C,T0* a1);
void r67a_r2(T67* C,T0* a1);
void r67a_r3(T67* C,T0* a1);
void r67a_r4(T67* C,T0* a1);
void r67a_r5(T67* C,T0* a1);
void r67a_r6(T67* C,T0* a1);
void r67a_r7(T67* C,T0* a1);
T0* r67last_result(T67* C);
void r67a_r8(T67* C,T0* a1);
T0* r67a_alias(T67* C);
void r67a_feature_clause(T67* C);
void r67err_exp(T0* a1,T0* a2);
void r67a_class_declaration(T67* C);
void r39put_string(T39* C,T0* a1);
void r39put_integer(T39* C,T2 a1);
void r72load_file(T72* C,T0* a1);
extern T0*oBC72text;
T0* r72get_line(T2 a1);
T0* r72item(T2 a1);
void r162short_target(T162* C);
T0* r162static_result_base_class(void);
void r162make(T162* C,T0* a1,T0* a2);
void r162bracketed_short(T162* C);
T0* r162add_comment(T162* C,T0* a1);
T2 r162to_integer(T162* C);
void r162error(T0* a1,T0* a2);
extern int fBC162result_type;
extern T0*oBC162result_type;
T0* r162result_type(void);
T6 r247is_any(T247* C);
void r247fatal_error_generic_list(T247* C);
T6 r247is_string(T247* C);
T0* r247generic_list(T247* C);
T2 r247id(T247* C);
T0* r247smallest_ancestor(T247* C,T0* a1);
T0* r247string_aliaser(void);
T0* r247base_class(T247* C);
T6 r247is_array(T247* C);
void r247with(T247* C,T0* a1,T0* a2);
T6 r247is_double(T247* C);
T6 r247is_none(T247* C);
T0* r247look_up_for(T247* C,T0* a1,T0* a2);
T0* r247to_runnable(T247* C,T0* a1);
T6 r247has_creation(T247* C,T0* a1);
T6 r247is_pointer(T247* C);
T0* r247static_base_class_name(T247* C);
T0* r247run_time_mark(T247* C);
T6 r247is_a_in(T247* C,T0* a1,T0* a2);
void r247short(T247* C);
T6 r247is_boolean(T247* C);
T6 r247is_a(T247* C,T0* a1);
T0* r247run_class(T247* C);
T6 r247is_generic(T247* C);
void r247anchor_cycle_start(T247* C);
void r247make(T247* C,T0* a1,T0* a2);
void r247fatal_error(T0* a1);
T0* r247run_type(T247* C);
T6 r247is_expanded(T247* C);
T6 r247is_basic_eiffel_expanded(T247* C);
T0* r247expanded_initializer(T247* C);
void r247anchor_cycle_end(T247* C);
void r247used_as_reference(T247* C);
T6 r247is_character(T247* C);
T6 r247is_reference(T247* C);
T6 r247is_real(T247* C);
T0* r247base_class_name(T247* C);
void r247short_hook(T247* C);
T6 r247is_run_type(T247* C);
T6 r247is_bit(T247* C);
T6 r247is_integer(T247* C);
void r204short(T204* C);
void r204make(T204* C,T0* a1,T0* a2,T0* a3);
void r204add_into(T204* C,T0* a1);
void r204make_runnable(T204* C,T0* a1,T0* a2,T0* a3,T0* a4);
T0* r187to_cst_att_character(T187* C,T0* a1);
void r187error(T0* a1,T0* a2);
T0* r187to_cst_att_real(T187* C,T0* a1);
T0* r187to_cst_att_unique(T187* C);
T0* r187to_cst_att_string(T187* C,T0* a1);
T0* r187to_procedure_or_function(T187* C);
T0* r187to_cst_att_bit(T187* C,T0* a1);
T0* r187n(void);
void r187to_cst_att_check_result_type(T187* C);
T0* r187to_cst_att_integer(T187* C,T0* a1);
T0* r187to_external_routine(T187* C,T0* a1,T0* a2);
void r187fatal_error(T0* a1);
void r187set_require(T187* C,T0* a1,T0* a2,T0* a3);
T0* r187to_deferred_routine(T187* C);
T0* r187to_writable_attribute(T187* C);
void r187add_synonym(T0* a1);
void r187set_require_else(T187* C,T0* a1,T0* a2,T0* a3);
void r187initialize(T187* C);
T0* r187to_once_routine(T187* C);
extern T0*oBC187names;
T0* r187to_cst_att_boolean(T187* C,T0* a1);
extern T0*oBC334manifest_array_types;
void r334register(T0* a1);
void r193increment(T193* C);
extern T0*oBC342mangling_dictionary;
T0* r342register(T0* a1);
extern T0*oBC339registered;
void r339register_for(T0* a1);
extern T0*oBC339caller_memory;
void r354add_procedure(T0* a1);
extern T0*oBC354procedure_list;
void r354add_function(T0* a1);
extern T0*oBC354function_list;
T6 r96is_current(void);
void r96reset(T96* C,T2 a1,T2 a2);
T0* r96to_tag_name(T96* C);
T0* r96to_argument_name2(T96* C,T0* a1,T2 a2);
T0* r96to_e_void(T96* C);
T0* r96to_local_name2(T96* C,T0* a1,T2 a2);
T0* r96to_simple_feature_name(T96* C);
T0* r96to_class_name(T96* C);
T6 r96isa_keyword(void);
T0* r96to_argument_name1(T96* C);
T0* r96start_position(T96* C);
T0* r96to_prefix_name(T96* C);
T0* r96string_aliaser(void);
T0* r96aliased_string(T96* C);
T0* r96to_infix_name(T96* C,T0* a1);
T0* r96pos(T2 a1,T2 a2);
T6 r96is_void(void);
T0* r96to_local_name1(T96* C);
T0* r96to_infix_name_use(T96* C);
T6 r96is_result(void);
T6 r10is_flag_no_warning(T0* a1);
T0* r10argument(T2 a1);
T6 r10gt(T2 a1,T2 a2);
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
void r10compute_run_class(T10* C,T0* a1);
T6 r10is_flag_no_style_warning(T0* a1);
T6 r10is_flag_case_insensitive(T0* a1);
void r10make(T10* C);
void r10automat(T10* C);
extern T0*oBC10rf_list;
void r10compute_rf_list(T10* C);
T0* r10system_tools(void);
extern T0*oBC10parents;
T6 r10is_flag_version(T10* C,T0* a1);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 366
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms271_124456;
extern T7*ms269_168036;
extern T7*ms165_268167;
extern T7*ms172_106468;
extern T7*ms41_0aaaaaaaa;
extern T7*ms164_366828;
extern T7*ms338_320658;
extern T7*ms187_147108;
extern T7*ms338_203069;
extern T7*ms204_0aaaaaaaaaaaaaaaaaaaaa;
extern T7*ms187_185909;
extern T7*ms273_0aaaaaaaaaaaaaaaaaaaaa;
extern T7*ms204_180a;
extern T7*ms204_616a;
extern T7*ms204_10aa;
extern T7*ms204_0aaa;
extern T7*ms273_180a;
extern T7*ms273_616a;
extern T7*ms273_10aa;
extern T7*ms273_0aaa;
extern T7*ms204_0aaaaaaaaaaa;
extern T7*ms273_0aaaaaaaaaaa;
extern T7*ms204_0aaaaaaaaaaaaaa;
extern T7*ms204_0aaaaaaaaaaaaaaaaaaa;
extern T7*ms40_5719a;
extern T7*ms40_5817a;
extern T7*ms40_5740a;
extern T7*ms40_5789a;
extern T7*ms40_10aaa;
extern T7*ms13_7524a;
extern T7*ms13_1684a;
extern T7*ms13_2615a;
extern T7*ms273_0aaaaaaaaaaaaaa;
extern T7*ms14_2765a;
extern T7*ms14_2730a;
extern T7*ms14_1035a;
extern T7*ms41_6020a;
extern T7*ms41_6069a;
extern T7*ms41_10aaa;
extern T7*ms41_6167a;
extern T7*ms41_6216a;
extern T7*ms41_5775a;
extern T7*ms41_5824a;
extern T7*ms41_5873a;
extern T7*ms41_5922a;
extern T7*ms41_5971a;
extern T7*ms41_6118a;
extern T7*ms41_0aaaa;
extern T7*ms67_1176a;
extern T7*ms67_9260a;
extern T7*ms67_9955a;
extern T7*ms273_0aaaaaaaaaaaaaaaaaaa;
extern T7*ms41_0aaaaaaaaaaaa;
extern T7*ms41_0aaaaaaaaaaaaaaa;
extern T7*ms41_0aaaaaaaaaaaaaaaaaaaa;
extern T7*ms204_0aaaaaaaa;
extern T7*ms273_0aaaaaaaa;
extern T7*ms204_0aaaaaaaaaaaaaaaaa;
extern T7*ms41_0aaaaaaaaa;
extern T7*ms273_0aaaaaaaaaaaaaaaaa;
extern T7*ms204_5999a;
extern T7*ms204_4032a;
extern T7*ms204_6048a;
extern T7*ms204_10aaa;
extern T7*ms204_6146a;
extern T7*ms204_6195a;
extern T7*ms204_5754a;
extern T7*ms204_5803a;
extern T7*ms204_5852a;
extern T7*ms204_5901a;
extern T7*ms204_5950a;
extern T7*ms204_6097a;
extern T7*ms204_0aaaa;
extern T7*ms273_5992a;
extern T7*ms273_4032a;
extern T7*ms273_6041a;
extern T7*ms273_10aaa;
extern T7*ms273_6139a;
extern T7*ms273_6188a;
extern T7*ms273_5747a;
extern T7*ms273_5796a;
extern T7*ms273_5845a;
extern T7*ms273_5894a;
extern T7*ms273_5943a;
extern T7*ms273_6090a;
extern T7*ms273_0aaaa;
extern T7*ms40_10aaaa;
extern T7*ms40_15456a;
extern T7*ms14_22824a;
extern T7*ms14_12915a;
extern T7*ms41_10aaaa;
extern T7*ms41_6069aa;
extern T7*ms41_6167aa;
extern T7*ms41_5873aa;
extern T7*ms41_5922aa;
extern T7*ms41_5971aa;
extern T7*ms41_6118aa;
extern T7*ms41_6216aa;
extern T7*ms41_5775aa;
extern T7*ms41_5824aa;
extern T7*ms41_0aaaaa;
extern T7*ms60_23814a;
extern T7*ms70_56820a;
extern T7*ms91_16720a;
extern T7*ms67_78588a;
extern T7*ms67_82473a;
extern T7*ms67_28980a;
extern T7*ms67_13832a;
extern T7*ms67_44694a;
extern T7*ms67_37992a;
extern T7*ms40_0;
extern T7*ms41_0;
extern T7*ms91_0;
extern T7*ms75_0;
extern T7*ms41_0aaaaaaaaaaaaaaaaaa;
extern T7*ms204_0;
extern T7*ms273_0;
extern T7*ms204_0aaaaaaaaaaaa;
extern T7*ms40_10;
extern T7*ms14_60;
extern T7*ms41_10;
extern T7*ms70_10;
extern T7*ms54_40;
extern T7*ms91_10;
extern T7*ms14_61;
extern T7*ms43_91;
extern T7*ms54_41;
extern T7*ms273_0aaaaaaaaaaaa;
extern T7*ms14_62;
extern T7*ms14_42;
extern T7*ms14_43;
extern T7*ms43_93;
extern T7*ms14_64;
extern T7*ms14_94;
extern T7*ms43_44;
extern T7*ms40_95;
extern T7*ms14_45;
extern T7*ms14_35;
extern T7*ms53_95;
extern T7*ms55_95;
extern T7*ms40_46;
extern T7*ms99_44;
extern T7*ms13_46;
extern T7*ms53_96;
extern T7*ms14_47;
extern T7*ms67_67;
extern T7*ms41_59;
extern T7*ms53_39;
extern T7*ms204_0aaaaaaaaaaaaaaa;
extern T7*ms204_10;
extern T7*ms137_40;
extern T7*ms273_10;
extern T7*ms41_0aaaaaaaaaaaaa;
extern T7*ms250_91;
extern T7*ms135_41;
extern T7*ms252_91;
extern T7*ms273_0aaaaaaaaaaaaaaa;
extern T7*ms137_41;
extern T7*ms263_91;
extern T7*ms204_10aaaa;
extern T7*ms204_6048aa;
extern T7*ms204_6146aa;
extern T7*ms204_5852aa;
extern T7*ms204_5901aa;
extern T7*ms204_5950aa;
extern T7*ms204_6097aa;
extern T7*ms204_6195aa;
extern T7*ms204_5754aa;
extern T7*ms204_5803aa;
extern T7*ms204_0aaaaa;
extern T7*ms103_32;
extern T7*ms176_41;
extern T7*ms117_37536a;
extern T7*ms273_10aaaa;
extern T7*ms273_6041aa;
extern T7*ms273_6139aa;
extern T7*ms273_5845aa;
extern T7*ms273_5894aa;
extern T7*ms273_5943aa;
extern T7*ms273_6090aa;
extern T7*ms273_6188aa;
extern T7*ms273_5747aa;
extern T7*ms273_5796aa;
extern T7*ms273_0aaaaa;
extern T7*ms204_0aaaaaaaaa;
extern T7*ms265_32;
extern T7*ms267_32;
extern T7*ms250_93;
extern T7*ms252_93;
extern T7*ms263_93;
extern T7*ms130_34;
extern T7*ms273_0aaaaaaaaa;
extern T7*ms126_34;
extern T7*ms137_44;
extern T7*ms263_44;
extern T7*ms159_34;
extern T7*ms171_95;
extern T7*ms136_95;
extern T7*ms13_240;
extern T7*ms22_160;
extern T7*ms40_180;
extern T7*ms13_440;
extern T7*ms31_270;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms31_210;
extern T7*ms31_690;
extern T7*ms14_450;
extern T7*ms41_180;
extern T7*ms70_300;
extern T7*ms47_870;
extern T7*ms40_981;
extern T7*ms67_280;
extern T7*ms14_921;
extern T7*ms269_46;
extern T7*ms40_972;
extern T7*ms13_422;
extern T7*ms22_152;
extern T7*ms31_132;
extern T7*ms40_882;
extern T7*ms40_822;
extern T7*ms14_242;
extern T7*ms14_552;
extern T7*ms14_432;
extern T7*ms60_112;
extern T7*ms159_37;
extern T7*ms13_933;
extern T7*ms204_59;
extern T7*ms79_152;
extern T7*ms12_294;
extern T7*ms47_873;
extern T7*ms13_414;
extern T7*ms13_424;
extern T7*ms273_59;
extern T7*ms67_663;
extern T7*ms14_564;
extern T7*ms70_144;
extern T7*ms40_10aaaaa;
extern T7*ms44_214;
extern T7*ms41_5922aaa;
extern T7*ms41_5971aaa;
extern T7*ms41_5873aaa;
extern T7*ms41_6216aaa;
extern T7*ms41_5775aaa;
extern T7*ms41_5824aaa;
extern T7*ms41_0aaaaaa;
extern T7*ms48_684;
extern T7*ms40_825;
extern T7*ms31_285;
extern T7*ms57_110836a;
extern T7*ms31_636;
extern T7*ms67_28980aa;
extern T7*ms67_112140a;
extern T7*ms67_145656a;
extern T7*ms67_103845a;
extern T7*ms14_246;
extern T7*ms14_216;
extern T7*ms14_696;
extern T7*ms41_616;
extern T7*ms60_336;
extern T7*ms13_957;
extern T7*ms68_366;
extern T7*ms13_248;
extern T7*ms40_288;
extern T7*ms13_188;
extern T7*ms40_858;
extern T7*ms31_948;
extern T7*ms31_738;
extern T7*ms67_657;
extern T7*ms14_368;
extern T7*ms14_188;
extern T7*ms41_288;
extern T7*ms70_208;
extern T7*ms41_0aaaaaaaaaa;
extern T7*ms13_939;
extern T7*ms14_669;
extern T7*ms41_0aaaaaaaaaaaaaaaa;
extern T7*ms204_0aaaaaaaaaaaaaaaaaaaa;
extern T7*ms300_180;
extern T7*ms273_0aaaaaaaaaaaaaaaaaaaa;
extern T7*ms204_180;
extern T7*ms273_180;
extern T7*ms297_180;
extern T7*ms176_182;
extern T7*ms297_152;
extern T7*ms205_174;
extern T7*ms10_7110;
extern T7*ms10_2660;
extern T7*ms10_2800;
extern T7*ms238_174;
extern T7*ms176_144;
extern T7*ms31_2800;
extern T7*ms40_6160;
extern T7*ms22_5320;
extern T7*ms40_5740;
extern T7*ms13_1020;
extern T7*ms13_2780;
extern T7*ms13_2810;
extern T7*ms13_7320;
extern T7*ms13_2830;
extern T7*ms13_2710;
extern T7*ms13_7260;
extern T7*ms13_8680;
extern T7*ms13_1700;
extern T7*ms13_2670;
extern T7*ms13_2550;
extern T7*ms13_2610;
extern T7*ms13_3720;
extern T7*ms22_1070;
extern T7*ms40_5880;
extern T7*ms14_1980;
extern T7*ms14_2600;
extern T7*ms14_2620;
extern T7*ms14_8750;
extern T7*ms14_2760;
extern T7*ms14_2440;
extern T7*ms14_7380;
extern T7*ms14_2730;
extern T7*ms14_7530;
extern T7*ms14_8820;
extern T7*ms14_1800;
extern T7*ms14_2780;
extern T7*ms41_6440;
extern T7*ms41_6020;
extern T7*ms60_5160;
extern T7*ms40_0a;
extern T7*ms70_2120;
extern T7*ms41_0a;
extern T7*ms54_8540;
extern T7*ms91_5880;
extern T7*ms40_6111;
extern T7*ms40_6181;
extern T7*ms204_616;
extern T7*ms67_6580;
extern T7*ms67_9260;
extern T7*ms67_7530;
extern T7*ms67_7510;
extern T7*ms13_9401;
extern T7*ms40_5831;
extern T7*ms68_2250;
extern T7*ms14_1011;
extern T7*ms14_8211;
extern T7*ms14_9051;
extern T7*ms14_9801;
extern T7*ms68_2610;
extern T7*ms41_5971;
extern T7*ms171_876;
extern T7*ms171_816;
extern T7*ms97_1660;
extern T7*ms99_2620;
extern T7*ms99_2540;
extern T7*ms237_156;
extern T7*ms91_5831;
extern T7*ms273_616;
extern T7*ms10_5782;
extern T7*ms12_1592;
extern T7*ms40_6062;
extern T7*ms22_3102;
extern T7*ms40_6132;
extern T7*ms40_4032;
extern T7*ms13_1792;
extern T7*ms13_6912;
extern T7*ms13_6822;
extern T7*ms13_9422;
extern T7*ms13_6852;
extern T7*ms31_6412;
extern T7*ms40_5782;
extern T7*ms31_8092;
extern T7*ms14_6702;
extern T7*ms14_1772;
extern T7*ms14_1672;
extern T7*ms14_6762;
extern T7*ms41_5922;
extern T7*ms134_957;
extern T7*ms53_1112;
extern T7*ms54_6702;
extern T7*ms10_5733;
extern T7*ms10_7073;
extern T7*ms40_6013;
extern T7*ms13_7263;
extern T7*ms40_6083;
extern T7*ms67_6402;
extern T7*ms67_5302;
extern T7*ms40_6223;
extern T7*ms13_1053;
extern T7*ms14_6643;
extern T7*ms41_5873;
extern T7*ms342_448;
extern T7*ms10_5824;
extern T7*ms11_2424;
extern T7*ms75_5553;
extern T7*ms159_168;
extern T7*ms40_5964;
extern T7*ms40_5754;
extern T7*ms22_4164;
extern T7*ms13_1724;
extern T7*ms13_1684;
extern T7*ms13_1744;
extern T7*ms13_7524;
extern T7*ms14_9234;
extern T7*ms14_1644;
extern T7*ms14_1664;
extern T7*ms14_1724;
extern T7*ms14_1744;
extern T7*ms14_7314;
extern T7*ms41_5824;
extern T7*ms171_819;
extern T7*ms70_5784;
extern T7*ms10_2505;
extern T7*ms55_1604;
extern T7*ms55_1524;
extern T7*ms40_5915;
extern T7*ms40_6195;
extern T7*ms22_8175;
extern T7*ms13_9485;
extern T7*ms13_2615;
extern T7*ms13_2595;
extern T7*ms31_9785;
extern T7*ms40_5775;
extern T7*ms31_2395;
extern T7*ms14_2765;
extern T7*ms14_2785;
extern T7*ms14_2445;
extern T7*ms14_8505;
extern T7*ms14_9275;
extern T7*ms14_1035;
extern T7*ms14_1915;
extern T7*ms14_6405;
extern T7*ms41_5775;
extern T7*ms43_8505;
extern T7*ms44_2775;
extern T7*ms99_7134;
extern T7*ms91_6125;
extern T7*ms75_5775;
extern T7*ms40_5866;
extern T7*ms40_5936;
extern T7*ms67_2595;
extern T7*ms67_9955;
extern T7*ms13_1736;
extern T7*ms31_5166;
extern T7*ms31_3636;
extern T7*ms40_4746;
extern T7*ms31_9226;
extern T7*ms31_1316;
extern T7*ms31_1296;
extern T7*ms14_1216;
extern T7*ms14_7576;
extern T7*ms14_6846;
extern T7*ms14_1656;
extern T7*ms14_9436;
extern T7*ms14_7326;
extern T7*ms14_4956;
extern T7*ms14_6776;
extern T7*ms68_2065;
extern T7*ms41_6216;
extern T7*ms70_1116;
extern T7*ms91_6076;
extern T7*ms75_5726;
extern T7*ms13_8267;
extern T7*ms40_5817;
extern T7*ms40_5887;
extern T7*ms40_5747;
extern T7*ms67_1176;
extern T7*ms67_7826;
extern T7*ms40_6027;
extern T7*ms14_8547;
extern T7*ms14_6307;
extern T7*ms41_6167;
extern T7*ms91_6027;
extern T7*ms75_9977;
extern T7*ms40_1648;
extern T7*ms13_9878;
extern T7*ms40_5768;
extern T7*ms40_2268;
extern T7*ms40_5838;
extern T7*ms13_7008;
extern T7*ms13_1768;
extern T7*ms13_6978;
extern T7*ms31_8478;
extern T7*ms13_3038;
extern T7*ms40_5978;
extern T7*ms14_5508;
extern T7*ms14_7928;
extern T7*ms14_1608;
extern T7*ms14_9408;
extern T7*ms14_1168;
extern T7*ms14_4728;
extern T7*ms41_2268;
extern T7*ms41_6118;
extern T7*ms53_1108;
extern T7*ms91_5978;
extern T7*ms91_2268;
extern T7*ms55_1528;
extern T7*ms22_4949;
extern T7*ms40_5719;
extern T7*ms40_5789;
extern T7*ms13_8799;
extern T7*ms67_9888;
extern T7*ms40_5929;
extern T7*ms68_8638;
extern T7*ms41_6069;
extern T7*ms79_9198;
extern T7*ms97_1688;
extern T7*ms43_9149;
extern T7*ms91_5929;
extern T7*ms130_1560;
extern T7*ms311_6980;
extern T7*ms204_0aaaaaaaaaaaaaaaaaa;
extern T7*ms204_3770;
extern T7*ms204_5950;
extern T7*ms117_9780;
extern T7*ms126_5460;
extern T7*ms315_7200;
extern T7*ms315_4200;
extern T7*ms137_9100;
extern T7*ms273_6090;
extern T7*ms329_1020;
extern T7*ms266_7630;
extern T7*ms204_5901;
extern T7*ms273_0aaaaaaaaaaaaaaaaaa;
extern T7*ms273_6041;
extern T7*ms300_4812;
extern T7*ms103_7242;
extern T7*ms204_4032;
extern T7*ms204_5852;
extern T7*ms126_1532;
extern T7*ms136_1572;
extern T7*ms264_7452;
extern T7*ms273_5992;
extern T7*ms273_4032;
extern T7*ms329_1012;
extern T7*ms204_5803;
extern T7*ms273_5943;
extern T7*ms204_5754;
extern T7*ms134_1404;
extern T7*ms204_5901aaa;
extern T7*ms204_5950aaa;
extern T7*ms204_5852aaa;
extern T7*ms204_6195aaa;
extern T7*ms204_5754aaa;
extern T7*ms204_5803aaa;
extern T7*ms204_0aaaaaa;
extern T7*ms135_5894;
extern T7*ms11_24020;
extern T7*ms315_5894;
extern T7*ms244_1684;
extern T7*ms13_25640;
extern T7*ms13_12870;
extern T7*ms22_23730;
extern T7*ms137_6984;
extern T7*ms13_17460;
extern T7*ms13_11460;
extern T7*ms13_23520;
extern T7*ms13_18080;
extern T7*ms40_32950;
extern T7*ms40_33500;
extern T7*ms22_36270;
extern T7*ms22_17730;
extern T7*ms22_32700;
extern T7*ms13_66110;
extern T7*ms13_10880;
extern T7*ms13_10720;
extern T7*ms13_41100;
extern T7*ms31_82530;
extern T7*ms31_11880;
extern T7*ms31_33210;
extern T7*ms31_46640;
extern T7*ms31_41310;
extern T7*ms31_26180;
extern T7*ms31_38280;
extern T7*ms31_31980;
extern T7*ms31_19880;
extern T7*ms31_10010;
extern T7*ms246_1684;
extern T7*ms273_5894;
extern T7*ms14_12550;
extern T7*ms14_10740;
extern T7*ms14_12030;
extern T7*ms14_10680;
extern T7*ms14_15070;
extern T7*ms14_15570;
extern T7*ms14_30660;
extern T7*ms14_26880;
extern T7*ms14_33240;
extern T7*ms14_60060;
extern T7*ms14_33270;
extern T7*ms14_53940;
extern T7*ms14_32730;
extern T7*ms14_27580;
extern T7*ms14_33990;
extern T7*ms14_16970;
extern T7*ms14_16770;
extern T7*ms14_16850;
extern T7*ms14_21300;
extern T7*ms14_56720;
extern T7*ms14_15650;
extern T7*ms14_22140;
extern T7*ms247_1684;
extern T7*ms60_12960;
extern T7*ms60_24060;
extern T7*ms176_6034;
extern T7*ms70_56820;
extern T7*ms53_10720;
extern T7*ms204_6195;
extern T7*ms273_5894aaa;
extern T7*ms273_5943aaa;
extern T7*ms273_5845aaa;
extern T7*ms273_6188aaa;
extern T7*ms273_5747aaa;
extern T7*ms273_5796aaa;
extern T7*ms273_0aaaaaa;
extern T7*ms250_8505;
extern T7*ms91_16720;
extern T7*ms56_23940;
extern T7*ms83_91200;
extern T7*ms117_1855;
extern T7*ms252_8505;
extern T7*ms315_5845;
extern T7*ms57_22560;
extern T7*ms57_71750;
extern T7*ms57_93400;
extern T7*ms57_73570;
extern T7*ms244_2265;
extern T7*ms67_57450;
extern T7*ms67_82140;
extern T7*ms67_70550;
extern T7*ms67_28980;
extern T7*ms67_43830;
extern T7*ms67_11050;
extern T7*ms67_73800;
extern T7*ms67_91880;
extern T7*ms67_20060;
extern T7*ms67_90080;
extern T7*ms67_63690;
extern T7*ms67_37500;
extern T7*ms67_27720;
extern T7*ms67_28940;
extern T7*ms67_75620;
extern T7*ms67_32940;
extern T7*ms67_74830;
extern T7*ms67_97990;
extern T7*ms67_28720;
extern T7*ms67_57210;
extern T7*ms67_65170;
extern T7*ms67_47790;
extern T7*ms67_56460;
extern T7*ms86_19170;
extern T7*ms263_8505;
extern T7*ms86_66660;
extern T7*ms13_38641;
extern T7*ms13_45441;
extern T7*ms86_41470;
extern T7*ms31_43761;
extern T7*ms246_2265;
extern T7*ms273_5845;
extern T7*ms247_2265;
extern T7*ms130_1556;
extern T7*ms311_6056;
extern T7*ms204_6146;
extern T7*ms359_2535;
extern T7*ms297_5985;
extern T7*ms315_5796;
extern T7*ms13_67082;
extern T7*ms22_63712;
extern T7*ms13_11292;
extern T7*ms22_15152;
extern T7*ms13_14292;
extern T7*ms273_5796;
extern T7*ms204_0a;
extern T7*ms14_16692;
extern T7*ms14_27272;
extern T7*ms14_34432;
extern T7*ms14_21192;
extern T7*ms14_13662;
extern T7*ms14_13752;
extern T7*ms60_55332;
extern T7*ms60_48112;
extern T7*ms60_70652;
extern T7*ms53_44172;
extern T7*ms204_6097;
extern T7*ms273_0a;
extern T7*ms56_50372;
extern T7*ms297_5936;
extern T7*ms11_17743;
extern T7*ms57_35512;
extern T7*ms94_66792;
extern T7*ms94_43392;
extern T7*ms67_38352;
extern T7*ms67_85332;
extern T7*ms67_76392;
extern T7*ms67_13832;
extern T7*ms67_19992;
extern T7*ms67_78192;
extern T7*ms67_45252;
extern T7*ms67_25992;
extern T7*ms67_37992;
extern T7*ms67_34992;
extern T7*ms13_63393;
extern T7*ms86_64152;
extern T7*ms86_82612;
extern T7*ms13_50483;
extern T7*ms68_19162;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms273_5747;
extern T7*ms14_16393;
extern T7*ms14_14193;
extern T7*ms14_27443;
extern T7*ms14_13833;
extern T7*ms96_84672;
extern T7*ms103_7248;
extern T7*ms130_6448;
extern T7*ms176_5887;
extern T7*ms70_62493;
extern T7*ms99_63162;
extern T7*ms204_6528;
extern T7*ms204_6048;
extern T7*ms47_36693;
extern T7*ms270_3438;
extern T7*ms126_1528;
extern T7*ms75_28313;
extern T7*ms11_10984;
extern T7*ms57_98523;
extern T7*ms136_1648;
extern T7*ms136_1568;
extern T7*ms67_82473;
extern T7*ms67_60543;
extern T7*ms22_72324;
extern T7*ms13_14504;
extern T7*ms22_68094;
extern T7*ms137_6888;
extern T7*ms263_7248;
extern T7*ms13_60064;
extern T7*ms13_28644;
extern T7*ms22_89544;
extern T7*ms13_47034;
extern T7*ms13_25714;
extern T7*ms13_10704;
extern T7*ms13_10544;
extern T7*ms31_25494;
extern T7*ms31_22824;
extern T7*ms273_6528;
extern T7*ms273_6188;
extern T7*ms14_12804;
extern T7*ms14_19124;
extern T7*ms14_11424;
extern T7*ms14_22524;
extern T7*ms14_19294;
extern T7*ms14_60104;
extern T7*ms14_11144;
extern T7*ms14_18964;
extern T7*ms14_21624;
extern T7*ms14_22824;
extern T7*ms14_12744;
extern T7*ms14_25584;
extern T7*ms60_23814;
extern T7*ms60_30744;
extern T7*ms204_0aaaaaaaaaaaaa;
extern T7*ms176_5838;
extern T7*ms43_10544;
extern T7*ms159_9338;
extern T7*ms204_5999;
extern T7*ms57_60064;
extern T7*ms57_34344;
extern T7*ms67_62784;
extern T7*ms67_68714;
extern T7*ms67_31374;
extern T7*ms67_70924;
extern T7*ms67_44694;
extern T7*ms67_63104;
extern T7*ms67_83144;
extern T7*ms67_79794;
extern T7*ms67_36624;
extern T7*ms67_48484;
extern T7*ms31_76935;
extern T7*ms273_6139;
extern T7*ms14_12595;
extern T7*ms14_13995;
extern T7*ms14_12915;
extern T7*ms14_14175;
extern T7*ms14_58075;
extern T7*ms60_53165;
extern T7*ms273_0aaaaaaaaaaaaa;
extern T7*ms40_95a;
extern T7*ms40_0aa;
extern T7*ms40_10a;
extern T7*ms41_5824aaaa;
extern T7*ms41_0aaaaaaa;
extern T7*ms41_59a;
extern T7*ms41_10a;
extern T7*ms41_0aa;
extern T7*ms67_41925;
extern T7*ms67_70945;
extern T7*ms67_60295;
extern T7*ms67_38675;
extern T7*ms67_71715;
extern T7*ms67_34845;
extern T7*ms67_74305;
extern T7*ms67_32955;
extern T7*ms67_12285;
extern T7*ms67_37125;
extern T7*ms67_65135;
extern T7*ms22_35616;
extern T7*ms22_43966;
extern T7*ms13_14056;
extern T7*ms40_16736;
extern T7*ms22_30576;
extern T7*ms13_32336;
extern T7*ms13_37216;
extern T7*ms13_10776;
extern T7*ms13_11256;
extern T7*ms40_15456;
extern T7*ms31_12816;
extern T7*ms14_11776;
extern T7*ms14_29246;
extern T7*ms14_22596;
extern T7*ms14_60016;
extern T7*ms14_17886;
extern T7*ms14_11496;
extern T7*ms14_11336;
extern T7*ms14_26156;
extern T7*ms14_11376;
extern T7*ms14_22716;
extern T7*ms14_27456;
extern T7*ms91_10a;
extern T7*ms94_58386;
extern T7*ms67_85576;
extern T7*ms67_43966;
extern T7*ms67_33946;
extern T7*ms67_63096;
extern T7*ms67_47096;
extern T7*ms67_25156;
extern T7*ms67_85386;
extern T7*ms67_82066;
extern T7*ms67_63616;
extern T7*ms67_63456;
extern T7*ms67_98236;
extern T7*ms67_33396;
extern T7*ms67_33286;
extern T7*ms67_84626;
extern T7*ms67_53476;
extern T7*ms41_0aaaaaaaaaaaaaaaaaaa;
extern T7*ms13_37417;
extern T7*ms22_82177;
extern T7*ms86_51136;
extern T7*ms14_14817;
extern T7*ms14_19437;
extern T7*ms14_13707;
extern T7*ms14_13977;
extern T7*ms75_66627;
extern T7*ms75_46407;
extern T7*ms11_36958;
extern T7*ms67_14067;
extern T7*ms67_88647;
extern T7*ms13_21528;
extern T7*ms13_33308;
extern T7*ms13_10608;
extern T7*ms13_10808;
extern T7*ms13_11328;
extern T7*ms22_36828;
extern T7*ms13_19808;
extern T7*ms14_17448;
extern T7*ms14_10528;
extern T7*ms14_22248;
extern T7*ms14_22788;
extern T7*ms14_26908;
extern T7*ms14_21648;
extern T7*ms14_34528;
extern T7*ms14_40358;
extern T7*ms14_12978;
extern T7*ms204_0aaaaaaaaaa;
extern T7*ms53_10848;
extern T7*ms53_11528;
extern T7*ms36_26208;
extern T7*ms11_37859;
extern T7*ms67_63328;
extern T7*ms67_71128;
extern T7*ms67_36168;
extern T7*ms67_94248;
extern T7*ms67_42978;
extern T7*ms67_77508;
extern T7*ms67_78588;
extern T7*ms67_22168;
extern T7*ms67_26638;
extern T7*ms67_90558;
extern T7*ms67_40338;
extern T7*ms67_57288;
extern T7*ms67_29148;
extern T7*ms22_66429;
extern T7*ms31_18029;
extern T7*ms14_12529;
extern T7*ms14_13419;
extern T7*ms14_23829;
extern T7*ms79_60608;
extern T7*ms221_94240;
extern T7*ms221_18080;
extern T7*ms311_16400;
extern T7*ms273_0aaaaaaaaaa;
extern T7*ms222_18400;
extern T7*ms106_16290;
extern T7*ms242_22600;
extern T7*ms134_24320;
extern T7*ms270_34500;
extern T7*ms270_38600;
extern T7*ms270_71400;
extern T7*ms117_41400;
extern T7*ms135_11560;
extern T7*ms47_28899;
extern T7*ms136_56430;
extern T7*ms137_16290;
extern T7*ms137_43200;
extern T7*ms67_53969;
extern T7*ms67_13509;
extern T7*ms237_45900;
extern T7*ms68_10489;
extern T7*ms238_76570;
extern T7*ms184_54060;
extern T7*ms258_29400;
extern T7*ms249_27080;
extern T7*ms259_38600;
extern T7*ms187_83790;
extern T7*ms179_12870;
extern T7*ms242_53041;
extern T7*ms117_88031;
extern T7*ms117_45961;
extern T7*ms137_89271;
extern T7*ms255_43011;
extern T7*ms238_30681;
extern T7*ms259_23751;
extern T7*ms311_23562;
extern T7*ms222_20672;
extern T7*ms269_55831;
extern T7*ms231_86032;
extern T7*ms223_14812;
extern T7*ms151_50092;
extern T7*ms233_78192;
extern T7*ms233_24012;
extern T7*ms260_29392;
extern T7*ms135_11432;
extern T7*ms137_99162;
extern T7*ms263_35952;
extern T7*ms129_50092;
extern T7*ms264_41652;
extern T7*ms256_35472;
extern T7*ms176_26532;
extern T7*ms159_11512;
extern T7*ms159_11632;
extern T7*ms187_98482;
extern T7*ms187_97692;
extern T7*ms359_86602;
extern T7*ms172_24263;
extern T7*ms41_0aaaaaaaaaaaaaa;
extern T7*ms237_36693;
extern T7*ms267_45873;
extern T7*ms221_11424;
extern T7*ms311_22284;
extern T7*ms222_29304;
extern T7*ms240_34344;
extern T7*ms12_581900;
extern T7*ms250_10544;
extern T7*ms242_63264;
extern T7*ms233_41834;
extern T7*ms342_54464;
extern T7*ms252_10544;
extern T7*ms190_98784;
extern T7*ms254_99414;
extern T7*ms137_40404;
extern T7*ms263_10544;
extern T7*ms75_139750;
extern T7*ms168_36624;
extern T7*ms169_85234;
extern T7*ms94_500000;
extern T7*ms67_120520;
extern T7*ms67_666080;
extern T7*ms67_112140;
extern T7*ms67_112230;
extern T7*ms67_141350;
extern T7*ms187_86564;
extern T7*ms67_196560;
extern T7*ms67_115740;
extern T7*ms67_191760;
extern T7*ms67_115650;
extern T7*ms231_20145;
extern T7*ms105_53215;
extern T7*ms78_116840;
extern T7*ms253_37975;
extern T7*ms41_0aaaaaaaaaaa;
extern T7*ms257_38125;
extern T7*ms249_38075;
extern T7*ms311_50576;
extern T7*ms311_61446;
extern T7*ms67_124691;
extern T7*ms187_33465;
extern T7*ms222_63376;
extern T7*ms240_33396;
extern T7*ms214_18176;
extern T7*ms22_171472;
extern T7*ms31_716872;
extern T7*ms242_45376;
extern T7*ms233_36096;
extern T7*ms233_14616;
extern T7*ms233_75456;
extern T7*ms117_20976;
extern T7*ms117_37536;
extern T7*ms60_802392;
extern T7*ms43_233442;
extern T7*ms137_36216;
extern T7*ms263_16976;
extern T7*ms245_86756;
extern T7*ms165_63456;
extern T7*ms238_63756;
extern T7*ms265_11056;
extern T7*ms176_36216;
extern T7*ms168_18096;
extern T7*ms159_11416;
extern T7*ms267_11056;
extern T7*ms268_18176;
extern T7*ms67_135632;
extern T7*ms67_349402;
extern T7*ms67_202032;
extern T7*ms67_128352;
extern T7*ms204_0aaaaaaaaaaaaaaaa;
extern T7*ms150_66627;
extern T7*ms242_66627;
extern T7*ms215_32637;
extern T7*ms12_570704;
extern T7*ms205_58608;
extern T7*ms22_121824;
extern T7*ms273_0aaaaaaaaaaaaaaaa;
extern T7*ms215_74948;
extern T7*ms117_41868;
extern T7*ms137_35088;
extern T7*ms81_101934;
extern T7*ms81_121394;
extern T7*ms238_11648;
extern T7*ms47_783104;
extern T7*ms268_50008;
extern T7*ms67_197274;
extern T7*ms269_17008;
extern T7*ms222_53969;
extern T7*ms22_228345;
extern T7*ms22_130095;
extern T7*ms262_49909;
extern T7*ms67_115695;
extern T7*ms67_114705;
extern T7*ms67_103845;
extern T7*ms67_116145;
extern T7*ms67_116865;
extern T7*ms22_196786;
extern T7*ms31_131716;
extern T7*ms31_848426;
extern T7*ms103_32a;
extern T7*ms204_10a;
extern T7*ms204_0aa;
extern T7*ms57_110836;
extern T7*ms67_145656;
extern T7*ms67_203856;
extern T7*ms97_107916;
extern T7*ms273_10a;
extern T7*ms273_0aa;
extern T7*ms159_34a;
extern T7*ms13_554698;
extern T7*ms31_225848;
extern T7*ms270_101250;
extern T7*ms56_162378;
extern T7*ms187_126960;
extern T7*ms40_981a;
extern T7*ms40_0aaa;
extern T7*ms22_160a;
extern T7*ms40_10aa;
extern T7*ms13_939a;
extern T7*ms41_288a;
extern T7*ms41_180a;
extern T7*ms41_616a;
extern T7*ms41_10aa;
extern T7*ms41_0aaa;
extern T7*ms91_10aa;
extern T7*ms67_280a;
extern T7*ms67_663a;
extern T7*ms67_657a;
extern T7*ms68_366a;
extern T7*ms117_382452;
extern T7*ms41_0aaaaaaaaaaaaaaaaa;
extern T7*ms166_358643;
extern T7*ms187_235773;
extern T7*ms187_141933;
extern T7*ms204_5803aaaa;
extern T7*ms204_0aaaaaaa;
extern T7*ms273_0aaaaaaa;
extern T7*ms67_1419840;
extern T7*ms276_126054;
extern T7*ms187_157734;
extern T7*ms179_120244;
extern T7*ms134_153435;
extern T7*ms187_115695;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void se_msi17(void);
void se_msi18(void);
void se_msi19(void);
void se_msi20(void);
void se_msi21(void);
void se_msi22(void);
void*se_ma98(int argc,...);
void*se_ma295(int argc,...);
void*se_ma304(int argc,...);
void*se_ma210(int argc,...);
void*se_ma309(int argc,...);
void*se_ma217(int argc,...);
void*se_ma224(int argc,...);
void*se_ma227(int argc,...);
void*se_ma35(int argc,...);
void*se_ma326(int argc,...);
void*se_ma45(int argc,...);
void*se_ma51(int argc,...);
void*se_ma248(int argc,...);
void*se_ma58(int argc,...);
void*se_ma160(int argc,...);
void*se_ma76(int argc,...);
void*se_ma174(int argc,...);
void*se_ma84(int argc,...);
void*se_ma180(int argc,...);
void*se_ma92(int argc,...);
void X203set_rescue_compound(void *C,T0* a1);
T2 X150arg_count(void *C);
T0* X150arguments(void *C);
T0* X150make_runnable(void *C,T0* a1,T0* a2,T0* a3);
T0* X313ensure_assertion(void *C);
T0* X313run_class(void *C);
void X313vape_check_from(void *C,T0* a1);
T0* X313local_vars(void *C);
T0* X313require_assertion(void *C);
T0* X313arguments(void *C);
T6 X313is_exported_in(void *C,T0* a1);
T0* X313clients(void *C);
T0* X313result_type(void *C);
T0* X313start_position(void *C);
T0* X226to_runnable_integer(void *C,T0* a1);
T0* X226to_runnable_character(void *C,T0* a1);
T0* X226twin(void *C);
T0* X189value(void *C,T2 a1);
T0* X189start_position(void *C);
void X294short(void *C);
void X294append_in(void *C,T0* a1);
T2 X294count(void *C);
T6 X312fast_has(void *C,T0* a1);
void X312swap(void *C,T2 a1,T2 a2);
void X312resize(void *C,T2 a1);
void X173short(void *C);
void X173set_rank(void *C,T2 a1);
T0* X173to_string(void *C);
T0* X173start_position(void *C);
void X298put(void *C,T0* a1,T2 a2);
T0* X288result_type(void *C);
T0* X288start_position(void *C);
T6 X47is_any(void *C);
T6 X47is_string(void *C);
T0* X47generic_list(void *C);
T2 X47id(void *C);
T0* X47smallest_ancestor(void *C,T0* a1);
T6 X47is_like_current(void *C);
T6 X47is_array(void *C);
T0* X47base_class(void *C);
T6 X47is_double(void *C);
T6 X47is_none(void *C);
T0* X47look_up_for(void *C,T0* a1,T0* a2);
T0* X47to_runnable(void *C,T0* a1);
T6 X47has_creation(void *C,T0* a1);
T6 X47is_pointer(void *C);
T0* X47static_base_class_name(void *C);
T6 X47is_a_in(void *C,T0* a1,T0* a2);
T0* X47run_time_mark(void *C);
T6 X47is_boolean(void *C);
void X47short(void *C);
T6 X47is_a(void *C,T0* a1);
T6 X47is_generic(void *C);
T0* X47run_class(void *C);
T6 X47is_like_feature(void *C);
T6 X47is_like_argument(void *C);
T0* X47run_type(void *C);
T6 X47is_expanded(void *C);
T0* X47expanded_initializer(void *C);
T6 X47is_basic_eiffel_expanded(void *C);
T6 X47is_formal_generic(void *C);
void X47used_as_reference(void *C);
T6 X47is_character(void *C);
T6 X47is_reference(void *C);
T0* X47written_mark(void *C);
T6 X47is_real(void *C);
T0* X47base_class_name(void *C);
void X47short_hook(void *C);
T6 X47is_anchored(void *C);
T6 X47is_run_type(void *C);
T6 X47is_bit(void *C);
T0* X47start_position(void *C);
T6 X47is_integer(void *C);
T0* X254base_class(void *C);
T0* X149add_comment(void *C,T0* a1);
T0* X149to_runnable(void *C,T0* a1);
T0* X149start_position(void *C);
void X231set_current_type(void *C,T0* a1);
T0* X231to_runnable(void *C,T0* a1);
T0* X271result_type(void *C);
T0* X271start_position(void *C);
void X78short(void *C);
void X78declaration_in(void *C,T0* a1);
void X78undefine_in(void *C,T0* a1);
T0* X78origin_base_class(void *C);
T0* X78to_key(void *C);
T6 X78is_frozen(void *C);
T0* X78to_string(void *C);
T0* X78start_position(void *C);
T0* X139twin(void *C);
void X336resize(void *C,T2 a1);
void X168add_last(void *C,T0* a1);
void X54short_target(void *C);
T2 X54precedence(void *C);
T6 X54is_current(void *C);
void X54short(void *C);
T0* X54static_result_base_class(void *C);
void X54bracketed_short(void *C);
T0* X54add_comment(void *C,T0* a1);
void X54assertion_check(void *C,T3 a1);
T0* X54to_runnable(void *C,T0* a1);
T2 X54to_integer(void *C);
T6 X54is_void(void *C);
T0* X54result_type(void *C);
T0* X54start_position(void *C);
T2 X266nb(void *C);
T0* X98twin(void *C);
void X86set_header_comment(void *C,T0* a1);
T0* X86ensure_assertion(void *C);
T6 X86is_deferred(void *C);
T6 X86is_merge_with(void *C,T0* a1,T0* a2);
T6 X86is_merge_with2aux(void *C,T0* a1,T0* a2);
T6 X86can_hide(void *C,T0* a1,T0* a2);
void X86add_into(void *C,T0* a1);
T0* X86try_to_undefine(void *C,T0* a1,T0* a2);
T0* X86require_assertion(void *C);
void X86check_obsolete(void *C,T0* a1);
T0* X86arguments(void *C);
T0* X86to_run_feature(void *C,T0* a1,T0* a2);
T0* X86obsolete_mark(void *C);
T0* X86result_type(void *C);
T0* X86start_position(void *C);

