#!/bin/csh -f
#
# To INSTALL SmallEiffel on UNIX like platforms (including LINUX).
#
# If you have the gcc compiler, simply run this script.
#
if (!($?SmallEiffel)) then
   echo Please set the environment Variable 'SmallEiffel' with
   echo the absolute path of file SmallEiffel/sys/system.se
   exit 1
endif
if (-d $SmallEiffel) then
   echo Since release -0.79 the value of the environment
   echo variable SmallEiffel should be the absolute path of
   echo file SmallEiffel/sys/system.se
   echo Trying to fix this automatically.
   set SmallEiffel=${SmallEiffel}/sys/system.se
endif
if (! -f ${SmallEiffel}) then
   echo File ${SmallEiffel} not found.
   echo Please check the value of the environment Variable
   echo 'SmallEiffel' wich must be the absolute path of 
   echo the file SmallEiffel/sys/system.se
   exit 1
endif
if (`basename $SmallEiffel` != "system.se") then
   echo Please check the value of the environment Variable
   echo 'SmallEiffel' wich must be the absolute path of 
   echo the file SmallEiffel/sys/system.se
   exit 1
endif
echo UNIX >! ${SmallEiffel}
set SE=`dirname $SmallEiffel`
set SE=`dirname $SE`
if (! -d ${SE}) then
   echo SmallEiffel home directory ${SE} not found.
   echo Please check the value of the environment Variable
   echo 'SmallEiffel' wich must be the absolute path of 
   echo the file SmallEiffel/sys/system.se
   exit 1
endif
cd ${SE}/bin_c
foreach fmake (*.make)
   set cmd=$fmake:r
   if (!(-f ${cmd})) then
      echo Running ${SE}/bin_c/${fmake} "..."
      source ${fmake}
   endif
   mv -f ../bin/${cmd} ../bin/${cmd}.old >& /dev/null
   mv -f ${cmd} ../bin/${cmd}
   /bin/rm -f ../bin/${cmd}.old
end
/bin/rm -f *.o >& /dev/null
echo Writing default ${SE}/sys/loadpath.UNIX
/bin/rm -f ${SE}/sys/loadpath.UNIX
echo    "./"              >  ${SE}/sys/loadpath.UNIX
echo    "${SE}/lib_std/"  >> ${SE}/sys/loadpath.UNIX
echo    "${SE}/lib_rand/" >> ${SE}/sys/loadpath.UNIX
echo    "${SE}/lib_show/" >> ${SE}/sys/loadpath.UNIX
echo -n "${SE}/lib_se/"   >> ${SE}/sys/loadpath.UNIX
#
echo Garbage Collector selection :
${SE}/misc/GC.SH
echo Done.
