/* Generic m68k cpu.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996, 1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: m68k.h,v 1.4 1999/01/05 11:55:46 tiggr Exp $  */

/* Which registers to inspect in the setjmp created buffer.  */
#define REG_PROT_START	JB_D0
#define REG_PROT_END	(JB_A5 + 1)

/* Macro local to this target file to emit a value of some type to the
   ARGS being built.  */
#define APPLY_ARGS_EMIT_VALUE(TYPE, VALUE)  \
 ({								\
    TYPE *addr = (void *) ((char *) args->stack + offset);	\
    *addr = (VALUE);						\
    offset += sizeof (TYPE);					\
    addr;})

/* The size of the registers in the ARGS to __builtin_apply.
   This is 0 for the NeXT, as all arguments are passed on the stack.  */
#define APPLY_ARGS_REG_SIZE  0

/* Start building the ARGS to __builtin_apply.
   This should be called init_cumulative_args :-) */
#define APPLY_ARGS_START(SEL)  \
  do			\
    {			\
      int offset = 0

/* Return an estimate, which is guaranteed to be large enough, for the
   size of the stack arguments to __builtin_apply_args.

   For the NeXT, worst case is the implicit first arguments SELF and CMD,
   followed by all double arguments, followed by the tuple return value
   pointers.  */
#define APPLY_ARGS_STACK_SIZE(SEL)  \
  (2 * sizeof (void *) + sizeof (tom_double) * (SEL)->in->num	\
   + sizeof (void *) * (SEL)->out->num)

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_int, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_long, VALUE)

/* Add a float value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_float, VALUE)

/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (tom_double, VALUE)

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_VALUE (void *, VALUE)

/* Return the actual size of the stack arguments to __builtin_apply_args.  */
#define APPLY_ARGS_ACTUAL_SIZE()  \
      offset

/* Undo anything started by APPLY_ARGS_START.  */
#define APPLY_ARGS_END()  \
    } while (0)
