/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>
   Gas syntax by Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>

   Copyright (C) 1996, 1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: trt_send.S,v 1.13 1999/07/22 10:11:57 tiggr Exp $  */

#include <tom/trt.h>

/* return_type
   trt_send (tom_State_c_ref self, selector *_cmd)
   {
     int sel_id = _cmd->sel_id;
     int bucket_idx = sel_id / TRT_BUCKET_SIZE;
     int imp_idx = sel_id % TRT_BUCKET_SIZE;

     jump (self->isa->mdt->b[bucket_idx].m[imp_idx]);
   }
 */

/* I'm not sure whether d1 needs to be saved on the stack before using it,
   but from GCC's config/m68k/m68k.h, it seems such a save is not
   necessary, probably because d0/d1 are used to return long long results.
   ++roman: %d1 is officially a scratch register and needs not be saved.
   */

#if !AS_SYNTAX_GAS
/* Non-GAS syntax, as used on, e.g., m68k-next.  */
.globl	_trt_send
_trt_send:

#if defined (PROFILE)
.data
LP0:
	.long	0
.text
	pea	a6@
	movel	sp, a6
	lea	LP0, a0
	jsr	mcount
	unlk	a6
#endif

	movel	sp@(8), a0		/* selector */
	movel	a0@, d1			/* sid = selector->sel_id */
	movel	sp@(4), a0		/* self */

#if defined (DEBUG) || defined (ALWAYS_CHECK_NIL_RECEIVER)
	cmpl	#0, a0
	jeq	_trt_send_nil
#endif

	movel	a0@, a0			/* self->isa */
	movel	a0@(8), a0		/* self->isa->mdt */
	movel	d1, d0	
	lsrl	#TRT_BUCKET_SHIFT, d0	/* bucket_idx = sid / TRT_BUCKET_SIZE */
	movel	a0@(8, d0:l:4), a0  /* bucket = self->isa->mdt->b[bucket_idx] */
	andl	#(TRT_BUCKET_SIZE - 1), d1 /* imp_idx = sid % TRT_BUCKET_SIZE */
	movel	a0@(d1:l:4), a0		/* imp = bucket->m[imp_idx] */
	jmp	a0@

#else
/* GAS syntax, as used on, e.g., m68k-linux.  */
.globl	trt_send
trt_send:

#if defined (PROFILE)
.data
LP0:
	.long	0
.text
	pea	%a6@
	movel	%sp, %a6
	lea	LP0, %a0
	jsr	mcount
	unlk	%a6
#endif

	movel	%sp@(8), %a0		/* selector */
	movel	%a0@, %d1		/* sid = selector->sel_id */
	movel	%sp@(4), %a0		/* self */

#if defined (DEBUG) || defined (ALWAYS_CHECK_NIL_RECEIVER)
	cmpl	#0, %a0
	jeq	trt_send_nil
#endif

	movel	%a0@, %a0		/* self->isa */
	movel	%a0@(8), %a0		/* self->isa->mdt */
	movel	%d1, %d0	
	lsrl	#TRT_BUCKET_SHIFT, %d0	/* bucket_idx = sid / TRT_BUCKET_SIZE */
	movel	%a0@(8, %d0:l:4), %a0  /* bucket = self->isa->mdt->b[bucket_idx] */
	andl	#(TRT_BUCKET_SIZE - 1), %d1 /* imp_idx = sid % TRT_BUCKET_SIZE */
	movel	%a0@(%d1:l:4), %a0		/* imp = bucket->m[imp_idx] */
	jmp	%a0@

#endif
