/* Simple Fraction class.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: Fraction.t,v 1.9 1998/01/05 00:55:18 tiggr Exp $  */

implementation class Fraction: State

instance (id)
with int value
{
  = [[self alloc] init (value, 1)];
}

instance (id)
with (int, int) (n, d)
{
  = [[self alloc] init (n, d)];
}

boolean
integerp (int, int) (n, d)
{
  = !(n % d);
}

(int, int)
mul (int, int) (n1, d1) with (int, int) (n2, d2)
{
  = (n1 * n2, d1 * d2);
}

(int, int)
div (int, int) (n1, d1) with (int, int) (n2, d2)
{
  = (n1 * d2, n2 * d1);
}

(int, int)
add (int, int) (n1, d1) with (int, int) (n2, d2)
{
  = (n1 * d2 + n2 * d1, d1 * d2);
}

(int, int)
sub (int, int) (n1, d1) with (int, int) (n2, d2)
{
  = (n1 * d2 - n2 * d1, d1 * d2);
}

end;

implementation instance Fraction
{
  <doc> The numerator and denominator.  </doc>
  public int numerator, denominator;

  <doc> We don't like typing long names for ivars (experiment #328).  </doc>
  const num = numerator;
  const den = denominator;
}

int
compare (int, int) (n, d)
{
  int mn = num * d;
  int zn = n * den;

  = mn == zn
    ? 0
    : mn > zn
      ? 1
      : -1;
}

int
compare id o
{
  = [self compare [o dissect]];
}

(int, int)
dissect
{
  = (num, den);
}

boolean
equals id o
{
  = ![self compare o];
}

boolean
equals (int, int) (n, d)
{
  = ![self compare (n, d)];
}

protected id
init (int, int) (n, d)
{
  (numerator, denominator) = (n, d);

  = self;
}

boolean
integerp
{
  = [isa integerp (num, den)];
}

id
mul id o
{
  = [isa with [isa mul (num, den) with [o dissect]]];
}

id
div id o
{
  = [isa with [isa div (num, den) with [o dissect]]];
}

id
add id o
{
  = [isa with [isa add (num, den) with [o dissect]]];
}

id
sub id o
{
  = [isa with [isa sub (num, den) with [o dissect]]];
}

redefine OutputStream
write OutputStream s
{
  = [[[s print num] print "/"] print den];
}

end;
