/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTEntity.m,v 1.7 1998/01/05 00:57:57 tiggr Exp $  */

#import "ltt.h"

@implementation LTTEntity

-(void) gcReference
{
  MARK (name);
  MARK (semantics);

  [super gcReference];
} /* -gcReference */

-(id) initWithName: (LTTName *) n
{
  if (![super init])
    return nil;

  name = n;

  return self;
} /* -initWithName: */

-(LTTName *) lttName
{
  return name;
}

-(id <TLString>) outputName
{
  return [name external];
}

-(id) semantics
{
  return semantics;
} /* -semantics */

-(void) setSemantics: (id) s
{
  if (semantics)
    error (@"%#: changing semantics from %# to %#", self, semantics, s);

  ASGN_IVAR (semantics, s);
} /* -setSemantics: */

@end
