/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTUnit.h,v 1.18 1998/01/20 00:02:22 tiggr Exp $  */

#import "LTTEntity.h"
#import "unit.h"

/* All units currently known.  */
extern TLDictionary *ltt_units;

@class LTTExtension, LTTFile, LTTMeta, LTTInstance;

@interface LTTUnit: LTTEntity <LTTUnitAcceptor>
{
  /* The directory containing this unit, or NIL if in current directory.  */
  TLString *dir;

  /* Files contained in this unit.  */
  TLDictionary *files;

  /* Instances contained in this unit.  */
  TLDictionary *instances;

  /* Extensions in this unit of metas defined in other units.  */
  TLVector *extensions;

  /* Units being depended upon by this unit.  */
  TLVector *units_used;

  /* Iff !0, a list of posing indications still needing to be resolved.
     Each entry is an extension followed by a list of superclass names
     being posed.  */
  TLCons *posing;

  /* A list of posing relationships introduced by (main) extensions in
     this unit.  Each value is a (poser . posed) pair.  */
  TLCons *posers;

  /* Super references.  Keyed on LTTMeta, the value if a TLSet of supers
     being referenced.  */
  TLDictionary *super_refs;

  /* Mark when searching the unit hierarchy.  */
  int mark;
}

/* Return the unit with the name N.  */
+(LTTUnit *) unitNamed: (id <TLString>) n;

/* Return the unit with the name N.  It is searched, if necessary.  */
+(LTTUnit *) findUnitNamed: (id <TLString>) n;

+(LTTUnit *) searchUnit: (id <TLString>) n alongPath: (TLVector *) path;

+(LTTUnit *) unitWithName: (id <TLString>) n directory: (id <TLString>) d;

/* Return all instances's with the indicated name, in any unit.  */
+(TLVector *) instancesNamed: (id <TLString>) n;

-(id) initWithName: (TLString *) n directory: (TLString *) d;

-(void) addExtension: (LTTExtension *) e;

-(void) addInstance: (LTTInstance *) m;

-(void) addSuperReferenceFrom: (LTTMeta *) from to: (LTTMeta *) to;

-(TLString *) directory;

-(id <TLEnumerator>) extensions;

-(LTTFile *) fileNamed: (id <TLString>) s;

/* Return an enumerator on the files in this unit.  */
-(id <TLEnumerator>) files;

-(id <TLEnumerator>) instances;

-(LTTInstance *) instanceNamed: (id <TLString>) s;

/* Find the instance with the unqualified name S, in the receiving unit
   and the units on which it depends.  */
-(LTTInstance *) findInstanceNamed: (id <TLString>) s;

/* Create a new instance and class pair, added to this unit, named S.
   Return the instance.  */
-(LTTInstance *) metaWithName: (TLString *) s;

-(id <TLString>) outputDefinitionName;

/* Resolve any posing qualifications for this unit.  */
-(void) resolvePosing;

-(TLCons *) posers;

/* Return the SUPER_REFS.  */
-(TLDictionary *) superReferences;

-(TLVector *) unitsUsed;

/* Append the receiving unit and all units it depends on in a topological
   sorted order to the list L, and return that.  */
-(TLCons *) orderedUnits: (TLCons *) l;

-(BOOL) dependsOn: (LTTUnit *) u;

@end
