/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: ltt.h,v 1.34 1998/02/23 14:18:06 tiggr Exp $  */

#import <config/config.h>
#import <tl/tl.h>
#import <config/target.h>
#import "LTTClass.h"
#import "LTTEntity.h"
#import "LTTExtension.h"
#import "LTTFile.h"
#import "LTTFileItem.h"
#import "LTTInstance.h"
#import "LTTMeta.h"
#import "LTTName.h"
#import "LTTUnit.h"
#import "LTTSelArgTypes.h"
#import "LTTSelector.h"
#import "LTTStringCST.h"
#import "LTTTop.h"
#import "LTTVariable.h"
#import "report.h"
#import "unit.h"

extern id CO_LTTClass, CO_LTTEntity, CO_LTTExtension, CO_LTTFile;
extern id CO_LTTFileItem, CO_LTTInstance, CO_LTTMeta, CO_LTTName;
extern id CO_LTTSelector, CO_LTTSelArgTypes, CO_LTTStringCST;
extern id CO_LTTTop, CO_LTTUnit, CO_LTTVariable;
extern id CO_TLVector, CO_TLString, CO_TLNumber;

/* The name under which this program was invoked.  */
extern id <TLString> prog;

/* The version information of ltt, as defined in `version.m'.  */
extern char *ltt_long_version, *ltt_short_version;

/* The path to search for files.  */
extern TLVector *load_path;

/* Global variables pointing to important things.  */
extern LTTInstance *ltt_instance_any, *ltt_instance_all, *ltt_instance_state;
extern LTTClass *ltt_class_any, *ltt_class_all, *ltt_class_state;
extern LTTExtension *ltt_ext_c_state, *ltt_ext_i_state;
extern LTTUnit *ltt_unit_tom;

/* The units for the builtin information and that of missing information
   (due to errors of the user).  And the file `containing' the builtin
   information.  */
extern LTTUnit *ltt_builtin_unit, *ltt_missing_unit;
extern LTTFile *ltt_builtin_file, *ltt_missing_file;

/* Value used to mark objects during a search.  This value should be
   modified for each search performed.  */
extern int search_mark;

/* The current unit.  Used in selector name mangling.  */
extern LTTUnit *ltt_current_unit;

/* Initialize ltt, and anything below it (like libtl).  */
void ltt_init (int argc, char **argv);

/* Finish initialization of init.  This reads the tom unit, sets global
   variables, etc.  */
void ltt_finish_init (void);

/* Get the argument to the option (with length OFFSET) in ARGV[*I].  Barf
   and return NULL on error.  An argument to an option, when specified
   seperately, can not start with a `-'.  */
char *get_arg (int *i, int offset, char **argv, int argc);

/* Empty the load path.  */
void reset_load_path (void);

/* Add the elements from the VECTOR to the LOAD_PATH.  */
void add_to_load_path (TLVector *vector);

/* Locate the file named NAME along the PATH and return the full name.  If
   not found, return NIL.

   For every DIR along the PATH, the FILE is looked for in DIR/FILE,
   DIR/NAME/FILE, DIR/NAME/GEN/FILE, DIR/GEN/FILE.  */
id <TLString> locate_file_along_path (id <TLString> name, TLVector *path,
				      id <TLString> name_subdir,
				      id <TLString> gen_subdir);

/* Return the filename without extension.  */
TLString * ltt_filename_without_extension (TLString *filename);

/* Find the name of the single unit file in the directory DIR.  */
TLString *basename_of_unit_file (id <TLString> dir);

/* Quote the string S suitable for use as an identifier in the output
   language.  */
id <TLString> quote (id <TLString> s);

/* Given the INSTANCES which all have the same meta name (for instance
   because they were returned by `+[LTTUnit metasNamed]'), return the
   instance from the unit named UNIT_NAME.  If !UNIT_NAME the instance
   must either be unique in INSTANCES, or the CURRENT unit must define the
   instance.  */
LTTInstance *ltt_instance_in_unit (id <TLString> unit_name, LTTUnit *current,
				   TLVector *instances);

/* Return the meta name META_NAME in the unit named UNIT_NAME.  Moan if
   either can not be found.  If CLASSP, return the class, otherwise the
   instance.  */
LTTMeta *ltt_get_meta (TLString *unit_name, TLString *meta_name, BOOL classp);

/* Return the full qualified name of the meta M.  */
id <TLString> ltt_meta_name (LTTMeta *m);

/* Return the full qualified name of the extension E.  */
id <TLString> ltt_ext_name (LTTExtension *e);

id open_output_file (id <TLString> s);

id <TLString> ltt_lex_string_cst (const char *yytext, int yyleng, char quote,
				  int *num_new_lines);

id semantics_for_extension (LTTExtension *e);
