<copyright> This is a TOM test.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: test11.t,v 1.5 1998/01/05 01:00:26 tiggr Exp $</id>
    </copyright>

implementation class
Test: Runtime, stdio
{
  static IntArray constants;
}

<doc> Add {n} elements and extract them using {extract_root}.  </doc>
void
  doit1 (int, boolean) (n, max_p)
{
  Heap h = [[Heap alloc] init max_p];
  int i;

  [[out print h] nl];

  for (i = 0; i < n; i++)
    {
      double x = constants[i];
      Timer t = [[Timer alloc] initWithFireTime x invocation nil];

      [h add t];

      [[out print h] nl];
    }

  for (i = 0; i < n; i++)
    [[out print ([h extract_root], ": ", h)] nl];
}

<doc> Add {n} elements and extract them in the same order.  </doc>
void
  doit2 (int, boolean) (n, max_p)
{
  Heap h = [[Heap alloc] init max_p];
  MutableObjectArray a = [MutableObjectArray withCapacity n];
  int i;

  for (i = 0; i < n; i++)
    {
      double x = constants[i];
      Timer t = [[Timer alloc] initWithFireTime x invocation nil];

      [a add t];
      [h add t];
    }

  for (i = 0; i < n; i++)
    {
      Timer elt = a[i];
      [h remove elt];

      [[out print (elt, ": ", h)] nl];
    }
}

int
  main Indexed arguments
{
  /* Numbers are from (max-heap) exercise 7.5-1 of `Introduction to
     algorithms' by Cormen, Leiserson, and Rivest.  */
  constants = [IntArray with (15, 13, 9, 5, 12, 8, 7, 4, 0, 6, 2, 1)];
  int i, n = [constants length];

  for (i = 1; i <= n; i++)
    {
      [[out print ("min-heap-1 ", i)] nl];
      [self doit1 (i, FALSE)];
      [[out print ("min-heap-2 ", i)] nl];
      [self doit2 (i, FALSE)];
      [[out print ("max-heap-1 ", i)] nl];
      [self doit1 (i, TRUE)];
      [[out print ("max-heap-2 ", i)] nl];
      [self doit2 (i, TRUE)];
    }
}

end;

implementation instance
Test

end;


/* Get some decent printing out of {Timer}.  */
implementation class
Timer extension Test

end;

implementation instance
Timer extension Test

OutputStream (s)
  write OutputStream s
{
  s = [s print fire_time];
}

end;
