/* Implementation of TLLDelegate class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLDelegate.m,v 1.2 1998/02/23 14:17:29 tiggr Exp $  */

#import "tl/support.h"
#import "tl/TLLDelegate.h"
#import "tl/TLCons.h"

/* Quick access to forwarding selectors, indexed on #arguments.  Can't be
   statically initialized with NeXT runtime.  */
static SEL forwarding_selectors[3];

static int num_forwarding_selectors = (sizeof (forwarding_selectors)
				       / sizeof (*forwarding_selectors));

@implementation TLLDelegate

/******************** private methods ********************/

+initialize
{
  forwarding_selectors[0] = @selector (delegateForward);
  forwarding_selectors[1] = @selector (delegateForward:);
  forwarding_selectors[2] = @selector (delegateForward::);
  return (self);
} /* +initialize */

-(void *) delegateForward
{
  return (EVAL (CONS (imp, nil)));
} /* -delegateForward */

-(void *) delegateForward: (id) arg1
{
  return (EVAL (CONS (imp, CONS (arg1, nil))));
} /* -delegateForward: */

-(void *) delegateForward: (id) arg1 : (id) arg2
{
  return (EVAL (CONS (imp, CONS (arg1, CONS (arg2, nil)))));
} /* -delegateForward:: */

/******************** public methods ********************/

+(TLLDelegate *) delegate
{
  return ([[self gcAlloc] init]);
} /* +delegate */

+(TLLDelegate *) delegateForObject: o
{
  id r = [self delegate];
  [o setDelegate: r];
  return (r);
} /* +delegate */

-addMethod: (TLSymbol *) name implementation: im
{
  [methods setObject: im forKey: name];
  return (name);
} /* -addMethod: */

-(retval_t) forward: (SEL) sel : (FORWARD_ARGUMENTS) arg_frame
{
  TLSymbol *s = symbol (sel_get_name (sel));
  int n;

  ASGN_IVAR (imp, [methods objectForKey: s]);

  if (!imp)
    [self error: "No implementation of selector `%#'", s];

  /* XXX Fix this!  */
  if (!sel_objects_only (NULL, sel))
    [self error: "No type information for selector `%#'", s];

  n = sel_num_args (NULL, sel);
  if (n >= num_forwarding_selectors)
    [self error: "Too many arguments for delegate (fix me): %d", n];

  /* XXX It is a pitty we can't pass the found method implementation along
     with the arguments.  Putting it in an instance variable would make it
     utterly thread-unsafe, even though that will never be a problem since I
     don't expect we'll ever run multi-threaded (apart from the gc maybe).  */
  return ([self performv: forwarding_selectors[n] : arg_frame]);
} /* -forward:: */

-init
{
  ASGN_IVAR (methods, [TLDictionary dictionary]);
  return (self);
} /* -init */

-methods
{
  return (methods);
} /* -methods */

-(BOOL) respondsTo: (SEL) sel
{
  return ([super respondsTo: sel]
	  || [methods objectForKey: symbol (sel_get_name (sel))]);
} /* -respondsTo: */

/******************** garbage collection ********************/

-(void) gcReference
{
  MARK (methods);
} /* -gcReference */

@end
