/* Implementation of TLRange class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLRange.m,v 1.1 1998/01/08 16:11:51 tiggr Exp $  */

#import "tl/support.h"
#import "tl/TLRange.h"
#import "tl/TLStream.h"

id <TLRange> tll_full_range;

@implementation TLRange

/******************** private methods ********************/

-initWithStart: (int) s length: (int) l
{
  start = s;
  length = l;
  return (self);
} /* -initWithStart:length: */

/******************** public methods ********************/

+(id <TLRange>) rangeWithStart: (int) s end: (int) e
{
  return ([[self gcAlloc] initWithStart: s length: e - s]);
} /* +rangeWithStart:end: */

+(id <TLRange>) rangeWithStart: (int) s length: (int) l
{
  return ([[self gcAlloc] initWithStart: s length: l]);
} /* +rangeWithStart:length: */

-(void) print: (id <TLMutableStream>) stream quoted: (BOOL) qp
{
  formac (stream, @"(%d, %d)", start, length);
} /* -print:quoted: */

/******************** TLRange ********************/

-(int) _start
{
  return (start);
} /* -_start */

-(int) _end
{
  return (length == -1 ? length : start + length);
} /* -_end */

-start
{
  if (start >= TL_SMALL_INT_MIN && start <= TL_SMALL_INT_MAX)
    return (tll_small_int[start]);
  return ([CO_TLNumber numberWithInt: start]);
} /* -start */

-(int) length
{
  return (length);
} /* -length */

-objectLength
{
  if (length >= TL_SMALL_INT_MIN && length <= TL_SMALL_INT_MAX)
    return (tll_small_int[length]);
  return ([CO_TLNumber numberWithInt: length]);
} /* -objectLength */

-end
{
  return ([CO_TLNumber numberWithInt: (length == -1 ? length : start + length)]);
} /* -end */

/******************** TLMutableRange ********************/

-(void) _setStart: (int) s
{
  start = s;
} /* -_setStart: */

-(void) _setLength: (int) l
{
  length = l;
} /* -_setLength: */

-(void) _setEnd: (int) e
{
  length = e == -1 ? e : e - start;
} /* -_setEnd: */

-setStart: (id <TLNumber>) s
{
  start = [s intValue];
  return (self);
} /* -setStart: */

-setLength: (id <TLNumber>) l
{
  length = [l intValue];
  return (self);
} /* -setLength: */

-setEnd: (id <TLNumber>) e
{
  int ev = [e intValue];

  length = ev == -1 ? ev : ev - start;
  return (self);
} /* -setEnd: */

@end
