/* Interface to TLLInvocation: TLL Objective-C messaging.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLInvocation.h,v 1.1 1998/01/08 16:13:22 tiggr Exp $  */

#import "TLSymbol.h"

@interface TLLInvocation: TLObject
{
  /* The selector to be invoked.  */
  TLSymbol *selector;

  /* The receiver expression.  */
  id receiver;

  /* The number of argument expressions.  */
  int num_args;

  /* The argument expressions.  */
  id *args;
}

/* Return an invocation from the list `(receiver sel:: arg arg)'.  */
+(TLLInvocation *) invocationWithCompressedList: (TLCons *) list
 length: (int) len;

/* Return an invocation from the list `(receiver sel: arg : arg)'.  */
+(TLLInvocation *) invocationWithList: (TLCons *) list length: (int) len;

-(id) initWithCompressedList: (TLCons *) list length: (int) len;
-(id) initWithList: (TLCons *) list length: (int) len;

-eval;

@end
