/* Interface to TLRange class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLRange.h,v 1.1 1998/01/08 16:13:31 tiggr Exp $  */

#import "TLObject.h"
#import "TLNumber.h"

@protocol TLRange

/* Return the start of this range, first is 0.  */
-(int) _start;

/* Return the length of this range, unlimited is -1.  */
-(int) length;

/* Return the end of this range, or -1 if it is unlimited.  */
-(int) _end;

/* Same as the above, but returning TLNumbers.  */
-start;
-objectLength;
-end;

@end

@protocol TLMutableRange <TLRange>

-(void) _setStart: (int) s;
-(void) _setLength: (int) l;
-(void) _setEnd: (int) e;

/* Same as the above, but using TLIntegers, or something similar.  */
-setStart: (id <TLNumber>) s;
-setLength: (id <TLNumber>) l;
-setEnd: (id <TLNumber>) e;

@end

/* The range from 0 to infinity.  */
extern id <TLRange> tll_full_range;

@interface TLRange: TLObject <TLMutableRange>
{
  int start, length;
}

+(TLRange *) rangeWithStart: (int) s length: (int) l;
+(TLRange *) rangeWithStart: (int) s end: (int) e;

@end
