/* Interface to TLVector class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLVector.h,v 1.1 1998/01/08 16:13:47 tiggr Exp $  */

#import <stdarg.h>
#import "TLObject.h"
#import "TLNumber.h"
#import "TLEnumerator.h"
#import "TLRange.h"

@protocol TLVector

-elementAtIndex: i;
-_elementAtIndex: (int) i;

-(int) length;
-objectLength;

/* Return an enumerator that goes from 0 up.  */
-(id <TLEnumerator>) enumerator;

/* Return an enumerator that starts at the end, going down.  */
-(id <TLEnumerator>) reverseEnumerator;

/******************** finding elements ********************/

/* Return the index of the first occurance of O, or -1 if it is not
   contained in the vector.  Comparison is done with `equal:'.  */
-(int) _indexOfElement: (id) o;

/* Likewise, by restrict the search to the RANGE.  */
-(int) _indexOfElement: (id) o range: (id <TLRange>) range;

/* Likewise, but return a TLNumber.  */
-(TLNumber *) indexOfElement: (id) o;
-(TLNumber *) indexOfElement: (id) o range: (id <TLRange>) range;

/* Likewise, but compare using `eq'.  */
-(int) _indexOfElementIdenticalTo: (id) o;
-(int) _indexOfElementIdenticalTo: (id) o range: (id <TLRange>) range;
-(TLNumber *) indexOfElementIdenticalTo: (id) o;
-(TLNumber *) indexOfElementIdenticalTo: (id) o
 range: (id <TLRange>) range;

@end

@protocol TLMutableVector <TLVector>

-addElement: e;

/* Add the elements from the enumerator E and return the number of
   elements added.  */
-(int) addElementsFromEnumerator: (id <TLEnumerator>) e;
-(int) addElementsFromSequence: (id) seq;

-(void) _insertElement: o atIndex: (int) i;

/* Replace the element at index I by the object O.  Return the previous
   object at that index.  */
-(id) _replaceElementAtIndex: (int) i by: (id) o;
-(id) replaceElementAtIndex: (id <TLNumber>) i by: (id) o;

-(void) removeElementIdenticalTo: e;

-(void) _removeElementAtIndex: (int) i;
-(id) removeElementAtIndex: (id <TLNumber>) i;
-(void) removeElementsFromIndex: (int) i range: (int) n;

@end

@interface TLVector: TLObject <TLMutableVector>
{
  int num, cap;
  id *contents;
}

/******************** creation ********************/

+(TLVector *) vector;
+(TLVector *) vectorWithCapacity: (int) c;

/* Return a vector containing N copies of the object O.  */
+(TLVector *) vectorWith: (int) n copies: (id) o;

/* XXX Why can't this be `+vectorWith: n elements: ...;'?  */
+(TLVector *) vectorWithElements: (int) n, ...;

+(TLVector *) vectorWithElements: (int) n : (va_list) ap;

/* Return a new vector with the element from the enumerator.  */
+(TLVector *) vectorWithEnumerator: (id <TLEnumerator>) en;

/* Return a new vector with the elements from the sequence SEQ.  */
+(TLVector *) vectorWithSequence: seq;

/* Create a new vector by storing the return values of the perform of SEL
   on each of the elements of SEQ .  */
+(TLVector *) vectorByPerforming: (SEL) sel
	    onElementsOfSequence: seq;

/* Designated initializer.  */
-initWithCapacity: (int) c;

-memq: (id) o;

-vinitWith: (int) n elements: (va_list) ap;

#ifdef TLVECTOR_DECLARE_PRIVATE_METHODS

-(id) initWith: (int) n copies: (id) o;

#endif

@end
