<copyright> Array class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Array.t,v 1.52 1998/01/05 01:04:50 tiggr Exp $</id>  </copyright>

<doc> {Array} is the superclass of all arrays; it is an {Indexed}
    {Collection} </doc>

implementation class
Array: State, Indexed, C

end;

implementation instance
Array
{
  <doc> The number of elements in the array.  </doc>
  public int length;

  <doc> A pointer to the elements of this array.  </doc>
  pointer contents;
}

<doc> Clean up the memory this array is using.  </doc>
extern void
  dealloc;

<doc> Return the size, in bytes, of the elements contained in this
    {Array}.  </doc>
deferred int
  elementByteSize;

<doc> Get the elements from the {other}, and invoke {[self initCopy]}.  </doc>
id
  initAsCopyOf id other
{
  (contents, length) = [other pointerToElements (0, -1)];

  = [self initCopy];
}

<doc> Duplicate our {contents} since that is what we own.  </doc>
id (self)
  initCopy
{
  int num_bytes = length * [self elementByteSize];

  contents = memcpy (malloc (num_bytes), contents, num_bytes);
}

<doc> Initialize with the indicated pointer and integer for contents and
    length.  </doc>
id (self)
  initWith int n
	at pointer addr
{
  (length, contents) = (n, addr);
}

<doc> Return the element contained in this {Array}, which is {equal} to
    the {object}.  </doc>
Any
  member All object
{
  int i;

  for (i = 0; i < length; i++)
    {
      All o = self[i];

      if ([o equal object])
	return Any (o);
    }
}

<doc> Like {member}, but the element is identified on reference equality.
    </doc>
Any
  memq All object
{
  int i;

  for (i = 0; i < length; i++)
    {
      All o = self[i];

      if (o == object)
	return Any (o);
    }
}

<doc> Return the {address} of the first element of the receiving array in
    the range {(start, len)}, and the {number} of elements in that range.
    </doc>
deferred (pointer, int) (address, number)
  pointerToElements (int, int) (start, len)
pre
  start >= 0 && len >= -1
post
  number >= 0 && !number == !address;

<doc> Like {makeElementsPerform}, but allow the element currently messaged
    to vanish from this array.  </doc>
void
  makeVanishingElementsPerform Invocation inv
{
  int i;

  while (i < length)
    {
      int l = length;

      [inv fireAt self[i]];
      if (l == length)
	i++;
    }
}

end;
