<copyright> ByteArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: ByteArray.t,v 1.21 1998/01/05 01:05:09 tiggr Exp $</id>
    </copyright>

<doc> Like the {CharArray}, the {ByteArray} is a particular kind of
    {Array}, which is here for abstraction purposes, but which is never
    actually used, since the {ByteString} holds the same kind of state,
    but provides much more functionality.  </doc>
implementation class
ByteArray: Array

end;

implementation instance
ByteArray

protected extern id
  initWithEnumerator Enumerator e;

Any
  at int index
{
  byte b = self[index];

  = Any ([ByteNumber with b]);
}

extern byte
  at int index;

extern char
  at int index;

int
  at int index
{
  byte c = self[index];

  = c;
}

long
  at int index
{
  byte c = self[index];

  = c;
}

float
  at int index
{
  byte c = self[index];

  = float (c);
}

double
  at int index
{
  byte c = self[index];

  = double (c);
}

extern int
  elementByteSize;

extern int
  hash;

extern (pointer, int)
  pointerToElements (int, int) (start, len);

int
  writeRange (int, int) (start, len)
        into MutableByteArray destination
	  at int position
{
  = [destination readRange (start, len) fromByteArray self to position];
}

/******************** coding methods ********************/

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [ByteArray self]])
    {
      [super encodeUsingCoder coder];
      [coder encodeBytes (0, -1) from self];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [ByteArray self]])
    {
      [super initWithCoder coder];
      (contents, length) = [coder decodeBytes];
    }
}

/******************** copying ********************/
<doc> <h4>Copying</h4> </doc>

<doc> Return the {MutableByteArray} class.  </doc>
class (State)
  mutableCopyClass
{
  = [MutableByteArray self];
}

end;
