<copyright> ByteSubstring class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: ByteSubstring.t,v 1.11 1998/03/30 11:29:22 tiggr Exp $</id>
    </copyright>

// I'm not sure if this could be a generic {Substring}, also usable for
// constant {CharString} objects...
// Wed Sep 18 14:54:55 1996, tiggr@cobra.es.ele.tue.nl

<doc> A {ByteSubstring} is a substring of a constant {ByteString}.  It
    tries to maskerade as one (even though it is certainly not an
    {Array}), possibly not perfect (yet).  </doc>
implementation class
ByteSubstring: String, C

instance (id)
  with (int, int) (start, len)
    in ByteString string
{
  = [[self alloc] init (start, len) in string];
}

end;

implementation instance
ByteSubstring
{
  <doc> The string we're begin part of.  </doc>
  ByteString string;

  <doc> The start of us in our {string}.  </doc>
  int start;

  <doc> The length of us, which is never {< 0}.  </doc>
  public int length;
}

<doc> Designated initializer.  </doc>
id
  init (int, int) (s, l)
    in ByteString str
{
  (string, start, length) = (str, s, l);

  = self;
}

/******************** copying ********************/

<doc> Return the {MutableByteString} class.  </doc>
class (State)
  mutableCopyClass
{
  = [MutableByteString self];
}

/******************** Indexed ********************/

<doc> Retrieve the {byte} at the {index}.  </doc>
byte
  at int index
{
  = string[start + index];
}

<doc> Return the {ByteNumber} at the {index}.  </doc>
ByteNumber
  at int index
{
  byte b = self[index];
  = [ByteNumber with b];
}

<doc> Return a restricted enumerator on the underlying string.  </doc>
Enumerator
  enumerator
{
  = [[IndexedEnumerator alloc] init self start: start length length];
}

id
  initWithEnumerator Enumerator e
{
  [self shouldNotImplement cmd];
}

/******************** Array ********************/

<doc> Another low level access method.  </doc>
(pointer, int)
  pointerToElements (int, int) (begin, len)
{
  (begin, len) = [self adjustRange (begin, len)];

  = [string pointerToElements (start + begin, len)];
}

/******************** String ********************/

<doc> Return a new substring on our {string}---we do not cascade
    substrings.  </doc>
ByteSubstring
  substring (int, int) (begin, len)
{
  (begin, len) = [self adjustRange (begin, len)];

  = [isa with (start + begin, len) in string];
}

MutableByteString
  mutableSubstring (int, int) (begin, len)
{
  pointer p;

  (p, len) = [self pointerToElements (begin, len)];

  = [[class (MutableByteString) ([self mutableCopyClass]) alloc]
     initCopy (p, len)];
}

/******************** ByteString ********************/

<doc> Low level access method.  </doc>
(pointer, int)
  byteStringContents
{
  = [string pointerToElements (start, length)];
}

boolean
  equal String other
{
  = [other equalByteString Any (self)];
}

int
  hash
{
  = [string hashRange (start, length)];
}

int
  hashRange (int, int) (begin, len)
{
  (begin, len) = [self adjustRange (begin, len)];

  = [string hashRange (start + begin, len)];
}

boolean
  equalByteString ByteString other
{
  pointer p1, p2;
  int l;

  (p1, l) = [other byteStringContents];
  (p2,) = [string pointerToElements (start, length)];

  = l == length ? !memcmp (p1, p2, l) : FALSE;
}

boolean
  equalCharString CharString other
{
  [self unimplemented cmd];
}

boolean
  equalUniqueString UniqueString other
{
  = [other equalByteString Any (self)];
}

UniqueByteString
  uniqueString
{
  = [[UniqueByteString alloc]
     initCopy [string pointerToElements (start, length)]];
}

OutputStream
  write OutputStream s
{
  [s writeRange (start, length) from string];

  = s;
}

end;
