<copyright> CharString class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: CharString.t,v 1.14 1998/01/05 01:05:33 tiggr Exp $</id>
    </copyright>

implementation class
CharString: CharArray

end;

implementation instance
CharString

boolean
  equal String other
{
  = [other equalCharString self];
}

boolean
  equalByteString ByteString other
{
  = [other equalCharString self];
}

extern boolean
  equalCharString id other;

boolean
  equalUniqueString UniqueString other
{
  = [other equalCharString self];
}

<doc> Initialize the newly allocated instance with the {num} characters at
    {p}.  The receiving instance will `own' the memory at {p}.  </doc>
protected id
  init (pointer, int) (p, num)
{
  (contents, length) = (p, num);

  = self;
}

<doc> Initialize the newly allocated instance with a copy of the {num}
    chars at {p}.  </doc>
id (self)
  initCopy (pointer, int) (p, num)
{
  (length, contents) = (num, memcpy (malloc (2 * num), p, 2 * num));
}

extern MutableCharString
  mutableSubstring (int, int) (start, len);

extern CharString
  substring (int, int) (start, len);

UniqueCharString
  uniqueString
{
  = [[UniqueCharString alloc] initCopy (contents, length)];
}

class (State)
  classForCoder Encoder coder
{
  = [MutableCharString self];
}

/******************** copying ********************/
<doc> <h4>Copying</h4> </doc>

<doc> Return the {MutableCharString} class.  </doc>
class (State)
  mutableCopyClass
{
  = [MutableCharString self];
}

end;
