<copyright> PointerDictionary and MutablePointerDictionary classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: PointerDictionary.t,v 1.11 1998/01/20 17:08:12 tiggr Exp $</id>
    </copyright>

/******************** PointerDictionary ********************/

<doc> A {PointerDictionary} maps a {pointer} to an object reference.  </doc>
implementation class
PointerDictionary: EqHashTable, DictionaryContainer

end;

implementation instance
PointerDictionary

Any
  at pointer key
{
  int code;
  <c> code = HASH_POINTER (key); </c>
  int bucket = code * GOLDEN_BITS >>> (32 - size_shift);
  BucketPointerDictElement elt = buckets[bucket];

  = !elt ? nil : [elt member key];
}

end;

/******************** MutablePointerDictionary ********************/

implementation class
MutablePointerDictionary: PointerDictionary, MutableEqHashTable

end;

implementation instance
MutablePointerDictionary

<doc> Remove the mapping for the {key}.  </doc>
void
  remove pointer key
{
  int code;
  <c> code = HASH_POINTER (key); </c>
  int inc = 1, bucket = code * GOLDEN_BITS >>> (32 - size_shift);
  BucketPointerDictElement bucket_elt = buckets[bucket];

  if (!!bucket_elt)
    {
      BucketPointerDictElement ne;
      int delta;

      (ne, delta) = [bucket_elt remove key];

      if (ne != bucket_elt)
	buckets[bucket] = ne;

      length -= delta;
    }
}

<doc> Associate the {value} with the {key}.  </doc>
void
  set All value
   at pointer key
pre
  value != nil
{
  int code;
  <c> code = HASH_POINTER (key); </c>
  int inc = 1, bucket = code * GOLDEN_BITS >>> (32 - size_shift);
  BucketPointerDictElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = [[BucketPointerDictElement alloc] initWith (key, value)];
  else
    inc = [bucket_elt add (key, value)];

  if (inc != 0)
    [self adjust_length inc];
}

end;
