/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMBreak.h,v 1.7 1998/01/05 01:12:16 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMLoop;

@interface OTMBreak: OTMExpr
{
  /* The value we pass up.  */
  OTMExpr *value;

  /* The loop we break.  */
  OTMLoop *enclosing_loop;
}

+(OTMBreak *) jumpStatement;

+(OTMBreak *) jumpStatementWithValue: (OTMExpr *) value;

-(void) compileJump;

#ifdef OTMBREAK_DECLARE_PRIVATE_METHODS

-(id) initWithValue: (OTMExpr *) e;

#endif

@end
