/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCondExpr.h,v 1.6 1998/01/05 01:12:32 tiggr Exp $  */

#import "OTMExpr.h"

@interface OTMCondExpr: OTMExpr
{
  OTMExpr *ip, *tp, *ep;

  /* Our the possible types.  */
  TLCons *possible_types;
}

+(OTMCondExpr *) iteWithCondition: (OTMExpr *) c
			 thenPart: (OTMExpr *) t
			 elsePart: (OTMExpr *) e;

-(void) setIf: (OTMExpr *) ip;
-(void) setThen: (OTMCompound *) t;
-(void) setElse: (OTMCompound *) e;

#ifdef OTMCONDEXPR_DECLARE_PRIVATE_METHODS

-(id) initWithCondition: (OTMExpr *) c
			 thenPart: (OTMExpr *) t
			 elsePart: (OTMExpr *) e;

#endif

@end
