/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMForeignType.m,v 1.4 1998/01/05 01:13:00 tiggr Exp $  */

#define OTMFOREIGNTYPE_DECLARE_PRIVATE_METHODS
#import "OTMForeignType.h"

@implementation OTMForeignType

+(OTMForeignType *) foreignTypeWithString: (id <TLString>) s;
{
  return [[self gcAlloc] initWithString: s];
}

-(void) gcReference
{
  MARK (output);

  [super gcReference];
}

-(id) initWithString: (id <TLString>) s
{
  if (![super init])
    return nil;

  output = s;

  return self;
}

-(id <TLString>) outputTypeName
{
  return output;
}

@end
