/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMMeta.h,v 1.40 1998/04/06 11:56:35 tiggr Exp $  */

#import "OTMEntity.h"
#import "OTMExpr.h"

@class LTTMeta;
@class OTMClass, OTMExtension, OTMInstance, OTMMeta, OTMMetaRef;
@class OTMMethod, OTMType, OTMObjectVar;;

void dump_classes (int verbose);

@interface OTMMeta: OTMEntity <OTMExpr>
{
  /* The structural counterpart of this meta.  */
  LTTMeta *structure;

  /* Ourselves, as a reference for class messaging.  */
  OTMMetaRef *reference;

  /* Iff !0, any references to super needed.  */
  TLSet *super_refs;

  /* Iff !nil, the definition is a foreign one.  This specifies how
     foreign.  Most of the time probably "C".  */
  id <TLString> foreign;

  /* Mark of this meta when searching in the hierarchy for methods,
     variables and such.  */
  int mark;

  /* If !0, we have state (somewhere in our extensions).  This is not
     strange for classes; it is special for instances.  */
  unsigned int has_state : 1;

  /* If !0, we have thread-local variables.  */
  unsigned int have_local_vars;

  /* Iff !0, all files (partially) defining this meta have been loaded.  */
  unsigned int fully_loaded: 1;

  /* Iff !0, we have already output our pointer-to-object declaration (and
     so have, or will, our superclasses).  */
  unsigned int did_output_pointer_decl: 1;

  /* Iff !0, we have told our extensions (and thos of our superclasses) to
     declare their structures.  */
  unsigned int did_output_extension_declarations: 1;
}

+(void) init;

+(void) resolveIdentifiers;

-(BOOL) classp;

-(void) compileDeclaration;
-(void) compileObjVarDeclarations: (int) mark;

#if 0
-(void) compileObjVarTypeDeclarations;
#endif

-(void) compileSuperReferenceDeclaration: (OTMMeta *) the_super;

-(void) dumpInfo: (id <TLOutputStream>) s;

-(id <TLString>) foreign;
-(void) setForeign: (id <TLString>) f;

/* Our structural counterpart.  */
-(LTTMeta *) structure;

/* Return a reference to this meta, for the purpose of class messaging.  */
-(OTMMetaRef *) metaReference;

/* These really are for compatibility with OTMBasic...  */
-(OTMMeta *) instance;
-(OTMMeta *) itsClass;

/* Return ourselves, or, if we have a poser, our poser's posedSelf.  */
-(OTMMeta *) posedSelf;

/* Return YES iff the object carries state.  Classes always carry state.
   Instances only if they have a state super.  */
-(BOOL) statep;

/* Indication (probably from one of our extensions) that we carry state.  */
-(void) setStatep;

/* Indicate that this meta (which must be a class) has thread-local
   variables.  */
-(void) setThreadLocalVarsP;

-(BOOL) fullyLoaded;
-(void) setFullyLoaded;

/********** methods **********/

/* Return a list of all methods implemented by the receiving meta or any
   of its superclasses with the given known NAME_PARTS, in no particular
   order.  Only methods visible from the SENDER need to be returned.  Iff
   SUPER_P methods implemented by the receiving meta itself should not be
   taken into account.  Iff, in addition, CONFINED, methods implemented by
   other superclasses should also not be taken into account.  */
-(TLCons *) methodsNamed: (TLVector *) name_parts
		  sender: (OTMMeta *) sender
		   super: (BOOL) super_p
		confined: (OTMMeta *) confined;

/* Search for a prototypically identical method in the hierarchy.  */
-(OTMMethod *) searchSimilarMethod: (OTMMethod *) method;

-(TLVector *) collectConditions: (BOOL) pre_not_post
			    for: (OTMCustomMethod *) method;

/********** variables **********/

/* Find the variable or constant (depending on VP and CP) named N in the
   receiving meta proper, not including its supers.  */
-(OTMObjectVar *) entityNamed: (id <TLString>) n
		    variables: (BOOL) vp
		    constants: (BOOL) cp;

/* Search the receiving meta proper, its supers (iff YES) and its class
   (iff YES) for the indicated variable.  */
-(OTMObjectVar *) searchEntityNamed: (id <TLString>) n
			     supers: (BOOL) search_supers
			      class: (BOOL) search_class
			  variables: (BOOL) vp
			  constants: (BOOL) cp;

/******************** private methods ********************/

#ifdef OTMMETA_DECLARE_PRIVATE_METHODS

-initWithStructure: (LTTMeta *) str;

/********** methods **********/

-(TLCons *) methodsNamed: (TLVector *) name_parts
		  sender: (OTMMeta *) sender
		   super: (BOOL) super_p
		confined: (OTMMeta *) confined
		    list: (TLCons *) l
		    mark: (int) k;

-(OTMMethod *) searchSimilarMethod: (OTMMethod *) method
			      mark: (int) k;

-(TLVector *) collectConditions: (BOOL) pre_not_post
			    for: (OTMCustomMethod *) method
			   into: (TLVector *) conditions
			   mark: (int) k;

/********** variables **********/

-(OTMObjectVar *) searchEntityNamed: (id <TLString>) n
			     supers: (BOOL) search_supers
			       mark: (int) k
			  variables: (BOOL) vp
			  constants: (BOOL) cp;


#endif

@end
