/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMModAssign.m,v 1.10 1998/01/05 01:13:28 tiggr Exp $  */

#define OTMMODASSIGN_DECLARE_PRIVATE_METHODS
#import "OTMModAssign.h"
#import "OTMMethod.h"
#import "OTMType.h"
#import "OTMUnvocation.h"
#import "global.h"

@implementation OTMModAssign

+(OTMModAssign *) assignmentWithLhs: (OTMExpr *) l
				rhs: (OTMExpr *) r
			   operator: (enum builtin_operator) o
			      postp: (BOOL) p
{
  return [[self gcAlloc] initWithLhs: l rhs: r operator: o postp: p];
}

-(id) elaborate
{
  OTMExpr *result;

  if (!post_not_pre)
    result = lhs;
  else
    {
      result = temp_something_with_type ([lhs type], YES);
      emit_assignment (result, lhs);
    }

  rhs = [rhs elaborate];

  emit_assignment (lhs, rhs);

  return result;
}

-(id) initWithLhs: (OTMExpr *) l
	      rhs: (OTMExpr *) r
	 operator: (enum builtin_operator) o
	    postp: (BOOL) p
{
  if (![super initWithType: nil])
    return nil;

  lhs = l;
  post_not_pre = p;
  rhs = [CO_OTMUnvocation unvocationWithReceiver:
		       [[CO_OTMExpr gcAlloc] initWithType:
					  [[current_either itsClass] semantics]]
		       sender: [current_either semantics]
		       arguments: [CO_TLVector vectorWithElements: 2, l, r]
		       nameParts: [CO_TLVector vectorWithElements: 2,
					    builtin_operator_name[o],
					    unique_identifier_colon]
		       super: NO confined: nil];

  return self;
}

@end
