/* Unresolved invocation.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMUnvocation.m,v 1.50 1998/05/07 16:02:23 tiggr Exp $  */

#define OTMUNVOCATION_DECLARE_PRIVATE_METHODS
#import "OTMUnvocation.h"
#import "OTMBasic.h"
#import "OTMDynamicType.h"
#import "OTMExtension.h"
#import "OTMInvocation.h"
#import "OTMMeta.h"
#import "OTMMethod.h"

@implementation OTMUnvocation

+(OTMUnvocation *) unvocationWithReceiver: (OTMExpr *) rcv
				   sender: (OTMMeta *) snd
				arguments: (TLVector *) args
			        nameParts: (TLVector *) v
				    super: (BOOL) sp
				 confined: (OTMMeta *) c
{
  return [[self gcAlloc] initWithReceiver: rcv sender: snd
			 arguments: args nameParts: v super: sp confined: c];
}

-(id) conditionCopyFor: (OTMCustomMethod *) method
{
  int i, l = [arguments length];

  receiver = [receiver conditionCopyFor: method];
  for (i = 0; i < l; i++)
    {
      OTMExpr *b, *a = [arguments _elementAtIndex: i];

      b = [a conditionCopyFor: method];
      if (a != b)
	[arguments _replaceElementAtIndex: i by: b];
    }

  return self;
}

-(void) description: (id <TLMutableStream>) stream
{
  [super description: stream];

  formac (stream, @" name=%@ args=%@", name_parts, arguments);
}

-(id) elaborate
{
  OTMMethod *m = [eligible_methods car];

  if (eligible_methods && [eligible_methods cdr])
    {
      TLCons *c = eligible_methods;

      error_for (self, @"invocation wasn't resolved of method %@",
		 method_name2 (name_parts, arguments));
      cerror_for (self, @"possible methods are (with declaration line):");

      while (c)
	{
	  DECONS (c, m, c);

	  cerror_for (m, @"%@", method_name (m, 1));
	}
    }
  else if (super_p && !confined)
    {
      LTTMeta *rcv_meta = [(OTMMeta *) [[receiver type] actualSelfNonPosing:
					     [current_either semantics]]
			    structure];
      LTTMeta *mth_meta = [[[m extension] structure] meta];
      TLCons *l;

      do
	{
	  l = [rcv_meta directSuperForProperSuper: mth_meta];
	  if (!l)
	    mth_meta = [mth_meta posed];
	} while (!l && mth_meta);

      if ([l cdr])
	error (@"ambiguous super reference: possible direct supers are %@", l);
      else if (!l)
	internal (@"no possible direct supers for %@", [receiver type]);
      else
	confined = [[l car] semantics];
    }

  return [[[CO_OTMInvocation invocationWithReceiver: receiver
			  super: confined method: m
			  arguments: [m argumentsForNameParts: name_parts
					arguments: arguments]
			  returnType: type inContext: current_compound]
	    elaborate] getLocationFrom: self];
}

-(void) gcReference
{
  MARK (name_parts);
  MARK (receiver);
  MARK (sender);
  MARK (arguments);
  MARK (eligible_methods);
  MARK (possible_arg_types);
  MARK (confined);

  [super gcReference];
}

-(id) initWithReceiver: (OTMExpr *) rcv
		sender: (OTMMeta *) snd
	     arguments: (TLVector *) args
	     nameParts: (TLVector *) v
		 super: (BOOL) sp
	      confined: (OTMMeta *) conf
{
  if (![super initWithType: nil])
    return nil;

  name_parts = v;
  sender = snd;
  receiver = rcv;
  arguments = args;
  super_p = !!sp;
  confined = conf;

  return self;
}

-(id) resolveInContext: (OTMMeta *) meta
{
  int i, n = arguments ? [arguments length] : 0;

  receiver = [receiver resolveInContext: meta];

  for (i = 0; i < n; i++)
    {
      id p = [arguments _elementAtIndex: i];
      id o = [p resolveInContext: meta];

      if (o != p)
	[arguments _replaceElementAtIndex: i by: o];
    }

  return self;
}

-(id) oldsEliminated
{
  int i, n = [arguments length];

  receiver = [receiver oldsEliminated];

  for (i = 0; i < n; i++)
    {
      id p = [arguments _elementAtIndex: i];
      id o = [p oldsEliminated];

      if (o != p)
	[arguments _replaceElementAtIndex: i by: o];
    }

  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  BOOL must_fully_resolve = (to || (expected && ![expected cdr]
				    && [[expected car] isFullyDefinedType]));
  OTMType *t, *to_at_index = to ? [to typeAt: index in: indices] : nil;
  int num_args = arguments ? [arguments length] : 0;
  BOOL changes, fully_typed;
  id <TLEnumerator> me;
  TLCons *possible;
  OTMMeta *either;
  int i, j, implicit;
  OTMMethod *m;
  TLVector *v;

  if (type)
    return [super resolveWithExpected: expected convertible: to
		  context: cxt indices: indices index: index];

  if (possible_arg_types)
    either = [[receiver type] actualSelf: [current_either semantics]];
  else
    {
      TLVector *em;
      int num_em;

      /* Let the receiver have a go at it.  */
      receiver = resolve_expr (receiver, CONS (the_any_ref_type, nil),
			       nil, cxt);
      if (![receiver type])
	return nil;

      either = [[receiver type] actualSelf: [current_either semantics]];

      /* Set up the basic set of methods.  */
      eligible_methods = [either methodsNamed: name_parts sender: sender
				 super: super_p confined: confined];

      if (!eligible_methods)
	{
	  error_for (self, @"%@%@%@ never responds to a method",
		     super_p && confined ? @"indicated " : @"",
		     super_p ? @"super of " : @"", type_name (either));
	  cerror_for (self, @"%@", method_name2 (name_parts, arguments));
	  return nil;
	}

      /* Eliminate methods and build possible argument types.  */
      possible_arg_types = [CO_TLVector vectorWith: num_args copies: nil];
      me = [eligible_methods enumerator];
      eligible_methods = nil;
      em = [CO_TLVector vector];
      num_em = 0;
      while ((m = [me nextObject]))
	{
	  t = [[m returnType] actualSelf: either];

	  /* If the return type does not match.  Skip this method.  */
	  if (t != the_dynamic_type
	      && ((expected && !types_element_of (t, expected, cxt, indices,
						  index, 1))
		  || (to && (!to_at_index || ![t validCastTo: to_at_index]))))
	    continue;

	  /* If the number of provided arguments can never fit the method,
             skip it.  This is needed to discern the methods `id init' and
             `id init int a'.  */
	  if (![m fitsInvocationNumArguments: num_args])
	    continue;

	  /* If this is not an invocation to SUPER, we can safely drop
	     (duplicate) methods with truely identical types and kinds.  */
	  if (!super_p && num_em)
	    {
	      int mi, mn;

	      for (mi = 0, mn = [em length]; mi < mn; mi++)
		{
		  OTMMethod *m2 = [em _elementAtIndex: mi];

		  if ([m2 identical: m inContext: either])
		    break;
		}

	      if (mi != mn)
		continue;
	    }

	  if (num_em)
	    {
	      LTTMeta *this_meta = [[[m extension] structure] meta];
	      int replacing = 0;

	      for (i = 0; i < num_em; i++)
		{
		  OTMMethod *m2 = [em _elementAtIndex: i];

		  if ([(id) [m2 methodName] equal: [m methodName]]
		      && [m2 typesMatch: m])
		    {
		      /* This method M2 in EM is identical to the one we
                         try to add (M).  If M's meta is a superclass of
                         or identical to M2's meta, we can drop M.  */
		      LTTMeta *already_meta = [[[m2 extension] structure] meta];

		      if (replacing)
			{
			  if ([already_meta isProperSub: this_meta])
			    {
			      [em _removeElementAtIndex: i];
			      num_em--;
			      i--;
			    }
			}
		      else if (already_meta == this_meta
			  || [this_meta isProperSub: already_meta])
			break;
		      else if ([already_meta isProperSub: this_meta])
			{
			  [em _replaceElementAtIndex: i by: m];
			  replacing = 1;
			}
		    }
		}

	      if (i != num_em || replacing)
		continue;
	    }

	  [em addElement: m];
	  num_em++;
	}

      /* Build the possible argument types.  */
      for (j = 0; j < num_em; j++)
	{
	  m = [em _elementAtIndex: j];

	  for (i = 0; i < num_args; i++)
	    {
	      t = [m typeForArgumentAtIndex: i inContext: either
		     withNamePart: [name_parts _elementAtIndex: i]];

	      [possible_arg_types _replaceElementAtIndex: i by:
	       types_add_element (t, [possible_arg_types _elementAtIndex: i])];
	    }
	}

      eligible_methods = [tlcons_class listWithSequence: em];
    }

  if (!eligible_methods)
    return nil;

  do
    {
      fully_typed = YES;
      changes = NO;

      /* Type the arguments.  */
      for (i = 0; i < num_args; i++)
	{
	  TLCons *pt, *et = [possible_arg_types _elementAtIndex: i];
	  OTMExpr *arg = [arguments _elementAtIndex: i];

	  pt = [arg resolveWithExpected: et convertible: nil
		    context: cxt indices: NULL index: -1];

	  /* If the argument can not have a type, we can't either.  */
	  if (!pt)
	    return nil;

	  if (!types_equal (pt, et, et))
	    {
	      [possible_arg_types _replaceElementAtIndex: i by: pt];
	      changes = YES;
	    }

	  if (fully_typed && ![arg type]
	      /* If the argument has a type, it is fully typed.  No need to
		 check if it can fit more than one type.

		 && ([pt cdr] || ![[pt car] isFullyDefinedType]) */)
	    fully_typed = NO;
	}

      if (changes)
	{
	  changes = NO;

	  /* Eliminate methods from the eligible methods due to argument
             type constraints.  */
	  me = [eligible_methods enumerator];
	  eligible_methods = nil;
	  while ((m = [me nextObject]))
	    {
	      for (i = 0; i < num_args; i++)
		{
		  t = [m typeForArgumentAtIndex: i inContext: either
			 withNamePart: [name_parts _elementAtIndex: i]];
		  if (!types_element_of (t, [possible_arg_types
					     _elementAtIndex: i],
					 cxt, NULL, -1, 0))
		    break;
		}

	      if (i < num_args)
		{
		  /* This method didn't make it.  */
		  changes = YES;
		  continue;
		}

	      eligible_methods = CONS (m, eligible_methods);
	    }

	  if (changes)
	    {
	      /* Rebuild the possible argument types.  */
	      possible_arg_types = [CO_TLVector vectorWith: num_args
						copies: nil];
	      me = [eligible_methods enumerator];
	      while ((m = [me nextObject]))
		{
		  for (i = 0; i < num_args; i++)
		    {
		      t = [m typeForArgumentAtIndex: i inContext: either
			     withNamePart: [name_parts _elementAtIndex: i]];

		      [possible_arg_types _replaceElementAtIndex: i by:
		       types_add_element (t, [possible_arg_types
					      _elementAtIndex: i])];
		    }
		}
	    }
	}
    } while (changes);

  possible = nil;
  if ((must_fully_resolve || fully_typed)
      && eligible_methods && [eligible_methods cdr])
    {
      /* We've got multiple methods to choose from, the return type is
	 either indicated or fully specified, or the arguments are fully
	 typed, and thus we're expected to totally resolve.  */

      /* Pick the best from the remaining set of methods.  This is decided
	 by the best matching return type.  */
      if (must_fully_resolve && eligible_methods && [eligible_methods cdr])
	{
	  TLVector *em = [CO_TLVector vectorWithSequence: eligible_methods];
	  int this_best, max_best = -1, num_meth = [em length];
	  OTMType *desired_type;

	  desired_type = (to ? [[to typeAt: index in: indices] actualSelf: cxt]
			  : [[[expected car] typeAt: index in: indices]
			     actualSelf: cxt]);

	  for (i = 0; i < num_meth;)
	    {
	      m = [em _elementAtIndex: i];
	      v = [m arguments];
	      implicit = [m implicitArguments];

	      this_best = [desired_type matchesConvertibly:
			   [[[m returnType] typeAt: index in: indices]
			    actualSelf: either]];

	      if (max_best == -1 || (this_best >= 0 && this_best < max_best))
		{
		  [em removeElementsFromIndex: 0 range: i];
		  max_best = this_best;
		  num_meth -= i;
		  i = 1;
		}
	      else if (this_best == max_best)
		i++;
	      else /* this_best > max_best */
		{
		  [em _removeElementAtIndex: i];
		  num_meth--;
		}
	    }

	  eligible_methods = [tlcons_class listWithSequence: em];
	}

      /* If still needed, pick the best from the remaining set of methods,
         decided by the number of fully-matching arguments.  */
      if (eligible_methods && [eligible_methods cdr])
	{
	  TLVector *em = [CO_TLVector vectorWithSequence: eligible_methods];
	  int j, this_best, max_best = -1, num_meth = [em length];

	  for (i = 0; i < num_meth;)
	    {
	      m = [em _elementAtIndex: i];

	      for (j = this_best = 0; j < num_args; j++)
		{
		  t = [[arguments _elementAtIndex: j] type];

		  if (t && [[m typeForArgumentAtIndex: j inContext: either
			     withNamePart: [name_parts _elementAtIndex: j]]
			    matchesConvertibly: [t actualSelf: cxt]] == 0)
		    this_best++;
		}

	      if (this_best > max_best)
		{
		  [em removeElementsFromIndex: 0 range: i];
		  max_best = this_best;
		  num_meth -= i;
		  i = 1;
		}
	      else if (this_best == max_best)
		i++;
	      else /* this_best < max_best */
		{
		  [em _removeElementAtIndex: i];
		  num_meth--;
		}
	    }

	  eligible_methods = [tlcons_class listWithSequence: em];
	}

      /* If we still haven't figured it out, drop all methods with the
	 most number of name parts, i.e. prefer those with a closer match.  */
      if (eligible_methods && [eligible_methods cdr])
	{
	  TLVector *em = [CO_TLVector vectorWithSequence: eligible_methods];
	  int this, num_meth = [em length];
	  unsigned int min = -1;

	  for (i = 0; i < num_meth;)
	    {
	      this = [[[em _elementAtIndex: i] nameParts] length];

	      if (this < min)
		{
		  [em removeElementsFromIndex: 0 range: i];
		  min = this;
		  num_meth -= i;
		  i = 1;
		}
	      else if (this == min)
		i++;
	      else
		{
		  [em _removeElementAtIndex: i];
		  num_meth--;
		}
	    }
	  eligible_methods = [tlcons_class listWithSequence: em];
	}

      /* Multiple methods match.  Drop those involving dynamic typing, if
         there are some not involving dynamic typing.  */
      if (eligible_methods && [eligible_methods cdr])
	{
	  TLCons *dynamics = nil, *statics = nil;
	  id <TLEnumerator> e = [eligible_methods enumerator];

	  while ((m = [e nextObject]))
	    if ([m dynamicTyped])
	      dynamics = CONS (m, dynamics);
	    else
	      statics = CONS (m, statics);

	  if (statics && dynamics)
	    eligible_methods = statics;
	}

      /* Ehhh... what's next?  */
      if (must_fully_resolve && eligible_methods && [eligible_methods cdr])
	;
    }

  if (!eligible_methods)
    return nil;

  if (must_fully_resolve)
    {
      if ([eligible_methods cdr])
	{
	  /* We couldn't decide.  We'll moan in elaborate.  */
	}
      else if (!fully_typed)
	{
	  /* Fully type the arguments according to the single left-over
	     eligible method.  */
	  m = [eligible_methods car];

	  for (i = 0; i < num_args; i++)
	    {
	      OTMExpr *e = [arguments _elementAtIndex: i];

	      if (![e type])
		resolve_expr (e, CONS ([m typeForArgumentAtIndex: i
					inContext: either withNamePart:
					[name_parts _elementAtIndex: i]], nil),
			      nil, cxt);
	    }
	  fully_typed = YES;
	}
    }

  if (fully_typed && ![eligible_methods cdr])
    {
      type = [[[eligible_methods car] returnType] actualSelf: either];
      if (type == the_dynamic_type)
	{
	  if (!expected)
	    {
	      type = basic_type[BT_VOID];
	      possible = CONS (type, nil);
	    }
	  else if (![expected cdr])
	    {
	      type = [expected car];
	      possible = expected;
	    }
	  else
	    error_for (self, @"ambiguous context for dynamic type");
	}
      else
	possible = CONS (expected ? types_element_of (type, expected, cxt,
						      indices, index, 1)
			 : type, nil);
    }
  else
    {
      /* Confine expected or create a list of possible types.  */
      me = [eligible_methods enumerator];
      while ((m = [me nextObject]))
	{
	  t = [[m returnType] actualSelf: either];
	  if (!expected)
	    possible = types_add_element (t, possible);
	  else
	    possible = types_add_elt_ordered (t, possible, expected);
	}
    }

  return possible;
}

@end
