/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMVariable.h,v 1.17 1998/01/05 01:14:11 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMType;

int next_tmp;

@interface OTMVariable: OTMExpr
{
  id <TLString> name;
}

+(OTMVariable *) variableWithName: (id) n type: (OTMType *) t;

+(OTMVariable *) temporaryVariableWithType: (OTMType *) t;

-(BOOL) argumentp;

-(void) compileAddressListWithFirst: (id <TLString>) f
			  separator: (id <TLString>) s;

-(id <TLString>) variableName;

-(id) outputDeclaration: (id) stream;

-(id <TLString>) outputName;

-(BOOL) residesInRefStruct;

#ifdef OTMVARIABLE_DECLARE_PRIVATE_METHODS

/* N is either a TLString name or an OTMTuple with names.  */
-(id) initWithName: (id) n type: (OTMType *) t;

#endif

@end
