
/*  A Bison parser, made from parse.y
 by  GNU Bison version 1.25.90
  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse otm_parse
#define yylex otm_lex
#define yyerror otm_error
#define yylval otm_lval
#define yychar otm_char
#define yydebug otm_debug
#define yynerrs otm_nerrs
#define	CLASS	257
#define	END	258
#define	EXTENSION	259
#define	EXTERN	260
#define	IMPLEMENTATION	261
#define	INSTANCE	262
#define	INTERFACE	263
#define	POSING	264
#define	RECEIVER	265
#define	SUPER	266
#define	CONST	267
#define	LOCAL	268
#define	OLD	269
#define	IF	270
#define	ELSE	271
#define	DO	272
#define	FOR	273
#define	WHILE	274
#define	BREAK	275
#define	CONTINUE	276
#define	RETURN	277
#define	PRE	278
#define	POST	279
#define	PUBLIC	280
#define	PRIVATE	281
#define	PROTECTED	282
#define	MUTABLE	283
#define	STATIC	284
#define	DEFERRED	285
#define	REDEFINE	286
#define	REDECLARE	287
#define	CATCH	288
#define	BIND	289
#define	UNWIND	290
#define	DYNAMIC	291
#define	EQ	292
#define	GE	293
#define	LE	294
#define	NE	295
#define	AND	296
#define	OR	297
#define	IMPLIES	298
#define	SHL	299
#define	SHR	300
#define	LSR	301
#define	TYPEDEF	302
#define	VOID	303
#define	NIL	304
#define	PLUSPLUS	305
#define	MINMIN	306
#define	ASSIGN	307
#define	STRING_CST	308
#define	IDENTIFIER	309
#define	NUMBER	310
#define	TYPE	311
#define	BASIC_TYPE	312
#define	C_LITERAL	313
#define	UNARY_MINUS	314

#line 12 "parse.y"

#import <tl/tl.h>
#import <time.h>
#import "global.h"
#import "OTMAlias.h"
#import "OTMAliasAlias.h"
#import "OTMArgument.h"
#import "OTMAssignment.h"
#import "OTMBasic.h"
#import "OTMBind.h"
#import "OTMBreak.h"
#import "OTMBuiltinMethod.h"
#import "OTMCast.h"
#import "OTMCatch.h"
#import "OTMCondExpr.h"
#import "OTMConstant.h"
#import "OTMContinue.h"
#import "OTMClass.h"
#import "OTMCompound.h"
#import "OTMCustomMethod.h"
#import "OTMDynamicType.h"
#import "OTMError.h"
#import "OTMExpr.h"
#import "OTMExtension.h"
#import "OTMIdentifier.h"
#import "OTMInstance.h"
#import "OTMInvocation.h"
#import "OTMITE.h"
#import "OTMLocalVar.h"
#import "OTMLoop.h"
#import "OTMMetaRef.h"
#import "OTMModAssign.h"
#import "OTMNumberCST.h"
#import "OTMObjectVar.h"
#import "OTMOld.h"
#import "OTMReturn.h"
#import "OTMStringCST.h"
#import "OTMTuple.h"
#import "OTMTypeTuple.h"
#import "OTMUnvocation.h"
#import "OTMUnwind.h"
#import "OTMVariable.h"
#import "OTMVarRef.h"

/* Forward declarations.  */
extern int otm_lex ();
void do_postponed_aliases (BOOL must);

#define YYDEBUG 1
#define YYERROR_VERBOSE

int current_line;
id <TLString> current_filename;

/* The current unit.  */
LTTUnit *current_unit;

/* The current output file.  It is NIL when parsing a file which is not to
   be output.  */
id <TLOutputStream> of;

/* The extensions output to the output file.  */
TLSet *extensions_output;

/* The current class or the current instance.
   Only one of these will ever be !NIL.  */
LTTClass *current_class;
LTTInstance *current_instance;

/* This is either the CURRENT_CLASS or the CURRENT_INSTANCE, whichever is
   !nil (they can't be both).  */
LTTMeta *current_either;

/* The current extension.  The main definition of a class or instance is
   also an extension.  It is called the main extension.  */
LTTExtension *current_extension;

/* In a definition, or during the pre and post conditions of a
   declaration, the current method.  */
OTMCustomMethod *current_method;

/* The meta involved in the meta or method or whatever currently being
   output to the output file, be it as a declaration, or as a definition.  */
LTTMeta *output_current_context;

/* Similarly, the method.  */
OTMCustomMethod *output_current_method;

/* The current compound.  */
OTMCompound *current_compound;

/* The type enclosing the current local variable declaration.  */
OTMType *enclosing_type;

/* Semantics to some of the above.  */
#define C_EXT_SEMANTICS		(OTMExtension *) [current_extension semantics]
#define C_CLS_SEMANTICS		(OTMClass *) [current_class semantics]
#define C_INS_SEMANTICS		(OTMInstance *) [current_instance semantics]
#define C_EITHER_SEMANTICS	(OTMMeta *) [current_either semantics]

static enum
{
  GLOBAL_SCOPE,
  INTERFACE_SCOPE,
  IMPLEMENTATION_SCOPE,
} in_what;

/* Lists of still-to-patch supers.  Each entry is a cons cell holding the
   LTTMeta and the super meta.  Semantics of the inheritance depends on
   the list.  The STATE_SUPERS holds instances, but inheritance applies to
   both the instance and its class.  The BEHAVIOUR_SUPERS only applies to
   the actual metas involved.  */
TLCons *postponed_state_supers, *postponed_behaviour_supers;

TLCons *postponed_aliases;

/* The index number of the next argument.  */
int next_arg;

void
yyerror (char *s)
{
  extern char *yytext;
  error (@"parse error at `%s' (%s)", yytext, s);
}

LTTInstance *
instance_in_unit (id <TLString> unit_name, LTTUnit *current,
		  TLVector *instances)
{
  LTTInstance *i = ltt_instance_in_unit (unit_name, current, instances);

  if (!i && instances)
    error (@"ambiguous reference to %@",
	   [[(LTTInstance *) [instances _elementAtIndex: 0] lttName]
	    internal]);

  if (of && (postponed_state_supers || postponed_behaviour_supers))
    do_postponed_supers (1);

  return i;
}

/* Return a a pair of a variable with the name N and the type T, and the
   DEF expression, or, if T is a type-tuple and N is a tuple of names, and
   they correspond, return a pair of a properly typed tuple of properly
   typed variables, and the default value.

   Thus, this return CONS (arg, value).  */
id
digest_arguments (id n, id t, id def)
{
  BOOL ntup = ![n stringp];
  BOOL ttup = [t isTuple];
  OTMExpr *ret;

  /* A tuple with one element is not a real tuple.  */
  if (ttup)
    {
      TLVector *tv = [t elements];
      if ([tv length] == 1)
	{
	  t = [tv _elementAtIndex: 0];

	  /* XXX What is a tuple consisting of only a tuple?  What if the
             contained tuple also contains only a single element?  */
	  ttup = [t isTuple];
	}
    }

  /* If T is a tuple, it is a Real Tuple (> 1 element).  */
  if (ttup)
    {
      if (!ntup)
	{
	  error (@"attempt to declare `%@' with tuple type", n);
	  return nil;
	}
      else
	{
	  TLVector *tv = [(id) t elements], *nv = [n elements];
	  int i, nn = [nv length], tn = [tv length];
	  TLVector *vars;

	  if (tn != nn)
	    {
	      error (@"number of elements (%d) does not match type (%d)",
		     nn, tn);
	      return nil;
	    }

	  /* Create a vector of typed variables, by zipping the name tuple
             and type tuple.  */
	  vars = [CO_TLVector vectorWithCapacity: tn];
	  for (i = 0; i < nn; i++)
	    [vars addElement: [CO_OTMArgument variableWithName:
					      [nv _elementAtIndex: i]
					      type: [tv _elementAtIndex: i]
					      number: next_arg++]];

	  ret = [CO_OTMTuple tupleWithSequence: vars];
	  [ret setType: t];
	}
    }
  else if (ntup > 1)
    {
      error (@"non-tuple type for tupled argument");
      return nil;
    }
  else
    {
      if (ntup == 1)
	n = [[n elements] _elementAtIndex: 0];
      ret = [CO_OTMArgument variableWithName: n type: t number: next_arg++];
    }

  return CONS (ret, def);
}

/* Load the FILE.  Iff !INTERFACE, the implementation will be loaded.
   Otherwise, the interface will be preferred.  Iff META_NAME, the meta
   with that name must be declared after having read the file.  Iff MUST,
   the file type indicated by the INTERFACE must be found; otherwise an
   error is issued.  */
void
load_file (LTTFile *file, id <TLString> meta_name, BOOL interface, BOOL must)
{
  TLString *full_name = nil;
  FILE *f;
  GCDECL1;

  GCPRO1 (full_name);

  /* Open the file, preferring `.j' above `.t', unless !INTERFACE.  */
  if (!interface)
    f = NULL;
  else
    {
      if ([file loadedInterface] || (!must && [file loadedImplementation]))
	return;

      full_name = [file interfaceFilename];
      f = fopen ([full_name cString], "r");
      if (f)
	[file setLoadedInterface];
      else if (must)
	{
	  error (@"%@: %s", full_name, ERRMSG);
	  return;
	}
      else if (ERRNO != ENOENT)
	warning (@"%@: %s", full_name, ERRMSG);
    }

  if (!f)
    {
      if ([file loadedImplementation] || (!must && [file loadedInterface]))
	return;

      full_name = [file implementationFilename];
      f = fopen ([full_name cString], "r");
      if (f)
	[file setLoadedImplementation];
      else
	error (@"%@: %s", full_name, ERRMSG);
    }

  if (f)
    {
      char buf[4096];
      const char *s;
      TLVector *v;
      int mi, mn;

      s = [full_name cString];
      if (s[0] != '/')
	{
	  /* Make the path absolute.  */
	  if (getcwd (buf, sizeof (buf)))
	    full_name = [CO_TLString stringWithFormat: @"%s/%s", buf, s];
	}

      parse_file (full_name, [file unit], f);
      fclose (f);

      for (mi = 0, v = [file items], mn = [v length]; mi < mn; mi++)
	{
	  LTTExtension *ext = [v _elementAtIndex: mi];
	  OTMExtension *sem = [ext semantics];

	  if (!sem || !([sem definedp] || [sem declaredp]))
	    error (@"%@ fails to define or declare %@",
		   full_name, ltt_ext_name (ext));
	}
    }

  GCUNPRO;
}

/* Load the interface (or the implementation) of the extension EXT.  */
void
load_extension_interface (LTTExtension *ext)
{
  LTTFile *file = [ext container];
  id pof = nil;
  GCDECL1;

  GCPRO1 (pof);

  pof = of;
  of = nil;

  /* Only check the meta in case we're loading the main extension.  */
  load_file (file, [ext isMainExtension] ? [[ext meta] lttName] : nil, 1, 0);

  of = pof;

  GCUNPRO;
}

/* Load the meta M.  This implies that all files which have defined
   extensions or posing classes for M are loaded.  */
void
load_interface (LTTInstance *ins)
{
  LTTExtension *ext;

  /* If the main extension's file has been set loaded, we do not do
     anything since that file will declare this meta.  */
  if (![[ins semantics] fullyLoaded])
    {
      int previous_in_what = in_what;
      TLVector *exts = 0;
      int i, n;
      GCDECL1;

      GCPRO1 (exts);

      [[ins semantics] setFullyLoaded];

      exts = [ins extensions];
      for (i = 0, n = [exts length]; i < n; i++)
	{
	  ext = [exts _elementAtIndex: i];
	  if (![[ext container] loadedInterface]
	      && ![[ext container] loadedImplementation])
	    load_extension_interface (ext);
	}

      GCUNPRO;

      in_what = previous_in_what;
    }

  {
    LTTMeta *p = [ins posedSelf];

    if ((id) ins != p)
      load_interface ([p classp] ? (id) [p instance] : p);
  }
}

/* Add the method declaration of METHOD to the current extension.  */
void
add_method_decl (OTMCustomMethod *method)
{
  BOOL ok = YES, shown = NO;
  OTMMethod *orig;

  if (!current_extension)
    return;

  if (in_what == IMPLEMENTATION_SCOPE && [C_EXT_SEMANTICS declaredp]
      && ![method foreign] && ![method deferredp])
    error (@"method declaration in implementation scope");

  orig = [C_EITHER_SEMANTICS searchSimilarMethod: method];
  if (orig)
    {
      otm_qualifiers q = [method qualifiers];
      otm_qualifiers oq = [orig qualifiers];

      if (![method foreign] && !Q_DEFERRED (oq))
	{
	  if ([method extension] == [orig extension])
	    {
	      error (@"duplicate declaration of identical method");
	      if (!shown)
		cerror_for (orig, @"previous declaration was here");
	      ok = NO;
	    }

	  // XXX This is a hack.  The `searchSimilarMethod:' should return
	  // a list of applicable methods (i.e. all of those in scope,
	  // which can be multiple methods for multiple extensions of this
	  // either)
	  if (([[[orig extension] structure] meta]
	       == [[[method extension] structure] meta])
	      && [[[method extension] structure] isMainExtension])
	    ;
	  else if (!Q_REDO (q))
	    {
	      if (!flag_inhibit_unqualified_redeclare)
		{
		  warning (@"unqualified redeclaration of undeferred method");
		  if (!shown)
		    cerror_for (orig, @"previous declaration was here");
		}
	      [method setRedo: OQ_REDEFINE];
	    }
	}
      if (!Q_PROTECTION (q))
	Q_SET_PROTECTION (q, Q_PROTECTION (oq));
      else if (Q_PROTECTION (q) != Q_PROTECTION (oq))
	{
	  error (@"protection %@ differs from original declaration",
		 qualifier_name (Q_PROTECTION (q)));
	  error_for (orig, @"original protection %@ declared here",
		     qualifier_name (Q_PROTECTION (oq)));
	  [method setProtection: Q_PROTECTION (oq)];
	}

      /* XXX `Inherit' the default arguments from the original?  */
    }

  if (ok)
    {
      /* Make sure the selector of this method is registered.
	 This is needed for foreign methods.  */
      if (of)
	[method selector];

      /* No need to add the declaration of a foreign method twice.  */
      if (in_what == IMPLEMENTATION_SCOPE && [method foreign]
	  && [method extension] == [orig extension])
	return;
      else
	{
	  [C_EXT_SEMANTICS addMethod: method];
	  [method setDeclared: YES];
	}
    }
}

/* Add the method declaration or definition of METHOD with the PRE and
   POST conditions to the current extension.  */
OTMCustomMethod *
add_method_def (OTMCustomMethod *method)
{
  OTMMethod *orig;
  OTMExtension *ext;
  BOOL ok = YES, shown = NO;

  if (!current_extension)
    return nil;

  ext = [method extension];
  orig = [C_EXT_SEMANTICS searchSimilarMethod: method];

  if (orig)
    {
      if (ext == [orig extension])
	{
	  if ([orig definedp])
	    {
	      error (@"redefinition of prototypicially identical method");
	      if (!shown)
		{
		  cerror_for (orig, @"previous definition was here");
		  shown = YES;
		}
	      ok = NO;
	    }
	}
    }
  else
    {
      /* In an implementation, if the interface has been seen, this method
         must have been declared.  */
      if (in_what == IMPLEMENTATION_SCOPE && [ext declaredp])
	error (@"definition of undeclared method %@", method_name (method, 0));
    }

  if (ok && orig
      && ![orig allowedRedeclaration: method
		inSubclass: ([[ext structure] meta]
			     != [[[orig extension] structure] meta])])
    {
      error (@"argument type mismatch with declaration");
      if (!shown)
	{
	  cerror_for (orig, @"previous definition was here");
	  shown = YES;
	}
      ok = NO;
    }

  if (ok)
    {
      if (orig)
	{
	  id f;

	  [method warnDifferingArguments: orig];
	  method = (id) orig;

	  [method refreshLocation];

	  f = [method foreign];
	  if (f)
	    [(OTMCustomMethod *) orig setForeign: f];
	}
      else
	{
	  TLVector *v;

	  v = [C_EXT_SEMANTICS methodsNamed: [method methodName] create: YES];
	  [v addElement: method];
	}

      [method setDefined: YES];

      /* Make sure the selector of this method is registered.
	 This is needed for foreign methods.  */
      if (of && !NUM_ERRORS)
	[method selector];
    }

  return method;
}

/* Add CI to the behavioural super information of SUBI.  */
void
add_super_1 (LTTMeta *subi, LTTMeta *ci)
{
  OTMMeta *cis = [ci semantics];

  if (![cis declaredp] && ![cis definedp])
    postponed_behaviour_supers = CONS (CONS (subi, ci),
				       postponed_behaviour_supers);
  else if ([ci isDirectSub: subi]
	   && (in_what == INTERFACE_SCOPE
	       || (in_what == IMPLEMENTATION_SCOPE
		   && ![[subi semantics] declaredp])))
    warning (@"%@: repeated immediate super %@",
	     ltt_meta_name (subi), ltt_meta_name (ci));
  else
    {
      [subi addBehaviourSuper: ci];
      [[[subi extensionNamed: [[current_extension lttName] internal]] semantics]
	addSuper: cis];
    }
}

/* Handle the normal case of straight inheritance (without shifting meta
   levels).  */
static void
add_super_0 (LTTInstance *subi, LTTInstance *ci)
{
  BOOL already = [ci isDirectSub: subi];
  LTTClass *subc = [subi itsClass];
  LTTClass *cc = [ci itsClass];
  OTMMeta *subis = [subi semantics];
  OTMMeta *cis = [ci semantics];

  if (![cis declaredp] && ![cis definedp])
    postponed_state_supers = CONS (CONS (subi, ci), postponed_state_supers);
  else if (already
	   && (in_what == INTERFACE_SCOPE
	       || (in_what == IMPLEMENTATION_SCOPE && ![subis declaredp])))
    warning (@"%@: repeated immediate super %@",
	     ltt_meta_name (subi), ltt_meta_name (ci));
  else if (!already && in_what == IMPLEMENTATION_SCOPE && [subis declaredp])
    error_for ([subi semantics],
	       @"%@: super indication was absent in interface",
	       ltt_meta_name (ci));
  else
    {
      LTTName *cename = current_extension ? [current_extension lttName] : nil;
      id <TLString> cenamei = cename ? [cename internal] : nil;

      [subi addStateSuper: ci];
      [subc addStateSuper: cc];
      [[[subi extensionNamed: cenamei] semantics] addSuper: cis];
      [[[subc extensionNamed: cenamei] semantics] addSuper: [cc semantics]];
      if ([cis statep])
	[[subi semantics] setStatep];
      if ([[cc semantics] statep])
	[[subc semantics] setStatep];
    }
}

/* Add C to be a super of the current meta.  If !direction, this is state
   inheritance (even if C has no state).  If it is -1, it is inheritance
   of the instance behaviour only.  If it is +1, it indicates inheritance
   of the class behaviour only.  */
static void
add_super (LTTInstance *inst, int direction)
{
  if (!direction)
    {
      if (current_instance)
	add_super_0 (current_instance, inst);
      else if (current_class)
	add_super_0 ([current_class instance], inst);
    }
  else if (direction < 0)
    add_super_1 (current_either, inst);
  else
    add_super_1 (current_either, [inst itsClass]);
}

static void
do_add_super (id what, int posing)
{
  int dir = 0;

  if ([what consp])
    {
      id a, d;

      DECONS (what, a, d);
      if (a)
	what = a, dir = 1;
      else
	what = d, dir = -1;
    }

  add_super (what, dir);

  if (posing)
    {
      /* XXX Check consistency.  */

    }
}

void
do_postponed_aliases (BOOL must)
{
  TLCons *list = postponed_aliases;

  postponed_aliases = nil;

  while (list)
    {
      OTMAliasAlias *a;

      DECONS (list, a, list);
      [[a extension] handlePostponedAlias: a];
    }

  if (must && postponed_aliases)
    internal (@"non-empty postponed aliases");
}

void
do_postponed_supers (BOOL must)
{
  TLCons *states = postponed_state_supers;
  TLCons *behaviours = postponed_behaviour_supers;
  int previous_in_what = in_what;
  id sub, sup;
  TLCons *c;

  postponed_behaviour_supers = postponed_state_supers = nil;
  in_what = GLOBAL_SCOPE;

  while (states)
    {
      DECONS (states, c, states);
      DECONS (c, sub, sup);
      add_super_0 (sub, sup);
    }

  while (behaviours)
    {
      DECONS (behaviours, c, behaviours);
      DECONS (c, sub, sup);
      add_super_1 (sub, sup);
    }

  if (must && (postponed_state_supers || postponed_behaviour_supers))
    internal (@"non-empty postponed supers");

  in_what = previous_in_what;
}

/* Add the variables from the VARS list to the current_either with the
   indicated qualifiers and TYPE.  */
void
object_add_variables (otm_qualifiers q, id type, TLCons *vars, BOOL is_local)
{
  id <TLString> name;
  OTMObjectVar *var;
  
  q = mask_qualifiers (q, ((current_instance ? 0 : OQ_STATIC_MASK)
			   | OQ_PROTECTION_MASK | OQ_MUTABLE_MASK
			   | OQ_REDO_MASK));

  if (Q_REDO (q) && Q_REDO (q) != OQ_REDECLARE)
    q = mask_qualifiers (q, 0);

  if (Q_REDO (q) && is_local)
    {
      error (@"can't redeclare something as local");
      is_local = 0;
    }

  if (!current_either)
    return;

  if (in_what == IMPLEMENTATION_SCOPE && [[current_either semantics] declaredp])
    while (vars)
      {
	OTMCustomMethod *m;
	OTMExpr *e;

	DECONS (vars, name, vars);

	/* XXX Check consistency with declaration.  */
	var = [C_EXT_SEMANTICS variableNamed: name];

	if (!var)
	  {
	    error (@"declaration of %@ not found in interface", name);
	    continue;
	  }

	if ([var type] != type)
	  {
	    error (@"differing declaration of %@", name);
	    error_for (var, @"previous declaration was here");
	  }

	/* Generate the accessor methods.  */
	if (Q_PROTECTION (q) == OQ_PUBLIC)
	  {
	    m = add_method_def ((id) [CO_OTMCustomMethod
				      methodWithExtension: C_EXT_SEMANTICS
				      name: accessor_method_name (name)
				      returnType: type flatp: NO]);
	    current_method = m;
	    current_compound = [CO_OTMCompound compoundWithContainer: (id) m];
	    [current_method setBody: current_compound];
	    e = [CO_OTMAssignment assignmentWithLhs:
			       temp_something_with_type ([var type], 0)
			       rhs: var];
	    e = emit_expr (e);
	    [m setReturnValue: e];
	    current_compound = nil;
	    if (of && !NUM_ERRORS)
	      [current_method compile];
	    current_method = nil;
	  }

	if (Q_MUTABLE (q))
	  {
	    m = add_method_def
	      ((id) [CO_OTMCustomMethod methodWithExtension: C_EXT_SEMANTICS
		     nameTypes: CONS (CONS (modifier_method_name (name),
					    CONS ([CO_OTMVariable
						   variableWithName:
						   @"value" type: type], nil)),
				      nil)
		     returnType: basic_type[BT_VOID] flatp: NO]);

	    current_method = m;
	    current_compound = [CO_OTMCompound compoundWithContainer: (id) m];
	    [current_method setBody: current_compound];
	    e = [CO_OTMAssignment assignmentWithLhs:
		 [C_EITHER_SEMANTICS searchEntityNamed: name supers: YES
		  class: YES variables: YES constants: YES]
		 rhs: [current_compound searchVariableNamed: @"value"]];
	    e = emit_expr (e);
	    current_compound = nil;
	    if (of && !NUM_ERRORS)
	      [current_method compile];
	    current_method = nil;
	  }
      }
  else
    while (vars)
      {
	OTMMethod *m;

	DECONS (vars, name, vars);

	if (Q_REDO (q))
	  var = [C_EXT_SEMANTICS aliasWithName: name
				 type: type qualifiers: q];
	else
	  {
	    if (current_either != ltt_instance_state
		&& current_either != ltt_class_state)
	      {
		var = [C_EITHER_SEMANTICS searchEntityNamed: name
					  supers: YES class: YES
					  variables: YES constants: YES];
		if (var)
		  {
		    warning (@"declaration of %@ hides previous declaration",
			     name);
		    cwarning_for (var, @"%@ previously declared here", name);
		  }
	      }

	    var = [C_EXT_SEMANTICS variableWithName: name
				   type: type qualifiers: q];
	    if (is_local)
	      if (![var staticp] || ![current_either classp])
		error_for (var,
			   @"non-static or non-class variable can't be local");
	      else
		{
		  [var setIsThreadLocal];
		  [C_EITHER_SEMANTICS setThreadLocalVarsP];
		}
	  }

	if (Q_PROTECTION (q) == OQ_PUBLIC)
	  {
	    m = [CO_OTMCustomMethod methodWithExtension: C_EXT_SEMANTICS
				    name: accessor_method_name (name)
				    returnType: type flatp: NO];
	    if (Q_REDO (q) == OQ_REDECLARE)
	      [m setRedo: OQ_REDECLARE];
	    add_method_decl ((id) m);
	  }
	if (Q_MUTABLE (q))
	  {
	    m = [CO_OTMCustomMethod methodWithExtension: C_EXT_SEMANTICS
		     nameTypes: CONS (CONS (modifier_method_name (name),
				  CONS ([CO_OTMVariable variableWithName:
					      @"value" type: type], nil)), nil)
				    returnType: basic_type[BT_VOID] flatp: NO];
	    if (Q_REDO (q) == OQ_REDECLARE)
	      [m setRedo: OQ_REDECLARE];

	    add_method_decl ((id) m);
	  }
      }
}

/* Add the variables from the VARS list to the current_either with the
   indicated qualifiers and TYPE.  */
void
object_add_const (otm_qualifiers q, id <TLString> name, id value)
{
  OTMConstant *c;
  
  q = mask_qualifiers (q, OQ_PROTECTION_MASK);

  if (!current_either)
    return;

  c = [C_EXT_SEMANTICS constantWithName: name qualifiers: q value: value];
}

/* Check the super class declarations of the current meta.  */
static void
check_supers (void)
{
  if ([current_extension isMainExtension])
    {
      /* Make sure Any and State are supers.  */
      if (current_class)
	{
	  /* XXX Should search in the other direction...  */
	  if (current_class != ltt_class_state
	      && ![ltt_class_state isProperStateSub: current_class])
	    [current_class addStateSuper: ltt_class_state];
	  if (![ltt_class_any isProperSub: current_class])
	    [current_class addBehaviourSuper: ltt_class_any];

	  /* Make both the class and instance of this EITHER a superclass
             of All.  */
	  [ltt_instance_all addBehaviourSuper: current_class];
	  [ltt_instance_all addBehaviourSuper: [current_class instance]];
	}
      else if (current_instance
	       && ![ltt_instance_any isProperSub: current_instance])
	[current_instance addBehaviourSuper: ltt_instance_any];
    }
}

/* Setup everything for the interface or implementation (depends on
   DEFINITIONP) of instance or class (depending on IS_CLASS) of the
   extension EXT of the INSTANCE.  If !EXT this is the main extension.  */
static void
set_current_either (LTTInstance *instance, id <TLString> ext, int is_class,
		    id <TLString> foreign, otm_qualifiers q, int definitionp)
{
  OTMMeta *either, *counterpart;
  id <TLString> errmsg;

  current_class = nil;
  current_instance = nil;
  current_either = nil;
  current_extension = nil;

  if (!instance)
    return;

  /* We're loading a named extension.  Make sure the main extension is
     also loaded.  */
  if (ext && ![[[instance extensionNamed: nil] container] loadedInterface])
    load_interface (instance);

  q = mask_qualifiers (q, 0);

  if (is_class)
    current_either = current_class = [instance itsClass];
  else
    current_either = current_instance = instance;

  errmsg = ltt_meta_name (current_either);
  either = C_EITHER_SEMANTICS;
  counterpart = [(is_class ? (LTTMeta *) [(LTTClass *) current_either instance]
		  : (LTTMeta *) [current_either itsClass]) semantics];

  if (ext)
    {
      if (!([either declaredp] || [either definedp]
	    || [[[current_either extensionNamed: nil]
		 container] loadedInterface]))
	internal (@"interface of `%@' not found", errmsg);

      if (current_either == ltt_instance_any || current_either == ltt_class_any
	  || current_either == ltt_instance_all
	  || current_either == ltt_class_all)
	error (@"extensions of %@ not allowed", ltt_meta_name (current_either));
    }
  else
    {
      if (definitionp)
	{
	  if ([either definedp] && ![either foreign])
	    {
	      error (@"redefinition of %@", errmsg);
	      cerror_for (either, @"previous definition of %@ was here",
			  errmsg);
	    }

	  if (Q_DEFERRED (q) && [either declaredp] && ![either deferredp])
	    {
	      error (@"deferred status mismatch with interface of %@", errmsg);
	      cerror_for (either, @"previous declaration was here");
	    }
	}
      else
	{
	  if ([either declaredp])
	    error (@"redeclaration of %@", errmsg);
	  else
	    [either refreshLocation];
	}

      if (!is_class)
	{
	  /* Foreign is only allowed on a class interface.  Instance
	     interface and any implementation are not allowed.  */
	  if (foreign || [[[current_instance itsClass] semantics] foreign])
	    error (@"foreign instances are not possible");

	  /* The declaration of the class must have been seen before the
	     instance is encountered.  */
	  if (![counterpart declaredp] && ![counterpart definedp])
	    error (@"declaration of %@ should preceed %@ of %@",
		   ltt_meta_name ([counterpart structure]),
		   definitionp ? @"definition" : @"declaration",
		   ltt_meta_name (current_instance));
	}
      else
	{
	  if (foreign && ![either declaredp])
	    if (definitionp)
	      error (@"implementation of foreign class meaningless");
	    else
	      {
		[either setForeign: foreign];
		[counterpart setDeclared: YES];
	      }
	}

      if (definitionp)
	[either setDefined: YES];
      else
	[either setDeclared: YES];

      if (Q_DEFERRED (q))
	{
	  /* XXX This kind of information which is applicable to both the
	     instance and the class, should reside in the class; not in
	     both.  */
	  [either setDeferred: YES];
	  [counterpart setDeferred: YES];
	}
    }

  current_extension = [current_either extensionNamed: ext];
  if (!current_extension)
    {
      current_extension = [CO_LTTExtension extensionWithName: ext
					file: ltt_missing_file
					meta: current_either];

      error (@"inventing %@", ltt_ext_name (current_extension));
    }

  if (definitionp)
    {
      [C_EXT_SEMANTICS setDefined: YES];

      if (of)
	{
	  [extensions_output addElement: C_EXT_SEMANTICS];
	  if ([current_extension isMainExtension])
	    if (current_class)
	      {
		[C_EXT_SEMANTICS addSuper: [ltt_class_any semantics]];
		[C_EXT_SEMANTICS addSuper: [ltt_class_state semantics]];
	      }
	    else if (current_instance)
	      [C_EXT_SEMANTICS addSuper: [ltt_instance_any semantics]];
	}
    }
  else
    {
      [C_EXT_SEMANTICS setDeclared: YES];

      if (foreign)
	{
	  /* This is a class.  Set the instance declared.  */
	  [[[[counterpart structure] extensionNamed: ext]
	    semantics] setDeclared: YES];

	  /* Make sure the information on the class object in this
             interface is output.  */
	  if (of)
	    [extensions_output addElement: C_EXT_SEMANTICS];
	}
    }

  if (current_extension)
    push_report_context (formac (nil, @"in %@",
				 ltt_ext_name (current_extension)));
  else if (current_either)
    push_report_context (formac (nil, @"in %@",
				 ltt_meta_name (current_either)));
  else
    push_report_context (formac (nil, @"somewhere in `%@'", current_filename));

  in_what = definitionp ? IMPLEMENTATION_SCOPE : INTERFACE_SCOPE;
}

OTMExpr *
do_return_stmt (int kind, OTMExpr *expr)
{
  OTMExpr *r = nil;

  if (current_method)
    if (expr)
      {
	id rt = [current_method returnType];

	if (rt == basic_type[BT_VOID])
	  if (kind)
	    r = [CO_OTMReturn assignmentWithLhs: void_expr rhs: expr];
	  else
	    {
	      warning (@"setting void return value has no effect");
	      r = expr;
	    }
	else
	  {
	    OTMExpr *e = [current_method returnValue];

	    if (expr == void_expr)
	      {
		if (!e)
		  {
		    e = temp_something_with_type (rt, 0);
		    emit_assignment (e, nil_something_with_type (rt));
		    [current_method setReturnValue: e];
		  }

		/* Allow `return;' to indicate immediate return without
		   affecting the return value.  */
		expr = e;
	      }
	    else if (!e)
	      {
		e = temp_something_with_type (rt, 0);
		[current_method setReturnValue: e];
	      }

	    r = (kind == 1 ? [CO_OTMReturn assignmentWithLhs: e rhs: expr]
		 : (id) [CO_OTMAssignment assignmentWithLhs: e rhs: expr]);
	  }

	if (kind == 1)
	  [current_method setHaveReturnStatement];
      }

  return r;
}

OTMCompound *
enter_compound (void)
{
  if (current_compound || current_method)
    {
      current_compound = [CO_OTMCompound compoundWithContainer:
					 (current_compound ? current_compound
					  : (id) current_method)];
      if (![current_method body])
	[current_method setBody: current_compound];
    }

  return current_compound;
}

void
exit_compound (void)
{
  if (current_compound)
    {
      current_compound = [current_compound container];
      if (current_compound == (id) current_method)
	current_compound = nil;
    }
}

void
init_local_var (OTMVariable *v, OTMType *t, OTMExpr *expr)
{
  if (current_compound)
    {
      emit_local_var (v);
      emit_assignment (v, [resolve_expr (expr ? expr
					 : nil_something_with_type (t),
					 CONS (t, nil), nil,
					 C_EITHER_SEMANTICS) elaborate]);
      [current_compound releaseTemporaryVariables];
    }
}

OTMLocalVar *
create_local_var (id <TLString> name, OTMType *type, OTMExpr *expr)
{
  OTMLocalVar *r = [CO_OTMLocalVar variableWithName: name type: type];

  init_local_var (r, type, expr);

  return r;
}

#line 1173 "parse.y"
typedef union {
  int i;
  id v;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		477
#define	YYFLAG		-32768
#define	YYNTBASE	85

#define YYTRANSLATE(x) ((unsigned)(x) <= 314 ? yytranslate[x] : 207)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    77,     2,     2,     2,    75,    70,     2,    81,
    82,    73,    71,    61,    72,    84,    74,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    65,    60,    66,
    63,    67,    64,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    79,     2,    83,    68,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    62,    69,    80,    76,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
    57,    58,    59,    78
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     7,    10,    13,    16,    18,    19,    20,
    33,    34,    35,    36,    50,    51,    52,    65,    66,    67,
    68,    82,    83,    84,    89,    90,    94,    98,   103,   109,
   111,   113,   115,   117,   119,   121,   123,   125,   127,   129,
   131,   136,   141,   145,   147,   151,   152,   155,   157,   160,
   164,   169,   171,   176,   181,   182,   184,   187,   188,   191,
   194,   197,   200,   201,   205,   206,   207,   215,   216,   218,
   219,   222,   225,   228,   231,   234,   237,   240,   243,   247,
   251,   252,   255,   256,   259,   260,   262,   264,   267,   271,
   277,   279,   282,   284,   286,   288,   290,   292,   294,   296,
   298,   300,   302,   304,   306,   308,   310,   312,   314,   316,
   318,   320,   322,   324,   326,   328,   330,   332,   334,   336,
   338,   340,   342,   344,   346,   348,   350,   352,   354,   356,
   358,   360,   362,   364,   368,   369,   371,   374,   378,   380,
   381,   384,   385,   390,   391,   396,   397,   399,   401,   404,
   406,   409,   411,   413,   414,   419,   421,   423,   424,   428,
   430,   434,   436,   440,   441,   442,   443,   451,   452,   455,
   456,   463,   464,   465,   471,   472,   473,   485,   488,   490,
   492,   494,   498,   501,   504,   507,   510,   514,   518,   523,
   528,   529,   531,   532,   533,   536,   538,   540,   542,   544,
   547,   549,   551,   553,   555,   557,   559,   561,   563,   564,
   569,   570,   571,   577,   581,   585,   587,   591,   593,   596,
   598,   601,   603,   605,   608,   611,   614,   617,   621,   625,
   629,   633,   637,   641,   645,   649,   653,   657,   661,   665,
   669,   673,   677,   681,   685,   689,   693,   697,   703,   708,
   710,   712,   714,   716,   718,   720,   722,   724,   726,   731,
   736,   741,   746,   749,   751,   754,   758,   760,   762,   767,
   772,   777,   785,   788,   792,   794,   796,   798,   801,   804,
   808,   812,   814,   815,   819,   822,   824,   828,   830,   832,
   834,   836,   838,   840,   842,   844,   846,   850,   854,   856,
   858,   862,   864
};

static const short yyrhs[] = {    -1,
    85,    86,     0,    87,   199,     0,    94,   199,     0,    90,
   199,     0,    97,   199,     0,    59,     0,     0,     0,     9,
   124,   125,     3,   202,   115,    88,   112,    89,   101,   117,
     4,     0,     0,     0,     0,     7,   124,   125,     3,   202,
   115,    91,   112,    92,   101,    93,   136,     4,     0,     0,
     0,     9,   124,   125,     8,   202,   115,    95,   112,    96,
   101,   117,     4,     0,     0,     0,     0,     7,   124,   125,
     8,   202,   115,    98,   112,    99,   101,   100,   136,     4,
     0,     0,     0,    62,   102,   103,    80,     0,     0,   103,
   104,   199,     0,   125,   105,   198,     0,    14,   125,   105,
   198,     0,   125,    13,    55,    63,   175,     0,    58,     0,
   110,     0,   109,     0,    49,     0,    37,     0,   105,     0,
    37,     0,   105,     0,   105,     0,   203,     0,    11,     0,
     3,    81,   109,    82,     0,     8,    81,   109,    82,     0,
    81,   111,    82,     0,   108,     0,   111,    61,   108,     0,
     0,    65,   113,     0,   114,     0,    10,   114,     0,   113,
    61,   114,     0,   113,    61,    10,   114,     0,   205,     0,
     8,    81,   205,    82,     0,     3,    81,   205,    82,     0,
     0,   116,     0,     5,   206,     0,     0,   117,   118,     0,
   117,   137,     0,   117,     1,     0,   121,   199,     0,     0,
   121,   120,   138,     0,     0,     0,   122,   125,   124,   126,
   123,   127,   128,     0,     0,     6,     0,     0,   125,    30,
     0,   125,    31,     0,   125,    29,     0,   125,    32,     0,
   125,    33,     0,   125,    26,     0,   125,    28,     0,   125,
    27,     0,   106,   129,   133,     0,   106,   129,   130,     0,
     0,    24,   185,     0,     0,    25,   185,     0,     0,   135,
     0,   131,     0,   130,   131,     0,   132,   107,   134,     0,
   132,   107,   134,    63,   175,     0,   133,     0,   133,    65,
     0,    65,     0,    55,     0,    35,     0,     3,     0,    34,
     0,     4,     0,     5,     0,     6,     0,     7,     0,     8,
     0,     9,     0,    14,     0,    10,     0,    11,     0,    12,
     0,    13,     0,    16,     0,    17,     0,    18,     0,    19,
     0,    20,     0,    21,     0,    22,     0,    23,     0,    26,
     0,    27,     0,    28,     0,    29,     0,    30,     0,    31,
     0,    32,     0,    33,     0,    37,     0,    48,     0,    36,
     0,    49,     0,    50,     0,    58,     0,    57,     0,    55,
     0,   135,     0,    81,   198,    82,     0,     0,   137,     0,
   136,   119,     0,    48,   105,    55,     0,   199,     0,     0,
   139,   140,     0,     0,    62,   141,   144,    80,     0,     0,
    62,   143,   144,    80,     0,     0,   145,     0,   146,     0,
   145,   146,     0,   147,     0,   150,   199,     0,    59,     0,
   148,     0,     0,   149,    62,   144,    80,     0,   174,     0,
   199,     0,     0,   105,   151,   152,     0,   153,     0,   152,
    61,   153,     0,    55,     0,    55,    63,   175,     0,     0,
     0,     0,    16,   155,   196,   156,   148,   157,   158,     0,
     0,    17,   148,     0,     0,    18,   160,   146,    20,   196,
   199,     0,     0,     0,    20,   162,   196,   163,   146,     0,
     0,     0,    19,    81,   172,   199,   165,   171,   199,   166,
   172,    82,   146,     0,   168,   175,     0,   168,     0,    63,
     0,    23,     0,   186,    63,   175,     0,    51,   186,     0,
   186,    51,     0,    52,   186,     0,   186,    52,     0,   186,
    53,   175,     0,   170,    63,   175,     0,   175,    79,   197,
    83,     0,   175,    79,     1,    83,     0,     0,   175,     0,
     0,     0,   173,   176,     0,   154,     0,   164,     0,   159,
     0,   161,     0,   175,   199,     0,   185,     0,   169,     0,
   167,     0,   184,     0,   183,     0,   177,     0,   175,     0,
   142,     0,     0,    34,   181,   178,   175,     0,     0,     0,
    35,   179,   181,   180,   175,     0,    36,   181,   175,     0,
    81,   182,    82,     0,   176,     0,   182,    60,   176,     0,
    21,     0,    21,   175,     0,    22,     0,    22,   175,     0,
   186,     0,   170,     0,    72,   175,     0,    76,   175,     0,
    77,   175,     0,    15,   175,     0,   175,    73,   175,     0,
   175,    74,   175,     0,   175,    75,   175,     0,   175,    71,
   175,     0,   175,    72,   175,     0,   175,    45,   175,     0,
   175,    46,   175,     0,   175,    47,   175,     0,   175,    70,
   175,     0,   175,    69,   175,     0,   175,    68,   175,     0,
   175,    66,   175,     0,   175,    40,   175,     0,   175,    38,
   175,     0,   175,    41,   175,     0,   175,    39,   175,     0,
   175,    67,   175,     0,   175,    42,   175,     0,   175,    43,
   175,     0,   175,    44,   175,     0,   175,    64,   175,    65,
   175,     0,   175,    64,   175,     1,     0,    56,     0,   187,
     0,    55,     0,    49,     0,    50,     0,   196,     0,   192,
     0,   188,     0,    54,     0,   191,    81,   175,    82,     0,
   191,    81,    12,    82,     0,   191,    81,   189,    82,     0,
   191,    81,     1,    82,     0,   106,   190,     0,   132,     0,
   132,   107,     0,   132,   107,   190,     0,   109,     0,    58,
     0,    79,   176,   193,   201,     0,    79,   203,   193,   201,
     0,    79,    12,   193,   201,     0,    79,    12,    81,   109,
   200,   193,   201,     0,    55,   196,     0,    79,     1,    83,
     0,   132,     0,   194,     0,   195,     0,   194,   195,     0,
   132,   175,     0,    81,   197,    82,     0,    81,     1,    82,
     0,   176,     0,     0,   197,    61,   176,     0,   197,    61,
     0,    55,     0,   198,    61,    55,     0,    60,     0,     1,
     0,    82,     0,     1,     0,    83,     0,     1,     0,   204,
     0,   204,     0,    57,     0,    57,    84,    57,     0,    55,
    84,    57,     0,   203,     0,    55,     0,    55,    84,    55,
     0,    55,     0,    57,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
  1239,  1241,  1244,  1246,  1247,  1248,  1249,  1256,  1263,  1267,
  1274,  1281,  1285,  1289,  1299,  1306,  1310,  1317,  1324,  1328,
  1332,  1342,  1344,  1348,  1351,  1353,  1356,  1362,  1367,  1380,
  1382,  1383,  1386,  1388,  1389,  1392,  1394,  1397,  1404,  1409,
  1413,  1417,  1423,  1433,  1438,  1444,  1446,  1449,  1454,  1458,
  1462,  1468,  1470,  1474,  1480,  1482,  1485,  1489,  1491,  1492,
  1493,  1499,  1507,  1515,  1523,  1528,  1561,  1567,  1569,  1575,
  1577,  1588,  1594,  1600,  1606,  1612,  1618,  1624,  1632,  1639,
  1648,  1650,  1657,  1659,  1666,  1668,  1671,  1673,  1679,  1685,
  1692,  1694,  1699,  1705,  1707,  1708,  1709,  1710,  1711,  1712,
  1713,  1714,  1715,  1716,  1717,  1718,  1719,  1720,  1721,  1722,
  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,  1732,
  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,
  1743,  1750,  1752,  1755,  1762,  1764,  1765,  1768,  1775,  1792,
  1809,  1811,  1833,  1843,  1848,  1855,  1860,  1863,  1865,  1868,
  1879,  1899,  1903,  1909,  1913,  1918,  1919,  1927,  1933,  1938,
  1940,  1946,  1951,  1957,  1963,  1967,  1971,  1977,  1982,  1988,
  1994,  2004,  2011,  2015,  2022,  2030,  2034,  2054,  2059,  2065,
  2067,  2070,  2075,  2081,  2087,  2093,  2099,  2104,  2114,  2121,
  2128,  2133,  2136,  2141,  2146,  2155,  2157,  2158,  2159,  2160,
  2163,  2165,  2166,  2167,  2168,  2169,  2172,  2174,  2177,  2193,
  2198,  2215,  2221,  2229,  2250,  2257,  2262,  2268,  2273,  2279,
  2284,  2290,  2292,  2300,  2304,  2308,  2312,  2316,  2320,  2324,
  2328,  2332,  2336,  2340,  2344,  2348,  2352,  2356,  2360,  2364,
  2368,  2372,  2376,  2380,  2384,  2388,  2392,  2396,  2400,  2406,
  2408,  2409,  2445,  2449,  2453,  2454,  2455,  2458,  2469,  2488,
  2493,  2500,  2507,  2538,  2543,  2547,  2553,  2555,  2558,  2563,
  2568,  2573,  2579,  2585,  2592,  2594,  2597,  2599,  2605,  2612,
  2622,  2629,  2635,  2640,  2645,  2652,  2657,  2663,  2665,  2671,
  2673,  2679,  2681,  2687,  2691,  2702,  2707,  2713,  2719,  2721,
  2727,  2743,  2745
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","CLASS",
"END","EXTENSION","EXTERN","IMPLEMENTATION","INSTANCE","INTERFACE","POSING",
"RECEIVER","SUPER","CONST","LOCAL","OLD","IF","ELSE","DO","FOR","WHILE","BREAK",
"CONTINUE","RETURN","PRE","POST","PUBLIC","PRIVATE","PROTECTED","MUTABLE","STATIC",
"DEFERRED","REDEFINE","REDECLARE","CATCH","BIND","UNWIND","DYNAMIC","EQ","GE",
"LE","NE","AND","OR","IMPLIES","SHL","SHR","LSR","TYPEDEF","VOID","NIL","PLUSPLUS",
"MINMIN","ASSIGN","STRING_CST","IDENTIFIER","NUMBER","TYPE","BASIC_TYPE","C_LITERAL",
"';'","','","'{'","'='","'?'","':'","'<'","'>'","'^'","'|'","'&'","'+'","'-'",
"'*'","'/'","'%'","'~'","'!'","UNARY_MINUS","'['","'}'","'('","')'","']'","'.'",
"file","file_element","class_interface","@1","@2","class_implementation","@3",
"@4","@5","instance_interface","@6","@7","instance_implementation","@8","@9",
"@10",".object_variables.","@11","object_variables","object_variable","entity_type",
"return_type","argument_type","tuple_elt_type","object_type","tuple_type","tuple_type_field_list",
".colon_super_list.","super_list","super_indication",".extension.","extension",
"decl_list","annotated_method_decl","method_def","@12","shared_method_part",
"@13","@14",".foreign.",".qualifiers.","method_decl",".pre.",".post.",".return_value_name.",
"method_decl_parts","method_decl_part","method_name_part","bare_method_name_part",
"argument_name","tuple_argument_name","def_list","typedef","method_body","@15",
"method_body_expression","@16","compound","@17","top_expression_list","ne_top_expression_list",
"top_expression","actual_top_expression","top_expr","@18","local_var","@19",
"local_var_decl_list","local_var_decl","if_stmt","@20","@21","@22",".if_else.",
"do_stmt","@23","while_stmt","@24","@25","for_stmt","@26","@27","return_stmt",
"return_stmt_kind","assign_stmt","array_reference",".expr.",".compounded_expr.",
"@28","expr_sc","expr","expr_or_compound","special_form","@29","@30","@31","expr_sequence",
"expr_sequence_elts","break_stmt","continue_stmt","simple_expr","atom","string_cst",
"type_cast","selector_decl","selector_name_parts","type_cast_type","method_invocation",
"rest_of_method_invocation","method_invocation_parts","method_invocation_part",
"tuple","tuple_field_list","identifier_list","semicolon","close_paren","close_bracket",
"new_class_name","class_name","resolved_class_name","missing_class_name","extension_name", NULL
};
#endif

static const short yyr1[] = {     0,
    85,    85,    86,    86,    86,    86,    86,    88,    89,    87,
    91,    92,    93,    90,    95,    96,    94,    98,    99,   100,
    97,   101,   102,   101,   103,   103,   104,   104,   104,   105,
   105,   105,   106,   106,   106,   107,   107,   108,   109,   109,
   109,   109,   110,   111,   111,   112,   112,   113,   113,   113,
   113,   114,   114,   114,   115,   115,   116,   117,   117,   117,
   117,   118,   120,   119,   122,   123,   121,   124,   124,   125,
   125,   125,   125,   125,   125,   125,   125,   125,   126,   126,
   127,   127,   128,   128,   129,   129,   130,   130,   131,   131,
   132,   132,   132,   133,   133,   133,   133,   133,   133,   133,
   133,   133,   133,   133,   133,   133,   133,   133,   133,   133,
   133,   133,   133,   133,   133,   133,   133,   133,   133,   133,
   133,   133,   133,   133,   133,   133,   133,   133,   133,   133,
   133,   134,   134,   135,   136,   136,   136,   137,   138,   139,
   138,   141,   140,   143,   142,   144,   144,   145,   145,   146,
   147,   147,   147,   149,   148,   148,   148,   151,   150,   152,
   152,   153,   153,   155,   156,   157,   154,   158,   158,   160,
   159,   162,   163,   161,   165,   166,   164,   167,   167,   168,
   168,   169,   169,   169,   169,   169,   169,   169,   170,   170,
   171,   171,   172,   173,   172,   174,   174,   174,   174,   174,
   175,   175,   175,   175,   175,   175,   176,   176,   178,   177,
   179,   180,   177,   177,   181,   182,   182,   183,   183,   184,
   184,   185,   185,   185,   185,   185,   185,   185,   185,   185,
   185,   185,   185,   185,   185,   185,   185,   185,   185,   185,
   185,   185,   185,   185,   185,   185,   185,   185,   185,   186,
   186,   186,   186,   186,   186,   186,   186,   187,   188,   188,
   188,   188,   189,   190,   190,   190,   191,   191,   192,   192,
   192,   192,   192,   192,   193,   193,   194,   194,   195,   196,
   196,   197,   197,   197,   197,   198,   198,   199,   199,   200,
   200,   201,   201,   202,   203,   204,   204,   204,   205,   205,
   205,   206,   206
};

static const short yyr2[] = {     0,
     0,     2,     2,     2,     2,     2,     1,     0,     0,    12,
     0,     0,     0,    13,     0,     0,    12,     0,     0,     0,
    13,     0,     0,     4,     0,     3,     3,     4,     5,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     4,     4,     3,     1,     3,     0,     2,     1,     2,     3,
     4,     1,     4,     4,     0,     1,     2,     0,     2,     2,
     2,     2,     0,     3,     0,     0,     7,     0,     1,     0,
     2,     2,     2,     2,     2,     2,     2,     2,     3,     3,
     0,     2,     0,     2,     0,     1,     1,     2,     3,     5,
     1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     3,     0,     1,     2,     3,     1,     0,
     2,     0,     4,     0,     4,     0,     1,     1,     2,     1,
     2,     1,     1,     0,     4,     1,     1,     0,     3,     1,
     3,     1,     3,     0,     0,     0,     7,     0,     2,     0,
     6,     0,     0,     5,     0,     0,    11,     2,     1,     1,
     1,     3,     2,     2,     2,     2,     3,     3,     4,     4,
     0,     1,     0,     0,     2,     1,     1,     1,     1,     2,
     1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
     0,     0,     5,     3,     3,     1,     3,     1,     2,     1,
     2,     1,     1,     2,     2,     2,     2,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     5,     4,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
     4,     4,     2,     1,     2,     3,     1,     1,     4,     4,
     4,     7,     2,     3,     1,     1,     1,     2,     2,     3,
     3,     1,     0,     3,     2,     1,     3,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     3,     3,     1,     1,
     3,     1,     1
};

static const short yydefact[] = {     1,
     0,    68,    68,     7,     2,     0,     0,     0,     0,    69,
    70,    70,   289,   288,     3,     5,     4,     6,     0,     0,
     0,     0,    76,    78,    77,    73,    71,    72,    74,    75,
     0,     0,     0,   296,    55,   294,    55,    55,    55,     0,
     0,     0,    11,    56,    18,     8,    15,   298,   297,   302,
   303,    57,    46,    46,    46,    46,     0,    12,    19,     9,
    16,     0,     0,     0,   300,    47,    48,   299,   295,    52,
    22,    22,    22,    22,     0,     0,    49,     0,     0,    23,
    13,    20,    58,    58,     0,     0,   301,     0,    50,    25,
   135,   135,     0,     0,    54,    53,    51,    70,     0,    65,
   136,    65,    61,    10,    59,     0,    70,    60,    17,    70,
    24,     0,     0,     0,     0,    40,    30,     0,     0,    32,
    31,    39,    14,   137,    63,    21,    62,    68,     0,    26,
     0,     0,     0,     0,    38,    44,     0,   138,     0,     0,
     0,     0,   286,    27,     0,     0,     0,    43,    64,     0,
   139,    34,    33,    35,    85,    66,    28,     0,     0,    41,
    42,    45,   142,   141,     0,     0,    86,    81,     0,   218,
   220,   181,     0,   211,     0,   253,   254,     0,     0,   258,
   252,   250,   268,   180,     0,     0,     0,     0,     0,   267,
   203,   179,   202,   223,    29,   206,   205,   204,   201,   222,
   251,   257,     0,   256,   255,   287,     0,     0,    96,    98,
    99,   100,   101,   102,   103,   105,   106,   107,   108,   104,
   109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
   119,   120,   121,   122,   123,   124,    97,    95,   127,   125,
   126,   128,   129,    94,   131,   130,    93,    80,    87,     0,
    91,     0,    83,   227,   219,   221,     0,   209,     0,     0,
   183,   185,   273,   224,   225,   226,     0,     0,   144,   208,
   207,     0,    39,     0,   282,     0,   178,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   184,   186,     0,     0,     0,   164,   170,     0,   172,    30,
   152,     0,   158,    32,     0,     0,   148,   150,   153,     0,
     0,   196,   198,   199,   197,   156,     0,   157,   134,    88,
    91,    36,    37,     0,    92,     0,   201,     0,    67,   216,
     0,     0,   212,   214,   274,     0,   275,     0,   276,   277,
     0,     0,     0,   281,   285,   280,   188,   241,   243,   240,
   242,   245,   246,   247,   233,   234,   235,     0,   239,   244,
   238,   237,   236,   231,   232,   228,   229,   230,     0,     0,
   187,   182,     0,     0,    33,     0,     0,     0,     0,     0,
   194,     0,     0,   143,   149,     0,   151,   200,   132,    89,
   133,   201,     0,   215,   210,     0,     0,   279,   293,   292,
   271,     0,   278,     0,   269,   270,   284,   249,     0,   190,
   189,   262,   260,   264,   263,   259,   261,   165,     0,     0,
     0,   173,   162,   159,   160,     0,     0,   217,   213,   291,
   290,     0,   145,   248,   265,     0,     0,   175,   195,     0,
     0,     0,   155,    90,     0,   266,   166,     0,   191,   174,
   163,   161,   272,   168,   171,     0,   192,     0,   167,   176,
   169,   194,     0,     0,   177,     0,     0
};

static const short yydefgoto[] = {     1,
     5,     6,    55,    73,     7,    53,    71,    91,     8,    56,
    74,     9,    54,    72,    92,    81,    90,    98,   112,   313,
   155,   334,   136,   190,   121,   137,    58,    66,    67,    43,
    44,    93,   105,   124,   139,   106,   107,   168,    11,    19,
   156,   253,   339,   166,   248,   249,   347,   331,   400,   167,
   100,   101,   149,   150,   164,   207,   270,   351,   315,   316,
   317,   318,   319,   320,   321,   393,   434,   435,   322,   389,
   446,   464,   469,   323,   390,   324,   392,   450,   325,   459,
   472,   191,   192,   193,   194,   466,   430,   431,   326,   327,
   275,   196,   342,   259,   406,   258,   341,   197,   198,   199,
   200,   201,   202,   388,   425,   203,   204,   348,   349,   350,
   205,   276,   144,   328,   442,   411,    35,   122,    69,    70,
    52
};

static const short yypact[] = {-32768,
    59,    51,    51,-32768,-32768,    32,    32,    32,    32,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   388,   439,
   -29,   -29,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
   -29,   -29,    43,    66,    92,-32768,    92,    92,    92,    73,
   105,    69,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,   137,   137,   137,   137,   141,-32768,-32768,-32768,
-32768,   123,   125,   205,   128,   148,-32768,-32768,-32768,-32768,
   158,   158,   158,   158,    91,    91,-32768,   102,   144,-32768,
-32768,-32768,-32768,-32768,   151,   152,-32768,   205,-32768,-32768,
   178,   178,   897,   932,-32768,-32768,-32768,     1,   250,   226,
-32768,   233,-32768,-32768,-32768,    32,-32768,-32768,-32768,-32768,
-32768,    32,  1166,   157,   165,-32768,-32768,   250,   202,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   451,  1263,-32768,
   204,   209,   150,   150,-32768,-32768,   -17,-32768,    20,   192,
   209,   185,-32768,   191,   199,   200,   250,-32768,-32768,   212,
-32768,-32768,-32768,-32768,   194,-32768,   191,  1099,   229,-32768,
-32768,-32768,-32768,-32768,   209,  1319,-32768,   265,  1099,  1099,
  1099,-32768,   215,-32768,   215,-32768,-32768,    29,    29,-32768,
   -54,-32768,-32768,-32768,  1099,  1099,  1099,   776,   377,-32768,
-32768,  1099,-32768,   230,  1392,-32768,-32768,-32768,-32768,   227,
-32768,-32768,   217,-32768,-32768,-32768,   512,    56,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,  1319,-32768,   228,
    74,  1099,   275,   224,  1392,  1392,  1036,-32768,   215,  1099,
-32768,-32768,-32768,   224,   224,   224,   237,   988,-32768,-32768,
  1392,  1319,  1319,   242,-32768,    61,  1392,  1099,  1099,  1099,
  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,
  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,   291,
-32768,-32768,  1099,  1099,   839,-32768,-32768,   247,-32768,   254,
-32768,   440,-32768,   269,   231,   579,-32768,-32768,-32768,   248,
    32,-32768,-32768,-32768,-32768,-32768,  1143,-32768,-32768,-32768,
   286,-32768,-32768,   -14,-32768,  1392,    63,  1099,-32768,-32768,
     9,  1099,-32768,  1392,-32768,   150,  1099,    13,  1319,-32768,
   512,    13,    13,-32768,  1036,-32768,  1392,  1333,  1333,  1333,
  1333,  1462,  1448,  1406,   435,   435,   435,  1190,  1333,  1333,
   197,   287,   330,   244,   244,   224,   224,   224,   273,    46,
  1392,  1392,   282,   289,  1347,  1319,  1237,   302,   284,   646,
    41,   284,   314,-32768,-32768,   512,-32768,-32768,-32768,   310,
-32768,    49,  1036,-32768,  1392,  1099,    21,  1392,-32768,-32768,
-32768,  1099,-32768,   306,-32768,-32768,-32768,-32768,  1099,-32768,
-32768,-32768,-32768,   228,-32768,-32768,-32768,-32768,   367,    32,
  1036,-32768,   326,   329,-32768,   313,  1099,-32768,  1392,-32768,
-32768,  1319,-32768,  1392,  1319,   713,   284,-32768,-32768,   646,
  1099,   314,-32768,  1392,    13,-32768,-32768,    32,  1099,-32768,
  1392,-32768,-32768,   378,-32768,    32,  1392,   713,-32768,-32768,
-32768,   312,   315,   646,-32768,   406,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,   -11,-32768,-32768,-32768,   -94,
   103,    -2,   260,   -95,-32768,-32768,   283,-32768,    40,   344,
-32768,   339,-32768,-32768,-32768,    14,-32768,-32768,     3,    -5,
-32768,-32768,-32768,-32768,-32768,   162,  -158,   259,-32768,    96,
   345,    27,-32768,-32768,-32768,-32768,-32768,-32768,  -320,-32768,
  -258,-32768,  -333,-32768,-32768,-32768,-32768,   -16,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,   -27,-32768,-32768,  -115,
  -168,-32768,-32768,-32768,-32768,  -165,-32768,-32768,-32768,  -243,
   -38,-32768,-32768,-32768,    -1,-32768,-32768,  -256,-32768,    97,
  -170,   164,  -116,    -6,-32768,  -340,   223,   -28,   193,   118,
-32768
};


#define	YYLAST		1541


static const short yytable[] = {    15,
    16,    17,    18,   120,   119,    12,    20,   250,   337,   260,
   263,   415,   416,   409,   110,   352,   353,   120,   132,   272,
    13,   440,   120,   135,   157,    33,   189,    34,    68,    40,
   414,   114,    13,   120,   141,    68,   115,   145,   146,   116,
   399,  -193,   195,   147,   120,   154,    68,    68,   208,   -84,
    68,   120,   135,   254,   255,   256,    10,   395,   476,    68,
    82,    83,    84,   -82,   148,     2,   165,     3,   403,   264,
   265,   266,   271,   271,   -79,   436,   277,   176,   177,    14,
   111,  -140,   180,   181,   182,    34,   183,   -82,   340,   250,
   404,    14,   113,   343,   402,   410,    42,   -79,   -79,   127,
  -193,   128,   441,    77,   129,   130,   355,   188,   -84,   189,
   -84,   314,   457,   125,   463,   125,   159,     4,    89,   108,
   108,   355,   -82,    50,   -82,    51,    40,    97,   421,    48,
   140,   429,   151,   -79,   471,   -79,   336,   329,   335,   261,
   262,   271,   356,    62,   344,    65,    62,    34,    63,    41,
    64,    63,   114,    88,   120,   333,    87,   115,    48,   273,
   116,    49,   357,   358,   359,   360,   361,   362,   363,   364,
   365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
   375,   376,   377,   378,   271,   455,   417,   381,   382,   387,
   412,   460,    85,    86,   114,    65,   271,    34,    65,   115,
    34,    57,   116,    75,    33,    76,    34,    62,    79,   314,
   154,    78,    63,    36,    36,   475,   314,   135,   428,    80,
   314,   432,   336,    36,    36,    99,   405,   424,   152,   123,
   114,   408,    95,    96,   438,   115,   126,   133,   116,   271,
   153,   286,   287,   288,    37,   134,    33,   158,    34,   117,
   407,   159,   114,    38,    39,   314,   138,   115,   142,    65,
   116,    34,   449,   143,   332,   293,   294,   295,   296,   297,
   298,   299,   118,   163,   165,   300,   458,   301,   302,   303,
   160,   161,    33,   206,    34,   117,   424,   271,   252,   304,
   439,   379,   278,   114,   314,   257,   408,   305,   115,   338,
   314,   116,   300,   444,    33,   169,    34,   117,   118,   396,
   394,   170,   171,   172,   397,   271,   297,   298,   299,   345,
   398,   454,   300,   354,   173,   174,   175,   391,   120,   333,
   118,   286,   287,   288,  -268,   461,    59,    60,    61,   176,
   177,   178,   179,   467,   180,   181,   182,    34,   183,  -267,
   335,  -283,   269,   184,   314,   420,   294,   295,   296,   297,
   298,   299,   185,   422,   189,   300,   186,   187,   433,   188,
   423,   189,   437,  -283,   286,   287,   288,   274,   314,   114,
    45,    46,    47,   427,   115,   443,   447,   116,   451,   452,
    21,   169,   453,  -193,   468,    22,   474,   170,   171,   172,
   295,   296,   297,   298,   299,   477,   162,   386,   300,   330,
   173,   174,   175,    23,    24,    25,    26,    27,    28,    29,
    30,   445,    94,   448,   251,   176,   177,   178,   179,   401,
   180,   181,   182,    34,   183,   462,   102,  -283,   269,   184,
   274,    31,   114,   456,   473,   413,    32,   115,   185,     0,
   116,   465,   186,   187,   169,   188,    10,   189,  -283,   470,
   170,   171,   172,   380,    23,    24,    25,    26,    27,    28,
    29,    30,     0,   173,   174,   175,    23,    24,    25,    26,
    27,    28,    29,    30,     0,     0,     0,     0,   176,   177,
   178,   179,     0,   180,   181,   182,    34,   310,     0,     0,
  -283,   269,   184,     0,     0,   295,   296,   297,   298,   299,
     0,   185,    13,   300,   114,   186,   187,     0,   188,   115,
   312,  -283,   116,     0,     0,     0,   169,   306,     0,   307,
   308,   309,   170,   171,   172,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   173,   174,   175,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   176,   177,   178,   179,     0,   180,   181,   182,    34,   310,
   311,    14,     0,  -154,   184,     0,     0,     0,     0,    13,
     0,   114,     0,   185,     0,     0,   115,   186,   187,   116,
   188,  -146,   312,   169,   306,     0,   307,   308,   309,   170,
   171,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   173,   174,   175,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   176,   177,   178,
   179,     0,   180,   181,   182,    34,   310,   311,    14,     0,
  -154,   184,     0,     0,     0,     0,    13,     0,   114,     0,
   185,     0,     0,   115,   186,   187,   116,   188,  -147,   312,
   169,   306,     0,   307,   308,   309,   170,   171,   172,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   173,
   174,   175,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   176,   177,   178,   179,     0,   180,
   181,   182,    34,   310,   311,    14,     0,  -154,   184,     0,
     0,     0,     0,    13,     0,   114,     0,   185,     0,     0,
   115,   186,   187,   116,   188,     0,   312,   169,   306,     0,
   307,   308,   309,   170,   171,   172,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   173,   174,   175,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   176,   177,   178,   179,     0,   180,   181,   182,    34,
   183,     0,    14,     0,  -154,   184,   267,     0,   114,     0,
     0,     0,     0,   115,   185,     0,   116,   268,   186,   187,
   169,   188,     0,   189,     0,     0,   170,   171,   172,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   173,
   174,   175,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   176,   177,   178,   179,     0,   180,
   181,   182,    34,   183,     0,     0,     0,   269,   184,   383,
     0,   114,     0,     0,     0,     0,   115,   185,     0,   116,
   384,   186,   187,   169,   188,     0,   189,     0,     0,   170,
   171,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   173,   174,   175,   152,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   385,   177,   178,
   179,     0,   180,   181,   182,    34,   310,   103,     0,   -65,
   104,   184,   -65,     0,   -65,     0,     0,   -65,     0,     0,
   185,     0,     0,     0,   186,   187,     0,   188,     0,   312,
     0,     0,   -65,   -65,   -65,   -65,   -65,   -65,   -65,   -65,
     0,     0,   103,   -65,   -65,   109,     0,   -65,     0,   -65,
     0,     0,   -65,     0,    99,   -65,     0,     0,     0,     0,
     0,   -65,     0,   -65,   -65,     0,     0,   -65,   -65,   -65,
   -65,   -65,   -65,   -65,   -65,     0,     0,     0,   -65,     0,
     0,     0,     0,     0,     0,     0,     0,   -65,     0,    99,
   -65,     0,     0,     0,     0,     0,   -65,     0,   -65,   -65,
   209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
   219,   220,     0,   221,   222,   223,   224,   225,   226,   227,
   228,     0,   -65,   229,   230,   231,   232,   233,   234,   235,
   236,   237,   238,   239,   240,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   241,   242,   243,   114,     0,
     0,     0,   244,   115,   245,   246,   116,     0,     0,     0,
   169,     0,   247,     0,     0,     0,   170,   171,   172,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   346,   173,
   174,   175,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   176,   177,   178,   179,     0,   180,
   181,   182,    34,   183,     0,     0,     0,   269,   184,     0,
     0,   114,     0,     0,     0,     0,   115,   185,     0,   116,
     0,   186,   187,   169,   188,     0,   189,     0,     0,   170,
   171,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   173,   174,   175,     0,     0,     0,     0,     0,
     0,     0,     0,    13,     0,     0,     0,   176,   177,   178,
   179,     0,   180,   181,   182,    34,   183,     0,     0,     0,
     0,   184,     0,     0,     0,     0,     0,     0,   114,     0,
   185,     0,     0,   115,   186,   187,   116,   188,   131,   189,
   279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
   418,    23,    24,    25,    26,    27,    28,    29,    30,     0,
     0,     0,    14,     0,     0,     0,   289,     0,   290,   291,
   292,   293,   294,   295,   296,   297,   298,   299,     0,     0,
    33,   300,    34,   117,     0,     0,     0,   279,   280,   281,
   282,   283,   284,   285,   286,   287,   288,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   118,     0,     0,     0,
     0,     0,     0,   289,   419,   290,   291,   292,   293,   294,
   295,   296,   297,   298,   299,   114,     0,     0,   300,     0,
   115,     0,     0,   116,   279,   280,   281,   282,   283,   284,
   285,   286,   287,   288,     0,     0,     0,     0,    23,    24,
    25,    26,    27,    28,    29,    30,     0,     0,     0,     0,
   289,     0,   290,   291,   292,   293,   294,   295,   296,   297,
   298,   299,     0,     0,     0,   300,     0,    33,   426,    34,
   117,   209,   210,   211,   212,   213,   214,   215,   216,   217,
   218,   219,   220,     0,   221,   222,   223,   224,   225,   226,
   227,   228,     0,   118,   229,   230,   231,   232,   233,   234,
   235,   236,   237,   238,   239,   240,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   241,   242,   243,     0,
     0,     0,     0,   244,     0,   245,   246,   286,   287,   288,
     0,     0,     0,   247,  -253,  -253,  -253,  -253,  -253,  -253,
  -253,  -253,  -253,  -253,     0,     0,     0,  -253,  -253,  -253,
   292,   293,   294,   295,   296,   297,   298,   299,     0,  -253,
  -253,   300,  -253,  -253,  -253,  -253,  -253,  -253,  -253,  -253,
  -253,  -253,     0,     0,     0,  -253,     0,     0,  -253,   279,
   280,   281,   282,   283,   284,   285,   286,   287,   288,     0,
     0,     0,     0,   279,   280,   281,   282,   283,   284,     0,
   286,   287,   288,     0,     0,   289,     0,   290,   291,   292,
   293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
   300,   290,   291,   292,   293,   294,   295,   296,   297,   298,
   299,     0,     0,     0,   300,   279,   280,   281,   282,   283,
     0,     0,   286,   287,   288,     0,     0,     0,     0,   279,
   280,   281,   282,     0,     0,     0,   286,   287,   288,     0,
     0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
   297,   298,   299,     0,     0,     0,   300,   290,   291,   292,
   293,   294,   295,   296,   297,   298,   299,     0,     0,     0,
   300
};

static const short yycheck[] = {     6,
     7,     8,     9,    99,    99,     3,    12,   166,   252,   175,
   181,   352,   353,     1,    14,   272,   273,   113,   113,   188,
     1,     1,   118,   118,   141,    55,    81,    57,    57,    84,
   351,     3,     1,   129,   129,    64,     8,   133,   134,    11,
    55,     1,   158,    61,   140,   140,    75,    76,   165,     1,
    79,   147,   147,   169,   170,   171,     6,   316,     0,    88,
    72,    73,    74,     1,    82,     7,    81,     9,    60,   185,
   186,   187,   188,   189,     1,   396,   192,    49,    50,    60,
    80,    62,    54,    55,    56,    57,    58,    25,   257,   248,
    82,    60,    98,   259,   338,    83,     5,    24,    25,   106,
    60,   107,    82,    64,   110,   112,    61,    79,    60,    81,
    62,   207,   446,   100,   455,   102,    61,    59,    79,    93,
    94,    61,    60,    55,    62,    57,    84,    88,    83,    57,
   128,   390,   139,    60,   468,    62,   252,    82,    65,   178,
   179,   257,    82,     3,   260,    55,     3,    57,     8,    84,
    10,     8,     3,    10,   250,   250,    55,     8,    57,   188,
    11,    57,   278,   279,   280,   281,   282,   283,   284,   285,
   286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
   296,   297,   298,   299,   300,   442,   355,   303,   304,   305,
   349,   450,    75,    76,     3,    55,   312,    57,    55,     8,
    57,    65,    11,    81,    55,    81,    57,     3,    61,   305,
   305,    84,     8,    21,    22,   474,   312,   312,   389,    62,
   316,   392,   338,    31,    32,    48,   342,   386,    37,     4,
     3,   347,    82,    82,   403,     8,     4,    81,    11,   355,
    49,    45,    46,    47,    22,    81,    55,    63,    57,    58,
   346,    61,     3,    31,    32,   351,    55,     8,    55,    55,
    11,    57,   431,    55,    37,    69,    70,    71,    72,    73,
    74,    75,    81,    62,    81,    79,   447,    51,    52,    53,
    82,    82,    55,    55,    57,    58,   445,   403,    24,    63,
   406,     1,    63,     3,   390,    81,   412,    81,     8,    25,
   396,    11,    79,   419,    55,    15,    57,    58,    81,    62,
    80,    21,    22,    23,   321,   431,    73,    74,    75,    83,
   327,   437,    79,    82,    34,    35,    36,    81,   424,   424,
    81,    45,    46,    47,    81,   451,    54,    55,    56,    49,
    50,    51,    52,   459,    54,    55,    56,    57,    58,    81,
    65,    61,    62,    63,   450,    83,    70,    71,    72,    73,
    74,    75,    72,    82,    81,    79,    76,    77,    55,    79,
    82,    81,    63,    83,    45,    46,    47,     1,   474,     3,
    37,    38,    39,    82,     8,    80,    20,    11,    63,    61,
     3,    15,    80,    82,    17,     8,    82,    21,    22,    23,
    71,    72,    73,    74,    75,     0,   147,   305,    79,   248,
    34,    35,    36,    26,    27,    28,    29,    30,    31,    32,
    33,   424,    84,   430,   166,    49,    50,    51,    52,   334,
    54,    55,    56,    57,    58,   452,    92,    61,    62,    63,
     1,     3,     3,   445,   472,   349,     8,     8,    72,    -1,
    11,   458,    76,    77,    15,    79,     6,    81,    82,   466,
    21,    22,    23,   300,    26,    27,    28,    29,    30,    31,
    32,    33,    -1,    34,    35,    36,    26,    27,    28,    29,
    30,    31,    32,    33,    -1,    -1,    -1,    -1,    49,    50,
    51,    52,    -1,    54,    55,    56,    57,    58,    -1,    -1,
    61,    62,    63,    -1,    -1,    71,    72,    73,    74,    75,
    -1,    72,     1,    79,     3,    76,    77,    -1,    79,     8,
    81,    82,    11,    -1,    -1,    -1,    15,    16,    -1,    18,
    19,    20,    21,    22,    23,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    34,    35,    36,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    49,    50,    51,    52,    -1,    54,    55,    56,    57,    58,
    59,    60,    -1,    62,    63,    -1,    -1,    -1,    -1,     1,
    -1,     3,    -1,    72,    -1,    -1,     8,    76,    77,    11,
    79,    80,    81,    15,    16,    -1,    18,    19,    20,    21,
    22,    23,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    34,    35,    36,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    51,
    52,    -1,    54,    55,    56,    57,    58,    59,    60,    -1,
    62,    63,    -1,    -1,    -1,    -1,     1,    -1,     3,    -1,
    72,    -1,    -1,     8,    76,    77,    11,    79,    80,    81,
    15,    16,    -1,    18,    19,    20,    21,    22,    23,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    34,
    35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    49,    50,    51,    52,    -1,    54,
    55,    56,    57,    58,    59,    60,    -1,    62,    63,    -1,
    -1,    -1,    -1,     1,    -1,     3,    -1,    72,    -1,    -1,
     8,    76,    77,    11,    79,    -1,    81,    15,    16,    -1,
    18,    19,    20,    21,    22,    23,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    34,    35,    36,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    49,    50,    51,    52,    -1,    54,    55,    56,    57,
    58,    -1,    60,    -1,    62,    63,     1,    -1,     3,    -1,
    -1,    -1,    -1,     8,    72,    -1,    11,    12,    76,    77,
    15,    79,    -1,    81,    -1,    -1,    21,    22,    23,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    34,
    35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    49,    50,    51,    52,    -1,    54,
    55,    56,    57,    58,    -1,    -1,    -1,    62,    63,     1,
    -1,     3,    -1,    -1,    -1,    -1,     8,    72,    -1,    11,
    12,    76,    77,    15,    79,    -1,    81,    -1,    -1,    21,
    22,    23,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    34,    35,    36,    37,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    51,
    52,    -1,    54,    55,    56,    57,    58,     1,    -1,     3,
     4,    63,     6,    -1,     8,    -1,    -1,    11,    -1,    -1,
    72,    -1,    -1,    -1,    76,    77,    -1,    79,    -1,    81,
    -1,    -1,    26,    27,    28,    29,    30,    31,    32,    33,
    -1,    -1,     1,    37,     3,     4,    -1,     6,    -1,     8,
    -1,    -1,    11,    -1,    48,    49,    -1,    -1,    -1,    -1,
    -1,    55,    -1,    57,    58,    -1,    -1,    26,    27,    28,
    29,    30,    31,    32,    33,    -1,    -1,    -1,    37,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,    -1,    48,
    49,    -1,    -1,    -1,    -1,    -1,    55,    -1,    57,    58,
     3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
    13,    14,    -1,    16,    17,    18,    19,    20,    21,    22,
    23,    -1,    81,    26,    27,    28,    29,    30,    31,    32,
    33,    34,    35,    36,    37,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    48,    49,    50,     3,    -1,
    -1,    -1,    55,     8,    57,    58,    11,    -1,    -1,    -1,
    15,    -1,    65,    -1,    -1,    -1,    21,    22,    23,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    81,    34,
    35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    49,    50,    51,    52,    -1,    54,
    55,    56,    57,    58,    -1,    -1,    -1,    62,    63,    -1,
    -1,     3,    -1,    -1,    -1,    -1,     8,    72,    -1,    11,
    -1,    76,    77,    15,    79,    -1,    81,    -1,    -1,    21,
    22,    23,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    34,    35,    36,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,     1,    -1,    -1,    -1,    49,    50,    51,
    52,    -1,    54,    55,    56,    57,    58,    -1,    -1,    -1,
    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,
    72,    -1,    -1,     8,    76,    77,    11,    79,    13,    81,
    38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
     1,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
    -1,    -1,    60,    -1,    -1,    -1,    64,    -1,    66,    67,
    68,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
    55,    79,    57,    58,    -1,    -1,    -1,    38,    39,    40,
    41,    42,    43,    44,    45,    46,    47,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,
    -1,    -1,    -1,    64,    65,    66,    67,    68,    69,    70,
    71,    72,    73,    74,    75,     3,    -1,    -1,    79,    -1,
     8,    -1,    -1,    11,    38,    39,    40,    41,    42,    43,
    44,    45,    46,    47,    -1,    -1,    -1,    -1,    26,    27,
    28,    29,    30,    31,    32,    33,    -1,    -1,    -1,    -1,
    64,    -1,    66,    67,    68,    69,    70,    71,    72,    73,
    74,    75,    -1,    -1,    -1,    79,    -1,    55,    82,    57,
    58,     3,     4,     5,     6,     7,     8,     9,    10,    11,
    12,    13,    14,    -1,    16,    17,    18,    19,    20,    21,
    22,    23,    -1,    81,    26,    27,    28,    29,    30,    31,
    32,    33,    34,    35,    36,    37,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    48,    49,    50,    -1,
    -1,    -1,    -1,    55,    -1,    57,    58,    45,    46,    47,
    -1,    -1,    -1,    65,    38,    39,    40,    41,    42,    43,
    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    53,
    68,    69,    70,    71,    72,    73,    74,    75,    -1,    63,
    64,    79,    66,    67,    68,    69,    70,    71,    72,    73,
    74,    75,    -1,    -1,    -1,    79,    -1,    -1,    82,    38,
    39,    40,    41,    42,    43,    44,    45,    46,    47,    -1,
    -1,    -1,    -1,    38,    39,    40,    41,    42,    43,    -1,
    45,    46,    47,    -1,    -1,    64,    -1,    66,    67,    68,
    69,    70,    71,    72,    73,    74,    75,    -1,    -1,    -1,
    79,    66,    67,    68,    69,    70,    71,    72,    73,    74,
    75,    -1,    -1,    -1,    79,    38,    39,    40,    41,    42,
    -1,    -1,    45,    46,    47,    -1,    -1,    -1,    -1,    38,
    39,    40,    41,    -1,    -1,    -1,    45,    46,    47,    -1,
    -1,    -1,    -1,    66,    67,    68,    69,    70,    71,    72,
    73,    74,    75,    -1,    -1,    -1,    79,    66,    67,    68,
    69,    70,    71,    72,    73,    74,    75,    -1,    -1,    -1,
    79
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.25.90.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 7:
#line 1250 "parse.y"
{
	      if (of)
		[yyvsp[0].v compileStatement];
	    ;
    break;}
case 8:
#line 1259 "parse.y"
{
	      set_current_either (yyvsp[-1].v, yyvsp[0].v, 1, yyvsp[-4].v, yyvsp[-3].i, 0);
	    ;
    break;}
case 9:
#line 1263 "parse.y"
{
	      check_supers ();
	    ;
    break;}
case 10:
#line 1268 "parse.y"
{
	      pop_report_context ();
	      in_what = GLOBAL_SCOPE;
	    ;
    break;}
case 11:
#line 1277 "parse.y"
{
	      set_current_either (yyvsp[-1].v, yyvsp[0].v, 1, yyvsp[-4].v, yyvsp[-3].i, 1);
	    ;
    break;}
case 12:
#line 1281 "parse.y"
{
	      check_supers ();
	    ;
    break;}
case 13:
#line 1285 "parse.y"
{
	      if (of)
		[C_EXT_SEMANTICS startCompile];
	    ;
    break;}
case 14:
#line 1290 "parse.y"
{
	      [C_EXT_SEMANTICS checkImplementation];
	      if (of)
		[C_EXT_SEMANTICS endCompile];
	      pop_report_context ();
	      in_what = GLOBAL_SCOPE;
	    ;
    break;}
case 15:
#line 1302 "parse.y"
{
	      set_current_either (yyvsp[-1].v, yyvsp[0].v, 0, yyvsp[-4].v, yyvsp[-3].i, 0);
	    ;
    break;}
case 16:
#line 1306 "parse.y"
{
	      check_supers ();
	    ;
    break;}
case 17:
#line 1311 "parse.y"
{
	      pop_report_context ();
	      in_what = GLOBAL_SCOPE;
	    ;
    break;}
case 18:
#line 1320 "parse.y"
{
	      set_current_either (yyvsp[-1].v, yyvsp[0].v, 0, yyvsp[-4].v, yyvsp[-3].i, 1);
	    ;
    break;}
case 19:
#line 1324 "parse.y"
{
	      check_supers ();
	    ;
    break;}
case 20:
#line 1328 "parse.y"
{
	      if (of)
		[C_EXT_SEMANTICS startCompile];
	    ;
    break;}
case 21:
#line 1333 "parse.y"
{
	      [C_EXT_SEMANTICS checkImplementation];
	      if (of)
		[C_EXT_SEMANTICS endCompile];
	      pop_report_context ();
	      in_what = GLOBAL_SCOPE;
	    ;
    break;}
case 23:
#line 1345 "parse.y"
{
	      [C_EITHER_SEMANTICS setStatep];
	    ;
    break;}
case 27:
#line 1358 "parse.y"
{
	      if (yyvsp[-1].v)
		object_add_variables (yyvsp[-2].i, yyvsp[-1].v, yyvsp[0].v, 0);
	    ;
    break;}
case 28:
#line 1363 "parse.y"
{
	      if (yyvsp[-1].v)
		object_add_variables (yyvsp[-2].i, yyvsp[-1].v, yyvsp[0].v, 1);
	    ;
    break;}
case 29:
#line 1368 "parse.y"
{
	      if (in_what == IMPLEMENTATION_SCOPE)
		{
		  /* XXX Check consistency.  */
		}
	      else
		{
		  object_add_const (yyvsp[-4].i, yyvsp[-2].v, yyvsp[0].v);
		}
	    ;
    break;}
case 33:
#line 1387 "parse.y"
{ yyval.v = basic_type[BT_VOID]; ;
    break;}
case 34:
#line 1388 "parse.y"
{ yyval.v = the_dynamic_type; ;
    break;}
case 36:
#line 1393 "parse.y"
{ yyval.v = the_dynamic_type; ;
    break;}
case 39:
#line 1406 "parse.y"
{
	      yyval.v = [yyvsp[0].v semantics];
	    ;
    break;}
case 40:
#line 1410 "parse.y"
{
	      yyval.v = basic_type[BT_RECV];
	    ;
    break;}
case 41:
#line 1414 "parse.y"
{
	      yyval.v = [(OTMMeta *) yyvsp[-1].v itsClass];
	    ;
    break;}
case 42:
#line 1418 "parse.y"
{
	      yyval.v = [(OTMMeta *) yyvsp[-1].v instance];
	    ;
    break;}
case 43:
#line 1425 "parse.y"
{
	      if ([yyvsp[-1].v cdr])
		yyval.v = [CO_OTMTypeTuple typeTupleWithSequence: yyvsp[-1].v];
	      else
		yyval.v = [yyvsp[-1].v car];
	    ;
    break;}
case 44:
#line 1435 "parse.y"
{
	      yyval.v = CONS (yyvsp[0].v, nil);
	    ;
    break;}
case 45:
#line 1439 "parse.y"
{
	      yyval.v = [yyvsp[-2].v nconc: CONS (yyvsp[0].v, nil)];
	    ;
    break;}
case 48:
#line 1451 "parse.y"
{
	      do_add_super (yyvsp[0].v, 0);
	    ;
    break;}
case 49:
#line 1455 "parse.y"
{
	      do_add_super (yyvsp[0].v, 1);
	    ;
    break;}
case 50:
#line 1459 "parse.y"
{
	      do_add_super (yyvsp[0].v, 0);
	    ;
    break;}
case 51:
#line 1463 "parse.y"
{
	      do_add_super (yyvsp[0].v, 1);
	    ;
    break;}
case 53:
#line 1471 "parse.y"
{
	      yyval.v = CONS (nil, yyvsp[-1].v);
	    ;
    break;}
case 54:
#line 1475 "parse.y"
{
	      yyval.v = CONS (yyvsp[-1].v, nil);
	    ;
    break;}
case 55:
#line 1481 "parse.y"
{ yyval.v = NULL; ;
    break;}
case 57:
#line 1486 "parse.y"
{ yyval.v = yyvsp[0].v; ;
    break;}
case 61:
#line 1494 "parse.y"
{
	      error (@"parse error at `%s'", yytext);
	    ;
    break;}
case 62:
#line 1501 "parse.y"
{
	      add_method_decl (yyvsp[-1].v);
	      current_method = nil;
	    ;
    break;}
case 63:
#line 1509 "parse.y"
{
	      /* Don't set the current method if we're just reading an
                 interface.  */
	      current_method = of ? yyvsp[0].v : nil;
	    ;
    break;}
case 64:
#line 1515 "parse.y"
{
	      if (of && !NUM_ERRORS)
		[current_method compile];

	      current_method = nil;
	    ;
    break;}
case 65:
#line 1524 "parse.y"
{
	      next_tmp = 0;
	      next_arg = 2;
	    ;
    break;}
case 66:
#line 1529 "parse.y"
{
	      yyvsp[-2].i = mask_qualifiers (yyvsp[-2].i, (OQ_DEFERRED_MASK
					 | OQ_REDO_MASK | OQ_PROTECTION_MASK));

	      /* Check foreigness compared to what was declared for this
                 class.  */
	      if (current_either)
		{
		  id f = [C_EITHER_SEMANTICS foreign];

		  if (!yyvsp[-1].v)
		    {
		      if (f)
			yyvsp[-1].v = f;
		    }
		  else if (f == yyvsp[-1].v)
		    warning (@"repeated foreign qualifier");
		  else if (f)
		    error (@"foreign %# differs from class' %#", yyvsp[-1].v, f);
		}

	      [yyvsp[0].v setQualifiers: yyvsp[-2].i];
	      if (yyvsp[-1].v)
		{
		  if (Q_DEFERRED (yyvsp[-2].i))
		    error (@"deferred method can't be foreign");
		  else
		    [yyvsp[0].v setForeign: yyvsp[-1].v];
		}

	      current_method = yyvsp[0].v;
	    ;
    break;}
case 67:
#line 1562 "parse.y"
{
	      yyval.v = current_method;
	    ;
    break;}
case 68:
#line 1568 "parse.y"
{ yyval.v = 0; ;
    break;}
case 69:
#line 1570 "parse.y"
{
	      yyval.v = @"C";
	    ;
    break;}
case 70:
#line 1576 "parse.y"
{ yyval.i = 0; ;
    break;}
case 71:
#line 1578 "parse.y"
{
	      if (current_instance)
		error (@"static qualifier only allowed in classes");
	      else
		{
		  if (Q_STATIC (yyvsp[-1].i))
		    error (@"`static' repeated");
		  yyval.i = Q_SET_STATIC (yyvsp[-1].i, OQ_STATIC);
		}
	    ;
    break;}
case 72:
#line 1589 "parse.y"
{
	      if (Q_DEFERRED (yyvsp[-1].i))
		error (@"`deferred' repeated");
	      yyval.i = Q_SET_DEFERRED (yyvsp[-1].i, OQ_DEFERRED);
	    ;
    break;}
case 73:
#line 1595 "parse.y"
{
	      if (Q_MUTABLE (yyvsp[-1].i))
		error (@"`deferred' repeated");
	      yyval.i = Q_SET_MUTABLE (yyvsp[-1].i, OQ_MUTABLE);
	    ;
    break;}
case 74:
#line 1601 "parse.y"
{
	      if (Q_REDO (yyvsp[-1].i))
		error (@"conflicting qualifiers for `redefine'");
	      yyval.i = Q_SET_REDO (yyvsp[-1].i, OQ_REDEFINE);
	    ;
    break;}
case 75:
#line 1607 "parse.y"
{
	      if (Q_REDO (yyvsp[-1].i))
		error (@"conflicting qualifiers for `redeclare'");
	      yyval.i = Q_SET_REDO (yyvsp[-1].i, OQ_REDECLARE);
	    ;
    break;}
case 76:
#line 1613 "parse.y"
{
	      if (Q_PROTECTION (yyvsp[-1].i))
		error (@"conflicting qualifiers for `public'");
	      yyval.i = Q_SET_PROTECTION (yyvsp[-1].i, OQ_PUBLIC);
	    ;
    break;}
case 77:
#line 1619 "parse.y"
{
	      if (Q_PROTECTION (yyvsp[-1].i))
		error (@"conflicting qualifiers for `protected'");
	      yyval.i = Q_SET_PROTECTION (yyvsp[-1].i, OQ_PROTECTED);
	    ;
    break;}
case 78:
#line 1625 "parse.y"
{
	      if (Q_PROTECTION (yyvsp[-1].i))
		error (@"conflicting qualifiers for `private'");
	      yyval.i = Q_SET_PROTECTION (yyvsp[-1].i, OQ_PRIVATE);
	    ;
    break;}
case 79:
#line 1634 "parse.y"
{
	      yyval.v = yyvsp[-2].v ? [CO_OTMCustomMethod methodWithExtension: C_EXT_SEMANTICS
				   name: yyvsp[0].v returnType: yyvsp[-2].v flatp: NO] : nil;
	      [yyval.v setReturnVariables: yyvsp[-1].v];
	    ;
    break;}
case 80:
#line 1640 "parse.y"
{
	      yyval.v = (yyvsp[-2].v && yyvsp[0].v
		    ? [CO_OTMCustomMethod methodWithExtension: C_EXT_SEMANTICS
				 nameTypes: yyvsp[0].v returnType: yyvsp[-2].v flatp: NO] : nil);
	      [yyval.v setReturnVariables: yyvsp[-1].v];
	    ;
    break;}
case 82:
#line 1651 "parse.y"
{
	      if (current_method)
		[current_method setPrecondition: yyvsp[0].v];
	    ;
    break;}
case 84:
#line 1660 "parse.y"
{
	      if (current_method)
		[current_method setPostcondition: yyvsp[0].v];
	    ;
    break;}
case 85:
#line 1667 "parse.y"
{ yyval.v = nil; ;
    break;}
case 86:
#line 1668 "parse.y"
{ yyval.v = yyvsp[0].v; ;
    break;}
case 88:
#line 1674 "parse.y"
{
	      yyval.v = [yyvsp[-1].v nconc: yyvsp[0].v];
	    ;
    break;}
case 89:
#line 1681 "parse.y"
{
	      yyval.v = CONS (yyvsp[-2].v, digest_arguments (yyvsp[0].v, yyvsp[-1].v, 0));
	      yyval.v = CONS (yyval.v, nil);
	    ;
    break;}
case 90:
#line 1686 "parse.y"
{
	      yyval.v = CONS (yyvsp[-4].v, digest_arguments (yyvsp[-2].v, yyvsp[-3].v, yyvsp[0].v));
	      yyval.v = CONS (yyval.v, nil);
	    ;
    break;}
case 92:
#line 1695 "parse.y"
{
	      yyval.v = unique_identifier ([CO_TLString stringWithFormat: @"%@:",
						yyvsp[-1].v]);
	    ;
    break;}
case 93:
#line 1700 "parse.y"
{
	      yyval.v = unique_identifier_colon;
	    ;
    break;}
case 95:
#line 1707 "parse.y"
{ yyval.v = unique_identifier (@"bind"); ;
    break;}
case 96:
#line 1708 "parse.y"
{ yyval.v = unique_identifier (@"class"); ;
    break;}
case 97:
#line 1709 "parse.y"
{ yyval.v = unique_identifier (@"catch"); ;
    break;}
case 98:
#line 1710 "parse.y"
{ yyval.v = unique_identifier (@"end"); ;
    break;}
case 99:
#line 1711 "parse.y"
{ yyval.v = unique_identifier (@"extension"); ;
    break;}
case 100:
#line 1712 "parse.y"
{ yyval.v = unique_identifier (@"extern"); ;
    break;}
case 101:
#line 1713 "parse.y"
{ yyval.v = unique_identifier (@"implementation"); ;
    break;}
case 102:
#line 1714 "parse.y"
{ yyval.v = unique_identifier (@"instance"); ;
    break;}
case 103:
#line 1715 "parse.y"
{ yyval.v = unique_identifier (@"interface"); ;
    break;}
case 104:
#line 1716 "parse.y"
{ yyval.v = unique_identifier (@"local"); ;
    break;}
case 105:
#line 1717 "parse.y"
{ yyval.v = unique_identifier (@"posing"); ;
    break;}
case 106:
#line 1718 "parse.y"
{ yyval.v = unique_identifier (@"id"); ;
    break;}
case 107:
#line 1719 "parse.y"
{ yyval.v = unique_identifier (@"super"); ;
    break;}
case 108:
#line 1720 "parse.y"
{ yyval.v = unique_identifier (@"const"); ;
    break;}
case 109:
#line 1721 "parse.y"
{ yyval.v = unique_identifier (@"if"); ;
    break;}
case 110:
#line 1722 "parse.y"
{ yyval.v = unique_identifier (@"else"); ;
    break;}
case 111:
#line 1723 "parse.y"
{ yyval.v = unique_identifier (@"do"); ;
    break;}
case 112:
#line 1724 "parse.y"
{ yyval.v = unique_identifier (@"for"); ;
    break;}
case 113:
#line 1725 "parse.y"
{ yyval.v = unique_identifier (@"while"); ;
    break;}
case 114:
#line 1726 "parse.y"
{ yyval.v = unique_identifier (@"break"); ;
    break;}
case 115:
#line 1727 "parse.y"
{ yyval.v = unique_identifier (@"continue"); ;
    break;}
case 116:
#line 1728 "parse.y"
{ yyval.v = unique_identifier (@"return"); ;
    break;}
case 117:
#line 1729 "parse.y"
{ yyval.v = unique_identifier (@"public"); ;
    break;}
case 118:
#line 1730 "parse.y"
{ yyval.v = unique_identifier (@"private"); ;
    break;}
case 119:
#line 1731 "parse.y"
{ yyval.v = unique_identifier (@"protected"); ;
    break;}
case 120:
#line 1732 "parse.y"
{ yyval.v = unique_identifier (@"mutable"); ;
    break;}
case 121:
#line 1733 "parse.y"
{ yyval.v = unique_identifier (@"static"); ;
    break;}
case 122:
#line 1734 "parse.y"
{ yyval.v = unique_identifier (@"deferred"); ;
    break;}
case 123:
#line 1735 "parse.y"
{ yyval.v = unique_identifier (@"redefine"); ;
    break;}
case 124:
#line 1736 "parse.y"
{ yyval.v = unique_identifier (@"redeclare"); ;
    break;}
case 125:
#line 1737 "parse.y"
{ yyval.v = unique_identifier (@"dynamic"); ;
    break;}
case 126:
#line 1738 "parse.y"
{ yyval.v = unique_identifier (@"typedef"); ;
    break;}
case 127:
#line 1739 "parse.y"
{ yyval.v = unique_identifier (@"unwind"); ;
    break;}
case 128:
#line 1740 "parse.y"
{ yyval.v = unique_identifier (@"void"); ;
    break;}
case 129:
#line 1741 "parse.y"
{ yyval.v = unique_identifier (@"nil"); ;
    break;}
case 130:
#line 1742 "parse.y"
{ yyval.v = unique_identifier ([(OTMMeta *) yyvsp[0].v typeName]); ;
    break;}
case 131:
#line 1744 "parse.y"
{
	      yyval.v = unique_identifier ([[(LTTMeta *) [yyvsp[0].v _elementAtIndex: 0]
						    lttName] internal]);
	    ;
    break;}
case 134:
#line 1757 "parse.y"
{
	      yyval.v = [CO_OTMTuple tupleWithSequence: yyvsp[-1].v];
	    ;
    break;}
case 138:
#line 1770 "parse.y"
{
	      ABORT ();
	    ;
    break;}
case 139:
#line 1777 "parse.y"
{
	      if (current_method)
		{
		  otm_qualifiers q = [current_method qualifiers];

		  /* A method declaration in an implementation is only
                     allowed if it is a redeclaration, deferred or
                     foreign.  */
		  if (![current_method definedp] && !Q_REDO (q)
		      && !Q_DEFERRED (q) && ![current_method foreign])
		    error (@"method definition missing");

		  add_method_def (current_method);
		}
	    ;
    break;}
case 140:
#line 1793 "parse.y"
{
	      if (current_method)
		{
		  id f;

		  if ([current_method deferredp])
		    error (@"definition of method declared deferred");

		  f = [current_method foreign];
		  if (f)
		    error (@"definition of method declared extern", f);

		  current_method = add_method_def (current_method);
		}
	    ;
    break;}
case 142:
#line 1813 "parse.y"
{
	      enter_compound ();
	      if (current_method)
		{
		  OTMType *t = [current_method returnType];

		  if (t != basic_type[BT_VOID])
		    {
		      OTMTuple *rvn = [current_method returnVariables];

		      /* Initialize the return value.  */
		      if (rvn)
			[current_method setReturnValue: rvn];
		      else
			do_return_stmt (0, nil_something_with_type (t));
		    }

		  emit_conditions_pre (current_method);
		}
	    ;
    break;}
case 143:
#line 1834 "parse.y"
{
	      if ([current_method haveReturnStatement])
		emit_statement ([current_method setHaveReturnStatement]);

	      emit_conditions_post (current_method);
	      exit_compound ();
	    ;
    break;}
case 144:
#line 1845 "parse.y"
{
	      enter_compound ();
	    ;
    break;}
case 145:
#line 1849 "parse.y"
{
	      yyval.v = current_compound;
	      exit_compound ();
	    ;
    break;}
case 146:
#line 1857 "parse.y"
{
		  emit_expr (void_expr);
		;
    break;}
case 150:
#line 1870 "parse.y"
{
	      if (current_compound && yyvsp[0].v)
		{
		  [current_compound setValue: yyvsp[0].v];
		  [current_compound releaseTemporaryVariables];
		}
	    ;
    break;}
case 152:
#line 1900 "parse.y"
{
	      yyval.v = emit_expr (yyvsp[0].v);
	    ;
    break;}
case 153:
#line 1904 "parse.y"
{
	      yyval.v = emit_expr (yyvsp[0].v);
	    ;
    break;}
case 154:
#line 1910 "parse.y"
{
	      enter_compound ();
	    ;
    break;}
case 155:
#line 1914 "parse.y"
{
	      yyval.v = current_compound;
	      exit_compound ();
	    ;
    break;}
case 157:
#line 1920 "parse.y"
{
	      if (!flag_inhibit_empty)
		warning (@"empty expression");
	      yyval.v = void_expr;
	    ;
    break;}
case 158:
#line 1929 "parse.y"
{
	      enclosing_type = yyvsp[0].v;
	    ;
    break;}
case 159:
#line 1933 "parse.y"
{
	      yyval.v = yyvsp[0].v;
	    ;
    break;}
case 161:
#line 1941 "parse.y"
{
	      yyval.v = yyvsp[0].v;
	    ;
    break;}
case 162:
#line 1948 "parse.y"
{
	      yyval.v = create_local_var (yyvsp[0].v, enclosing_type, nil);
	    ;
    break;}
case 163:
#line 1952 "parse.y"
{
	      yyval.v = create_local_var (yyvsp[-2].v, enclosing_type, yyvsp[0].v);
	    ;
    break;}
case 164:
#line 1959 "parse.y"
{
	      yyval.v = [CO_OTMCondExpr new];
	    ;
    break;}
case 165:
#line 1963 "parse.y"
{
	      [yyvsp[-1].v setIf: yyvsp[0].v];
	    ;
    break;}
case 166:
#line 1967 "parse.y"
{
	      [yyvsp[-3].v setThen: yyvsp[0].v];
	    ;
    break;}
case 167:
#line 1971 "parse.y"
{
	      yyval.v = yyvsp[-5].v;
	      [yyval.v setElse: yyvsp[0].v];
	    ;
    break;}
case 168:
#line 1979 "parse.y"
{
	      yyval.v = nil;
	    ;
    break;}
case 169:
#line 1983 "parse.y"
{
	      yyval.v = yyvsp[0].v;
	    ;
    break;}
case 170:
#line 1990 "parse.y"
{
	      current_compound = [CO_OTMLoop
				   loopWithContainer: current_compound];
	    ;
    break;}
case 171:
#line 1995 "parse.y"
{
	      [(OTMLoop *) current_compound startLoopEnd];
	      [(OTMLoop *) current_compound setCondition: yyvsp[-1].v atEnd: 1];

	      yyval.v = current_compound;
	      current_compound = [current_compound container];
	    ;
    break;}
case 172:
#line 2006 "parse.y"
{
	      current_compound = [CO_OTMLoop
				   loopWithContainer: current_compound];
	    ;
    break;}
case 173:
#line 2011 "parse.y"
{
	      [(OTMLoop *) current_compound setCondition: yyvsp[0].v atEnd: 0];
	    ;
    break;}
case 174:
#line 2015 "parse.y"
{
	      yyval.v = current_compound;
	      [(OTMLoop *) current_compound startLoopEnd];
	      current_compound = [current_compound container];
	    ;
    break;}
case 175:
#line 2024 "parse.y"
{
	      enter_compound ();
	      emit_statement (yyvsp[-1].v);
	      current_compound
		= [CO_OTMLoop loopWithContainer: current_compound];
	    ;
    break;}
case 176:
#line 2031 "parse.y"
{
	      [(OTMLoop *) current_compound setCondition: yyvsp[-1].v atEnd: 0];
	    ;
    break;}
case 177:
#line 2035 "parse.y"
{
	      OTMCompound *loop = current_compound;

	      [current_compound startLoopEnd];
	      emit_statement (yyvsp[-2].v);
	      current_compound = [current_compound container];
	      [current_compound setValue: emit_expr (loop)];
	      yyval.v = current_compound;
	      exit_compound ();
	    ;
    break;}
case 178:
#line 2056 "parse.y"
{
	      yyval.v = do_return_stmt (yyvsp[-1].i, yyvsp[0].v);
	    ;
    break;}
case 179:
#line 2060 "parse.y"
{
	      yyval.v = do_return_stmt (yyvsp[0].i, void_expr);
	    ;
    break;}
case 180:
#line 2066 "parse.y"
{ yyval.i = 0; ;
    break;}
case 181:
#line 2067 "parse.y"
{ yyval.i = 1; ;
    break;}
case 182:
#line 2072 "parse.y"
{
	      yyval.v = [CO_OTMAssignment assignmentWithLhs: yyvsp[-2].v rhs: yyvsp[0].v];
	    ;
    break;}
case 183:
#line 2076 "parse.y"
{
	      yyval.v = [CO_OTMModAssign assignmentWithLhs: yyvsp[0].v
				 rhs: (id) tll_small_int[1]
				 operator: BO_ADD postp: NO];
	    ;
    break;}
case 184:
#line 2082 "parse.y"
{
	      yyval.v = [CO_OTMModAssign assignmentWithLhs: yyvsp[-1].v
				 rhs: (id) tll_small_int[1]
				 operator: BO_ADD postp: YES];
	    ;
    break;}
case 185:
#line 2088 "parse.y"
{
	      yyval.v = [CO_OTMModAssign assignmentWithLhs: yyvsp[0].v
				 rhs: (id) tll_small_int[1]
				 operator: BO_SUB postp: NO];
	    ;
    break;}
case 186:
#line 2094 "parse.y"
{
	      yyval.v = [CO_OTMModAssign assignmentWithLhs: yyvsp[-1].v
				 rhs: (id) tll_small_int[1]
				 operator: BO_SUB postp: YES];
	    ;
    break;}
case 187:
#line 2100 "parse.y"
{
	      yyval.v = [CO_OTMModAssign assignmentWithLhs: yyvsp[-2].v rhs: yyvsp[0].v operator: yyvsp[-1].i
				 postp: YES];
	    ;
    break;}
case 188:
#line 2105 "parse.y"
{
	      yyval.v = build_invocation ([yyvsp[-2].v car],
				     CONS (CONS (MNP_SET_AT_1, yyvsp[0].v),
					   CONS (CONS (MNP_SET_AT_2, [yyvsp[-2].v cdr]),
						 nil)), 0, nil);
	    ;
    break;}
case 189:
#line 2116 "parse.y"
{
	      if ([[yyvsp[-1].v elements] length] == 1)
		yyvsp[-1].v = [[yyvsp[-1].v elements] _elementAtIndex: 0];
	      yyval.v = CONS (yyvsp[-3].v, yyvsp[-1].v);
	    ;
    break;}
case 190:
#line 2122 "parse.y"
{
	      error (@"error in index expression");
	      yyval.v = [CO_OTMError sharedError];
	    ;
    break;}
case 191:
#line 2130 "parse.y"
{
	      yyval.v = nil;
	    ;
    break;}
case 193:
#line 2138 "parse.y"
{
	      yyval.v = nil;
	    ;
    break;}
case 194:
#line 2142 "parse.y"
{
	      enter_compound ();
	    ;
    break;}
case 195:
#line 2146 "parse.y"
{
	      yyvsp[0].v = emit_expr (yyvsp[0].v);
	      if (yyvsp[0].v)
		[current_compound setValue: yyvsp[0].v];
	      yyval.v = current_compound;
	      exit_compound ();
	    ;
    break;}
case 209:
#line 2179 "parse.y"
{
	      if (yyvsp[0].v && yyvsp[0].v != an_error)
		{
		  if ([yyvsp[0].v cdr])
		    error (@"too many elements in catch tag");

		  yyvsp[0].v = [resolve_expr ([yyvsp[0].v car], CONS (the_any_ref_type, nil),
				      NULL, [current_either semantics])
			elaborate];
		}
	      current_compound = [CO_OTMCatch catchWithTag: yyvsp[0].v
					   container: current_compound];
	    ;
    break;}
case 210:
#line 2193 "parse.y"
{
	      [current_compound setValue: emit_expr (yyvsp[0].v)];
	      yyval.v = current_compound;
	      current_compound = [current_compound container];
	    ;
    break;}
case 211:
#line 2199 "parse.y"
{
	      enter_compound ();

	      /* This is naughty: a local variable for tom code to
		 reference the argument (with the same name) to the
		 function containing the handlers.  */
	      emit_local_var ([CO_OTMArgument
				variableWithName: @"condition"
				type: tom_condition_instance]);

	      if (![tom_condition_instance declaredp]
		  && ![tom_condition_instance definedp])
		load_interface ((LTTInstance *)
				[tom_condition_instance structure]);
	    ;
    break;}
case 212:
#line 2215 "parse.y"
{
	      current_compound = [CO_OTMBind bindWithContainer:
					     current_compound];
	      [(OTMBind *) current_compound setHandlers: yyvsp[0].v];
	    ;
    break;}
case 213:
#line 2221 "parse.y"
{
	      [current_compound setValue: emit_expr (yyvsp[0].v)];
	      yyval.v = current_compound;
	      current_compound = [current_compound container];
	      [current_compound setValue: emit_expr (yyval.v)];
	      yyval.v = current_compound;
	      current_compound = [current_compound container];
	    ;
    break;}
case 214:
#line 2230 "parse.y"
{
	      if (yyvsp[-1].v && yyvsp[-1].v != an_error)
		{
		  if ([yyvsp[-1].v cdr])
		    error (@"too many elements in unwind protection");

		  enter_compound ();
		  [current_compound setValue: emit_expr ([yyvsp[-1].v car])];
		  yyvsp[-1].v = current_compound;
		  current_compound = [current_compound container];
		}

	      current_compound = [CO_OTMUnwind unwindWithProtection: yyvsp[-1].v
					    container: current_compound];
	      [current_compound setValue: emit_expr (yyvsp[0].v)];
	      yyval.v = current_compound;
	      current_compound = [current_compound container];
	    ;
    break;}
case 215:
#line 2252 "parse.y"
{
	      yyval.v = yyvsp[-1].v;
	    ;
    break;}
case 216:
#line 2259 "parse.y"
{
	      yyval.v = CONS (yyvsp[0].v, nil);
	    ;
    break;}
case 217:
#line 2263 "parse.y"
{
	      yyval.v = [yyvsp[-2].v nconc: CONS (yyvsp[0].v, nil)];
	    ;
    break;}
case 218:
#line 2270 "parse.y"
{
	      yyval.v = [CO_OTMBreak jumpStatement];
	    ;
    break;}
case 219:
#line 2274 "parse.y"
{
	      yyval.v = [CO_OTMBreak jumpStatementWithValue: yyvsp[0].v];
	    ;
    break;}
case 220:
#line 2281 "parse.y"
{
	      yyval.v = [CO_OTMContinue jumpStatement];
	    ;
    break;}
case 221:
#line 2285 "parse.y"
{
	      yyval.v = [CO_OTMContinue jumpStatementWithValue: yyvsp[0].v];
	    ;
    break;}
case 223:
#line 2293 "parse.y"
{
	      if (!yyvsp[0].v || yyvsp[0].v == an_error)
		yyval.v = [CO_OTMError sharedError];
	      else
		yyval.v = invocation ([yyvsp[0].v car], unique_identifier (MNP_AT_1),
				 [yyvsp[0].v cdr]);
	    ;
    break;}
case 224:
#line 2301 "parse.y"
{
	      yyval.v = op_invocation1 (builtin_operator_name[BO_NEG], yyvsp[0].v);
	    ;
    break;}
case 225:
#line 2305 "parse.y"
{
	      yyval.v = op_invocation1 (builtin_operator_name[BO_INV], yyvsp[0].v);
	    ;
    break;}
case 226:
#line 2309 "parse.y"
{
	      yyval.v = op_invocation1 (builtin_operator_name[BO_NOT], yyvsp[0].v);
	    ;
    break;}
case 227:
#line 2313 "parse.y"
{
	      yyval.v = [CO_OTMOld with: yyvsp[0].v];
	    ;
    break;}
case 228:
#line 2317 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_MUL], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 229:
#line 2321 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_DIV], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 230:
#line 2325 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_MOD], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 231:
#line 2329 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_ADD], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 232:
#line 2333 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_SUB], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 233:
#line 2337 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_SHL], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 234:
#line 2341 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_SHR], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 235:
#line 2345 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_LSR], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 236:
#line 2349 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_AND], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 237:
#line 2353 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_OR], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 238:
#line 2357 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_EOR], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 239:
#line 2361 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_LT], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 240:
#line 2365 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_LE], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 241:
#line 2369 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_EQ], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 242:
#line 2373 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_NE], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 243:
#line 2377 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_GE], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 244:
#line 2381 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_GT], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 245:
#line 2385 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_SC_AND], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 246:
#line 2389 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_SC_OR], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 247:
#line 2393 "parse.y"
{
	      yyval.v = op_invocation2 (builtin_operator_name[BO_IMPLIES], yyvsp[-2].v, yyvsp[0].v);
	    ;
    break;}
case 248:
#line 2397 "parse.y"
{
	      yyval.v = [CO_OTMCondExpr iteWithCondition: yyvsp[-4].v thenPart: yyvsp[-2].v elsePart: yyvsp[0].v];
	    ;
    break;}
case 249:
#line 2401 "parse.y"
{
	      error (@"`:' expected");
	      yyval.v = [CO_OTMError sharedError];
	    ;
    break;}
case 252:
#line 2410 "parse.y"
{
	      yyval.v = nil;

	      /* Look for the variable in the current compound.  If the
                 compound is not set, we could be in a method condition,
                 and search for a method argument.  */
	      if (current_compound)
		yyval.v = [current_compound searchVariableNamed: yyvsp[0].v];
	      else if (current_method)
		yyval.v = [current_method searchVariableNamed: yyvsp[0].v];

	      if (yyval.v)
		yyval.v = [OTMVarRef referenceToVariable: yyval.v];
	      else
		{
		  yyval.v = [C_EITHER_SEMANTICS searchEntityNamed: yyvsp[0].v
			supers: YES class: YES variables: YES constants: YES];

		  if (!yyval.v)
		    if (!of)
		      yyval.v = [[CO_OTMIdentifier gcAlloc] initWithName: yyvsp[0].v];
		    else
		      {
			error (@"undeclared variable `%@'", yyvsp[0].v);
			if (current_compound)
			  {
			    yyval.v = [CO_OTMLocalVar variableWithName: yyvsp[0].v
					    type: [ltt_instance_any semantics]];
			    cerror (@"inventing `%@ %@'",
				    type_name ([yyval.v type]), yyvsp[0].v);
			    emit_local_var (yyval.v);
			  }
		      }
		}
	    ;
    break;}
case 253:
#line 2446 "parse.y"
{
	      yyval.v = void_expr;
	    ;
    break;}
case 254:
#line 2450 "parse.y"
{
	      yyval.v = nil_expr;
	    ;
    break;}
case 259:
#line 2471 "parse.y"
{
	      if (yyvsp[-3].v && yyvsp[-1].v)
		{
		  if (yyvsp[-3].v == basic_type[BT_SELECTOR]
		      && [yyvsp[-1].v isKindOf: [CO_OTMStringCST self]])
		    {
		      yyval.v = [[CO_LTTSelector selectorWithMangledName:
					      [[(OTMStringCST *) yyvsp[-1].v structure]
						string]] semantics];
		      warning (@"obsolete selector syntax");
		    }
		  else
		    yyval.v = [CO_OTMCast castWithExpr: yyvsp[-1].v type: yyvsp[-3].v];
		}
	      else
		yyval.v = yyvsp[-1].v;
	    ;
    break;}
case 260:
#line 2489 "parse.y"
{
	      error (@"cast of super not allowed");
	      yyval.v = [CO_OTMError sharedError];
	    ;
    break;}
case 261:
#line 2494 "parse.y"
{
	      if (yyvsp[-3].v != basic_type[BT_SELECTOR])
		error (@"invalid cast");
	      else
		yyval.v = yyvsp[-1].v;
	    ;
    break;}
case 262:
#line 2501 "parse.y"
{
	      error (@"parse error at `%s'", yytext);
	      yyval.v = [CO_OTMError sharedError];
	    ;
    break;}
case 263:
#line 2509 "parse.y"
{
		  TLCons *c = yyvsp[0].v;
		  TLString *in_args, *out_args, *name;
		  out_args = [yyvsp[-1].v flatFrobnicatedName];
		  in_args = formac (nil, @"");
		  name = formac (nil, @"%@", [yyvsp[-1].v frobnicatedName]);
		  while (c)
		    {
		      TLCons *th;
		      id <TLString> np;
		      OTMType *tp;

		      DECONS (c, th, c);
		      DECONS (th, np, tp);

		      formac (name, @"_%@", np);
		      if (tp != nil)
			{
			  formac (name, @"_%@", [tp frobnicatedName]);
			  formac (in_args, @"%@", [tp flatFrobnicatedName]);
			}
		    }
		  yyval.v = [[LTTSelector selectorWithName: name
				     inArgs: in_args outArgs: out_args]
			 semantics];
		;
    break;}
case 264:
#line 2540 "parse.y"
{
		  yyval.v = CONS (CONS (yyvsp[0].v, nil), nil);
		;
    break;}
case 265:
#line 2544 "parse.y"
{
		  yyval.v = CONS (CONS (yyvsp[-1].v, yyvsp[0].v), nil);
		;
    break;}
case 266:
#line 2548 "parse.y"
{
		  yyval.v = CONS (CONS (yyvsp[-2].v, yyvsp[-1].v), yyvsp[0].v);
		;
    break;}
case 269:
#line 2560 "parse.y"
{
	      yyval.v = build_invocation (yyvsp[-2].v, yyvsp[-1].v, 0, nil);
	    ;
    break;}
case 270:
#line 2564 "parse.y"
{
	      yyval.v = build_invocation ([[(OTMMeta *) [(LTTMeta *) yyvsp[-2].v semantics]
				       itsClass] metaReference], yyvsp[-1].v, 0, nil);
	    ;
    break;}
case 271:
#line 2569 "parse.y"
{
	      yyval.v = build_invocation
		([current_method argumentNamed: TO_NAME_SELF], yyvsp[-1].v, 1, nil);
	    ;
    break;}
case 272:
#line 2575 "parse.y"
{
	      yyval.v = build_invocation
		([current_method argumentNamed: TO_NAME_SELF], yyvsp[-1].v, 1, yyvsp[-3].v);
	    ;
    break;}
case 273:
#line 2580 "parse.y"
{
	      OTMExpr *e = [CO_OTMMetaRef metaRefWithMeta:
				       [[current_either itsClass] semantics]];
	      yyval.v = invocation (e, yyvsp[-1].v, yyvsp[0].v);
	    ;
    break;}
case 274:
#line 2586 "parse.y"
{
	      error (@"error in invocation");
	      yyval.v = [CO_OTMError sharedError];
	    ;
    break;}
case 278:
#line 2600 "parse.y"
{
	      yyval.v = [yyvsp[-1].v nconc: yyvsp[0].v];
	    ;
    break;}
case 279:
#line 2607 "parse.y"
{
	      yyval.v = CONS (CONS (yyvsp[-1].v, yyvsp[0].v), nil);
	    ;
    break;}
case 280:
#line 2614 "parse.y"
{
	      if ([[yyvsp[-1].v elements] length] == 1)
		yyval.v = [[yyvsp[-1].v elements] _elementAtIndex: 0];
	      else
		{
		  yyval.v = yyvsp[-1].v;
		}
	    ;
    break;}
case 281:
#line 2623 "parse.y"
{
	      error (@"error in tuple");
	      yyval.v = [CO_OTMError sharedError];
	    ;
    break;}
case 282:
#line 2631 "parse.y"
{
		yyval.v = [CO_OTMTuple tuple];
		[yyval.v addElement: yyvsp[0].v];
	    ;
    break;}
case 283:
#line 2636 "parse.y"
{
		yyval.v = [CO_OTMTuple tuple];
		[yyval.v addElement: nil];
	    ;
    break;}
case 284:
#line 2641 "parse.y"
{
		[yyvsp[-2].v addElement: yyvsp[0].v];
		yyval.v = yyvsp[-2].v;
	    ;
    break;}
case 285:
#line 2646 "parse.y"
{
		[yyvsp[-1].v addElement: nil];
		yyval.v = yyvsp[-1].v;
	    ;
    break;}
case 286:
#line 2654 "parse.y"
{
	      yyval.v = CONS (yyvsp[0].v, nil);
	    ;
    break;}
case 287:
#line 2658 "parse.y"
{
	      yyval.v = [yyvsp[-2].v nconc: CONS (yyvsp[0].v, nil)];
	    ;
    break;}
case 289:
#line 2666 "parse.y"
{
	      error (@"`;' expected");
	    ;
    break;}
case 291:
#line 2674 "parse.y"
{
	      error (@"`)' expected");
	    ;
    break;}
case 293:
#line 2682 "parse.y"
{
	      error (@"`]' expected");
	    ;
    break;}
case 295:
#line 2693 "parse.y"
{
	      OTMMeta *oins = [yyvsp[0].v semantics];

	      yyval.v = yyvsp[0].v;
	      if (yyvsp[0].v && ![oins fullyLoaded])
		load_interface (yyvsp[0].v);
	    ;
    break;}
case 296:
#line 2704 "parse.y"
{
	      yyval.v = instance_in_unit (nil, current_unit, yyvsp[0].v);
	    ;
    break;}
case 297:
#line 2708 "parse.y"
{
	      yyval.v = instance_in_unit ([[(LTTMeta *) [yyvsp[-2].v _elementAtIndex: 0]
					   lttName] internal],
				     current_unit, yyvsp[0].v);
	    ;
    break;}
case 298:
#line 2714 "parse.y"
{
	      yyval.v = instance_in_unit (yyvsp[-2].v, current_unit, yyvsp[0].v);
	    ;
    break;}
case 300:
#line 2722 "parse.y"
{
	      error (@"inventing class `%@'", yyvsp[0].v);

	      yyval.v = [ltt_missing_unit metaWithName: yyvsp[0].v];	      
	    ;
    break;}
case 301:
#line 2728 "parse.y"
{
	      LTTUnit *u = [CO_LTTUnit unitNamed: yyvsp[-2].v];

	      error (@"inventing class `%@.%@'", yyvsp[-2].v, yyvsp[0].v);

	      if (!u)
		{
		  error (@"unknown unit `%@'", yyvsp[-2].v);
		  u = ltt_missing_unit;
		}

	      yyval.v = [u metaWithName: yyvsp[0].v];
	    ;
    break;}
case 303:
#line 2746 "parse.y"
{
	      yyval.v = [[(LTTMeta *) [yyvsp[0].v _elementAtIndex: 0] lttName] internal];
	    ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 2750 "parse.y"

