/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIExtensions.m,v 1.62 1998/01/05 01:15:37 tiggr Exp $  */

#import "tr.h"
#import "tom/trt.h"

@implementation LTIMethod (tr)

-(id) compileDeclaration: (id) s
{
  return formac (s, @"extern void %@ ();\n", name);
}

@end

@implementation LTISelector (tr)

-(id) compileDeclaration: (id) s
{
  return formac (s, @"extern struct trtd_selector %@;\n",
		 [structure outputDefinitionName]);
}

-(id) compileDefinition: (id) s
{
  id <TLString> n = [[structure lttName] internal];

  return formac (s, @"struct trtd_selector %@ =\n {%d, {%#, %d}, &%@, &%@};\n",
		 [structure outputDefinitionName],
		 app_unit ? 0 : identity, n, [n length],
		 [[structure inArgumentTypes] outputDefinitionName],
		 [[structure outArgumentTypes] outputDefinitionName]);
}

@end

@implementation LTIStringCST (tr)

-(id) compileDefinition: (id) s
{
  /* XXX */
  s = formac (s, @"static struct %@ %@ = {{(%@) &%@, TGC_BLACK}, ",
	      [tom_string_instance outputTypeName],
	      [structure outputDefinitionName],
	      [ltt_class_state outputTypeName],
	      [tom_string_instance metaDefinitionName]);
  return formac (s, @"{%d, (void *) %#}};\n",
		 [[structure string] length], [structure string]);
}

-(id) compileReference: (id) s
{
  return formac (s, @"struct %@ *%@ = &%@;\n",
		 [tom_string_instance outputTypeName],
		 [structure outputReferenceName],
		 [[[CO_LTIStringCST stringForString: [structure string]]
		   structure] outputDefinitionName]);
}

@end

@implementation LTTSelArgTypes (tr)

-(id) compileDeclaration: (id) s
{
  return formac (s, @"extern struct trtd_selector_args %@;\n",
		 [self outputDefinitionName]);
}

-(id) compileDefinition: (id) s
{
  const char *fmt = [args cString];
  int i, n = [args length];

  s = formac (s, @"struct trtd_selector_args %@ = {%d, {",
	      [self outputDefinitionName], n);

  for (i = 0; i < n; i++)
    {
      id <TLString> t;

      switch (fmt[i])
	{
	case 'v': t = @"TRT_TE_VOID"; break;
	case 'o': t = @"TRT_TE_BOOLEAN"; break;
	case 'b': t = @"TRT_TE_BYTE"; break;
	case 'c': t = @"TRT_TE_CHAR"; break;
	case 'i': t = @"TRT_TE_INT"; break;
	case 'l': t = @"TRT_TE_LONG"; break;
	case 'f': t = @"TRT_TE_FLOAT"; break;
	case 'd': t = @"TRT_TE_DOUBLE"; break;
	case 'p': t = @"TRT_TE_POINTER"; break;
	case 's': t = @"TRT_TE_SELECTOR"; break;
	case 'r': t = @"TRT_TE_REFERENCE"; break;
	case 'x': t = @"TRT_TE_DYNAMIC"; break;
	default:
	  t = nil;
	  ABORT ();
	}
      formac (s, i ? @", %@" : @"%@", t);
    }

  return formac (s, @"}};\n");
}

@end

/* XXX YYY ZZZ  */
#ifdef SOMETHINGS_VERY_WRONG_WITH_THE_GNU_RUNTIME

@implementation TLObject (FooBar)

-equal: o
{
  return ![self compare: o] ? self : nil;
}

-consp { return (nil); }
-emptyp { return (nil); }
-floatp { return (nil); }
-integerp { return (nil); }
-lambdap { return (nil); }
-listp { return (nil); }
-nilp { return (nil); }
-sequencep { return (nil); }
-stackp { return (nil); }
-stringp { return (nil); }
-streamp { return (nil); }
-subroutinep { return (nil); }
-symbolp { return (nil); }

@end

#endif
