/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: tr.h,v 1.18 1998/01/05 01:15:45 tiggr Exp $ */

#import <lti/lti.h>
#import "LTIExtensions.h"

/* The version information, as defined in `version.m'.  */
extern char *long_version, *short_version;

extern LTTInstance *tom_string_instance;

/* All super references.  */
extern TLCons *super_refs;

extern TLDictionary *mdt_buckets;

extern int flag_verbose_deferred;
extern int flag_instances_deferred;
extern int flag_instances_non_deferred;

extern TLCons *instances_deferred, *instances_non_deferred;

/* The unit we're handling.  */
extern LTTUnit *top_unit;

/* Iff !nil, the unit into which the TOP_UNIT will be dynamically loaded.
   It is identical to the TOP_UNIT if we're not to statically resolve.  */
extern LTTUnit *app_unit;

/* This is the TOP_UNIT iff FLAG_1, otherwise, it is NIL.  */
extern LTTUnit *single_unit;

/* Iff !0, we're doing FLAG_1 on the tom unit.  */
extern int single_tom_unit;

/* Iff we have an APP_UNIT which is not the TOP_UNIT, this set is !NIL and
   contains all units depended upon by the APP_UNIT.  */
extern TLSet *app_units;

/* The set of units actually output for the current module.  */
extern TLSet *included_units;

/* Iff we're to do dynamic loading, the sets for the APP_UNIT.  Thus, stuff
   contained in these should not be defined for the TOP_UNIT.  */
extern TLSet *app_sel_arg_types;
extern TLSet *app_selectors;

extern id <TLString> default_asi_value;

int next_thread_local_offset;
