<copyright> Nameserver interface classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Nameserver.t,v 1.3 1998/01/05 01:16:44 tiggr Exp $</id>
    </copyright>

/******************** NameserverDefinitions ********************/

<doc> The NameserverDefinitions class contains nameserver related
    constants for any interested class to inherit.  </doc>
implementation class
NameserverDefinitions
{
  <doc> The default TCP port on which the nameserver is listening.  </doc>
  const DEFAULT_SERVER_PORT = 2360;

  <doc> The port number returned for the port which is not found.  </doc>
  const PORT_NOT_FOUND = -1;
}

end;

implementation instance
NameserverDefinitions

end;

/******************** Nameserver ********************/

implementation class
Nameserver: NameserverDefinitions

end;

implementation instance
Nameserver

<doc> Report to the {client} the internet TCP port of the service named
    {service_name} which is running on the host named {hostname}.  </doc>
deferred void
       reportTo NameserverClient client
  portOfService String service_name
	 onHost String hostname;

end;

/******************** NameserverClient ********************/

implementation class
NameserverClient: NameserverDefinitions

end;

implementation instance
NameserverClient

<doc> Be informed of the {port} in response to the {reportTo portOfService
    onHost} request.  </doc>
deferred void
  service String service_name
   onHost String hostname
  hasPort int port;

end;
