/*
---------------------------------------------
parser.y: grammatica di g48 - main()
by M. Andreoli, (C) 1997
---------------------------------------------
*/


%{
/* il tipo dello stack */

#define YYSTYPE char * 

char usage[128]="g48 [-v|-t] < input_file > output_file";
static char buffer[1024];
static char tmp[1024];
#include <stdio.h>
#include "version.h"
%}

%token NAME STRING QUOTED RPN RPNPRG NUMBER COMMENT TYPE
%token PP MM EQ NE GE LE AND OR LS RS
%token IF ELSE FOR WHILE SWITCH CASE DEFAULT

%right '=' 
%left OR AND EQ NE GE LE '>' '<' 
%right '+' '-' '*' '/'
%left NEG
%left NOT 
%right POW PROD DIV MOD

/* grammatica */

%%
prg: 	 
	|stmts { printf("%s",$1);}
        ;
/* Per lo switch */

swi_stmts:	swi_stmt	{$$=$1;} 
		| swi_stmt swi_stmts {sprintf(buffer,"%s%s",$1,$2);make($$);}
	;
swi_stmt:	CASE expr ':' block 	{sprintf(buffer,"\n$ %s == THEN\n%s END ",$2,$4); make($$);}
		|DEFAULT ':' block  { sprintf(buffer,"\n%s",$3); make($$);}
	;


/* Lista di espressioni a,b,c,d,... */

expr_list: 	  expr
	| expr_list ',' expr	{ sprintf(buffer,"%s,%s",$1,$3); make($$);}
	;

opt_expr:	{$$="";}
	|expr
	;
/* Espressioni ritornanti un valore */

expr:	NUMBER
	|NAME   
	|STRING
	|RPNPRG
	| '[' expr_list ']'  { sprintf(buffer,"[%s]",$2);  make($$);} 
	| '{' expr_list '}'  {
				 sprintf(buffer,"{%s}",$2);
				  make($$);} 
	| '{' '}'  { sprintf(buffer,"{}"); make($$);} 
	| '(' expr ',' expr ')'  { sprintf(buffer,"(%s,%s)",$2,$4);  make($$);} 
	| NAME '[' expr_list ']'    { sprintf(buffer,"'%s(%s)' EVAL",$1,$3); make($$); } 
	| NAME '[' ']'    { sprintf(buffer,"%s",$1); make($$); } 
	| RPN  { $$[strlen($$)-1]='\0'; $$++;}	
	| QUOTED  	
	| '(' expr ')'  	{ $$=$2;}
	| expr '^' expr	%prec POW { sprintf(buffer,"%s %s ^",$1,$3); make($$);}
	| expr '*' expr	%prec PROD { sprintf(buffer,"%s %s *",$1,$3); make($$);}
	| expr '/' expr	%prec DIV { sprintf(buffer,"%s %s /",$1,$3); make($$);}
	| expr '%' expr	%prec MOD { sprintf(buffer,"%s %s MOD",$1,$3); make($$);}
	| expr '-' expr	{ sprintf(buffer,"%s %s -",$1,$3); make($$);}
	| expr '+' expr	{ sprintf(buffer,"%s %s +",$1,$3); make($$);}
	| expr OP expr	{ sprintf(buffer,"%s %s %s",$1,$3,$2); make($$);}
	| '-'  expr %prec NEG	{ sprintf(buffer,"-%s ",$2); make($$);}
	| '~'  expr %prec NOT	{ sprintf(buffer,"%s NOT ",$2); make($$);}
	| '!'  expr %prec NOT	{ sprintf(buffer,"%s NOT ",$2); make($$);}
	/* fattoriale */
	| NUMBER '!'		{ sprintf(buffer,"%s!",$1); make($$);}
	/* Operatori a due caratteri  */
	| expr '|' '|' expr { sprintf(buffer,"%s %s OR",$1,$4); make($$);} 
	| expr '&' '&' expr { sprintf(buffer,"%s %s AND",$1,$4); make($$);} 
	| expr OP '=' expr  {
		switch( $2[0] )	
		{
		case '/':
		case '*':
		case '-':
		case '+': sprintf(buffer,"%s '%s' STO%s",$4,$1,$2); break;
		case '!': sprintf(buffer,"%s %s \\=/",$1,$4) ; break;
		case '>': sprintf(buffer,"%s %s \\>=",$1,$4) ; break;
		case '<': sprintf(buffer,"%s %s \\<=",$1,$4) ; break;
		case '=': sprintf(buffer,"%s %s ==",$1,$4)   ; break;
		case '|': sprintf(buffer,"%s %s OR '%s' STO",$1,$4,$1)   ; break;
		case '&': sprintf(buffer,"%s %s AND '%s' STO",$1,$4,$1)   ; break;
		}
		make($$);
		}
	/* assegnamenti semplici*/

	| NAME '[' expr_list ']' '=' expr    { sprintf(buffer,"%s '%s(%s)' STO",$6,$1,$3);
		make($$);
		} 
	| expr '=' expr    { sprintf(buffer,"%s '%s' STO",$3,$1);
		make($$);
		} 
	/* assegnamenti a liste */

	| '{' expr_list '}' '=' expr
			{
			sprintf(buffer,"%s %i \\->LIST {%s} 2 \\<<STO\\>> DOLIST",
			$5,count($2),$2);
			make($$);
			}
	/* operatori i++ e i-- */

	|expr '+' '+'  { sprintf(buffer,"'%s' 1 STO+",$1);
		make($$);} 
	|expr '-' '-'   { sprintf(buffer,"'%s' 1 STO-",$1);
		make($$);} 

	/* if ternario del C */

	| expr '?' expr ':' expr 
                {
                sprintf(buffer,"\nIF %s\nTHEN %s\nELSE %s\nEND\n",$1,$3,$5);
                make($$);
                }
	/* chiamate a funzioni : sintassi ordinaria */

        |NAME '(' expr_list ')'  {sprintf(buffer,"%s %s",$3,$1);  make($$);} 
        |NAME '(' ')'  { sprintf(buffer,"%s",$1);  make($$);} 
	;
	
	/* espressioni con dichiarative C base: ignora tipo */

        |'*'  expr  {sprintf(buffer,"%s",$2);  make($$);} 
        |'&'  expr  {sprintf(buffer,"%s",$2);  make($$);} 
        |TYPE expr  {sprintf(buffer,"%s",$2);  make($$);} 
	;
	/* casting : ignora tipo*/

        |'(' TYPE ')' expr  {sprintf(buffer,"%s",$4);  make($$);} 
        |'(' TYPE '*' ')' expr  {sprintf(buffer,"%s",$5);  make($$);} 
	;

/* Block opzionali */

opt_block:	';'  {$$="";}
	| block
	;
/* Block del tipo { ....} */

block:   stmt 
         | '{' stmts '}' { $$=$2;}
        ;
/* Sequenze di statement */

stmts: 	stmt		
         |  stmts stmt 
		{ sprintf(buffer,"%s\n%s",$1,$2); make($$);
		}
	;

/* Statement principali del C o istruzioni concluse con ; */

stmt:	 IF '(' expr ')' block 
                {
                sprintf(buffer,"IF %s\nTHEN %s\nEND",$3,$5);
                make($$);
                }
        |IF '(' expr ')' block ELSE block 
                {
                sprintf(buffer,"IF %s\nTHEN %s\nELSE %s\nEND",$3,$5,$7);
                make($$);
                }
	|FOR '(' opt_expr ';' opt_expr ';' opt_expr  ')' opt_block 
                {
		if (strlen($5)==0) sprintf(tmp,"%s","1"); else sprintf(tmp,"%s",$5);
                sprintf(buffer,"%s WHILE %s \nREPEAT %s %s \nEND",$3,tmp,$9,$7);
                make($$);              
                }
		;
	/* blocco while */

	|WHILE '(' expr  ')' opt_block 
		{
                sprintf(buffer,"WHILE %s \nREPEAT %s\nEND",$3,$4);
		make($$);
		}
	/* dichiarative di funzioni, con tipo e non */

	|TYPE '*'  fun_decl  	{$$=$3;}
	|TYPE fun_decl  	{$$=$2;}
	|fun_decl  		{$$=$1;}
		;
	/* blocco switch */

	|SWITCH '(' expr ')' '{' swi_stmts  '}' 
                {
                sprintf(buffer,"%s \\-> $\n\\<<CASE\n%s\nEND\\>>",$3,$6);
                make($$);
                }
		;
	/* include: elimina */

	|'#' NAME STRING { $$[0]='\0';}
        |'#' NAME '<' NAME '>'{ $$[0]='\0';}
	;	
	/* dichiarazioni di singole variabili o liste di variabili */

	|  TYPE  expr ';'		{ $$[0]='\0';}
	|  TYPE  expr ',' expr_list ';'	{ $$[0]='\0';}
	;
	/* singole expressioni con ; */
	| expr ';'
	;

fun_decl: NAME '(' expr_list ')' block 
                {
                sprintf(buffer,
                "@ Funzione %s()\n\n\\<< \\-> %s \\<<%s\\>> \\>> '%s' STO\n", 
                $1,$3,$5,$1);
                make($$);
                }
		;
        /* dichiarazioni senza parametri */

        | NAME '('  ')' block 
                {
                sprintf(buffer,
                "@ Funzione %s()\n\n\\<<%s\\>> '%s' STO\n", 
                $1,$4,$1);
                make($$);
                }
                ;


/*
 * Singoli caratteri provenienti da lexer, utilizzati
 * nelle operazioni C 
 */

OP:	 '!'
	|'<'
	|'>'
	|'='
	|'|'
	|'&'
	|'+'
	|'-'
	|'*'
	|'/'
	|'%' 
;
%%
#include <stdio.h>
#include <ctype.h>

/* lunghezza lista: a,b,c... */

int count( char *s)
{
int i,n=0;

if (s[0]=='\0') return 0;

for (i=0; s[i]!='\0'; i++)
	if(s[i]==',') n++;	
return n+1;
}

/* Attivita' di trace e settaggio variabile $$ */

int make(char *x) 
{
memcpy(x,buffer,strlen(buffer)+1);  
}
int main(int argc, char *argv[])
{
/* Parse opzioni */

if ( argc==2 && argv[1][0]=='-' )
{
	switch ( argv[1][1] )
	{
	case 'v': 
		fprintf(stderr,"g48 version %s (C) M.Andreoli,1997\n",VERSION); exit(0);	
	case 't':
		yydebug=1;break;	
	default: fprintf(stderr,"Usage: %s\n",usage); exit(1);
	}
}

/* Codici di apertura e chiusura */
	printf("%%");printf("%%");
	printf("HP: T(3)A(R)F(.);\n");
	printf("\\<<\n@ g48 C->RPN Translator Ver %s - by M. Andreoli (C) 1997\n",VERSION);
	if (yydebug) fprintf(stderr,"g48 trace file\n----------------\n");
	yyparse();
	printf("\n\\>>\n");
	return 0;
}

yyerror( char *s)
{
fprintf(stderr,"\n*** Uhh!: %s\n",s);
fprintf(stderr,"*** Last evaluated token: %s\n", yylval);
fprintf(stderr,"*** Buffer status       : %s\n", buffer);
fprintf(stderr,"*** Try -t option ...\n");
}
