/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_linux_macros.h
|
| Revision    : 1.0
| Date        : 26/03/97
|
| Object      : None
|
| Description : Macro routines for linux replacement code
|
| (c) Richard Kent 1997
|
| $Id$
|
****************************************************************************/

#ifdef LINUX

#ifndef _DPTich_linux_macros_h
#define _DPTich_linux_macros_h

#include <stdio.h>
#include <stdlib.h>
#include "DPTich_linux_ieee.h"

#define fail(message)        \
{                            \
  fprintf (stderr,message);  \
  return AF_NULL_FILEHANDLE; \
} 

#define alert(message)       \
{                            \
  fprintf (stderr,message);  \
} 

#define message(message)     \
{                            \
  fprintf (stderr,message);  \
} 

#define aiffError            \
{                            \
  done  = TRUE;              \
  error = TRUE;              \
  break;                     \
}

int ulRead (int file,unsigned long *ul);
int lRead (int file,long *l);;
int usRead (int file,unsigned short *us);;
int sRead (int file,short *s);;
int ucRead (int file,unsigned char *uc);;
int cRead (int file,signed char *c);;
int eRead (int file,double *d);
int idRead (int file,char *c);
int pstringRead (int file,char **c);
int ulWrite (int file,unsigned long ul);
int lWrite (int file,long l);
int usWrite (int file,unsigned short us);
int sWrite (int file,short s);
int ucWrite (int file,unsigned char uc);
int cWrite (int file,signed char c);
int eWrite (int file,double d);
int idWrite (int file,char *c);
int pstringWrite (int file,char *c);
void swapbytes (char *buffer,int n);
unsigned long swapbytes (unsigned long ul);
long swapbytes (long l);
unsigned short swapbytes (unsigned short us);
short swapbytes (short s);
unsigned int swapbytes (unsigned int ui);
int swapbytes (int i);
double swapbytes (double d);

#define ulread(into)                    \
{                                       \
  if (!ulRead (file,&ultemp)) aiffError \
  into = ultemp;                        \
}

#define lread(into)                     \
{                                       \
  if (!lRead (file,&ltemp)) aiffError   \
  into = ltemp;                         \
}

#define usread(into)                    \
{                                       \
  if (!usRead (file,&ustemp)) aiffError \
  into = ustemp;                        \
}

#define sread(into)                     \
{                                       \
  if (!sRead (file,&stemp)) aiffError   \
  into = stemp;                         \
}

#define ucread(into)                    \
{                                       \
  if (!ucRead (file,&uctemp)) aiffError \
  into = uctemp;                        \
}

#define cread(into)                     \
{                                       \
  if (!cRead (file,&ctemp)) aiffError   \
  into = ctemp;                         \
}

#define eread(into)                     \
{                                       \
  if (!eRead (file,&dtemp)) aiffError    \
  into = dtemp;                         \
}

#define idread(into)                    \
{                                       \
  if (!idRead (file,idtemp)) aiffError  \
  strncpy (into,idtemp,4);              \
}

#define pstringread(into)               \
{                                       \
  if (!pstringRead (file,&tempstring))  \
  {                                     \
    if (tempstring) free (tempstring);  \
    tempstring = 0;                     \
    aiffError                           \
  }                                     \
  into = tempstring;                    \
}

#define ulwrite(into)                   \
{                                       \
  ultemp = into;                        \
  if (!(bytes=ulWrite (file,ultemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define lwrite(into)                    \
{                                       \
  ltemp = into;                         \
  if (!(bytes=lWrite (file,ltemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define uswrite(into)                   \
{                                       \
  ustemp = into;                        \
  if (!(bytes=usWrite (file,ustemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define swrite(into)                    \
{                                       \
  stemp = into;                         \
  if (!(bytes=sWrite (file,stemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define ucwrite(into)                   \
{                                       \
  uctemp = into;                        \
  if (!(bytes=ucWrite (file,uctemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define cwrite(into)                    \
{                                       \
  ctemp = into;                         \
  if (!(bytes=cWrite (file,ctemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define ewrite(into)                    \
{                                       \
  dtemp = into;                         \
  if (!(bytes=eWrite (file,dtemp)))     \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define idwrite(into)                   \
{                                       \
  strncpy (idtemp,into,4);              \
  if (!(bytes=idWrite (file,idtemp)))   \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define pstringwrite(into)              \
{                                       \
  tempstring = into;                    \
  if (!(bytes=pstringWrite              \
    (file,tempstring)))                 \
    return AF_NULL_FILEHANDLE;          \
  handle->actualBytes += bytes;         \
}

#define ulupdate(into)                  \
{                                       \
  ultemp = into;                        \
  if (!ulWrite (file,ultemp))           \
    return -1;                          \
}

#define lupdate(into)                   \
{                                       \
  ltemp = into;                         \
  if (!lWrite (file,ltemp))             \
    return -1;                          \
}

#define usupdate(into)                  \
{                                       \
  ustemp = into;                        \
  if (!usWrite (file,ustemp))           \
    return -1;                          \
}

#define supdate(into)                   \
{                                       \
  stemp = into;                         \
  if (!sWrite (file,stemp))             \
    return -1;                          \
}

#define ucupdate(into)                  \
{                                       \
  uctemp = into;                        \
  if (!ucWrite (file,uctemp))           \
    return -1;                          \
}

#define cupdate(into)                   \
{                                       \
  ctemp = into;                         \
  if (!cWrite (file,ctemp))             \
    return -1;                          \
}

#define eupdate(into)                   \
{                                       \
  dtemp = into;                         \
  if (!eWrite (file,dtemp))             \
    return -1;                          \
}

#define idupdate(into)                  \
{                                       \
  strncpy (idtemp,into,4);              \
  if (!idWrite (file,idtemp))           \
    return -1;                          \
}

#define pstringupdate(into)             \
{                                       \
  tempString = into;                    \
  if (!pstringWrite (file,tempString))  \
    return -1;                          \
}

#endif // _DPTich_linux_macros_h

#endif // linux

/***************************************************************************/
