/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : delay.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDelay
|
| Description : DSPKitDelay
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char delay_cc [] = "$Id$";

#include "delay.h"

DSPKitDelay::DSPKitDelay ()
{
  buffer = 0;
}

DSPKitDelay::~DSPKitDelay ()
{
  if (buffer) delete [] buffer; 
}

long DSPKitDelay::setInputAndDelayTime (DSPKitProcessor *ip,double dt)
{
  DSPKitProcessor::setInput (ip);
  delayTime = dt;
  bufSize   = (long)(delayTime * inputSamplingRate);
  
  if (bufSize < 0)
  {
    bufSize = 0;
  }
  if (bufSize > 0)
  {
    if ((buffer = new double [bufSize]) == 0) return -1;
    for (long i=0; i<bufSize; i++) buffer [i] = 0;
  }

  oldestSampleIndex = 0;
  lastSampleIndex   = 0;
  haveSamples       = 0;
  endOfInput        = 0;
  return 0;
}

long DSPKitDelay::getSample (double &outputSample)
{
  double inputSample;

  if (!bufSize)
  {
    if (input->getSample (outputSample)) return 1;
    return 0;
  }

  if (endOfInput)
  {
    input->getSample (inputSample); // for feedback loops
    if (oldestSampleIndex == lastSampleIndex) return 0;
    outputSample = buffer [oldestSampleIndex++];
    oldestSampleIndex %= bufSize;
    return 1;
  } 

  if (input->getSample (inputSample) == 0)
  {
    endOfInput = 1;
    if (!haveSamples) return 0;
    outputSample = buffer [oldestSampleIndex++];
    oldestSampleIndex %= bufSize;
    return 1;
  } 

  haveSamples = 1;
  outputSample = buffer [oldestSampleIndex];
  buffer [oldestSampleIndex++] = inputSample;
  oldestSampleIndex %= bufSize;
  lastSampleIndex = oldestSampleIndex;
  return 1;
}

/***************************************************************************/
