%define name gnotepad+
%define version 1.2.1
%define release 1
%define prefix /usr

Summary: Simple but versatile HTML/text editor for X11.

Name: %{name}
Version: %{version}
Release: %{release}
Group: Applications/Editors
Copyright: GPL
Url: http://gnotepad.sourceforge.net
Source: %{name}-%{version}.tar.gz
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root
Requires: gtk+ >= 1.2.0 glib >= 1.2.0

%changelog

* Wed Feb 23 2000 Andy Kahn <ackahn@netapp.com>
- version 1.2.0

* Wed Feb 23 2000 John Gotts <jgotts@linuxsavvy.com>
- version 1.2.0pre5

* Wed Jul 07 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.4

* Tue Apr 01 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.3

* Fri Mar 19 1999 Michael Fulbright <drmike@redhat.com>
- strip binaries

* Fri Mar 12 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.2
- doesnt work with GNOME session management, disabling GNOME support

* Sun Mar 06 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.1

* Fri Feb 19 1999 Michael Fulbright <drmike@redhat.com>
- version 1.1.0

* Fri Jan 22 1999 Michael Fulbright <drmike@redhat.com>
- first attempt at spec file

%description
gnotepad+ is an easy-to-use, yet fairly feature-rich, simple HTML/text
editor for systems running X11 and using GTK+/GNOME. It is designed
for as little bloat as possible, while still providing many of the
common features found in a modern GUI-based text editor.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
make

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
mkdir -p $RPM_BUILD_ROOT%{prefix}
make prefix=$RPM_BUILD_ROOT%{prefix} install

# strip binaries
strip `file $RPM_BUILD_ROOT/%{prefix}/bin/* | awk -F':' '/executable/ { print $1 }'`

%files
%doc AUTHORS HACKING NEWS README TODO ChangeLog
%attr(755,root,root) %{prefix}/bin/gnp
%{prefix}/man/man1/gnp.1
%{prefix}/share/gnome/apps/Applications/gnotepad+.desktop
%{prefix}/share/gnome/help/gnotepad+/*
%{prefix}/share/gnotepad+
%{prefix}/share/locale/*/*/*

%clean
rm -r $RPM_BUILD_ROOT

