/* vi:set ts=8 sts=0 sw=8:
 * $Id: dialog.h,v 1.10 2000/01/19 17:19:50 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DIALOG_H__
#define __DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include "main.h"

#define BUTTON_OK	"Ok"
#define BUTTON_CANCEL	"Cancel"
#define BUTTON_YES	"Yes"
#define BUTTON_NO	"No"
#define BUTTON_CLOSE	"Close"
#define BUTTON_APPLY	"Apply"
#define BUTTON_HELP	"Help"

#define DIALOG_YES	1
#define DIALOG_NO	2
#define DIALOG_CANCEL	3

typedef struct {
	GtkWidget *toplev;
	GtkWidget *entry;
} dialog_entry_t;

extern int do_dialog_yes_no_cancel(char *title, char *msg);
extern int do_dialog_ok(char *title, char *msg);
extern void get_dialog_entry(char *title, char *labeltxt, char *dialogtxt,
	int entry_len, char *entrytxt,
	GtkSignalFunc ok_cb, gpointer ok_cbdata,
	GtkSignalFunc cancel_cb, gpointer cancel_cbdata,
	GtkSignalFunc destroy_cb, gpointer destroy_cbdata,
	GtkWidget **toplev, GtkWidget **entry);
extern int do_dialog(char *title, char *msg, short num, char **buttons,
	short dflt, GtkSignalFunc **cbs, void **cbd, bool_t block);

extern void do_dialog_clist(
		GtkWidget **toplev,
		char *title,
		int height, int width,
		GtkWidget **clist, int numcols,
		char *titles[],
		void (*destroy_cb)(GtkWidget *, gpointer),
		gpointer destroy_cbdata,
		int (*select_cb)(GtkWidget *, unsigned, int,
				 GdkEventButton *, gpointer),
		gpointer select_cbdata,
		void (*close_sel)(GtkWidget *, gpointer),
		gpointer close_sel_cbdata,
		void (*close_all)(GtkWidget *, gpointer),
		gpointer close_all_cbdata);

#ifdef USE_GNOME
extern int do_dialog_error(char *title, char *msg);
#else
#define do_dialog_error	do_dialog_ok
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __DIALOG_H__ */
