/* vi:set ts=8 sts=0 sw=8:
 * $Id: misc.h,v 1.17 2000/02/19 22:57:54 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MISC_H__
#define __MISC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <time.h>
#include <gtk/gtk.h>
#include "main.h"

#define SWAP_INT(x, y) {	\
		int tmp = (x);	\
		(x) = (y);	\
		(y) = tmp;	\
}

/* misc_button_new_w_label() options */
#define PACK_START	(1 << 0)
#define PACK_END	(1 << 1)
#define PACK_EXPAND	(1 << 2)
#define PACK_FILL	(1 << 3)
#define GRAB_DEFAULT	(1 << 4)
#define CANCEL_DEFAULT	(1 << 5)
#define SHOW_BUTTON	(1 << 6)
#define CONNECT_OBJ	(1 << 7)
#define NO_RELIEF	(1 << 8)

extern char *handle_null_string(char *s);
extern char *strrepl(char *orig, char *pat, char *repl);
extern char *my_tempname(void);
#ifdef USE_FILEINFO
extern char *ttoa(time_t curtime, bool_t append_nl);
extern char *ltoa(long num);
#endif	/* USE_FILEINFO */
#ifdef USE_SEARCH
extern char * strcasestr(const char *phaystack, const char *pneedle);
#endif	/* USE_SEARCH */
#ifdef GTK_HAVE_FEATURES_1_1_0
# define my_basename(name)	g_basename((const gchar *)(name))
# define my_dirname(name)	g_dirname((const gchar *)(name))
#else
extern char *my_basename(const char *name);
extern char *my_dirname(const char *fname);
#endif

extern GtkWidget *misc_open_dialog_create(void *w, char *title,
				void (*fsel_ok)(GtkWidget *, gpointer),
				void (*fsel_cancel)(GtkWidget *, gpointer),
				void (*fsel_destroy)(GtkWidget *, gpointer));
extern GtkWidget *misc_new_pixmap(char *fname, GtkWidget *parent,
				  GdkPixmap **pixmap_p, GdkBitmap **mask_p);
extern GtkWidget *misc_button_new_w_label(
			char *labelname, char *gnomename, GtkSignalFunc cbfunc,
			gpointer cbdata, GtkWidget *box, int packopts,
			int padding);

extern GtkWidget *misc_entry_w_label_create(
			GtkWidget *, char *, char *,
			GtkWidget *table,
			int lft1, int rht1, int top1, int bot1,
			int lft2, int rht2, int top2, int bot2);

extern gboolean misc_show_and_raise(GtkWidget *wgt);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __MISC_H__ */
