/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/time.h>
#include <sys/types.h>

#include "x10.h"


#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <sys/types.h>
#endif

extern int timeout;
extern int sptty;

void iquit();
jmp_buf mjb;

void iquit()
{
    longjmp(mjb, 1);
}

int c_monitor()
{
    off_t f_offset;
    int check4poll();
    struct stat stat_buf;
    char spoolfile[100];
#ifdef HASSELECT
    fd_set rfds;
    struct timeval tv;
#endif
    char RCSID[]= "@(#) $Id: monitor.c,v 1.9 1999/12/26 20:37:17 dbs Exp dbs $\n";


    display(RCSID);

    sprintf( spoolfile, "%s/heyu.out", SPOOLDIR);
    (void) signal(SIGCHLD, iquit);
    (void) signal(SIGINT, iquit);
    if (setjmp(mjb))
	return(0);

    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
    while (1)
    {
	if( f_offset == lseek(sptty, 0, SEEK_END) ) /* find end of file */
	{
	    if( stat( spoolfile, &stat_buf ) < 0)
	         return(0);
#ifndef HASSELECT
	    /* this imposes a 1 second delay between the start of new output*/
	    /* It keeps the disk from being thrashed. */
	    sleep(1);
#else
	    FD_ZERO(&rfds);
	    FD_SET(sptty, &rfds);
	    tv.tv_sec = 600;	/* This does it even better */
	    tv.tv_usec = 0;
	    (void) select(sptty + 1,&rfds, NULL, NULL, &tv) ;
#endif
	}
	else
	{
	    if( fstat( sptty, &stat_buf ) < 0)
	         return(0);
	    lseek(sptty, f_offset, SEEK_SET);
	    check4poll(1,2);
	    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
	}
    }
    return(0);
}
