#ifndef IIRSCRAM_BIT_STRING_LITERAL_HH
#define IIRSCRAM_BIT_STRING_LITERAL_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_BitStringLiteral.hh,v 1.2 1999/03/09 20:53:09 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_BitStringLiteral.hh"

template <class type> class set;
class IIR_TypeDefinition;

class IIRScram_BitStringLiteral : public IIRBase_BitStringLiteral {

public:
  void _publish_cc();
  void _publish_cc_range();
  void _publish_cc_bounds();
  void _publish_cc_headers();
  void _publish_cc_initialization_value();
  IIR_Int32 _get_num_digits();
  IIR_Int32 _get_effective_length();
  IIR_Boolean _is_array_type(){ return TRUE; }
  
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  void _type_check( set<IIR_TypeDefinition> * );

  void _publish_cc_state_object_init();

protected:
  IIRScram_BitStringLiteral() {}
  virtual ~IIRScram_BitStringLiteral() = 0;
    
private:
  IIR_Char* _convert_octal_to_binary();
  IIR_Char* _convert_hex_to_binary();
};
#endif
