#ifndef IIRSCRAM_CONCURRENT_ASSERTION_STATEMENT_HH
#define IIRSCRAM_CONCURRENT_ASSERTION_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcurrentAssertionStatement.hh,v 1.3 1999/07/21 01:17:43 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ConcurrentAssertionStatement.hh"

class IIRScram_ConcurrentAssertionStatement : public IIRBase_ConcurrentAssertionStatement {
public:
  void _publish_vhdl(ostream &);
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  IIR  *_transmute();
#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, 
			 IIR_DeclarationList*, char*);
  IIR *_clone();
#endif
  
  void _type_check();
  void _type_check_condition();
  void _type_check_expression();
  void _type_check_severity();

  IIR *_get_assertion_condition(){ return get_assertion_condition(); }
  void _set_assertion_condition( IIR *new_expr ){ set_assertion_condition( new_expr ); }
  
  IIR *_get_report_expression(){ return get_report_expression(); }
  void _set_report_expression( IIR *new_expr ){ set_report_expression( new_expr ); }
  
  IIR *_get_severity_expression(){ return get_severity_expression(); }
  void _set_severity_expression( IIR *new_expr ){ set_severity_expression( new_expr ); }

protected:
  IIRScram_ConcurrentAssertionStatement() {};
  virtual ~IIRScram_ConcurrentAssertionStatement() = 0;
    
private:
};
#endif
