// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EqualityOperator.cc,v 1.2 1999/03/09 20:54:22 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_EqualityOperator.hh"

IIRScram_EqualityOperator::~IIRScram_EqualityOperator() {}

void 
IIRScram_EqualityOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " = ";
}

void 
IIRScram_EqualityOperator::_publish_cc_operator_name() {
  _cc_out << "savantEqual";
}


IIR*
IIRScram_EqualityOperator::_clone() {
  IIR_EqualityOperator *clone = new IIR_EqualityOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_EqualityOperator::_get_operator_precedence(){
  return IIRScram::RELATIONAL_OPERATOR;
}

IIR_Boolean
IIRScram_EqualityOperator::_is_relational_operator(){
  return TRUE ;
}
