// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LibraryUnit.cc,v 1.2 1999/03/09 20:55:22 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_LibraryUnit.hh"
#include "IIR_AttributeSpecification.hh"

IIRScram_LibraryUnit::~IIRScram_LibraryUnit() {}


void
IIRScram_LibraryUnit::_publish_cc_binding_name(ostream &_vhdl_out){
  _report_undefined_scram_fn("_publish_cc_binding_name");
}


void
IIRScram_LibraryUnit::_publish_vhdl_binding_name(ostream &_vhdl_out){
  _report_undefined_scram_fn("_publish_vhdl_binding_name");
}


void
IIRScram_LibraryUnit::_publish_vhdl_with_library_name(ostream &_vhdl_out){
  _report_undefined_scram_fn("_publish_vhdl_with_library_name");
}


IIR_EntityDeclaration* 
IIRScram_LibraryUnit::_get_entity() {
  _report_undefined_scram_fn("_get_entity()");
  return NULL;
}


void
IIRScram_LibraryUnit::_clone(IIR *cl) {
  IIR_LibraryUnit *clone = (IIR_LibraryUnit*)cl;
  IIRScram_Declaration::_clone(clone);
  IIR_Declaration *decl = context_items.first();
  
  while (decl != NULL) {
    clone->context_items.append(decl);
    decl = context_items.successor(decl);
  }
  clone->context_items = context_items;
  IIR_AttributeSpecification *attrib = attributes.first();
  while (attrib != NULL) {
    clone->attributes.append((IIR_AttributeSpecification*)attrib->_clone());
    attrib = attributes.successor(attrib);
  }
}


// Snippet from old homograph code in symbol table.
//     else if( ( about_to_add->_is_iir_library_unit() == TRUE &&
// 	       current_declaration->_is_iir_component_declaration() == TRUE ) ){
//       are_homographs = FALSE;
//     }

IIR_Boolean 
IIRScram_LibraryUnit::_is_homograph_of( IIR_Declaration *to_check ){
  ASSERT( to_check != NULL );
  if( to_check->_is_iir_library_unit() == TRUE ){

    // Two library units with the same name aren't homographs.
    return FALSE;    
  }
  else{
    return TRUE;
  }
}
